/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.os;

import io.smallrye.common.os.OS;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public final class Linux {
    private Linux() {
    }

    public static boolean isWSL() {
        return WSL.version >= 1;
    }

    public static boolean isWSLv2() {
        return WSL.version >= 2;
    }

    private static final class WSL {
        private static final int version;

        private WSL() {
        }

        static {
            if (OS.current() != OS.LINUX) {
                version = 0;
            } else {
                int v;
                try {
                    String procVersion = Files.readString(Path.of("/proc/version", new String[0]));
                    v = procVersion.contains("Microsoft") ? 1 : (procVersion.contains("microsoft") ? 2 : 0);
                }
                catch (IOException e) {
                    v = 0;
                }
                version = v;
            }
        }
    }
}

