# -*- coding: binary -*-

#
# This class stores Metasploit option configuration used across service authentication
#
module Msf::Exploit::Remote::Kerberos::ServiceAuthenticator::Options
  # Create the list of options that a module must provide for Kerberos authentication via the given protocol
  # This method exists for ensuring consistency across service authentication modules
  #
  # @param [String] protocol The service protocol type, i.e. smb/ldap/winrm/mssql
  # @param [Array<String>] auth_methods The allowed auth methods
  # @see Msf::Exploit::Remote::Kerberos::ServiceAuthenticator::Options::Msf::Exploit::Remote::AuthOption
  def kerberos_auth_options(protocol:, auth_methods:)
    option_conditions = ["#{protocol}::Auth", '==', 'kerberos']

    etype_regex = "(#{Msf::Exploit::Remote::AuthOption::KERBEROS_DEFAULT_OFFERED_ENC_TYPES.map { |v| Regexp.escape(v) }.join('|')})"
    offered_enc_types_option = Msf::OptString.new(
      "#{protocol}::KrbOfferedEncryptionTypes",
      [
        true,
        'Kerberos encryption types to offer',
        Msf::Exploit::Remote::AuthOption::KERBEROS_DEFAULT_OFFERED_ENC_TYPES.join(',')
      ],
      regex: Regexp.new("(#{etype_regex},)*#{etype_regex}", Regexp::IGNORECASE),
      conditions: option_conditions
    )

    auth_options = [
      Msf::OptEnum.new(
        "#{protocol}::Auth",
        [true, 'The Authentication mechanism to use', Msf::Exploit::Remote::AuthOption::AUTO, auth_methods],
      ),
      Msf::OptString.new(
        "#{protocol}::Rhostname",
        [false, 'The rhostname which is required for kerberos - the SPN'],
        fallbacks: ['Rhostname'],
        conditions: option_conditions
      ),
      Msf::OptAddress.new(
        'DomainControllerRhost',
        [false, 'The resolvable rhost for the Domain Controller'],
        conditions: option_conditions
      ),
      Msf::OptKerberosCredentialCache.new(
        "#{protocol}::Krb5Ccname",
        [false, 'The ccache file to use for kerberos authentication', nil],
        conditions: option_conditions
      )
    ]

    [
      *auth_options,
      offered_enc_types_option
    ]
  end
end
