/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.fr.FrenchLightStemFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.util.ElisionFilter;
import org.apache.lucene.util.IOUtils;

public final class FrenchAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "french_stop.txt";
    public static final CharArraySet DEFAULT_ARTICLES = CharArraySet.unmodifiableSet((CharArraySet)new CharArraySet(Arrays.asList("l", "m", "t", "qu", "n", "s", "j", "d", "c", "jusqu", "quoiqu", "lorsqu", "puisqu"), true));
    private final CharArraySet excltable;

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public FrenchAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public FrenchAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public FrenchAnalyzer(CharArraySet stopwords, CharArraySet stemExclutionSet) {
        super(stopwords);
        this.excltable = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy((Set)stemExclutionSet));
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new ElisionFilter((TokenStream)source, DEFAULT_ARTICLES);
        result = new LowerCaseFilter((TokenStream)result);
        result = new StopFilter((TokenStream)result, this.stopwords);
        if (!this.excltable.isEmpty()) {
            result = new SetKeywordMarkerFilter((TokenStream)result, this.excltable);
        }
        result = new FrenchLightStemFilter((TokenStream)result);
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        ElisionFilter result = new ElisionFilter(in, DEFAULT_ARTICLES);
        result = new LowerCaseFilter((TokenStream)result);
        return result;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getSnowballWordSet((InputStream)((InputStream)IOUtils.requireResourceNonNull((Object)SnowballFilter.class.getResourceAsStream(FrenchAnalyzer.DEFAULT_STOPWORD_FILE), (String)FrenchAnalyzer.DEFAULT_STOPWORD_FILE)));
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

