/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.LeafReader;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.MappedFieldType;

public abstract class FieldValueFetcher {
    MappedFieldType mappedFieldType;
    final String simpleName;

    protected FieldValueFetcher(String simpleName) {
        this.simpleName = simpleName;
    }

    public abstract List<Object> fetch(LeafReader var1, int var2) throws IOException;

    Object convert(Object value) {
        return value;
    }

    void write(XContentBuilder builder, List<Object> values) throws IOException {
        if (values.isEmpty()) {
            return;
        }
        if (values.size() == 1) {
            builder.field(this.simpleName, this.convert(values.getFirst()));
        } else {
            Object[] displayValues = new Object[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                displayValues[i] = this.convert(values.get(i));
            }
            builder.array(this.simpleName, displayValues);
        }
    }
}

