/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.checkpoint;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;

@ExperimentalApi
public class MergedSegmentCheckpoint
extends ReplicationCheckpoint {
    private final String segmentName;

    public MergedSegmentCheckpoint(ShardId shardId, long primaryTerm, long segmentInfosVersion, long length, String codec, Map<String, StoreFileMetadata> metadataMap, String segmentName) {
        super(shardId, primaryTerm, -1L, segmentInfosVersion, length, codec, metadataMap);
        this.segmentName = segmentName;
    }

    public MergedSegmentCheckpoint(StreamInput in) throws IOException {
        super(in);
        this.segmentName = in.readString();
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.segmentName);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergedSegmentCheckpoint that = (MergedSegmentCheckpoint)o;
        return this.getPrimaryTerm() == that.getPrimaryTerm() && this.segmentName.equals(that.segmentName) && Objects.equals(this.getShardId(), that.getShardId()) && this.getCodec().equals(that.getCodec());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getShardId(), this.getPrimaryTerm(), this.segmentName);
    }

    @Override
    public String toString() {
        return "MergedSegmentCheckpoint{shardId=" + String.valueOf(this.getShardId()) + ", primaryTerm=" + this.getPrimaryTerm() + ", segmentsGen=" + this.getSegmentsGen() + ", version=" + this.getSegmentInfosVersion() + ", size=" + this.getLength() + ", codec=" + this.getCodec() + ", timestamp=" + this.getCreatedTimeStamp() + ", segmentName=" + this.segmentName + "}";
    }
}

