/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.comments;

import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.admin.indices.rollover.RolloverRequest;
import org.opensearch.action.admin.indices.rollover.RolloverResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.alerting.alerts.AlertIndices;
import org.opensearch.alerting.comments.CommentsIndices;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.util.IndexUtils;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.IndicesAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001b\u0018\u0000 L2\u00020\u0001:\u0001LB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u001fH\u0002J\u0006\u0010'\u001a\u00020\u0015J\u000e\u0010(\u001a\u00020\u001fH\u0086@\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020\u001fH\u0002J\b\u0010+\u001a\u00020\u001fH\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\"0-2\u0006\u0010.\u001a\u00020/H\u0002J*\u00100\u001a\u0004\u0018\u00010\"2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020\u0015H\u0002J\u0016\u00106\u001a\u00020\u001f2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\"0-H\u0002J\u0016\u00108\u001a\u00020\u001f2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\"0-H\u0002J*\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\"2\u0006\u0010;\u001a\u00020\"2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\"H\u0082@\u00a2\u0006\u0002\u0010=J(\u0010>\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020\"2\u0006\u0010?\u001a\u00020\"2\b\b\u0002\u0010<\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010@J\u0018\u0010A\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020\"2\u0006\u0010B\u001a\u00020\"H\u0002J@\u0010C\u001a\u00020\u001f2\u0006\u0010D\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\"2\u0006\u0010E\u001a\u00020\"2\u0006\u0010F\u001a\u00020\"2\u0006\u0010G\u001a\u00020\r2\u0006\u0010H\u001a\u00020\u00112\u0006\u00104\u001a\u00020\"H\u0002J\u0018\u0010I\u001a\u00020\u001f2\u0006\u0010J\u001a\u00020\"2\u0006\u0010K\u001a\u00020\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0016\u0010\u0010\u001a\n \u000e*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u000e*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u000e*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lorg/opensearch/alerting/comments/CommentsIndices;", "Lorg/opensearch/cluster/ClusterStateListener;", "settings", "Lorg/opensearch/common/settings/Settings;", "client", "Lorg/opensearch/transport/client/Client;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "<init>", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/transport/client/Client;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/cluster/service/ClusterService;)V", "commentsHistoryMaxDocs", "", "kotlin.jvm.PlatformType", "Ljava/lang/Long;", "commentsHistoryMaxAge", "Lorg/opensearch/common/unit/TimeValue;", "commentsHistoryRolloverPeriod", "commentsHistoryRetentionPeriod", "isClusterManager", "", "lastRolloverTime", "getLastRolloverTime", "()Lorg/opensearch/common/unit/TimeValue;", "setLastRolloverTime", "(Lorg/opensearch/common/unit/TimeValue;)V", "commentsHistoryIndexInitialized", "scheduledCommentsRollover", "Lorg/opensearch/threadpool/Scheduler$Cancellable;", "onManager", "", "offManager", "executorName", "", "clusterChanged", "event", "Lorg/opensearch/cluster/ClusterChangedEvent;", "rescheduleCommentsRollover", "isCommentsHistoryInitialized", "createOrUpdateInitialCommentsHistoryIndex", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "rolloverAndDeleteCommentsHistoryIndices", "rolloverCommentsHistoryIndex", "getIndicesToDelete", "", "clusterStateResponse", "Lorg/opensearch/action/admin/cluster/state/ClusterStateResponse;", "getHistoryIndexToDelete", "indexMetadata", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "retentionPeriodMillis", "writeIndex", "historyEnabled", "deleteAllOldHistoryIndices", "indicesToDelete", "deleteOldHistoryIndex", "createIndex", "index", "schemaMapping", "alias", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateIndexMapping", "mapping", "(Ljava/lang/String;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setIndexUpdateFlag", "targetIndex", "rolloverIndex", "initialized", "pattern", "map", "docsCondition", "ageCondition", "deleteOldIndices", "tag", "indices", "Companion", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nCommentsIndices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentsIndices.kt\norg/opensearch/alerting/comments/CommentsIndices\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,403:1\n1#2:404\n295#3,2:405\n37#4:407\n36#4,3:408\n37#4:411\n36#4,3:412\n*S KotlinDebug\n*F\n+ 1 CommentsIndices.kt\norg/opensearch/alerting/comments/CommentsIndices\n*L\n220#1:405,2\n238#1:407\n238#1:408,3\n262#1:411\n262#1:412,3\n*E\n"})
public final class CommentsIndices
implements ClusterStateListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Client client;
    @NotNull
    private final ThreadPool threadPool;
    @NotNull
    private final ClusterService clusterService;
    private volatile Long commentsHistoryMaxDocs;
    private volatile TimeValue commentsHistoryMaxAge;
    private volatile TimeValue commentsHistoryRolloverPeriod;
    private volatile TimeValue commentsHistoryRetentionPeriod;
    private volatile boolean isClusterManager;
    @Nullable
    private TimeValue lastRolloverTime;
    private boolean commentsHistoryIndexInitialized;
    @Nullable
    private Scheduler.Cancellable scheduledCommentsRollover;
    @NotNull
    public static final String COMMENTS_HISTORY_WRITE_INDEX = ".opensearch-alerting-comments-history-write";
    @NotNull
    public static final String COMMENTS_HISTORY_ALL = ".opensearch-alerting-comments-history*";
    @NotNull
    public static final String COMMENTS_HISTORY_INDEX_PATTERN = "<.opensearch-alerting-comments-history-{now/d}-1>";
    @NotNull
    public static final String ALL_COMMENTS_INDEX_PATTERN = ".opensearch-alerting-comments*";
    private static final Logger logger = LogManager.getLogger(AlertIndices.class);

    public CommentsIndices(@NotNull Settings settings, @NotNull Client client, @NotNull ThreadPool threadPool, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getCOMMENTS_HISTORY_MAX_DOCS(), arg_0 -> CommentsIndices._init_$lambda$0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getCOMMENTS_HISTORY_INDEX_MAX_AGE(), arg_0 -> CommentsIndices._init_$lambda$1(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getCOMMENTS_HISTORY_ROLLOVER_PERIOD(), arg_0 -> CommentsIndices._init_$lambda$2(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getCOMMENTS_HISTORY_RETENTION_PERIOD(), arg_0 -> CommentsIndices._init_$lambda$3(this, arg_0));
        this.commentsHistoryMaxDocs = (Long)AlertingSettings.Companion.getCOMMENTS_HISTORY_MAX_DOCS().get(settings);
        this.commentsHistoryMaxAge = (TimeValue)AlertingSettings.Companion.getCOMMENTS_HISTORY_INDEX_MAX_AGE().get(settings);
        this.commentsHistoryRolloverPeriod = (TimeValue)AlertingSettings.Companion.getCOMMENTS_HISTORY_ROLLOVER_PERIOD().get(settings);
        this.commentsHistoryRetentionPeriod = (TimeValue)AlertingSettings.Companion.getCOMMENTS_HISTORY_RETENTION_PERIOD().get(settings);
    }

    @Nullable
    public final TimeValue getLastRolloverTime() {
        return this.lastRolloverTime;
    }

    public final void setLastRolloverTime(@Nullable TimeValue timeValue) {
        this.lastRolloverTime = timeValue;
    }

    public final void onManager() {
        try {
            this.rolloverCommentsHistoryIndex();
            this.scheduledCommentsRollover = this.threadPool.scheduleWithFixedDelay(() -> CommentsIndices.onManager$lambda$4(this), this.commentsHistoryRolloverPeriod, this.executorName());
        }
        catch (Exception e) {
            logger.error("Error creating comments indices. Comments can't be recorded until clustermanager node is restarted.", (Throwable)e);
        }
    }

    public final void offManager() {
        block0: {
            Scheduler.Cancellable cancellable = this.scheduledCommentsRollover;
            if (cancellable == null) break block0;
            cancellable.cancel();
        }
    }

    private final String executorName() {
        return "management";
    }

    public void clusterChanged(@NotNull ClusterChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isClusterManager != event.localNodeClusterManager()) {
            this.isClusterManager = event.localNodeClusterManager();
            if (this.isClusterManager) {
                this.onManager();
            } else {
                this.offManager();
            }
        }
        this.commentsHistoryIndexInitialized = event.state().metadata().hasAlias(COMMENTS_HISTORY_WRITE_INDEX);
    }

    private final void rescheduleCommentsRollover() {
        if (this.clusterService.state().getNodes().isLocalNodeElectedClusterManager()) {
            Scheduler.Cancellable cancellable = this.scheduledCommentsRollover;
            if (cancellable != null) {
                cancellable.cancel();
            }
            this.scheduledCommentsRollover = this.threadPool.scheduleWithFixedDelay(() -> CommentsIndices.rescheduleCommentsRollover$lambda$5(this), this.commentsHistoryRolloverPeriod, this.executorName());
        }
    }

    public final boolean isCommentsHistoryInitialized() {
        return this.clusterService.state().getMetadata().hasAlias(COMMENTS_HISTORY_WRITE_INDEX);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createOrUpdateInitialCommentsHistoryIndex(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof createOrUpdateInitialCommentsHistoryIndex.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ CommentsIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createOrUpdateInitialCommentsHistoryIndex((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.isCommentsHistoryInitialized()) break;
                var2_5 = this;
                $continuation.L$0 = var2_5;
                $continuation.label = 1;
                v0 = this.createIndex("<.opensearch-alerting-comments-history-{now/d}-1>", CommentsIndices.Companion.commentsMapping(), ".opensearch-alerting-comments-history-write", (Continuation<? super Boolean>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl24
            }
            case 1: {
                var2_5 = (CommentsIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                var2_5.commentsHistoryIndexInitialized = (Boolean)v0;
                if (this.commentsHistoryIndexInitialized) {
                    v1 = this.clusterService.state();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"state(...)");
                    IndexUtils.Companion.setLastUpdatedCommentsHistoryIndex(IndexUtils.Companion.getIndexNameWithAlias(v1, ".opensearch-alerting-comments-history-write"));
                }
                ** GOTO lbl39
            }
        }
        $continuation.label = 2;
        v2 = this.updateIndexMapping(".opensearch-alerting-comments-history-write", CommentsIndices.Companion.commentsMapping(), true, (Continuation<? super Unit>)$continuation);
        if (v2 == var5_4) {
            return var5_4;
        }
        ** GOTO lbl39
        {
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl39:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void rolloverAndDeleteCommentsHistoryIndices() {
        this.rolloverCommentsHistoryIndex();
        this.deleteOldIndices("comments", COMMENTS_HISTORY_ALL);
    }

    private final void rolloverCommentsHistoryIndex() {
        String string = Companion.commentsMapping();
        Long l = this.commentsHistoryMaxDocs;
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"commentsHistoryMaxDocs");
        long l2 = ((Number)l).longValue();
        TimeValue timeValue = this.commentsHistoryMaxAge;
        Intrinsics.checkNotNullExpressionValue((Object)timeValue, (String)"commentsHistoryMaxAge");
        this.rolloverIndex(this.commentsHistoryIndexInitialized, COMMENTS_HISTORY_WRITE_INDEX, COMMENTS_HISTORY_INDEX_PATTERN, string, l2, timeValue, COMMENTS_HISTORY_WRITE_INDEX);
    }

    private final List<String> getIndicesToDelete(ClusterStateResponse clusterStateResponse) {
        List indicesToDelete = new ArrayList();
        Map map = clusterStateResponse.getState().getMetadata().getIndices();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getIndices(...)");
        for (Map.Entry entry : map.entrySet()) {
            IndexMetadata indexMetaData = (IndexMetadata)entry.getValue();
            Intrinsics.checkNotNull((Object)indexMetaData);
            String string = this.getHistoryIndexToDelete(indexMetaData, this.commentsHistoryRetentionPeriod.getMillis(), COMMENTS_HISTORY_WRITE_INDEX, true);
            if (string == null) continue;
            String it = string;
            boolean bl = false;
            indicesToDelete.add(it);
        }
        return indicesToDelete;
    }

    private final String getHistoryIndexToDelete(IndexMetadata indexMetadata, long retentionPeriodMillis, String writeIndex, boolean historyEnabled) {
        long creationTime = indexMetadata.getCreationDate();
        if (Instant.now().toEpochMilli() - creationTime > retentionPeriodMillis) {
            Object v0;
            block5: {
                Iterable $this$firstOrNull$iv = indexMetadata.getAliases().entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)writeIndex, (Object)((AliasMetadata)it.getValue()).getAlias())) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            Map.Entry alias = v0;
            if (alias != null) {
                if (historyEnabled) {
                    return null;
                }
                if (Intrinsics.areEqual((Object)writeIndex, (Object)COMMENTS_HISTORY_WRITE_INDEX)) {
                    this.commentsHistoryIndexInitialized = false;
                }
            }
            return indexMetadata.getIndex().getName();
        }
        return null;
    }

    private final void deleteAllOldHistoryIndices(List<String> indicesToDelete) {
        if (!((Collection)indicesToDelete).isEmpty()) {
            Collection $this$toTypedArray$iv = indicesToDelete;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(Arrays.copyOf(stringArray, stringArray.length));
            this.client.admin().indices().delete(deleteIndexRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(indicesToDelete, this){
                final /* synthetic */ List<String> $indicesToDelete;
                final /* synthetic */ CommentsIndices this$0;
                {
                    this.$indicesToDelete = $indicesToDelete;
                    this.this$0 = $receiver;
                }

                public void onResponse(AcknowledgedResponse deleteIndicesResponse) {
                    Intrinsics.checkNotNullParameter((Object)deleteIndicesResponse, (String)"deleteIndicesResponse");
                    if (!deleteIndicesResponse.isAcknowledged()) {
                        CommentsIndices.access$getLogger$cp().error("Could not delete one or more comments history indices: " + this.$indicesToDelete + ".Retrying one by one.");
                        CommentsIndices.access$deleteOldHistoryIndex(this.this$0, this.$indicesToDelete);
                    }
                }

                public void onFailure(Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    CommentsIndices.access$getLogger$cp().error("Delete for comments History Indices " + this.$indicesToDelete + " Failed. Retrying one By one.");
                    CommentsIndices.access$deleteOldHistoryIndex(this.this$0, this.$indicesToDelete);
                }
            });
        }
    }

    private final void deleteOldHistoryIndex(List<String> indicesToDelete) {
        for (String index : indicesToDelete) {
            Collection $this$toTypedArray$iv = indicesToDelete;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            DeleteIndexRequest singleDeleteRequest = new DeleteIndexRequest(Arrays.copyOf(stringArray, stringArray.length));
            this.client.admin().indices().delete(singleDeleteRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(index){
                final /* synthetic */ String $index;
                {
                    this.$index = $index;
                }

                public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                    if (acknowledgedResponse != null && !acknowledgedResponse.isAcknowledged()) {
                        CommentsIndices.access$getLogger$cp().error("Could not delete one or more comments history indices: " + this.$index);
                    }
                }

                public void onFailure(Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    CommentsIndices.access$getLogger$cp().debug("Exception " + e.getMessage() + " while deleting the index " + this.$index);
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object createIndex(String index, String schemaMapping, String alias, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof createIndex.1)) ** GOTO lbl-1000
        var10_5 = $completion;
        if ((var10_5.label & -2147483648) != 0) {
            var10_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ CommentsIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return CommentsIndices.access$createIndex(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = index;
                $continuation.L$1 = schemaMapping;
                $continuation.L$2 = alias;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client.admin().indices()), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, createIndex$lambda$8(java.lang.String org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((String)index), (Continuation)$continuation);
                if (v0 == var11_7) {
                    return var11_7;
                }
                ** GOTO lbl26
            }
            case 1: {
                alias = (String)$continuation.L$2;
                schemaMapping = (String)$continuation.L$1;
                index = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                if ((existsResponse = (IndicesExistsResponse)v0).isExists()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                CommentsIndices.logger.debug("index: [" + index + "] schema mappings: [" + schemaMapping + "]");
                request = new CreateIndexRequest(index).mapping(schemaMapping).settings(Settings.builder().put("index.hidden", true).build());
                if (alias != null) {
                    request.alias(new Alias(alias));
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)index);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)schemaMapping);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)alias);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)existsResponse);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.label = 2;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client.admin().indices()), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, createIndex$lambda$9(org.opensearch.action.admin.indices.create.CreateIndexRequest org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((CreateIndexRequest)request), (Continuation)$continuation);
                ** if (v1 != var11_7) goto lbl44
lbl43:
                // 1 sources

                return var11_7;
lbl44:
                // 1 sources

                ** GOTO lbl55
            }
            case 2: {
                request = (CreateIndexRequest)$continuation.L$4;
                existsResponse = (IndicesExistsResponse)$continuation.L$3;
                alias = (String)$continuation.L$2;
                schemaMapping = (String)$continuation.L$1;
                index = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl55:
                    // 2 sources

                    createIndexResponse = (CreateIndexResponse)v1;
                    var7_13 = createIndexResponse.isAcknowledged();
                }
                catch (Exception t) {
                    if (!(ExceptionsHelper.unwrapCause((Throwable)t) instanceof ResourceAlreadyExistsException)) {
                        throw t;
                    }
                    var7_13 = true;
                }
                return Boxing.boxBoolean((boolean)(var7_13 != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object createIndex$default(CommentsIndices commentsIndices, String string, String string2, String string3, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return commentsIndices.createIndex(string, string2, string3, (Continuation<? super Boolean>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateIndexMapping(String index, String mapping, boolean alias, Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateIndexMapping.1)) ** GOTO lbl-1000
        var11_5 = $completion;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ CommentsIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return CommentsIndices.access$updateIndexMapping(this.this$0, null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                clusterState = this.clusterService.state();
                targetIndex = index;
                if (alias) {
                    Intrinsics.checkNotNull((Object)clusterState);
                    targetIndex = IndexUtils.Companion.getIndexNameWithAlias(clusterState, index);
                }
                if (Intrinsics.areEqual((Object)targetIndex, (Object)IndexUtils.Companion.getLastUpdatedCommentsHistoryIndex())) {
                    return Unit.INSTANCE;
                }
                var9_11 = new String[]{targetIndex};
                v0 = new PutMappingRequest(var9_11).source(mapping, (MediaType)XContentType.JSON);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"source(...)");
                putMappingRequest = v0;
                $continuation.L$0 = index;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)mapping);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)clusterState);
                $continuation.L$3 = targetIndex;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)putMappingRequest);
                $continuation.Z$0 = alias;
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client.admin().indices()), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, updateIndexMapping$lambda$10(org.opensearch.action.admin.indices.mapping.put.PutMappingRequest org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((PutMappingRequest)putMappingRequest), (Continuation)$continuation);
                if (v1 == var12_7) {
                    return var12_7;
                }
                ** GOTO lbl43
            }
            case 1: {
                alias = $continuation.Z$0;
                putMappingRequest = (PutMappingRequest)$continuation.L$4;
                targetIndex = (String)$continuation.L$3;
                clusterState = (ClusterState)$continuation.L$2;
                mapping = (String)$continuation.L$1;
                index = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 2 sources

                if ((updateResponse = (AcknowledgedResponse)v1).isAcknowledged()) {
                    CommentsIndices.logger.info("Index mapping of " + targetIndex + " is updated");
                    this.setIndexUpdateFlag(index, targetIndex);
                } else {
                    CommentsIndices.logger.info("Failed to update index mapping of " + targetIndex);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object updateIndexMapping$default(CommentsIndices commentsIndices, String string, String string2, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return commentsIndices.updateIndexMapping(string, string2, bl, (Continuation<? super Unit>)continuation);
    }

    private final void setIndexUpdateFlag(String index, String targetIndex) {
        if (Intrinsics.areEqual((Object)index, (Object)COMMENTS_HISTORY_WRITE_INDEX)) {
            IndexUtils.Companion.setLastUpdatedCommentsHistoryIndex(targetIndex);
        }
    }

    private final void rolloverIndex(boolean initialized, String index, String pattern, String map, long docsCondition, TimeValue ageCondition, String writeIndex) {
        logger.info("in rolloverIndex, initialize: " + initialized);
        if (!initialized) {
            return;
        }
        logger.info("sending rollover request");
        RolloverRequest request = new RolloverRequest(index, null);
        request.getCreateIndexRequest().index(pattern).mapping(map).settings(Settings.builder().put("index.hidden", true).build());
        request.addMaxIndexDocsCondition(docsCondition);
        request.addMaxIndexAgeCondition(ageCondition);
        this.client.admin().indices().rolloverIndex(request, (ActionListener)new ActionListener<RolloverResponse>(writeIndex, this){
            final /* synthetic */ String $writeIndex;
            final /* synthetic */ CommentsIndices this$0;
            {
                this.$writeIndex = $writeIndex;
                this.this$0 = $receiver;
            }

            public void onResponse(RolloverResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (!response2.isRolledOver()) {
                    CommentsIndices.access$getLogger$cp().info(this.$writeIndex + " not rolled over. Conditions were: " + response2.getConditionStatus());
                } else {
                    CommentsIndices.access$getLogger$cp().info(this.$writeIndex + " rolled over. Conditions were: " + response2.getConditionStatus());
                    this.this$0.setLastRolloverTime(TimeValue.timeValueMillis((long)CommentsIndices.access$getThreadPool$p(this.this$0).absoluteTimeInMillis()));
                }
            }

            public void onFailure(Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CommentsIndices.access$getLogger$cp().error(this.$writeIndex + " not roll over failed.");
            }
        });
    }

    private final void deleteOldIndices(String tag, String indices) {
        String[] stringArray = new String[]{indices};
        ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(stringArray).metadata(true).local(true)).indicesOptions(IndicesOptions.strictExpand());
        this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(this, tag){
            final /* synthetic */ CommentsIndices this$0;
            final /* synthetic */ String $tag;
            {
                this.this$0 = $receiver;
                this.$tag = $tag;
            }

            public void onResponse(ClusterStateResponse clusterStateResponse) {
                Intrinsics.checkNotNullParameter((Object)clusterStateResponse, (String)"clusterStateResponse");
                Map map = clusterStateResponse.getState().getMetadata().getIndices();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getIndices(...)");
                if (!map.isEmpty()) {
                    List indicesToDelete = CommentsIndices.access$getIndicesToDelete(this.this$0, clusterStateResponse);
                    CommentsIndices.access$getLogger$cp().info("Deleting old " + this.$tag + " indices viz " + indicesToDelete);
                    CommentsIndices.access$deleteAllOldHistoryIndices(this.this$0, indicesToDelete);
                } else {
                    CommentsIndices.access$getLogger$cp().info("No Old " + this.$tag + " Indices to delete");
                }
            }

            public void onFailure(Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CommentsIndices.access$getLogger$cp().error("Error fetching cluster state");
            }
        });
    }

    private static final void _init_$lambda$0(CommentsIndices this$0, Long it) {
        this$0.commentsHistoryMaxDocs = it;
    }

    private static final void _init_$lambda$1(CommentsIndices this$0, TimeValue it) {
        this$0.commentsHistoryMaxAge = it;
    }

    private static final void _init_$lambda$2(CommentsIndices this$0, TimeValue it) {
        this$0.commentsHistoryRolloverPeriod = it;
        this$0.rescheduleCommentsRollover();
    }

    private static final void _init_$lambda$3(CommentsIndices this$0, TimeValue it) {
        this$0.commentsHistoryRetentionPeriod = it;
    }

    private static final void onManager$lambda$4(CommentsIndices this$0) {
        this$0.rolloverAndDeleteCommentsHistoryIndices();
    }

    private static final void rescheduleCommentsRollover$lambda$5(CommentsIndices this$0) {
        this$0.rolloverAndDeleteCommentsHistoryIndices();
    }

    private static final Unit createIndex$lambda$8(String $index, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{$index};
        $this$suspendUntil.exists((IndicesExistsRequest)new IndicesExistsRequest(stringArray).local(true), it);
        return Unit.INSTANCE;
    }

    private static final Unit createIndex$lambda$9(CreateIndexRequest $request, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.create($request, it);
        return Unit.INSTANCE;
    }

    private static final Unit updateIndexMapping$lambda$10(PutMappingRequest $putMappingRequest, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.putMapping($putMappingRequest, it);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final String commentsMapping() {
        return Companion.commentsMapping();
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$deleteOldHistoryIndex(CommentsIndices $this, List indicesToDelete) {
        $this.deleteOldHistoryIndex(indicesToDelete);
    }

    public static final /* synthetic */ Object access$createIndex(CommentsIndices $this, String index, String schemaMapping, String alias, Continuation $completion) {
        return $this.createIndex(index, schemaMapping, alias, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$updateIndexMapping(CommentsIndices $this, String index, String mapping, boolean alias, Continuation $completion) {
        return $this.updateIndexMapping(index, mapping, alias, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ ThreadPool access$getThreadPool$p(CommentsIndices $this) {
        return $this.threadPool;
    }

    public static final /* synthetic */ List access$getIndicesToDelete(CommentsIndices $this, ClusterStateResponse clusterStateResponse) {
        return $this.getIndicesToDelete(clusterStateResponse);
    }

    public static final /* synthetic */ void access$deleteAllOldHistoryIndices(CommentsIndices $this, List indicesToDelete) {
        $this.deleteAllOldHistoryIndices(indicesToDelete);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/opensearch/alerting/comments/CommentsIndices$Companion;", "", "<init>", "()V", "COMMENTS_HISTORY_WRITE_INDEX", "", "COMMENTS_HISTORY_ALL", "COMMENTS_HISTORY_INDEX_PATTERN", "ALL_COMMENTS_INDEX_PATTERN", "commentsMapping", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String commentsMapping() {
            URL uRL = CommentsIndices.class.getResource("alerting_comments.json");
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getResource(...)");
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            return new String(byArray, charset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

