/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.internal;

import com.amazonaws.annotation.ThreadSafe;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@ThreadSafe
public final class LRUCache<T> {
    private final Map<String, T> map;
    private final int maxSize;

    public LRUCache(int maxSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("maxSize " + maxSize + " must be at least 1");
        }
        this.maxSize = maxSize;
        this.map = Collections.synchronizedMap(new LRUHashMap(maxSize));
    }

    public T add(String key, T value) {
        return this.map.put(key, value);
    }

    public T get(String key) {
        return this.map.get(key);
    }

    public int size() {
        return this.map.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void clear() {
        this.map.clear();
    }

    public T remove(String key) {
        return this.map.remove(key);
    }

    public String toString() {
        return this.map.toString();
    }

    private static class LRUHashMap<T>
    extends LinkedHashMap<String, T> {
        private final int maxSize;

        private LRUHashMap(int maxSize) {
            super(10, 0.75f, true);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, T> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

