/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.rl;

import ai.djl.modality.rl.ReplayBuffer;
import ai.djl.modality.rl.env.RlEnv;
import ai.djl.util.RandomUtils;

public class LruReplayBuffer
implements ReplayBuffer {
    private int batchSize;
    private RlEnv.Step[] steps;
    private int firstStepIndex;
    private int stepsActualSize;

    public LruReplayBuffer(int batchSize, int bufferSize) {
        this.batchSize = batchSize;
        this.steps = new RlEnv.Step[bufferSize];
        this.firstStepIndex = 0;
        this.stepsActualSize = 0;
    }

    @Override
    public RlEnv.Step[] getBatch() {
        RlEnv.Step[] batch = new RlEnv.Step[this.batchSize];
        for (int i = 0; i < this.batchSize; ++i) {
            int baseIndex = RandomUtils.nextInt(this.stepsActualSize);
            int index = Math.floorMod(this.firstStepIndex + baseIndex, this.steps.length);
            batch[i] = this.steps[index];
        }
        return batch;
    }

    @Override
    public void addStep(RlEnv.Step step) {
        if (this.stepsActualSize == this.steps.length) {
            int stepToReplace = Math.floorMod(this.firstStepIndex - 1, this.steps.length);
            this.steps[stepToReplace].close();
            this.steps[stepToReplace] = step;
            this.firstStepIndex = Math.floorMod(this.firstStepIndex + 1, this.steps.length);
        } else {
            this.steps[this.stepsActualSize] = step;
            ++this.stepsActualSize;
        }
    }
}

