/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer.memory;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.action.memorycontainer.memory.MemoryInfo;
import org.opensearch.ml.common.memorycontainer.MLLongTermMemory;
import org.opensearch.ml.common.memorycontainer.MemoryConfiguration;
import org.opensearch.ml.common.memorycontainer.MemoryDecision;
import org.opensearch.ml.common.memorycontainer.MemoryStrategy;
import org.opensearch.ml.common.memorycontainer.MemoryStrategyType;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLAddMemoriesInput;
import org.opensearch.ml.common.transport.memorycontainer.memory.MemoryEvent;
import org.opensearch.ml.common.transport.memorycontainer.memory.MemoryResult;
import org.opensearch.ml.helper.MemoryContainerHelper;
import org.opensearch.ml.utils.MLExceptionUtils;

public class MemoryOperationsService {
    @Generated
    private static final Logger log = LogManager.getLogger(MemoryOperationsService.class);
    private final MemoryContainerHelper memoryContainerHelper;

    public MemoryOperationsService(MemoryContainerHelper memoryContainerHelper) {
        this.memoryContainerHelper = memoryContainerHelper;
    }

    private MemoryStrategyType getMemoryTypeFromStrategy(MemoryStrategy strategy) {
        MemoryStrategyType type = strategy.getType();
        return type != null ? type : MemoryStrategyType.SEMANTIC;
    }

    public void executeMemoryOperations(List<MemoryDecision> decisions, MemoryConfiguration memoryConfig, Map<String, String> namespace, User user, MLAddMemoriesInput input, MemoryStrategy strategy, ActionListener<List<MemoryResult>> listener) {
        String longTermMemoryIndex = memoryConfig.getLongMemoryIndexName();
        String longTermMemoryHistoryIndex = memoryConfig.getLongMemoryHistoryIndexName();
        ArrayList<MemoryResult> results = new ArrayList<MemoryResult>();
        ArrayList<IndexRequest> addRequests = new ArrayList<IndexRequest>();
        ArrayList<UpdateRequest> updateRequests = new ArrayList<UpdateRequest>();
        ArrayList<DeleteRequest> deleteRequests = new ArrayList<DeleteRequest>();
        Instant now = Instant.now();
        for (MemoryDecision memoryDecision : decisions) {
            switch (memoryDecision.getEvent()) {
                case ADD: {
                    MLLongTermMemory mLLongTermMemory = MLLongTermMemory.builder().ownerId(input.getOwnerId()).memoryContainerId(input.getMemoryContainerId()).memory(memoryDecision.getText()).strategyType(this.getMemoryTypeFromStrategy(strategy)).namespace(namespace).tags(input.getTags()).strategyId(strategy.getId()).createdTime(now).lastUpdatedTime(now).build();
                    IndexRequest addRequest = new IndexRequest(longTermMemoryIndex).source(mLLongTermMemory.toIndexMap());
                    addRequests.add(addRequest);
                    MemoryResult memoryResult = MemoryResult.builder().ownerId(input.getOwnerId()).memoryId(null).memory(memoryDecision.getText()).event(MemoryEvent.ADD).oldMemory(null).build();
                    results.add(memoryResult);
                    break;
                }
                case UPDATE: {
                    HashMap<String, Object> updateDoc = new HashMap<String, Object>();
                    updateDoc.put("memory", memoryDecision.getText());
                    updateDoc.put("last_updated_time", now.toEpochMilli());
                    UpdateRequest updateRequest = new UpdateRequest(longTermMemoryIndex, memoryDecision.getId()).doc(updateDoc);
                    updateRequests.add(updateRequest);
                    MemoryResult memoryResult = MemoryResult.builder().ownerId(input.getOwnerId()).memoryId(memoryDecision.getId()).memory(memoryDecision.getText()).event(MemoryEvent.UPDATE).oldMemory(memoryDecision.getOldMemory()).build();
                    results.add(memoryResult);
                    break;
                }
                case DELETE: {
                    DeleteRequest deleteRequest = new DeleteRequest(longTermMemoryIndex, memoryDecision.getId());
                    deleteRequests.add(deleteRequest);
                    MemoryResult memoryResult = MemoryResult.builder().ownerId(input.getOwnerId()).memoryId(memoryDecision.getId()).memory(memoryDecision.getText()).event(MemoryEvent.DELETE).oldMemory(null).build();
                    results.add(memoryResult);
                    break;
                }
            }
        }
        BulkRequest bulkRequest = new BulkRequest().setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        for (IndexRequest indexRequest : addRequests) {
            bulkRequest.add(indexRequest);
        }
        for (UpdateRequest updateRequest : updateRequests) {
            bulkRequest.add(updateRequest);
        }
        for (DeleteRequest deleteRequest : deleteRequests) {
            bulkRequest.add(deleteRequest);
        }
        if (bulkRequest.requests().isEmpty()) {
            log.debug("No memory operations to execute");
            listener.onResponse(results);
            return;
        }
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ActionListener actionListener = ActionListener.wrap(bulkResponse -> {
            if (bulkResponse.hasFailures()) {
                log.error("Bulk memory operations had failures: {}", (Object)bulkResponse.buildFailureMessage());
            }
            log.debug("Executed {} memory operations successfully", (Object)bulkResponse.getItems().length);
            BulkItemResponse[] items = bulkResponse.getItems();
            for (int i = 0; i < bulkResponse.getItems().length; ++i) {
                MemoryResult result = (MemoryResult)results.get(i);
                if (result.getEvent() != MemoryEvent.ADD || items[i].isFailed()) continue;
                String actualId = items[i].getId();
                ((MemoryResult)results.get(i)).setMemoryId(actualId);
            }
            if (memoryConfig.isDisableHistory()) {
                listener.onResponse((Object)results);
                return;
            }
            BulkRequest bulkHistoryRequest = new BulkRequest().setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            for (MemoryResult memoryResult : results) {
                bulkHistoryRequest.add(new IndexRequest(longTermMemoryHistoryIndex).source(this.createMemoryHistory(memoryResult, namespace, input, input.getMemoryContainerId())));
            }
            bulkHistoryRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            ActionListener bulkHistoryResponseListener = ActionListener.wrap(bulkHistoryResponse -> {
                if (bulkHistoryResponse.hasFailures()) {
                    log.error("Bulk memory history operations had failures: {}", (Object)bulkHistoryResponse.buildFailureMessage());
                }
                listener.onResponse((Object)results);
            }, e -> {
                log.error("Failed to execute memory history operations", (Throwable)e);
                listener.onFailure(e);
            });
            this.memoryContainerHelper.bulkIngestData(memoryConfig, bulkHistoryRequest, (ActionListener<BulkResponse>)bulkHistoryResponseListener);
        }, e -> {
            log.error("Failed to execute memory operations", (Throwable)e);
            listener.onFailure(e);
        });
        this.memoryContainerHelper.bulkIngestData(memoryConfig, bulkRequest, (ActionListener<BulkResponse>)actionListener);
    }

    public void writeErrorToMemoryHistory(MemoryConfiguration configuration, Map<String, String> strategyNamespace, MLAddMemoriesInput input, Exception exception) {
        Map<String, Object> errorMemoryHistory = this.createErrorMemoryHistory(strategyNamespace, input, exception, input.getMemoryContainerId());
        IndexRequest indexRequest = new IndexRequest(configuration.getLongMemoryHistoryIndexName());
        indexRequest.source(errorMemoryHistory);
        this.memoryContainerHelper.indexData(configuration, indexRequest, (ActionListener<IndexResponse>)ActionListener.wrap(r -> log.debug("Successfully indexed error memory history"), e -> log.error("Failed to index error memory history", (Throwable)e)));
    }

    public Map<String, Object> createErrorMemoryHistory(Map<String, String> strategyNamespace, MLAddMemoriesInput input, Exception exception, String memoryContainerId) {
        HashMap<String, Object> history = new HashMap<String, Object>();
        String ownerId = input.getOwnerId();
        Map tags = input.getTags();
        if (ownerId == null) {
            history.put("owner_id", ownerId);
        }
        if (memoryContainerId != null) {
            history.put("memory_container_id", memoryContainerId);
        }
        history.put("created_time", Instant.now().toEpochMilli());
        if (strategyNamespace != null && strategyNamespace.size() > 0) {
            history.put("namespace", strategyNamespace);
            history.put("namespace_size", strategyNamespace.size());
        }
        if (tags != null) {
            history.put("tags", tags);
        }
        history.put("error", MLExceptionUtils.getRootCauseMessage(exception));
        return history;
    }

    private Map<String, Object> createMemoryHistory(MemoryResult memoryResult, Map<String, String> strategyNamespace, MLAddMemoriesInput input, String memoryContainerId) {
        HashMap<String, Object> history = new HashMap<String, Object>();
        if (memoryResult.getOwnerId() != null) {
            history.put("owner_id", memoryResult.getOwnerId());
        }
        if (memoryContainerId != null) {
            history.put("memory_container_id", memoryContainerId);
        }
        history.put("memory_id", memoryResult.getMemoryId());
        history.put("action", memoryResult.getEvent().getValue());
        if (memoryResult.getOldMemory() != null) {
            history.put("before", Map.of("memory", memoryResult.getOldMemory()));
        }
        if (memoryResult.getMemory() != null) {
            if (memoryResult.getEvent() == MemoryEvent.DELETE) {
                history.put("before", Map.of("memory", memoryResult.getMemory()));
            } else {
                history.put("after", Map.of("memory", memoryResult.getMemory()));
            }
        }
        history.put("created_time", Instant.now().toEpochMilli());
        if (strategyNamespace != null && strategyNamespace.size() > 0) {
            history.put("namespace", strategyNamespace);
            history.put("namespace_size", strategyNamespace.size());
        }
        if (input.getTags() != null) {
            history.put("tags", input.getTags());
        }
        return history;
    }

    public void createFactMemoriesFromList(List<String> facts, String indexName, MLAddMemoriesInput input, Map<String, String> strategyNameSpace, User user, MemoryStrategy strategy, List<IndexRequest> indexRequests, List<MemoryInfo> memoryInfos, String memoryContainerId) {
        Instant now = Instant.now();
        for (String fact : facts) {
            MLLongTermMemory factMemory = MLLongTermMemory.builder().memory(fact).strategyType(this.getMemoryTypeFromStrategy(strategy)).namespace(strategyNameSpace).tags(input.getTags()).memoryContainerId(memoryContainerId).strategyId(strategy.getId()).createdTime(now).lastUpdatedTime(now).build();
            IndexRequest request = new IndexRequest(indexName).source(factMemory.toIndexMap());
            indexRequests.add(request);
            memoryInfos.add(new MemoryInfo(null, factMemory.getMemory(), factMemory.getStrategyType(), true));
        }
    }
}

