/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.deque;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.deque.DequeIterBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.deque.DequeIterBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.deque.DequeIterCommonBuiltins;
import com.oracle.graal.python.builtins.objects.deque.PDeque;
import com.oracle.graal.python.builtins.objects.deque.PDequeIter;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PDequeIter})
public final class DequeIterBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = DequeIterBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DequeIterBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="_deque_iterator", minNumOfPositionalArgs=2, parameterNames={"$self", "iterable", "index"})
    @GenerateNodeFactory
    public static abstract class DequeIterNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        static PDequeIter doGeneric(VirtualFrame frame, Object cls, Object deque, Object indexObj, @Bind Node inliningTarget, @Cached InlinedConditionProfile dequeProfile, @Cached InlinedConditionProfile indexNoneProfile, @Cached PyNumberIndexNode toIndexNode, @Cached CastToJavaIntExactNode castToJavaIntExactNode, @Cached DequeIterCommonBuiltins.DequeIterNextNode getNextNode, @Bind PythonLanguage language, @Cached PRaiseNode raiseNode) {
            if (!dequeProfile.profile(inliningTarget, deque instanceof PDeque)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_OBJ_TYPE_S_GOT_P, BuiltinNames.T_DEQUE, deque);
            }
            PDequeIter dequeIter = PFactory.createDequeIter(language, (PDeque)deque);
            if (indexNoneProfile.profile(inliningTarget, indexObj != PNone.NO_VALUE)) {
                int index = castToJavaIntExactNode.execute(inliningTarget, toIndexNode.execute((Frame)frame, inliningTarget, indexObj));
                for (int i = 0; i < index; ++i) {
                    getNextNode.execute(dequeIter);
                }
            }
            return dequeIter;
        }
    }
}

