/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_update_contract_session.h
 * @brief implementation of the update_contract_session function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_UPDATE_CONTRACT_SESSION_H
#define PG_UPDATE_CONTRACT_SESSION_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Update session associated with a contract and return
 * the fulfillment URL and the refund status.
 *
 * @param cls closure
 * @param instance_id instance to mark contract as paid for
 * @param h_contract_terms hash of the contract that is now paid
 * @param session_id the session that paid the contract
 * @param[out] fulfillment_url set to the fulfillment URL (possibly NULL)
 * @param[out] refunded set to true if the order was refunded
 * @return transaction status
 */
enum GNUNET_DB_QueryStatus
TMH_PG_update_contract_session (
  void *cls,
  const char *instance_id,
  const struct TALER_PrivateContractHashP *h_contract_terms,
  const char *session_id,
  char **fulfillment_url,
  bool *refunded);

#endif
