//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cglayer?language=objc)
#[repr(C)]
pub struct CGLayer {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CGLayer {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"CGLayer"> for CGLayer {}
);

impl CGLayer {
    #[doc(alias = "CGLayerCreateWithContext")]
    #[cfg(feature = "CGContext")]
    #[inline]
    pub unsafe fn with_context(
        context: Option<&CGContext>,
        size: CGSize,
        auxiliary_info: Option<&CFDictionary>,
    ) -> Option<CFRetained<CGLayer>> {
        extern "C-unwind" {
            fn CGLayerCreateWithContext(
                context: Option<&CGContext>,
                size: CGSize,
                auxiliary_info: Option<&CFDictionary>,
            ) -> Option<NonNull<CGLayer>>;
        }
        let ret = unsafe { CGLayerCreateWithContext(context, size, auxiliary_info) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGLayerGetSize")]
    #[inline]
    pub unsafe fn size(layer: Option<&CGLayer>) -> CGSize {
        extern "C-unwind" {
            fn CGLayerGetSize(layer: Option<&CGLayer>) -> CGSize;
        }
        unsafe { CGLayerGetSize(layer) }
    }

    #[doc(alias = "CGLayerGetContext")]
    #[cfg(feature = "CGContext")]
    #[inline]
    pub unsafe fn context(layer: Option<&CGLayer>) -> Option<CFRetained<CGContext>> {
        extern "C-unwind" {
            fn CGLayerGetContext(layer: Option<&CGLayer>) -> Option<NonNull<CGContext>>;
        }
        let ret = unsafe { CGLayerGetContext(layer) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }
}

#[cfg(feature = "CGContext")]
impl CGContext {
    #[doc(alias = "CGContextDrawLayerInRect")]
    #[cfg(feature = "CGContext")]
    #[inline]
    pub unsafe fn draw_layer_in_rect(
        context: Option<&CGContext>,
        rect: CGRect,
        layer: Option<&CGLayer>,
    ) {
        extern "C-unwind" {
            fn CGContextDrawLayerInRect(
                context: Option<&CGContext>,
                rect: CGRect,
                layer: Option<&CGLayer>,
            );
        }
        unsafe { CGContextDrawLayerInRect(context, rect, layer) }
    }

    #[doc(alias = "CGContextDrawLayerAtPoint")]
    #[cfg(feature = "CGContext")]
    #[inline]
    pub unsafe fn draw_layer_at_point(
        context: Option<&CGContext>,
        point: CGPoint,
        layer: Option<&CGLayer>,
    ) {
        extern "C-unwind" {
            fn CGContextDrawLayerAtPoint(
                context: Option<&CGContext>,
                point: CGPoint,
                layer: Option<&CGLayer>,
            );
        }
        unsafe { CGContextDrawLayerAtPoint(context, point, layer) }
    }
}

unsafe impl ConcreteType for CGLayer {
    #[doc(alias = "CGLayerGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGLayerGetTypeID() -> CFTypeID;
        }
        unsafe { CGLayerGetTypeID() }
    }
}

#[cfg(feature = "CGContext")]
#[deprecated = "renamed to `CGLayer::with_context`"]
#[inline]
pub unsafe extern "C-unwind" fn CGLayerCreateWithContext(
    context: Option<&CGContext>,
    size: CGSize,
    auxiliary_info: Option<&CFDictionary>,
) -> Option<CFRetained<CGLayer>> {
    extern "C-unwind" {
        fn CGLayerCreateWithContext(
            context: Option<&CGContext>,
            size: CGSize,
            auxiliary_info: Option<&CFDictionary>,
        ) -> Option<NonNull<CGLayer>>;
    }
    let ret = unsafe { CGLayerCreateWithContext(context, size, auxiliary_info) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGLayer::size`"]
    pub fn CGLayerGetSize(layer: Option<&CGLayer>) -> CGSize;
}

#[cfg(feature = "CGContext")]
#[deprecated = "renamed to `CGLayer::context`"]
#[inline]
pub unsafe extern "C-unwind" fn CGLayerGetContext(
    layer: Option<&CGLayer>,
) -> Option<CFRetained<CGContext>> {
    extern "C-unwind" {
        fn CGLayerGetContext(layer: Option<&CGLayer>) -> Option<NonNull<CGContext>>;
    }
    let ret = unsafe { CGLayerGetContext(layer) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CGContext")]
    #[deprecated = "renamed to `CGContext::draw_layer_in_rect`"]
    pub fn CGContextDrawLayerInRect(
        context: Option<&CGContext>,
        rect: CGRect,
        layer: Option<&CGLayer>,
    );
}

extern "C-unwind" {
    #[cfg(feature = "CGContext")]
    #[deprecated = "renamed to `CGContext::draw_layer_at_point`"]
    pub fn CGContextDrawLayerAtPoint(
        context: Option<&CGContext>,
        point: CGPoint,
        layer: Option<&CGLayer>,
    );
}
