/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_te extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "\u0c28\u0c4c\u0c30\u0c41";
        final String metaValue_TK = "\u0c1f\u0c4b\u0c15\u0c46\u0c32\u0c3e\u0c35\u0c4d";
        final String metaValue_TV = "\u0c1f\u0c41\u0c35\u0c3e\u0c32\u0c41";
        final String metaValue_ae = "\u0c05\u0c35\u0c47\u0c38\u0c4d\u0c1f\u0c3e\u0c28\u0c4d";
        final String metaValue_ar = "\u0c05\u0c30\u0c2c\u0c3f\u0c15\u0c4d";
        final String metaValue_bo = "\u0c1f\u0c3f\u0c2c\u0c46\u0c1f\u0c28\u0c4d";
        final String metaValue_el = "\u0c17\u0c4d\u0c30\u0c40\u0c15\u0c4d";
        final String metaValue_jv = "\u0c1c\u0c3e\u0c35\u0c28\u0c40\u0c38\u0c4d";
        final String metaValue_ka = "\u0c1c\u0c3e\u0c30\u0c4d\u0c1c\u0c3f\u0c2f\u0c28\u0c4d";
        final String metaValue_km = "\u0c16\u0c4d\u0c2e\u0c47\u0c30\u0c4d";
        final String metaValue_kn = "\u0c15\u0c28\u0c4d\u0c28\u0c21";
        final String metaValue_ko = "\u0c15\u0c4a\u0c30\u0c3f\u0c2f\u0c28\u0c4d";
        final String metaValue_la = "\u0c32\u0c3e\u0c1f\u0c3f\u0c28\u0c4d";
        final String metaValue_lo = "\u0c32\u0c3e\u0c35\u0c4b";
        final String metaValue_ml = "\u0c2e\u0c32\u0c2f\u0c3e\u0c33\u0c02";
        final String metaValue_mn = "\u0c2e\u0c02\u0c17\u0c4b\u0c32\u0c3f\u0c2f\u0c28\u0c4d";
        final String metaValue_or = "\u0c12\u0c21\u0c3f\u0c2f\u0c3e";
        final String metaValue_si = "\u0c38\u0c3f\u0c02\u0c39\u0c33\u0c02";
        final String metaValue_ta = "\u0c24\u0c2e\u0c3f\u0c33\u0c2e\u0c41";
        final String metaValue_te = "\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41";
        final String metaValue_th = "\u0c25\u0c3e\u0c2f\u0c4d";
        final String metaValue_tl = "\u0c1f\u0c17\u0c32\u0c3e\u0c17\u0c4d";
        final String metaValue_ban = "\u0c2c\u0c3e\u0c32\u0c3f\u0c28\u0c40\u0c38\u0c4d";
        final String metaValue_ccp = "\u0c1a\u0c15\u0c4d\u0c2e\u0c3e";
        final String metaValue_cop = "\u0c15\u0c4b\u0c2a\u0c4d\u0c1f\u0c3f\u0c15\u0c4d";
        final String metaValue_nqo = "\u0c28\u0c4d\u0c15\u0c4b";
        final String metaValue_peo = "\u0c2a\u0c4d\u0c30\u0c3e\u0c1a\u0c40\u0c28 \u0c2a\u0c30\u0c4d\u0c37\u0c3f\u0c2f\u0c28\u0c4d";
        final String metaValue_syr = "\u0c38\u0c3f\u0c30\u0c3f\u0c2f\u0c3e\u0c15\u0c4d";
        final String metaValue_vai = "\u0c35\u0c3e\u0c2f\u0c3f";
        final String metaValue_type_ca_islamic = "\u0c07\u0c38\u0c4d\u0c32\u0c3e\u0c2e\u0c3f\u0c15\u0c4d \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0c15\u0c4a\u0c32\u0c4b\u0c28\u0c3f\u0c2f\u0c28\u0c4d" },
            { "Ogam", "\u0c12\u0c18\u0c2e\u0c4d" },
            { "mwl", "\u0c2e\u0c3f\u0c30\u0c3e\u0c02\u0c21\u0c3f\u0c38\u0c4d" },
            { "Zsym", "\u0c1a\u0c3f\u0c39\u0c4d\u0c28\u0c3e\u0c32\u0c41" },
            { "cch", "\u0c05\u0c1f\u0c4d\u0c38\u0c3e\u0c2e\u0c4d" },
            { "mwr", "\u0c2e\u0c3e\u0c30\u0c4d\u0c35\u0c3e\u0c21\u0c3f" },
            { "Tagb", "\u0c1f\u0c3e\u0c17\u0c4d\u0c2c\u0c3e\u0c28\u0c35\u0c3e" },
            { "Zsye", "\u0c0e\u0c2e\u0c4b\u0c1c\u0c3f" },
            { "ccp", metaValue_ccp },
            { "egy", "\u0c2a\u0c4d\u0c30\u0c3e\u0c1a\u0c40\u0c28 \u0c08\u0c1c\u0c3f\u0c2a\u0c4d\u0c37\u0c3f\u0c2f\u0c28\u0c4d" },
            { "raj", "\u0c30\u0c3e\u0c1c\u0c38\u0c4d\u0c24\u0c3e\u0c28\u0c40" },
            { "Phag", "\u0c2b\u0c3e\u0c17\u0c4d\u0c38\u0c4d-\u0c2a\u0c3e" },
            { "tem", "\u0c1f\u0c3f\u0c2e\u0c4d\u0c28\u0c47" },
            { "teo", "\u0c1f\u0c46\u0c38\u0c4b" },
            { "rap", "\u0c30\u0c3e\u0c2a\u0c28\u0c4d\u0c2f\u0c41\u0c2f\u0c3f" },
            { "ter", "\u0c1f\u0c46\u0c30\u0c46\u0c28\u0c4b" },
            { "AC", "\u0c05\u0c38\u0c46\u0c28\u0c4d\u0c37\u0c28\u0c4d \u0c26\u0c40\u0c35\u0c3f" },
            { "rar", "\u0c30\u0c3e\u0c30\u0c4b\u0c1f\u0c4a\u0c02\u0c17\u0c3e\u0c28\u0c4d" },
            { "tet", "\u0c1f\u0c47\u0c1f\u0c02" },
            { "AD", "\u0c06\u0c02\u0c21\u0c4b\u0c30\u0c3e" },
            { "AE", "\u0c2f\u0c41\u0c28\u0c48\u0c1f\u0c46\u0c21\u0c4d \u0c05\u0c30\u0c2c\u0c4d \u0c0e\u0c2e\u0c3f\u0c30\u0c47\u0c1f\u0c4d\u0c38\u0c4d" },
            { "nl_BE", "\u0c2b\u0c4d\u0c32\u0c46\u0c2e\u0c3f\u0c37\u0c4d" },
            { "AF", "\u0c06\u0c2b\u0c4d\u0c18\u0c28\u0c3f\u0c38\u0c4d\u0c24\u0c3e\u0c28\u0c4d" },
            { "AG", "\u0c06\u0c02\u0c1f\u0c3f\u0c17\u0c4d\u0c35\u0c3e \u0c2e\u0c30\u0c3f\u0c2f\u0c41 \u0c2c\u0c3e\u0c30\u0c4d\u0c2c\u0c41\u0c21\u0c3e" },
            { "type.ca.ethiopic", "\u0c0e\u0c25\u0c3f\u0c2f\u0c4b\u0c2a\u0c3f\u0c15\u0c4d \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "AI", "\u0c06\u0c02\u0c17\u0c4d\u0c35\u0c3f\u0c32\u0c4d\u0c32\u0c3e" },
            { "key.tz", "\u0c38\u0c2e\u0c2f \u0c2e\u0c02\u0c21\u0c32\u0c3f" },
            { "AL", "\u0c05\u0c32\u0c4d\u0c2c\u0c47\u0c28\u0c3f\u0c2f\u0c3e" },
            { "AM", "\u0c06\u0c30\u0c4d\u0c2e\u0c47\u0c28\u0c3f\u0c2f\u0c3e" },
            { "Teng", "\u0c1f\u0c47\u0c02\u0c17\u0c4d\u0c35\u0c3e\u0c30\u0c4d" },
            { "AO", "\u0c05\u0c02\u0c17\u0c4b\u0c32\u0c3e" },
            { "AQ", "\u0c05\u0c02\u0c1f\u0c3e\u0c30\u0c4d\u0c15\u0c3f\u0c1f\u0c3f\u0c15\u0c3e" },
            { "AR", "\u0c05\u0c30\u0c4d\u0c1c\u0c46\u0c02\u0c1f\u0c40\u0c28\u0c3e" },
            { "Prti", "\u0c07\u0c02\u0c38\u0c4d\u0c15\u0c4d\u0c30\u0c3f\u0c2a\u0c4d\u0c37\u0c28\u0c3e\u0c32\u0c4d \u0c2a\u0c3e\u0c30\u0c4d\u0c25\u0c3f\u0c2f\u0c28\u0c4d" },
            { "AS", "\u0c05\u0c2e\u0c46\u0c30\u0c3f\u0c15\u0c28\u0c4d \u0c38\u0c2e\u0c4b\u0c35\u0c3e" },
            { "AT", "\u0c06\u0c38\u0c4d\u0c1f\u0c4d\u0c30\u0c3f\u0c2f\u0c3e" },
            { "AU", "\u0c06\u0c38\u0c4d\u0c1f\u0c4d\u0c30\u0c47\u0c32\u0c3f\u0c2f\u0c3e" },
            { "AW", "\u0c05\u0c30\u0c41\u0c2c\u0c3e" },
            { "en_US", "\u0c05\u0c2e\u0c46\u0c30\u0c3f\u0c15\u0c28\u0c4d \u0c07\u0c02\u0c17\u0c4d\u0c32\u0c40\u0c37\u0c4d" },
            { "AX", "\u0c06\u0c32\u0c3e\u0c02\u0c21\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "AZ", "\u0c05\u0c1c\u0c30\u0c4d\u0c2c\u0c48\u0c1c\u0c3e\u0c28\u0c4d" },
            { "BA", "\u0c2c\u0c4b\u0c38\u0c4d\u0c28\u0c3f\u0c2f\u0c3e \u0c2e\u0c30\u0c3f\u0c2f\u0c41 \u0c39\u0c46\u0c30\u0c4d\u0c1c\u0c3f\u0c17\u0c4b\u0c35\u0c3f\u0c28\u0c3e" },
            { "BB", "\u0c2c\u0c3e\u0c30\u0c4d\u0c2c\u0c21\u0c4b\u0c38\u0c4d" },
            { "ceb", "\u0c38\u0c46\u0c2c\u0c41\u0c35\u0c3e\u0c28\u0c4b" },
            { "BD", "\u0c2c\u0c02\u0c17\u0c4d\u0c32\u0c3e\u0c26\u0c47\u0c36\u0c4d" },
            { "kum", "\u0c15\u0c41\u0c2e\u0c4d\u0c2f\u0c3f\u0c15\u0c4d" },
            { "BE", "\u0c2c\u0c46\u0c32\u0c4d\u0c1c\u0c3f\u0c2f\u0c02" },
            { "gmh", "\u0c2e\u0c27\u0c4d\u0c2f\u0c2e \u0c39\u0c48 \u0c1c\u0c30\u0c4d\u0c2e\u0c28\u0c4d" },
            { "BF", "\u0c2c\u0c41\u0c30\u0c4d\u0c15\u0c3f\u0c28\u0c3e \u0c2b\u0c3e\u0c38\u0c4b" },
            { "BG", "\u0c2c\u0c32\u0c4d\u0c17\u0c47\u0c30\u0c3f\u0c2f\u0c3e" },
            { "BH", "\u0c2c\u0c39\u0c4d\u0c30\u0c46\u0c2f\u0c3f\u0c28\u0c4d" },
            { "BI", "\u0c2c\u0c41\u0c30\u0c41\u0c02\u0c21\u0c3f" },
            { "BJ", "\u0c2c\u0c46\u0c28\u0c3f\u0c28\u0c4d" },
            { "BL", "\u0c38\u0c46\u0c2f\u0c3f\u0c02\u0c1f\u0c4d \u0c2c\u0c30\u0c4d\u0c25\u0c46\u0c32\u0c3f\u0c2e\u0c3f" },
            { "BM", "\u0c2c\u0c46\u0c30\u0c4d\u0c2e\u0c41\u0c21\u0c3e" },
            { "kut", "\u0c15\u0c41\u0c1f\u0c47\u0c28\u0c48" },
            { "myv", "\u0c0e\u0c30\u0c4d\u0c1c\u0c3f\u0c2f\u0c3e" },
            { "BN", "\u0c2c\u0c4d\u0c30\u0c42\u0c28\u0c47" },
            { "BO", "\u0c2c\u0c4a\u0c32\u0c40\u0c35\u0c3f\u0c2f\u0c3e" },
            { "BQ", "\u0c15\u0c30\u0c40\u0c2c\u0c3f\u0c2f\u0c28\u0c4d \u0c28\u0c46\u0c26\u0c30\u0c4d\u0c32\u0c3e\u0c02\u0c21\u0c4d\u0c38\u0c4d" },
            { "BR", "\u0c2c\u0c4d\u0c30\u0c46\u0c1c\u0c3f\u0c32\u0c4d" },
            { "BS", "\u0c2c\u0c39\u0c3e\u0c2e\u0c3e\u0c38\u0c4d" },
            { "xog", "\u0c38\u0c4a\u0c17\u0c3e" },
            { "BT", "\u0c2d\u0c42\u0c1f\u0c3e\u0c28\u0c4d" },
            { "BV", "\u0c2c\u0c41\u0c35\u0c48 \u0c26\u0c40\u0c35\u0c3f" },
            { "BW", "\u0c2c\u0c4b\u0c1f\u0c4d\u0c38\u0c4d\u0c35\u0c3e\u0c28\u0c3e" },
            { "BY", "\u0c2c\u0c46\u0c32\u0c3e\u0c30\u0c38\u0c4d" },
            { "BZ", "\u0c2c\u0c46\u0c32\u0c3f\u0c1c\u0c4d" },
            { "Visp", "\u0c15\u0c28\u0c3f\u0c2a\u0c3f\u0c02\u0c1a\u0c47 \u0c2d\u0c3e\u0c37" },
            { "type.ca.persian", "\u0c2a\u0c30\u0c4d\u0c37\u0c3f\u0c2f\u0c28\u0c4d \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "type.nu.hebr", "\u0c39\u0c3f\u0c2c\u0c4d\u0c30\u0c42 \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "CA", "\u0c15\u0c46\u0c28\u0c21\u0c3e" },
            { "CC", "\u0c15\u0c4b\u0c15\u0c4b\u0c38\u0c4d (\u0c15\u0c40\u0c32\u0c3f\u0c02\u0c17\u0c4d) \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "mzn", "\u0c2e\u0c3e\u0c38\u0c28\u0c4d\u200c\u0c26\u0c46\u0c30\u0c3e\u0c28\u0c3f" },
            { "CD", "\u0c15\u0c3e\u0c02\u0c17\u0c4b- \u0c15\u0c3f\u0c28\u0c4d\u0c37\u0c3e\u0c38\u0c3e" },
            { "CF", "\u0c38\u0c46\u0c02\u0c1f\u0c4d\u0c30\u0c32\u0c4d \u0c06\u0c2b\u0c4d\u0c30\u0c3f\u0c15\u0c28\u0c4d \u0c30\u0c3f\u0c2a\u0c2c\u0c4d\u0c32\u0c3f\u0c15\u0c4d" },
            { "CG", "\u0c15\u0c3e\u0c02\u0c17\u0c4b- \u0c2c\u0c4d\u0c30\u0c3e\u0c1c\u0c3e\u0c35\u0c3f\u0c32\u0c4d\u0c32\u0c3f" },
            { "CH", "\u0c38\u0c4d\u0c35\u0c3f\u0c1f\u0c4d\u0c1c\u0c30\u0c4d\u0c32\u0c3e\u0c02\u0c21\u0c4d" },
            { "CI", "\u0c15\u0c4b\u0c1f\u0c4d \u0c21\u0c3f \u0c10\u0c35\u0c4b\u0c30\u0c4d" },
            { "CK", "\u0c15\u0c41\u0c15\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "CL", "\u0c1a\u0c3f\u0c32\u0c40" },
            { "Kthi", "\u0c15\u0c48\u0c25\u0c3f" },
            { "CM", "\u0c15\u0c3e\u0c2e\u0c46\u0c30\u0c42\u0c28\u0c4d" },
            { "CN", "\u0c1a\u0c48\u0c28\u0c3e" },
            { "CO", "\u0c15\u0c4a\u0c32\u0c02\u0c2c\u0c3f\u0c2f\u0c3e" },
            { "CP", "\u0c15\u0c4d\u0c32\u0c3f\u0c2a\u0c4d\u0c2a\u0c30\u0c4d\u0c1f\u0c28\u0c4d \u0c26\u0c40\u0c35\u0c3f" },
            { "CR", "\u0c15\u0c4b\u0c38\u0c4d\u0c1f\u0c3e \u0c30\u0c3f\u0c15\u0c3e" },
            { "CU", "\u0c15\u0c4d\u0c2f\u0c42\u0c2c\u0c3e" },
            { "CV", "\u0c15\u0c47\u0c2a\u0c4d \u0c35\u0c46\u0c30\u0c4d\u0c21\u0c46" },
            { "CW", "\u0c15\u0c4d\u0c2f\u0c42\u0c30\u0c38\u0c4b" },
            { "CX", "\u0c15\u0c4d\u0c30\u0c3f\u0c38\u0c4d\u0c2e\u0c38\u0c4d \u0c26\u0c40\u0c35\u0c3f" },
            { "CY", "\u0c38\u0c48\u0c2a\u0c4d\u0c30\u0c38\u0c4d" },
            { "CZ", "\u0c1a\u0c46\u0c15\u0c3f\u0c2f\u0c3e" },
            { "eka", "\u0c0f\u0c15\u0c3e\u0c1c\u0c15\u0c4d" },
            { "DE", "\u0c1c\u0c30\u0c4d\u0c2e\u0c28\u0c40" },
            { "goh", "\u0c2a\u0c4d\u0c30\u0c3e\u0c1a\u0c40\u0c28 \u0c39\u0c48 \u0c1c\u0c30\u0c4d\u0c2e\u0c28\u0c4d" },
            { "ace", "\u0c06\u0c16\u0c3f\u0c28\u0c40\u0c38\u0c4d" },
            { "cgg", "\u0c1a\u0c3f\u0c17\u0c3e" },
            { "DG", "\u0c21\u0c3f\u0c2f\u0c3e\u0c17\u0c4b \u0c17\u0c3e\u0c30\u0c4d\u0c38\u0c3f\u0c2f\u0c3e" },
            { "type.nu.deva", "\u0c26\u0c47\u0c35\u0c28\u0c3e\u0c17\u0c30\u0c3f \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "DJ", "\u0c1c\u0c3f\u0c2c\u0c4c\u0c1f\u0c3f" },
            { "DK", "\u0c21\u0c46\u0c28\u0c4d\u0c2e\u0c3e\u0c30\u0c4d\u0c15\u0c4d" },
            { "ach", "\u0c05\u0c15\u0c4b\u0c32\u0c3f" },
            { "gon", "\u0c17\u0c4b\u0c02\u0c21\u0c3f" },
            { "Brai", "\u0c2c\u0c4d\u0c30\u0c46\u0c2f\u0c3f\u0c32\u0c4d" },
            { "Brah", "\u0c2c\u0c4d\u0c30\u0c3e\u0c39\u0c4d\u0c2e\u0c3f" },
            { "DM", "\u0c21\u0c4a\u0c2e\u0c3f\u0c28\u0c3f\u0c15\u0c3e" },
            { "type.nu.armnlow", "\u0c06\u0c30\u0c4d\u0c2e\u0c47\u0c28\u0c3f\u0c2f\u0c28\u0c4d \u0c1a\u0c3f\u0c28\u0c4d\u0c28\u0c2c\u0c21\u0c3f \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "DO", "\u0c21\u0c4a\u0c2e\u0c3f\u0c28\u0c3f\u0c15\u0c28\u0c4d \u0c30\u0c3f\u0c2a\u0c2c\u0c4d\u0c32\u0c3f\u0c15\u0c4d" },
            { "gor", "\u0c17\u0c4b\u0c30\u0c4b\u0c02\u0c1f\u0c32\u0c3e" },
            { "got", "\u0c17\u0c4b\u0c25\u0c3f\u0c15\u0c4d" },
            { "Mtei", "\u0c2e\u0c40\u0c1f\u0c3f \u0c2e\u0c2f\u0c46\u0c15\u0c4d" },
            { "zun", "\u0c1c\u0c41\u0c28\u0c3f" },
            { "tig", "\u0c1f\u0c40\u0c17\u0c4d\u0c30\u0c46" },
            { "DZ", "\u0c05\u0c32\u0c4d\u0c1c\u0c40\u0c30\u0c3f\u0c2f\u0c3e" },
            { "pag", "\u0c2a\u0c02\u0c17\u0c3e\u0c38\u0c3f\u0c28\u0c3e\u0c28\u0c4d" },
            { "type.d0.hwidth", "\u0c38\u0c17\u0c02 \u0c35\u0c46\u0c21\u0c32\u0c4d\u0c2a\u0c41" },
            { "pal", "\u0c2a\u0c39\u0c4d\u0c32\u0c3e\u0c35\u0c3f" },
            { "EA", "\u0c38\u0c4d\u0c2f\u0c42\u0c1f\u0c3e & \u0c2e\u0c46\u0c32\u0c3f\u0c32\u0c4d\u0c32\u0c3e" },
            { "chb", "\u0c1a\u0c3f\u0c2c\u0c4d\u0c1a\u0c3e" },
            { "pam", "\u0c2a\u0c02\u0c2a\u0c28\u0c4d\u0c17\u0c3e" },
            { "EC", "\u0c08\u0c15\u0c4d\u0c35\u0c21\u0c3e\u0c30\u0c4d" },
            { "pap", "\u0c2a\u0c2a\u0c3f\u0c2f\u0c2e\u0c47\u0c02\u0c1f\u0c4b" },
            { "ada", "\u0c05\u0c21\u0c3e\u0c02\u0c17\u0c4d\u0c2e\u0c47" },
            { "EE", "\u0c0e\u0c38\u0c4d\u0c1f\u0c4b\u0c28\u0c3f\u0c2f\u0c3e" },
            { "tiv", "\u0c1f\u0c3f\u0c35\u0c4d" },
            { "EG", "\u0c08\u0c1c\u0c3f\u0c2a\u0c4d\u0c1f\u0c4d" },
            { "EH", "\u0c2a\u0c21\u0c2e\u0c1f\u0c3f \u0c38\u0c39\u0c3e\u0c30\u0c3e" },
            { "chg", "\u0c1a\u0c3e\u0c17\u0c1f\u0c48" },
            { "pau", "\u0c2a\u0c32\u0c3e\u0c35\u0c46\u0c28\u0c4d" },
            { "chk", "\u0c1a\u0c42\u0c15\u0c40\u0c38\u0c4d" },
            { "chn", "\u0c1a\u0c3f\u0c28\u0c42\u0c15\u0c4d \u0c1c\u0c3e\u0c30\u0c4d\u0c17\u0c28\u0c4d" },
            { "chm", "\u0c2e\u0c3e\u0c30\u0c3f" },
            { "chp", "\u0c1a\u0c3f\u0c2a\u0c46\u0c35\u0c4d\u0c2f\u0c3e\u0c28\u0c4d" },
            { "cho", "\u0c1a\u0c15\u0c4d\u0c1f\u0c3e" },
            { "chr", "\u0c1a\u0c46\u0c30\u0c4b\u0c15\u0c40" },
            { "ER", "\u0c0e\u0c30\u0c3f\u0c1f\u0c4d\u0c30\u0c3f\u0c2f\u0c3e" },
            { "ES", "\u0c38\u0c4d\u0c2a\u0c46\u0c2f\u0c3f\u0c28\u0c4d" },
            { "ET", "\u0c07\u0c25\u0c3f\u0c2f\u0c4b\u0c2a\u0c3f\u0c2f\u0c3e" },
            { "EU", "\u0c2f\u0c42\u0c30\u0c4b\u0c2a\u0c3f\u0c2f\u0c28\u0c4d \u0c2f\u0c42\u0c28\u0c3f\u0c2f\u0c28\u0c4d" },
            { "elx", "\u0c0e\u0c32\u0c3e\u0c2e\u0c48\u0c1f\u0c4d" },
            { "type.ca.gregorian", "\u0c17\u0c4d\u0c30\u0c47\u0c17\u0c4b\u0c30\u0c3f\u0c2f\u0c28\u0c4d \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "EZ", "\u0c2f\u0c42\u0c30\u0c4b\u0c1c\u0c4b\u0c28\u0c4d" },
            { "chy", "\u0c1a\u0c47\u0c2f\u0c47\u0c28\u0c4d" },
            { "type.nu.gujr", "\u0c17\u0c41\u0c1c\u0c30\u0c3e\u0c24\u0c40 \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "Inds", "\u0c38\u0c3f\u0c02\u0c27\u0c41" },
            { "ady", "\u0c05\u0c21\u0c3f\u0c17\u0c3e\u0c2c\u0c4d\u0c1c\u0c47" },
            { "aeb", "\u0c1f\u0c41\u0c28\u0c40\u0c37\u0c3f\u0c2f\u0c3e \u0c05\u0c30\u0c2c\u0c3f\u0c15\u0c4d" },
            { "FI", "\u0c2b\u0c3f\u0c28\u0c4d\u0c32\u0c3e\u0c02\u0c21\u0c4d" },
            { "FJ", "\u0c2b\u0c3f\u0c1c\u0c40" },
            { "FK", "\u0c2b\u0c3e\u0c15\u0c4d\u200c\u0c32\u0c4d\u0c2f\u0c3e\u0c02\u0c21\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "FM", "\u0c2e\u0c48\u0c15\u0c4d\u0c30\u0c4b\u0c28\u0c47\u0c37\u0c3f\u0c2f\u0c3e" },
            { "key.va", "\u0c32\u0c4a\u0c15\u0c47\u0c32\u0c4d \u0c30\u0c42\u0c2a\u0c3e\u0c02\u0c24\u0c30\u0c02" },
            { "FO", "\u0c2b\u0c3e\u0c30\u0c4b \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "Taml", metaValue_ta },
            { "FR", "\u0c2b\u0c4d\u0c30\u0c3e\u0c28\u0c4d\u0c38\u0c4d\u200c" },
            { "tkl", metaValue_TK },
            { "grb", "\u0c17\u0c4d\u0c30\u0c47\u0c2c\u0c4b" },
            { "type.ca.indian", "\u0c2d\u0c3e\u0c30\u0c24\u0c40\u0c2f \u0c1c\u0c3e\u0c24\u0c40\u0c2f \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "grc", "\u0c2a\u0c4d\u0c30\u0c3e\u0c1a\u0c40\u0c28 \u0c17\u0c4d\u0c30\u0c40\u0c15\u0c4d" },
            { "GA", "\u0c17\u0c47\u0c2c\u0c28\u0c4d" },
            { "vot", "\u0c35\u0c4b\u0c1f\u0c3f\u0c15\u0c4d" },
            { "GB", "\u0c2f\u0c41\u0c28\u0c48\u0c1f\u0c46\u0c21\u0c4d \u0c15\u0c3f\u0c02\u0c17\u0c4d\u200c\u0c21\u0c2e\u0c4d" },
            { "pcm", "\u0c28\u0c48\u0c1c\u0c40\u0c30\u0c3f\u0c2f\u0c3e \u0c2a\u0c3f\u0c21\u0c4d\u0c17\u0c3f\u0c28\u0c4d" },
            { "GD", "\u0c17\u0c4d\u0c30\u0c46\u0c28\u0c21\u0c3e" },
            { "GE", "\u0c1c\u0c3e\u0c30\u0c4d\u0c1c\u0c3f\u0c2f\u0c3e" },
            { "GF", "\u0c2b\u0c4d\u0c30\u0c46\u0c02\u0c1a\u0c4d \u0c17\u0c3f\u0c2f\u0c3e\u0c28\u0c3e" },
            { "GG", "\u0c17\u0c30\u0c4d\u0c28\u0c4d\u200c\u0c38\u0c40" },
            { "GH", "\u0c18\u0c28\u0c3e" },
            { "Tale", "\u0c24\u0c48 \u0c32\u0c40" },
            { "GI", "\u0c1c\u0c3f\u0c2c\u0c4d\u0c30\u0c3e\u0c32\u0c4d\u0c1f\u0c30\u0c4d" },
            { "afh", "\u0c05\u0c2b\u0c4d\u0c30\u0c3f\u0c39\u0c3f\u0c32\u0c3f" },
            { "GL", "\u0c17\u0c4d\u0c30\u0c40\u0c28\u0c4d\u200c\u0c32\u0c4d\u0c2f\u0c3e\u0c02\u0c21\u0c4d" },
            { "enm", "\u0c2e\u0c27\u0c4d\u0c2f\u0c2e \u0c06\u0c02\u0c17\u0c4d\u0c32\u0c02" },
            { "GM", "\u0c17\u0c3e\u0c02\u0c2c\u0c3f\u0c2f\u0c3e" },
            { "GN", "\u0c17\u0c3f\u0c28\u0c3f\u0c2f\u0c3e" },
            { "GP", "\u0c17\u0c4d\u0c35\u0c3e\u0c21\u0c46\u0c32\u0c4b\u0c2a\u0c4d" },
            { "GQ", "\u0c08\u0c15\u0c4d\u0c35\u0c1f\u0c4b\u0c30\u0c3f\u0c2f\u0c32\u0c4d \u0c17\u0c3f\u0c28\u0c3f\u0c2f\u0c3e" },
            { "GR", "\u0c17\u0c4d\u0c30\u0c40\u0c38\u0c4d" },
            { "GS", "\u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c1c\u0c3e\u0c30\u0c4d\u0c1c\u0c3f\u0c2f\u0c3e \u0c2e\u0c30\u0c3f\u0c2f\u0c41 \u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c36\u0c3e\u0c02\u0c21\u0c4d\u0c35\u0c3f\u0c1a\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "GT", "\u0c17\u0c4d\u0c35\u0c3e\u0c1f\u0c3f\u0c2e\u0c3e\u0c32\u0c3e" },
            { "GU", "\u0c17\u0c4d\u0c35\u0c3e\u0c2e\u0c4d" },
            { "GW", "\u0c17\u0c3f\u0c28\u0c3f\u0c2f\u0c3e-\u0c2c\u0c3f\u0c38\u0c4d\u0c38\u0c3e\u0c35\u0c4d" },
            { "tli", "\u0c1f\u0c4d\u0c32\u0c3f\u0c02\u0c17\u0c3f\u0c1f\u0c4d" },
            { "tlh", "\u0c15\u0c4d\u0c32\u0c3f\u0c02\u0c17\u0c3e\u0c28\u0c4d" },
            { "Talu", "\u0c15\u0c4d\u0c30\u0c4a\u0c24\u0c4d\u0c24 \u0c1f\u0c48 \u0c32\u0c41\u0c07" },
            { "GY", "\u0c17\u0c2f\u0c3e\u0c28\u0c3e" },
            { "ckb", "\u0c38\u0c46\u0c02\u0c1f\u0c4d\u0c30\u0c32\u0c4d \u0c15\u0c30\u0c4d\u0c21\u0c3f\u0c37\u0c4d" },
            { "zxx", "\u0c32\u0c3f\u0c2a\u0c3f \u0c32\u0c47\u0c26\u0c41" },
            { "de_AT", "\u0c06\u0c38\u0c4d\u0c1f\u0c4d\u0c30\u0c3f\u0c2f\u0c28\u0c4d \u0c1c\u0c30\u0c4d\u0c2e\u0c28\u0c4d" },
            { "Vaii", metaValue_vai },
            { "HK", "\u0c39\u0c3e\u0c02\u0c15\u0c3e\u0c02\u0c17\u0c4d \u0c0e\u0c38\u0c4d\u0c0f\u0c06\u0c30\u0c4d \u0c1a\u0c48\u0c28\u0c3e" },
            { "HM", "\u0c39\u0c46\u0c30\u0c4d\u0c21\u0c4d \u0c26\u0c40\u0c35\u0c3f \u0c2e\u0c30\u0c3f\u0c2f\u0c41 \u0c2e\u0c46\u0c15\u0c4d\u200c\u0c21\u0c4a\u0c28\u0c3e\u0c32\u0c4d\u0c21\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "HN", "\u0c39\u0c4b\u0c02\u0c21\u0c41\u0c30\u0c3e\u0c38\u0c4d" },
            { "HR", "\u0c15\u0c4d\u0c30\u0c4a\u0c2f\u0c47\u0c37\u0c3f\u0c2f\u0c3e" },
            { "agq", "\u0c05\u0c17\u0c47\u0c2e\u0c4d" },
            { "gsw", "\u0c38\u0c4d\u0c35\u0c3f\u0c38\u0c4d \u0c1c\u0c30\u0c4d\u0c2e\u0c28\u0c4d" },
            { "type.ca.islamic-umalqura", "\u0c07\u0c38\u0c4d\u0c32\u0c3e\u0c2e\u0c3f\u0c15\u0c4d \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d (\u0c09\u0c2e\u0c4d \u0c05\u0c32\u0c4d-\u0c16\u0c41\u0c30\u0c3e)" },
            { "HT", "\u0c39\u0c48\u0c1f\u0c3f" },
            { "HU", "\u0c39\u0c02\u0c17\u0c47\u0c30\u0c40" },
            { "tmh", "\u0c1f\u0c3e\u0c2e\u0c37\u0c47\u0c15\u0c4d" },
            { "IC", "\u0c15\u0c47\u0c28\u0c30\u0c40 \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "nan", "\u0c2e\u0c3f\u0c28\u0c4d \u0c28\u0c3e\u0c28\u0c4d \u0c1a\u0c48\u0c28\u0c40\u0c38\u0c4d" },
            { "peo", metaValue_peo },
            { "ID", "\u0c07\u0c02\u0c21\u0c4b\u0c28\u0c47\u0c37\u0c3f\u0c2f\u0c3e" },
            { "IE", "\u0c10\u0c30\u0c4d\u0c32\u0c3e\u0c02\u0c21\u0c4d" },
            { "nap", "\u0c28\u0c3f\u0c2f\u0c3e\u0c2a\u0c4b\u0c32\u0c3f\u0c1f\u0c28\u0c4d" },
            { "naq", "\u0c28\u0c2e" },
            { "zza", "\u0c1c\u0c3e\u0c1c\u0c3e" },
            { "IL", "\u0c07\u0c1c\u0c4d\u0c30\u0c3e\u0c2f\u0c46\u0c32\u0c4d" },
            { "IM", "\u0c10\u0c32\u0c4d \u0c06\u0c2b\u0c4d \u0c2e\u0c3e\u0c28\u0c4d" },
            { "IN", "\u0c2d\u0c3e\u0c30\u0c24\u0c26\u0c47\u0c36\u0c02" },
            { "type.co.eor", "\u0c2f\u0c41\u0c30\u0c4b\u0c2a\u0c3f\u0c2f\u0c28\u0c4d \u0c15\u0c4d\u0c30\u0c2e\u0c2c\u0c26\u0c4d\u0c27\u0c40\u0c15\u0c30\u0c23 \u0c28\u0c3f\u0c2c\u0c02\u0c27\u0c28\u0c32\u0c41" },
            { "IO", "\u0c2c\u0c4d\u0c30\u0c3f\u0c1f\u0c3f\u0c37\u0c4d \u0c39\u0c3f\u0c02\u0c26\u0c42 \u0c2e\u0c39\u0c3e\u0c38\u0c2e\u0c41\u0c26\u0c4d\u0c30 \u0c2a\u0c4d\u0c30\u0c3e\u0c02\u0c24\u0c02" },
            { "IQ", "\u0c07\u0c30\u0c3e\u0c15\u0c4d" },
            { "IR", "\u0c07\u0c30\u0c3e\u0c28\u0c4d" },
            { "IS", "\u0c10\u0c38\u0c4d\u0c32\u0c3e\u0c02\u0c21\u0c4d" },
            { "IT", "\u0c07\u0c1f\u0c32\u0c40" },
            { "Zmth", "\u0c17\u0c23\u0c3f\u0c24 \u0c38\u0c02\u0c15\u0c47\u0c24\u0c32\u0c3f\u0c2a\u0c3f" },
            { "type.nu.thai", "\u0c25\u0c3e\u0c2f\u0c4d \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "type.nu.beng", "\u0c2c\u0c46\u0c02\u0c17\u0c3e\u0c32\u0c40 \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "type.ca.islamic", metaValue_type_ca_islamic },
            { "JE", "\u0c1c\u0c46\u0c30\u0c4d\u0c38\u0c40" },
            { "JM", "\u0c1c\u0c2e\u0c48\u0c15\u0c3e" },
            { "Beng", "\u0c2c\u0c3e\u0c02\u0c17\u0c4d\u0c32\u0c3e" },
            { "JO", "\u0c1c\u0c4b\u0c30\u0c4d\u0c21\u0c3e\u0c28\u0c4d" },
            { "JP", "\u0c1c\u0c2a\u0c3e\u0c28\u0c4d" },
            { "ain", "\u0c10\u0c28\u0c41" },
            { "guz", "\u0c17\u0c41\u0c38\u0c4d\u0c38\u0c40" },
            { "tog", "\u0c28\u0c4d\u0c2f\u0c3e\u0c38\u0c3e \u0c1f\u0c4b\u0c28\u0c4d\u0c17\u0c3e" },
            { "type.nu.knda", "\u0c15\u0c28\u0c4d\u0c28\u0c21 \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "Kali", "\u0c15\u0c3e\u0c2f\u0c3e\u0c39\u0c4d \u0c32\u0c3f" },
            { "de_CH", "\u0c38\u0c4d\u0c35\u0c3f\u0c38\u0c4d \u0c39\u0c48 \u0c1c\u0c30\u0c4d\u0c2e\u0c28\u0c4d" },
            { "type.co.phonetic", "\u0c27\u0c4d\u0c35\u0c28\u0c3f \u0c09\u0c1a\u0c4d\u0c1b\u0c3e\u0c30\u0c3f\u0c24 \u0c15\u0c4d\u0c30\u0c2e\u0c2c\u0c26\u0c4d\u0c27\u0c40\u0c15\u0c30\u0c23 \u0c15\u0c4d\u0c30\u0c2e\u0c02" },
            { "type.ca.buddhist", "\u0c2c\u0c41\u0c26\u0c4d\u0c27\u0c41\u0c32 \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d\u200c" },
            { "KE", "\u0c15\u0c46\u0c28\u0c4d\u0c2f\u0c3e" },
            { "419", "\u0c32\u0c3e\u0c1f\u0c3f\u0c28\u0c4d \u0c05\u0c2e\u0c46\u0c30\u0c3f\u0c15\u0c3e" },
            { "KG", "\u0c15\u0c3f\u0c30\u0c4d\u0c17\u0c3f\u0c1c\u0c3f\u0c38\u0c4d\u0c24\u0c3e\u0c28\u0c4d" },
            { "KH", "\u0c15\u0c02\u0c2c\u0c4b\u0c21\u0c3f\u0c2f\u0c3e" },
            { "KI", "\u0c15\u0c3f\u0c30\u0c3f\u0c2c\u0c3e\u0c1f\u0c3f" },
            { "KM", "\u0c15\u0c4a\u0c2e\u0c4a\u0c30\u0c4b\u0c38\u0c4d" },
            { "Knda", metaValue_kn },
            { "KN", "\u0c38\u0c46\u0c2f\u0c3f\u0c02\u0c1f\u0c4d \u0c15\u0c3f\u0c1f\u0c4d\u0c38\u0c4d \u0c2e\u0c30\u0c3f\u0c2f\u0c41 \u0c28\u0c46\u0c35\u0c3f\u0c38\u0c4d" },
            { "Zinh", "\u0c35\u0c3e\u0c30\u0c38\u0c24\u0c4d\u0c35\u0c02" },
            { "fr_CA", "\u0c15\u0c46\u0c28\u0c21\u0c3f\u0c2f\u0c46\u0c28\u0c4d \u0c2b\u0c4d\u0c30\u0c46\u0c02\u0c1a\u0c4d" },
            { "KP", "\u0c09\u0c24\u0c4d\u0c24\u0c30 \u0c15\u0c4a\u0c30\u0c3f\u0c2f\u0c3e" },
            { "KR", "\u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c15\u0c4a\u0c30\u0c3f\u0c2f\u0c3e" },
            { "Plrd", "\u0c2a\u0c4b\u0c32\u0c4d\u0c32\u0c30\u0c4d\u0c21\u0c4d \u0c2b\u0c4b\u0c28\u0c46\u0c1f\u0c3f\u0c15\u0c4d" },
            { "fr_CH", "\u0c38\u0c4d\u0c35\u0c3f\u0c38\u0c4d \u0c2b\u0c4d\u0c30\u0c46\u0c02\u0c1a\u0c4d" },
            { "KW", "\u0c15\u0c41\u0c35\u0c48\u0c1f\u0c4d" },
            { "tpi", "\u0c1f\u0c4b\u0c15\u0c4d \u0c2a\u0c3f\u0c38\u0c3f\u0c28\u0c4d" },
            { "KY", "\u0c15\u0c47\u0c2e\u0c3e\u0c28\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "KZ", "\u0c15\u0c1c\u0c15\u0c3f\u0c38\u0c4d\u0c24\u0c3e\u0c28\u0c4d" },
            { "Cyrl", "\u0c38\u0c3f\u0c30\u0c3f\u0c32\u0c3f\u0c15\u0c4d" },
            { "LA", "\u0c32\u0c3e\u0c35\u0c4b\u0c38\u0c4d" },
            { "LB", "\u0c32\u0c46\u0c2c\u0c28\u0c3e\u0c28\u0c4d" },
            { "LC", "\u0c38\u0c46\u0c2f\u0c3f\u0c02\u0c1f\u0c4d \u0c32\u0c42\u0c38\u0c3f\u0c2f\u0c3e" },
            { "phn", "\u0c2b\u0c4b\u0c28\u0c3f\u0c15\u0c28\u0c4d" },
            { "Cyrs", "\u0c2a\u0c4d\u0c30\u0c3e\u0c1a\u0c40\u0c28 \u0c1a\u0c30\u0c4d\u0c1a \u0c38\u0c4d\u0c32\u0c3e\u0c35\u0c4b\u0c28\u0c3f\u0c15\u0c4d \u0c38\u0c3f\u0c30\u0c3f\u0c32\u0c3f\u0c15\u0c4d" },
            { "gwi", "\u0c17\u0c4d\u0c35\u0c3f\u0c1a\u0c3f\u0c28\u0c4d" },
            { "nds", "\u0c32\u0c4b \u0c1c\u0c30\u0c4d\u0c2e\u0c28\u0c4d" },
            { "LI", "\u0c32\u0c3f\u0c15\u0c4d\u0c1f\u0c46\u0c28\u0c4d\u200c\u0c38\u0c4d\u0c1f\u0c46\u0c2f\u0c3f\u0c28\u0c4d" },
            { "LK", "\u0c36\u0c4d\u0c30\u0c40\u0c32\u0c02\u0c15" },
            { "akk", "\u0c05\u0c15\u0c4d\u0c15\u0c3e\u0c21\u0c3f\u0c2f\u0c3e\u0c28\u0c4d" },
            { "cop", metaValue_cop },
            { "LR", "\u0c32\u0c48\u0c2c\u0c40\u0c30\u0c3f\u0c2f\u0c3e" },
            { "LS", "\u0c32\u0c46\u0c38\u0c4b\u0c24\u0c4b" },
            { "Phlv", "\u0c2a\u0c41\u0c38\u0c4d\u0c24\u0c15 \u0c2a\u0c39\u0c4d\u0c32\u0c3e\u0c35\u0c3f" },
            { "LT", "\u0c32\u0c3f\u0c25\u0c41\u0c35\u0c47\u0c28\u0c3f\u0c2f\u0c3e" },
            { "LU", "\u0c32\u0c15\u0c4d\u0c38\u0c46\u0c02\u0c2c\u0c30\u0c4d\u0c17\u0c4d" },
            { "LV", "\u0c32\u0c3e\u0c24\u0c4d\u0c35\u0c3f\u0c2f\u0c3e" },
            { "Kana", "\u0c15\u0c3e\u0c1f\u0c3e\u0c15\u0c3e\u0c28" },
            { "LY", "\u0c32\u0c3f\u0c2c\u0c3f\u0c2f\u0c3e" },
            { "lad", "\u0c32\u0c3e\u0c21\u0c3f\u0c28\u0c4b" },
            { "vun", "\u0c35\u0c41\u0c02\u0c1c\u0c4a" },
            { "lah", "\u0c32\u0c3e\u0c39\u0c02\u0c21\u0c3e" },
            { "lag", "\u0c32\u0c3e\u0c02\u0c17\u0c40" },
            { "Thaa", "\u0c25\u0c3e\u0c28\u0c3e" },
            { "MA", "\u0c2e\u0c4a\u0c30\u0c3e\u0c15\u0c4b" },
            { "MC", "\u0c2e\u0c4a\u0c28\u0c3e\u0c15\u0c4b" },
            { "MD", "\u0c2e\u0c4b\u0c32\u0c4d\u0c21\u0c4b\u0c35\u0c3e" },
            { "ME", "\u0c2e\u0c3e\u0c02\u0c1f\u0c46\u0c28\u0c46\u0c17\u0c4d\u0c30\u0c4b" },
            { "MF", "\u0c38\u0c46\u0c2f\u0c3f\u0c02\u0c1f\u0c4d \u0c2e\u0c3e\u0c30\u0c4d\u0c1f\u0c3f\u0c28\u0c4d" },
            { "lam", "\u0c32\u0c3e\u0c02\u0c2c\u0c3e" },
            { "MG", "\u0c2e\u0c21\u0c17\u0c3e\u0c38\u0c4d\u0c15\u0c30\u0c4d" },
            { "Thai", metaValue_th },
            { "MH", "\u0c2e\u0c3e\u0c30\u0c4d\u0c37\u0c32\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "ale", "\u0c05\u0c32\u0c3f\u0c2f\u0c41\u0c1f\u0c4d" },
            { "type.nu.vaii", "\u0c35\u0c3e\u0c2f\u0c4d \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "MK", "\u0c09\u0c24\u0c4d\u0c24\u0c30 \u0c2e\u0c3e\u0c38\u0c3f\u0c21\u0c4b\u0c28\u0c3f\u0c2f\u0c3e" },
            { "ML", "\u0c2e\u0c3e\u0c32\u0c3f" },
            { "MM", "\u0c2e\u0c2f\u0c28\u0c4d\u0c2e\u0c3e\u0c30\u0c4d" },
            { "MN", "\u0c2e\u0c02\u0c17\u0c4b\u0c32\u0c3f\u0c2f\u0c3e" },
            { "new", "\u0c28\u0c46\u0c35\u0c3e\u0c30\u0c3f" },
            { "MO", "\u0c2e\u0c15\u0c3e\u0c35\u0c4d \u0c0e\u0c38\u0c4d\u0c0f\u0c06\u0c30\u0c4d \u0c1a\u0c48\u0c28\u0c3e" },
            { "MP", "\u0c09\u0c24\u0c4d\u0c24\u0c30 \u0c2e\u0c30\u0c3f\u0c2f\u0c3e\u0c28\u0c3e \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "MQ", "\u0c2e\u0c3e\u0c30\u0c4d\u0c1f\u0c3f\u0c28\u0c40\u0c15\u0c4d" },
            { "MR", "\u0c2e\u0c4c\u0c30\u0c3f\u0c1f\u0c47\u0c28\u0c3f\u0c2f\u0c3e" },
            { "MS", "\u0c2e\u0c3e\u0c02\u0c1f\u0c4d\u0c38\u0c46\u0c30\u0c3e\u0c1f\u0c4d" },
            { "MT", "\u0c2e\u0c3e\u0c32\u0c4d\u0c1f\u0c3e" },
            { "type.m0.ungegn", "UN GEGN \u0c1f\u0c4d\u0c30\u0c3e\u0c28\u0c4d\u0c38\u0c4d\u200c\u0c32\u0c3f\u0c1f\u0c4d\u0c30\u0c47\u0c37\u0c28\u0c4d" },
            { "MU", "\u0c2e\u0c3e\u0c30\u0c3f\u0c37\u0c38\u0c4d" },
            { "alt", "\u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c06\u0c32\u0c4d\u0c1f\u0c48" },
            { "MV", "\u0c2e\u0c3e\u0c32\u0c4d\u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "MW", "\u0c2e\u0c32\u0c3e\u0c35\u0c40" },
            { "MX", "\u0c2e\u0c46\u0c15\u0c4d\u0c38\u0c3f\u0c15\u0c4b" },
            { "type.ca.japanese", "\u0c1c\u0c2a\u0c3e\u0c28\u0c40\u0c2f\u0c41\u0c32 \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "MY", "\u0c2e\u0c32\u0c47\u0c37\u0c3f\u0c2f\u0c3e" },
            { "MZ", "\u0c2e\u0c4a\u0c1c\u0c3e\u0c02\u0c2c\u0c3f\u0c15\u0c4d" },
            { "Phli", "\u0c07\u0c02\u0c38\u0c4d\u0c15\u0c4d\u0c30\u0c3f\u0c2a\u0c4d\u0c37\u0c28\u0c3e\u0c32\u0c4d \u0c2a\u0c39\u0c4d\u0c32\u0c3e\u0c35\u0c3f" },
            { "NA", "\u0c28\u0c2e\u0c40\u0c2c\u0c3f\u0c2f\u0c3e" },
            { "202", "\u0c09\u0c2a \u0c38\u0c46\u0c39\u0c30\u0c28\u0c4d \u0c06\u0c2b\u0c4d\u0c30\u0c3f\u0c15\u0c3e" },
            { "type.ca.hebrew", "\u0c39\u0c3f\u0c2c\u0c4d\u0c30\u0c42 \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "type.co.dictionary", "\u0c28\u0c3f\u0c18\u0c02\u0c1f\u0c41\u0c35\u0c41 \u0c15\u0c4d\u0c30\u0c2e\u0c2c\u0c26\u0c4d\u0c27\u0c40\u0c15\u0c30\u0c23 \u0c15\u0c4d\u0c30\u0c2e\u0c02" },
            { "NC", "\u0c15\u0c4d\u0c30\u0c4a\u0c24\u0c4d\u0c24 \u0c15\u0c3e\u0c32\u0c46\u0c21\u0c4b\u0c28\u0c3f\u0c2f\u0c3e" },
            { "%%WADEGILE", "\u0c35\u0c47\u0c21\u0c4d-\u0c17\u0c48\u0c32\u0c4d\u0c38\u0c4d \u0c30\u0c4b\u0c2e\u0c28\u0c48\u0c1c\u0c47\u0c37\u0c28\u0c4d" },
            { "NE", "\u0c28\u0c48\u0c1c\u0c30\u0c4d" },
            { "NF", "\u0c28\u0c3e\u0c30\u0c4d\u0c2b\u0c4b\u0c15\u0c4d \u0c26\u0c40\u0c35\u0c3f" },
            { "NG", "\u0c28\u0c48\u0c1c\u0c40\u0c30\u0c3f\u0c2f\u0c3e" },
            { "trv", "\u0c24\u0c30\u0c4b\u0c15\u0c4b" },
            { "Phlp", "\u0c38\u0c32\u0c4d\u0c1f\u0c3e\u0c30\u0c4d \u0c2a\u0c39\u0c4d\u0c32\u0c3e\u0c35\u0c3f" },
            { "NI", "\u0c28\u0c3f\u0c15\u0c30\u0c3e\u0c17\u0c41\u0c35\u0c3e" },
            { "Hmng", "\u0c2a\u0c3e\u0c39\u0c35\u0c3e \u0c39\u0c4d\u0c2e\u0c4b\u0c02\u0c17\u0c4d" },
            { "NL", "\u0c28\u0c46\u0c26\u0c30\u0c4d\u0c32\u0c3e\u0c02\u0c21\u0c4d\u0c38\u0c4d" },
            { "NO", "\u0c28\u0c3e\u0c30\u0c4d\u0c35\u0c47" },
            { "NP", "\u0c28\u0c47\u0c2a\u0c3e\u0c32\u0c4d" },
            { "NR", metaValue_NR },
            { "NU", "\u0c28\u0c3f\u0c2f\u0c42" },
            { "Phnx", "\u0c2b\u0c4b\u0c28\u0c3f\u0c36\u0c3f\u0c2f\u0c28\u0c4d" },
            { "rof", "\u0c30\u0c4b\u0c02\u0c2c\u0c4b" },
            { "tsi", "\u0c36\u0c3f\u0c02\u0c37\u0c40\u0c2f\u0c28\u0c4d" },
            { "NZ", "\u0c28\u0c4d\u0c2f\u0c42\u0c1c\u0c3f\u0c32\u0c3e\u0c02\u0c21\u0c4d" },
            { "rom", "\u0c30\u0c4b\u0c2e\u0c3e\u0c28\u0c40" },
            { "Mero", "\u0c2e\u0c46\u0c30\u0c4b\u0c07\u0c1f\u0c3f\u0c15\u0c4d" },
            { "crh", "\u0c15\u0c4d\u0c30\u0c3f\u0c2e\u0c3f\u0c2f\u0c28\u0c4d \u0c1f\u0c30\u0c4d\u0c15\u0c3f\u0c37\u0c4d" },
            { "ang", "\u0c2a\u0c4d\u0c30\u0c3e\u0c1a\u0c40\u0c28 \u0c06\u0c02\u0c17\u0c4d\u0c32\u0c02" },
            { "OM", "\u0c13\u0c2e\u0c28\u0c4d" },
            { "anp", "\u0c06\u0c02\u0c17\u0c3f\u0c15" },
            { "crs", "\u0c38\u0c46\u0c38\u0c47\u0c32\u0c4d\u0c35\u0c3e \u0c15\u0c4d\u0c30\u0c3f\u0c2f\u0c4b\u0c32\u0c4d \u0c2b\u0c4d\u0c30\u0c46\u0c02\u0c1a\u0c4d" },
            { "Xpeo", metaValue_peo },
            { "PA", "\u0c2a\u0c28\u0c3e\u0c2e\u0c3e" },
            { "type.ca.islamic-civil", "\u0c07\u0c38\u0c4d\u0c32\u0c3e\u0c2e\u0c3f\u0c15\u0c4d-\u0c38\u0c3f\u0c35\u0c3f\u0c32\u0c4d \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "csb", "\u0c15\u0c37\u0c41\u0c2c\u0c3f\u0c2f\u0c28\u0c4d" },
            { "en_GB", "\u0c2c\u0c4d\u0c30\u0c3f\u0c1f\u0c3f\u0c37\u0c4d \u0c07\u0c02\u0c17\u0c4d\u0c32\u0c40\u0c37\u0c4d" },
            { "PE", "\u0c2a\u0c46\u0c30\u0c42" },
            { "PF", "\u0c2b\u0c4d\u0c30\u0c46\u0c02\u0c1a\u0c4d \u0c2a\u0c4b\u0c32\u0c3f\u0c28\u0c40\u0c37\u0c3f\u0c2f\u0c3e" },
            { "PG", "\u0c2a\u0c3e\u0c2a\u0c41\u0c35\u0c3e \u0c28\u0c4d\u0c2f\u0c42 \u0c17\u0c3f\u0c28\u0c3f\u0c2f\u0c3e" },
            { "PH", "\u0c2b\u0c3f\u0c32\u0c3f\u0c2a\u0c4d\u0c2a\u0c48\u0c28\u0c4d\u0c38\u0c4d" },
            { "PK", "\u0c2a\u0c3e\u0c15\u0c3f\u0c38\u0c4d\u0c24\u0c3e\u0c28\u0c4d" },
            { "PL", "\u0c2a\u0c4b\u0c32\u0c3e\u0c02\u0c21\u0c4d" },
            { "ewo", "\u0c0e\u0c35\u0c4b\u0c02\u0c21\u0c4a" },
            { "PM", "\u0c38\u0c46\u0c2f\u0c3f\u0c02\u0c1f\u0c4d \u0c2a\u0c3f\u0c2f\u0c46\u0c30\u0c4d \u0c2e\u0c30\u0c3f\u0c2f\u0c41 \u0c2e\u0c3f\u0c15\u0c46\u0c32\u0c3e\u0c28\u0c4d" },
            { "PN", "\u0c2a\u0c3f\u0c1f\u0c4d\u200c\u0c15\u0c46\u0c2f\u0c3f\u0c30\u0c4d\u0c28\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "PR", "\u0c2a\u0c4d\u0c2f\u0c42\u0c30\u0c4d\u0c1f\u0c4b \u0c30\u0c3f\u0c15\u0c4b" },
            { "Bali", metaValue_ban },
            { "PS", "\u0c2a\u0c3e\u0c32\u0c38\u0c4d\u0c24\u0c40\u0c28\u0c3f\u0c2f\u0c28\u0c4d \u0c2a\u0c4d\u0c30\u0c3e\u0c02\u0c24\u0c3e\u0c32\u0c41" },
            { "PT", "\u0c2a\u0c4b\u0c30\u0c4d\u0c1a\u0c41\u0c17\u0c32\u0c4d" },
            { "PW", "\u0c2a\u0c3e\u0c32\u0c3e\u0c35\u0c4d" },
            { "nia", "\u0c28\u0c3f\u0c2f\u0c3e\u0c38\u0c4d" },
            { "type.nu.greklow", "\u0c17\u0c4d\u0c30\u0c40\u0c15\u0c4d \u0c1a\u0c3f\u0c28\u0c4d\u0c28\u0c2c\u0c21\u0c3f \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "PY", "\u0c2a\u0c30\u0c3e\u0c17\u0c4d\u0c35\u0c47" },
            { "tum", "\u0c1f\u0c41\u0c02\u0c2c\u0c41\u0c15\u0c3e" },
            { "Hebr", "\u0c39\u0c40\u0c2c\u0c4d\u0c30\u0c41" },
            { "QA", "\u0c16\u0c24\u0c3e\u0c30\u0c4d" },
            { "niu", "\u0c28\u0c3f\u0c2f\u0c3e\u0c28\u0c4d" },
            { "QO", "\u0c12\u0c37\u0c40\u0c28\u0c3f\u0c2f\u0c3e \u0c2c\u0c2f\u0c1f\u0c41\u0c28\u0c4d\u0c28\u0c35\u0c3f" },
            { "lez", "\u0c32\u0c47\u0c1c\u0c4d\u0c18\u0c3f\u0c2f\u0c28\u0c4d" },
            { "tvl", metaValue_TV },
            { "Tavt", "\u0c1f\u0c48 \u0c35\u0c3f\u0c2f\u0c1f\u0c4d" },
            { "001", "\u0c2a\u0c4d\u0c30\u0c2a\u0c02\u0c1a\u0c02" },
            { "002", "\u0c06\u0c2b\u0c4d\u0c30\u0c3f\u0c15\u0c3e" },
            { "003", "\u0c09\u0c24\u0c4d\u0c24\u0c30 \u0c05\u0c2e\u0c46\u0c30\u0c3f\u0c15\u0c3e" },
            { "RE", "\u0c30\u0c40\u0c2f\u0c42\u0c28\u0c3f\u0c2f\u0c28\u0c4d" },
            { "005", "\u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c05\u0c2e\u0c46\u0c30\u0c3f\u0c15\u0c3e" },
            { "jbo", "\u0c32\u0c4b\u0c1c\u0c4d\u0c2c\u0c3e\u0c28\u0c4d" },
            { "Rjng", "\u0c30\u0c47\u0c1c\u0c3e\u0c02\u0c17\u0c4d" },
            { "009", "\u0c13\u0c37\u0c3f\u0c28\u0c3f\u0c2f\u0c3e" },
            { "RO", "\u0c30\u0c4b\u0c2e\u0c47\u0c28\u0c3f\u0c2f\u0c3e" },
            { "RS", "\u0c38\u0c46\u0c30\u0c4d\u0c2c\u0c3f\u0c2f\u0c3e" },
            { "RU", "\u0c30\u0c37\u0c4d\u0c2f\u0c3e" },
            { "RW", "\u0c30\u0c41\u0c35\u0c3e\u0c02\u0c21\u0c3e" },
            { "Mani", "\u0c2e\u0c3e\u0c28\u0c3f\u0c1a\u0c47\u0c28\u0c4d" },
            { "Ugar", "\u0c2f\u0c41\u0c17\u0c3e\u0c30\u0c3f\u0c1f\u0c3f\u0c15\u0c4d" },
            { "Khar", "\u0c16\u0c30\u0c4b\u0c37\u0c25\u0c3f" },
            { "SA", "\u0c38\u0c4c\u0c26\u0c40 \u0c05\u0c30\u0c47\u0c2c\u0c3f\u0c2f\u0c3e" },
            { "pon", "\u0c2a\u0c4b\u0c39\u0c4d\u0c28\u0c4d\u0c2a\u0c46\u0c2f\u0c28\u0c4d" },
            { "Mand", "\u0c2e\u0c3e\u0c28\u0c4d\u0c21\u0c3f\u0c2f\u0c28\u0c4d" },
            { "SB", "\u0c38\u0c4b\u0c32\u0c2e\u0c28\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "twq", "\u0c1f\u0c38\u0c3e\u0c35\u0c3e\u0c16\u0c4d" },
            { "011", "\u0c2a\u0c36\u0c4d\u0c1a\u0c3f\u0c2e \u0c06\u0c2b\u0c4d\u0c30\u0c3f\u0c15\u0c3e \u0c2d\u0c42\u0c2d\u0c3e\u0c17\u0c02" },
            { "SC", "\u0c38\u0c40\u0c37\u0c46\u0c32\u0c4d\u0c38\u0c4d" },
            { "SD", "\u0c38\u0c42\u0c21\u0c3e\u0c28\u0c4d" },
            { "013", "\u0c2e\u0c27\u0c4d\u0c2f\u0c2e \u0c05\u0c2e\u0c46\u0c30\u0c3f\u0c15\u0c3e" },
            { "SE", "\u0c38\u0c4d\u0c35\u0c40\u0c21\u0c28\u0c4d" },
            { "014", "\u0c24\u0c42\u0c30\u0c4d\u0c2a\u0c41 \u0c06\u0c2b\u0c4d\u0c30\u0c3f\u0c15\u0c3e" },
            { "arc", "\u0c05\u0c30\u0c3e\u0c2e\u0c48\u0c15\u0c4d" },
            { "015", "\u0c09\u0c24\u0c4d\u0c24\u0c30 \u0c06\u0c2b\u0c4d\u0c30\u0c3f\u0c15\u0c3e" },
            { "SG", "\u0c38\u0c3f\u0c02\u0c17\u0c2a\u0c42\u0c30\u0c4d" },
            { "SH", "\u0c38\u0c46\u0c2f\u0c3f\u0c02\u0c1f\u0c4d \u0c39\u0c46\u0c32\u0c46\u0c28\u0c3e" },
            { "type.lb.strict", "\u0c15\u0c4d\u0c30\u0c2e \u0c32\u0c48\u0c28\u0c4d \u0c2c\u0c4d\u0c30\u0c47\u0c15\u0c4d \u0c36\u0c48\u0c32\u0c3f" },
            { "017", "\u0c2e\u0c27\u0c4d\u0c2f\u0c2e \u0c06\u0c2b\u0c4d\u0c30\u0c3f\u0c15\u0c3e" },
            { "SI", "\u0c38\u0c4d\u0c32\u0c4b\u0c35\u0c47\u0c28\u0c3f\u0c2f\u0c3e" },
            { "018", "\u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c06\u0c2b\u0c4d\u0c30\u0c3f\u0c15\u0c3e \u0c2d\u0c42\u0c2d\u0c3e\u0c17\u0c02" },
            { "SJ", "\u0c38\u0c4d\u0c35\u0c3e\u0c32\u0c4d\u200c\u0c2c\u0c3e\u0c30\u0c4d\u0c21\u0c4d \u0c2e\u0c30\u0c3f\u0c2f\u0c41 \u0c1c\u0c3e\u0c28\u0c4d \u0c2e\u0c3e\u0c2f\u0c46\u0c28\u0c4d" },
            { "019", "\u0c05\u0c2e\u0c46\u0c30\u0c3f\u0c15\u0c3e\u0c38\u0c4d" },
            { "SK", "\u0c38\u0c4d\u0c32\u0c4a\u0c35\u0c47\u0c15\u0c3f\u0c2f\u0c3e" },
            { "SL", "\u0c38\u0c3f\u0c2f\u0c46\u0c30\u0c4d\u0c30\u0c3e \u0c32\u0c3f\u0c2f\u0c3e\u0c28\u0c4d" },
            { "SM", "\u0c36\u0c3e\u0c28\u0c4d \u0c2e\u0c3e\u0c30\u0c3f\u0c28\u0c4b" },
            { "SN", "\u0c38\u0c46\u0c28\u0c46\u0c17\u0c32\u0c4d" },
            { "SO", "\u0c38\u0c4b\u0c2e\u0c3e\u0c32\u0c3f\u0c2f\u0c3e" },
            { "arn", "\u0c2e\u0c2a\u0c41\u0c1a\u0c47" },
            { "arp", "\u0c05\u0c30\u0c3e\u0c2a\u0c3e\u0c39\u0c4b" },
            { "type.nu.taml", "\u0c38\u0c3e\u0c02\u0c2a\u0c4d\u0c30\u0c26\u0c3e\u0c2f \u0c24\u0c2e\u0c3f\u0c33 \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "SR", "\u0c38\u0c42\u0c30\u0c3f\u0c28\u0c3e\u0c2e\u0c4d" },
            { "SS", "\u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c38\u0c42\u0c21\u0c3e\u0c28\u0c4d" },
            { "ST", "\u0c38\u0c3e\u0c35\u0c4b \u0c1f\u0c4b\u0c2e\u0c4d \u0c2e\u0c30\u0c3f\u0c2f\u0c41 \u0c2a\u0c4d\u0c30\u0c3f\u0c28\u0c4d\u0c38\u0c3f\u0c2a\u0c3f" },
            { "SV", "\u0c0e\u0c32\u0c4d \u0c38\u0c3e\u0c32\u0c4d\u0c35\u0c21\u0c4b\u0c30\u0c4d" },
            { "SX", "\u0c38\u0c3f\u0c02\u0c1f\u0c4d \u0c2e\u0c3e\u0c30\u0c4d\u0c1f\u0c46\u0c28\u0c4d" },
            { "SY", "\u0c38\u0c3f\u0c30\u0c3f\u0c2f\u0c3e" },
            { "yao", "\u0c2f\u0c3e\u0c2f\u0c47" },
            { "SZ", "\u0c08\u0c38\u0c4d\u0c35\u0c3e\u0c1f\u0c3f\u0c28\u0c3f" },
            { "arw", "\u0c05\u0c30\u0c3e\u0c35\u0c3e\u0c15\u0c4d" },
            { "arz", "\u0c08\u0c1c\u0c3f\u0c2a\u0c4d\u0c37\u0c3f\u0c2f\u0c28\u0c4d \u0c05\u0c30\u0c2c\u0c3f\u0c15\u0c4d" },
            { "yap", "\u0c2f\u0c3e\u0c2a\u0c3f\u0c38\u0c4d" },
            { "TA", "\u0c1f\u0c4d\u0c30\u0c3f\u0c38\u0c4d\u0c1f\u0c28\u0c4d \u0c21 \u0c15\u0c28\u0c4d\u0c39\u0c3e" },
            { "asa", "\u0c05\u0c38\u0c41" },
            { "type.ms.ussystem", "\u0c2f\u0c41.\u0c0e\u0c38\u0c4d. \u0c15\u0c4a\u0c32\u0c2e\u0c3e\u0c28 \u0c2a\u0c26\u0c4d\u0c27\u0c24\u0c3f" },
            { "021", "\u0c09\u0c24\u0c4d\u0c24\u0c30 \u0c05\u0c2e\u0c46\u0c30\u0c3f\u0c15\u0c3e \u0c2d\u0c42\u0c2d\u0c3e\u0c17\u0c02" },
            { "TC", "\u0c1f\u0c30\u0c4d\u0c15\u0c4d\u0c38\u0c4d \u0c2e\u0c30\u0c3f\u0c2f\u0c41 \u0c15\u0c48\u0c15\u0c4b\u0c38\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "yav", "\u0c2f\u0c3e\u0c02\u0c17\u0c4d\u200c\u0c2c\u0c46\u0c28\u0c4d" },
            { "TD", "\u0c1a\u0c3e\u0c26\u0c4d" },
            { "TF", "\u0c2b\u0c4d\u0c30\u0c46\u0c02\u0c1a\u0c4d \u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c2a\u0c4d\u0c30\u0c3e\u0c02\u0c24\u0c3e\u0c32\u0c41" },
            { "TG", "\u0c1f\u0c4b\u0c17\u0c4b" },
            { "TH", "\u0c25\u0c3e\u0c2f\u0c3f\u0c32\u0c3e\u0c02\u0c21\u0c4d" },
            { "TJ", "\u0c24\u0c1c\u0c3f\u0c15\u0c3f\u0c38\u0c4d\u0c24\u0c3e\u0c28\u0c4d" },
            { "TK", metaValue_TK },
            { "029", "\u0c15\u0c30\u0c3f\u0c2c\u0c4d\u0c2c\u0c3f\u0c2f\u0c28\u0c4d" },
            { "TL", "\u0c1f\u0c3f\u0c2e\u0c4b\u0c30\u0c4d-\u0c32\u0c46\u0c38\u0c4d\u0c1f\u0c46" },
            { "ybb", "\u0c2f\u0c46\u0c02\u0c2c\u0c3e" },
            { "type.co.searchjl", "\u0c39\u0c3e\u0c02\u0c17\u0c41\u0c32\u0c4d \u0c2a\u0c4d\u0c30\u0c3e\u0c30\u0c02\u0c2d \u0c39\u0c32\u0c4d\u0c32\u0c41 \u0c26\u0c4d\u0c35\u0c3e\u0c30\u0c3e \u0c36\u0c4b\u0c27\u0c3f\u0c02\u0c1a\u0c41" },
            { "TM", "\u0c1f\u0c30\u0c4d\u0c15\u0c4d\u200c\u0c2e\u0c46\u0c28\u0c3f\u0c38\u0c4d\u0c24\u0c3e\u0c28\u0c4d" },
            { "TN", "\u0c1f\u0c4d\u0c2f\u0c41\u0c28\u0c40\u0c37\u0c3f\u0c2f\u0c3e" },
            { "TO", "\u0c1f\u0c4b\u0c02\u0c17\u0c3e" },
            { "TR", "\u0c1f\u0c30\u0c4d\u0c15\u0c40" },
            { "TT", "\u0c1f\u0c4d\u0c30\u0c3f\u0c28\u0c3f\u0c21\u0c3e\u0c21\u0c4d \u0c2e\u0c30\u0c3f\u0c2f\u0c41 \u0c1f\u0c4a\u0c2c\u0c3e\u0c17\u0c4b" },
            { "TV", metaValue_TV },
            { "TW", "\u0c24\u0c48\u0c35\u0c3e\u0c28\u0c4d" },
            { "ast", "\u0c06\u0c38\u0c4d\u0c1f\u0c42\u0c30\u0c3f\u0c2f\u0c28\u0c4d" },
            { "Orkh", "\u0c13\u0c30\u0c4d\u0c16\u0c4b\u0c28\u0c4d" },
            { "TZ", "\u0c1f\u0c3e\u0c02\u0c1c\u0c3e\u0c28\u0c3f\u0c2f\u0c3e" },
            { "nmg", "\u0c15\u0c4d\u0c35\u0c3e\u0c38\u0c3f\u0c2f\u0c46" },
            { "Zzzz", "\u0c24\u0c46\u0c32\u0c3f\u0c2f\u0c28\u0c3f \u0c32\u0c3f\u0c2a\u0c3f" },
            { "UA", "\u0c09\u0c15\u0c4d\u0c30\u0c46\u0c2f\u0c3f\u0c28\u0c4d" },
            { "rup", "\u0c06\u0c30\u0c4b\u0c2e\u0c47\u0c28\u0c3f\u0c2f\u0c28\u0c4d" },
            { "030", "\u0c24\u0c42\u0c30\u0c4d\u0c2a\u0c41 \u0c06\u0c38\u0c3f\u0c2f\u0c3e" },
            { "tyv", "\u0c1f\u0c41\u0c35\u0c3f\u0c28\u0c3f\u0c2f\u0c28\u0c4d" },
            { "sw_CD", "\u0c15\u0c3e\u0c02\u0c17\u0c4b \u0c38\u0c4d\u0c35\u0c3e\u0c39\u0c3f\u0c32\u0c3f" },
            { "034", "\u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c06\u0c38\u0c3f\u0c2f\u0c3e" },
            { "hai", "\u0c39\u0c48\u0c21\u0c3e" },
            { "035", "\u0c06\u0c17\u0c4d\u0c28\u0c47\u0c2f \u0c06\u0c38\u0c3f\u0c2f\u0c3e" },
            { "UG", "\u0c09\u0c17\u0c3e\u0c02\u0c21\u0c3e" },
            { "hak", "\u0c39\u0c15\u0c4d\u0c15\u0c3e \u0c1a\u0c48\u0c28\u0c40\u0c38\u0c4d" },
            { "type.co.pinyin", "\u0c2a\u0c3f\u0c28\u0c4d\u200c\u0c2f\u0c3f\u0c28\u0c4d \u0c15\u0c4d\u0c30\u0c2e\u0c2c\u0c26\u0c4d\u0c27\u0c40\u0c15\u0c30\u0c23 \u0c15\u0c4d\u0c30\u0c2e\u0c02" },
            { "039", "\u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c2f\u0c42\u0c30\u0c4b\u0c2a\u0c4d" },
            { "Sinh", metaValue_si },
            { "UM", "\u0c38\u0c02\u0c2f\u0c41\u0c15\u0c4d\u0c24 \u0c30\u0c3e\u0c1c\u0c4d\u0c2f \u0c05\u0c2e\u0c46\u0c30\u0c3f\u0c15\u0c3e \u0c2c\u0c2f\u0c1f \u0c09\u0c28\u0c4d\u0c28 \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "UN", "\u0c2f\u0c41\u0c28\u0c48\u0c1f\u0c46\u0c21\u0c4d \u0c28\u0c47\u0c37\u0c28\u0c4d\u0c38\u0c4d" },
            { "US", "\u0c2f\u0c41\u0c28\u0c48\u0c1f\u0c46\u0c21\u0c4d \u0c38\u0c4d\u0c1f\u0c47\u0c1f\u0c4d\u0c38\u0c4d" },
            { "haw", "\u0c39\u0c35\u0c3e\u0c2f\u0c3f\u0c2f\u0c28\u0c4d" },
            { "type.co.gb2312han", "\u0c38\u0c30\u0c33\u0c40\u0c15\u0c43\u0c24 \u0c1a\u0c48\u0c28\u0c40\u0c38\u0c4d \u0c15\u0c4d\u0c30\u0c2e\u0c2c\u0c26\u0c4d\u0c27\u0c40\u0c15\u0c30\u0c23 \u0c15\u0c4d\u0c30\u0c2e\u0c02 - GB2312" },
            { "UY", "\u0c09\u0c30\u0c41\u0c17\u0c4d\u0c35\u0c47" },
            { "prg", "\u0c2a\u0c4d\u0c30\u0c37\u0c4d\u0c2f\u0c28\u0c4d" },
            { "UZ", "\u0c09\u0c1c\u0c4d\u0c2c\u0c46\u0c15\u0c3f\u0c38\u0c4d\u0c24\u0c3e\u0c28\u0c4d" },
            { "tzm", "\u0c38\u0c46\u0c02\u0c1f\u0c4d\u0c30\u0c32\u0c4d \u0c05\u0c1f\u0c4d\u0c32\u0c3e\u0c38\u0c4d \u0c1f\u0c3e\u0c2e\u0c3e\u0c1c\u0c48\u0c1f\u0c4d" },
            { "type.co.stroke", "\u0c38\u0c4d\u0c1f\u0c4d\u0c30\u0c4b\u0c15\u0c4d \u0c15\u0c4d\u0c30\u0c2e\u0c2c\u0c26\u0c4d\u0c27\u0c40\u0c15\u0c30\u0c23 \u0c15\u0c4d\u0c30\u0c2e\u0c02" },
            { "nnh", "\u0c17\u0c3f\u0c02\u0c2c\u0c42\u0c28\u0c4d" },
            { "VA", "\u0c35\u0c3e\u0c1f\u0c3f\u0c15\u0c28\u0c4d \u0c28\u0c17\u0c30\u0c02" },
            { "pro", "\u0c2a\u0c4d\u0c30\u0c3e\u0c1a\u0c40\u0c28 \u0c2a\u0c4d\u0c30\u0c4b\u0c35\u0c46\u0c02\u0c38\u0c3e\u0c32\u0c4d" },
            { "VC", "\u0c38\u0c46\u0c2f\u0c3f\u0c02\u0c1f\u0c4d \u0c35\u0c3f\u0c28\u0c4d\u0c38\u0c46\u0c02\u0c1f\u0c4d \u0c2e\u0c30\u0c3f\u0c2f\u0c41 \u0c17\u0c4d\u0c30\u0c46\u0c28\u0c21\u0c40\u0c28\u0c4d\u0c38\u0c4d" },
            { "VE", "\u0c35\u0c46\u0c28\u0c3f\u0c1c\u0c41\u0c32\u0c3e" },
            { "VG", "\u0c2c\u0c4d\u0c30\u0c3f\u0c1f\u0c3f\u0c37\u0c4d \u0c35\u0c30\u0c4d\u0c1c\u0c3f\u0c28\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "VI", "\u0c2f\u0c41.\u0c0e\u0c38\u0c4d. \u0c35\u0c30\u0c4d\u0c1c\u0c3f\u0c28\u0c4d \u0c26\u0c40\u0c35\u0c41\u0c32\u0c41" },
            { "VN", "\u0c35\u0c3f\u0c2f\u0c24\u0c4d\u0c28\u0c3e\u0c02" },
            { "VU", "\u0c35\u0c28\u0c3e\u0c1f\u0c41" },
            { "nog", "\u0c28\u0c4b\u0c17\u0c48" },
            { "rwk", "\u0c30\u0c4d\u0c35\u0c3e" },
            { "non", "\u0c2a\u0c4d\u0c30\u0c3e\u0c1a\u0c3f\u0c28 \u0c28\u0c4b\u0c30\u0c4d\u0c38\u0c4d" },
            { "053", "\u0c06\u0c38\u0c4d\u0c1f\u0c4d\u0c30\u0c47\u0c32\u0c47\u0c38\u0c3f\u0c2f\u0c3e" },
            { "054", "\u0c2e\u0c46\u0c32\u0c28\u0c47\u0c36\u0c3f\u0c2f" },
            { "WF", "\u0c35\u0c3e\u0c32\u0c4d\u0c32\u0c3f\u0c38\u0c4d \u0c2e\u0c30\u0c3f\u0c2f\u0c41 \u0c2b\u0c41\u0c1f\u0c41\u0c28\u0c3e" },
            { "type.co.traditional", "\u0c38\u0c3e\u0c02\u0c2a\u0c4d\u0c30\u0c26\u0c3e\u0c2f \u0c15\u0c4d\u0c30\u0c2e\u0c2c\u0c26\u0c4d\u0c27\u0c40\u0c15\u0c30\u0c23 \u0c15\u0c4d\u0c30\u0c2e\u0c02" },
            { "057", "\u0c2e\u0c48\u0c15\u0c4d\u0c30\u0c4b\u0c28\u0c47\u0c36\u0c3f\u0c2f \u0c2a\u0c4d\u0c30\u0c3e\u0c02\u0c24\u0c02" },
            { "jgo", "\u0c17\u0c4b\u0c02\u0c2c\u0c3e" },
            { "lkt", "\u0c32\u0c15\u0c4a\u0c1f\u0c3e" },
            { "type.nu.finance", "\u0c06\u0c30\u0c4d\u0c25\u0c3f\u0c15 \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "type.co.compat", "\u0c2e\u0c41\u0c28\u0c41\u0c2a\u0c1f\u0c3f \u0c15\u0c4d\u0c30\u0c2e\u0c2c\u0c26\u0c4d\u0c27\u0c40\u0c15\u0c30\u0c23 \u0c15\u0c4d\u0c30\u0c2e\u0c02, \u0c05\u0c28\u0c41\u0c15\u0c42\u0c32\u0c02" },
            { "wae", "\u0c35\u0c3e\u0c32\u0c4d\u0c38\u0c30\u0c4d" },
            { "WS", "\u0c38\u0c2e\u0c4b\u0c35\u0c3e" },
            { "wal", "\u0c35\u0c3e\u0c32\u0c47\u0c1f\u0c4d\u0c1f\u0c3e" },
            { "was", "\u0c35\u0c3e\u0c37\u0c4b" },
            { "XA", "\u0c38\u0c42\u0c21\u0c4b \u0c2f\u0c3e\u0c15\u0c4d\u0c38\u0c46\u0c02\u0c1f\u0c4d\u0c38\u0c4d" },
            { "war", "\u0c35\u0c3e\u0c30\u0c47" },
            { "XB", "\u0c38\u0c42\u0c21\u0c4b-\u0c2c\u0c3f\u0c21\u0c3f" },
            { "awa", "\u0c05\u0c35\u0c27\u0c3f" },
            { "061", "\u0c2a\u0c3e\u0c32\u0c3f\u0c28\u0c47\u0c37\u0c3f\u0c2f\u0c3e" },
            { "XK", "\u0c15\u0c4a\u0c38\u0c4b\u0c35\u0c4b" },
            { "Gujr", "\u0c17\u0c41\u0c1c\u0c30\u0c3e\u0c24\u0c40" },
            { "Zxxx", "\u0c32\u0c3f\u0c2a\u0c3f \u0c32\u0c47\u0c28\u0c3f" },
            { "Olck", "\u0c13\u0c32\u0c4d \u0c1a\u0c3f\u0c15\u0c3f" },
            { "wbp", "\u0c35\u0c3e\u0c30\u0c4d\u0c32\u0c2a\u0c3f\u0c30\u0c3f" },
            { "Batk", "\u0c2c\u0c3e\u0c1f\u0c15\u0c4d" },
            { "Blis", "\u0c2c\u0c4d\u0c32\u0c3f\u0c38\u0c4d\u0c38\u0c3f\u0c02\u0c2c\u0c32\u0c4d\u0c38\u0c4d" },
            { "YE", "\u0c2f\u0c46\u0c2e\u0c46\u0c28\u0c4d" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "\u0c2a\u0c4d\u0c30\u0c3e\u0c2e\u0c3e\u0c23\u0c3f\u0c15 \u0c15\u0c4d\u0c30\u0c2e\u0c2c\u0c26\u0c4d\u0c27\u0c40\u0c15\u0c30\u0c23 \u0c15\u0c4d\u0c30\u0c2e\u0c02" },
            { "fan", "\u0c2b\u0c3e\u0c02\u0c17\u0c4d" },
            { "fat", "\u0c2b\u0c3e\u0c02\u0c1f\u0c3f" },
            { "Sgnw", "\u0c38\u0c02\u0c1c\u0c4d\u0c1e \u0c32\u0c3f\u0c2a\u0c3f" },
            { "YT", "\u0c2e\u0c3e\u0c2f\u0c4a\u0c1f\u0c4d" },
            { "ZA", "\u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c06\u0c2b\u0c4d\u0c30\u0c3f\u0c15\u0c3e" },
            { "type.lb.loose", "\u0c05\u0c2a\u0c15\u0c4d\u0c30\u0c2e \u0c32\u0c48\u0c28\u0c4d \u0c2c\u0c4d\u0c30\u0c47\u0c15\u0c4d \u0c36\u0c48\u0c32\u0c3f" },
            { "Deva", "\u0c26\u0c47\u0c35\u0c28\u0c3e\u0c17\u0c30\u0c3f" },
            { "type.nu.geor", "\u0c1c\u0c3e\u0c30\u0c4d\u0c1c\u0c3f\u0c2f\u0c28\u0c4d \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "Hira", "\u0c39\u0c3f\u0c30\u0c3e\u0c17\u0c3e\u0c28" },
            { "ZM", "\u0c1c\u0c3e\u0c02\u0c2c\u0c3f\u0c2f\u0c3e" },
            { "%%PINYIN", "\u0c2a\u0c3f\u0c28\u0c4d\u200c\u0c2f\u0c3f\u0c28\u0c4d \u0c30\u0c4b\u0c2e\u0c28\u0c48\u0c1c\u0c47\u0c37\u0c28\u0c4d" },
            { "ZW", "\u0c1c\u0c3f\u0c02\u0c2c\u0c3e\u0c2c\u0c4d\u0c35\u0c47" },
            { "ZZ", "\u0c24\u0c46\u0c32\u0c3f\u0c2f\u0c28\u0c3f \u0c2a\u0c4d\u0c30\u0c3e\u0c02\u0c24\u0c02" },
            { "Runr", "\u0c30\u0c42\u0c28\u0c3f\u0c15\u0c4d" },
            { "type.ms.metric", "\u0c2e\u0c46\u0c1f\u0c4d\u0c30\u0c3f\u0c15\u0c4d \u0c2a\u0c26\u0c4d\u0c27\u0c24\u0c3f" },
            { "type.ca.iso8601", "ISO-8601 \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "lol", "\u0c2e\u0c4a\u0c02\u0c17\u0c4b" },
            { "nso", "\u0c09\u0c24\u0c4d\u0c24\u0c30 \u0c38\u0c4b\u0c24\u0c4b" },
            { "type.nu.telu", "\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41 \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "lou", "\u0c32\u0c42\u0c38\u0c3f\u0c2f\u0c3e\u0c28\u0c3e \u0c15\u0c4d\u0c30\u0c3f\u0c2f\u0c4b\u0c32\u0c4d" },
            { "loz", "\u0c32\u0c4b\u0c1c\u0c3f" },
            { "jmc", "\u0c2e\u0c15\u0c4a\u0c2e\u0c4d" },
            { "type.nu.hansfin", "\u0c38\u0c30\u0c33\u0c40\u0c15\u0c43\u0c24 \u0c1a\u0c48\u0c28\u0c40\u0c2f\u0c41\u0c32 \u0c06\u0c30\u0c4d\u0c25\u0c3f\u0c15 \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "hil", "\u0c39\u0c3f\u0c32\u0c3f\u0c17\u0c46\u0c28\u0c3e\u0c28\u0c4d" },
            { "type.nu.arabext", "\u0c2a\u0c4a\u0c21\u0c3f\u0c17\u0c3f\u0c02\u0c1a\u0c2c\u0c21\u0c3f\u0c28 \u0c05\u0c30\u0c2c\u0c3f\u0c15\u0c4d-\u0c07\u0c02\u0c21\u0c3f\u0c15\u0c4d \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "nus", "\u0c28\u0c4d\u0c2f\u0c41\u0c30\u0c4d" },
            { "dak", "\u0c21\u0c15\u0c4b\u0c1f\u0c3e" },
            { "type.nu.fullwide", "\u0c2a\u0c42\u0c30\u0c4d\u0c24\u0c3f \u0c35\u0c46\u0c21\u0c32\u0c4d\u0c2a\u0c41 \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "hit", "\u0c39\u0c3f\u0c1f\u0c4d\u0c1f\u0c3f\u0c1f\u0c47" },
            { "dar", "\u0c21\u0c3e\u0c30\u0c4d\u0c17\u0c4d\u0c35\u0c3e" },
            { "dav", "\u0c1f\u0c48\u0c1f\u0c3e" },
            { "Maya", "\u0c2e\u0c3e\u0c2f\u0c28\u0c4d \u0c39\u0c48\u0c30\u0c4b\u0c17\u0c4d\u0c32\u0c48\u0c2b\u0c4d\u0c38\u0c4d" },
            { "lrc", "\u0c09\u0c24\u0c4d\u0c24\u0c30 \u0c32\u0c42\u0c30\u0c40" },
            { "Copt", metaValue_cop },
            { "nwc", "\u0c38\u0c3e\u0c02\u0c2a\u0c4d\u0c30\u0c26\u0c3e\u0c2f \u0c28\u0c4d\u0c2f\u0c42\u0c2f\u0c3e\u0c30\u0c40" },
            { "udm", "\u0c09\u0c21\u0c4d\u0c2e\u0c41\u0c30\u0c4d\u0c1f\u0c4d" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "\u0c07\u0c38\u0c4d\u0c32\u0c3e\u0c2e\u0c3f\u0c15\u0c4d \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d (\u0c38\u0c4c\u0c26\u0c40 \u0c05\u0c30\u0c47\u0c2c\u0c3f\u0c2f\u0c3e)" },
            { "Limb", "\u0c32\u0c3f\u0c02\u0c2c\u0c41" },
            { "sad", "\u0c38\u0c02\u0c21\u0c3e\u0c35\u0c3f" },
            { "type.nu.roman", "\u0c30\u0c4b\u0c2e\u0c28\u0c4d \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "sah", "\u0c38\u0c3e\u0c16\u0c3e" },
            { "sam", "\u0c38\u0c2e\u0c3e\u0c30\u0c3f\u0c1f\u0c28\u0c4d \u0c05\u0c30\u0c3e\u0c2e\u0c48\u0c15\u0c4d" },
            { "saq", "\u0c38\u0c02\u0c2c\u0c41\u0c30\u0c41" },
            { "sas", "\u0c38\u0c38\u0c15\u0c4d" },
            { "sat", "\u0c38\u0c02\u0c24\u0c3e\u0c32\u0c3f" },
            { "Tfng", "\u0c1f\u0c3f\u0c2b\u0c40\u0c28\u0c3e\u0c18\u0c4d" },
            { "jpr", "\u0c1c\u0c4d\u0c2f\u0c41\u0c21\u0c3f\u0c2f\u0c4b-\u0c2a\u0c30\u0c4d\u0c37\u0c3f\u0c2f\u0c28\u0c4d" },
            { "type.d0.npinyin", "\u0c38\u0c02\u0c16\u0c4d\u0c2f" },
            { "type.nu.native", "\u0c38\u0c4d\u0c25\u0c3e\u0c28\u0c3f\u0c15 \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "sba", "\u0c17\u0c3e\u0c02\u0c2c\u0c47" },
            { "Guru", "\u0c17\u0c41\u0c30\u0c4d\u0c2e\u0c41\u0c16\u0c3f" },
            { "lua", "\u0c32\u0c41\u0c2c\u0c3e-\u0c32\u0c41\u0c32\u0c41\u0c35" },
            { "type.d0.fwidth", "\u0c2a\u0c42\u0c30\u0c4d\u0c24\u0c3f \u0c35\u0c46\u0c21\u0c32\u0c4d\u0c2a\u0c41" },
            { "sbp", "\u0c38\u0c3e\u0c02\u0c17\u0c41" },
            { "lui", "\u0c32\u0c41\u0c2f\u0c3f\u0c38\u0c46\u0c28\u0c4b" },
            { "nyn", "\u0c28\u0c4d\u0c2f\u0c3e\u0c28\u0c4d\u0c15\u0c4b\u0c32\u0c46" },
            { "nym", "\u0c28\u0c4d\u0c2f\u0c02\u0c35\u0c47\u0c1c\u0c3f" },
            { "lun", "\u0c32\u0c41\u0c02\u0c21\u0c3e" },
            { "nyo", "\u0c28\u0c47\u0c2f\u0c4b\u0c30\u0c4b" },
            { "luo", "\u0c32\u0c41\u0c35\u0c4b" },
            { "fil", "\u0c2b\u0c3f\u0c32\u0c3f\u0c2a\u0c3f\u0c28\u0c4b" },
            { "hmn", "\u0c2e\u0c4b\u0c02\u0c17\u0c4d" },
            { "del", "\u0c21\u0c46\u0c32\u0c3e\u0c35\u0c47\u0c30\u0c4d" },
            { "lus", "\u0c2e\u0c3f\u0c1c\u0c4b" },
            { "bal", "\u0c2c\u0c3e\u0c32\u0c41\u0c1a\u0c3f" },
            { "den", "\u0c38\u0c4d\u0c32\u0c47\u0c35\u0c4d" },
            { "ban", metaValue_ban },
            { "uga", "\u0c09\u0c17\u0c3e\u0c30\u0c3f\u0c1f\u0c3f\u0c15\u0c4d" },
            { "luy", "\u0c32\u0c41\u0c2f\u0c3f\u0c2f" },
            { "bas", "\u0c2c\u0c38\u0c3e" },
            { "jrb", "\u0c1c\u0c4d\u0c2f\u0c41\u0c21\u0c3f\u0c2f\u0c4b-\u0c05\u0c30\u0c2c\u0c3f\u0c15\u0c4d" },
            { "es_ES", "\u0c2f\u0c42\u0c30\u0c4b\u0c2a\u0c3f\u0c2f\u0c28\u0c4d \u0c38\u0c4d\u0c2a\u0c3e\u0c28\u0c3f\u0c37\u0c4d" },
            { "nzi", "\u0c1c\u0c40\u0c2e\u0c3e" },
            { "sco", "\u0c38\u0c4d\u0c15\u0c3e\u0c1f\u0c4d\u0c38\u0c4d" },
            { "scn", "\u0c38\u0c3f\u0c38\u0c3f\u0c32\u0c3f\u0c2f\u0c28\u0c4d" },
            { "aa", "\u0c05\u0c2b\u0c3e\u0c30\u0c4d" },
            { "ab", "\u0c05\u0c2c\u0c4d\u0c16\u0c3e\u0c1c\u0c3f\u0c2f\u0c28\u0c4d" },
            { "ae", metaValue_ae },
            { "af", "\u0c06\u0c2b\u0c4d\u0c30\u0c3f\u0c15\u0c3e\u0c28\u0c4d\u0c38\u0c4d" },
            { "ak", "\u0c05\u0c15\u0c3e\u0c28\u0c4d" },
            { "am", "\u0c05\u0c2e\u0c4d\u0c39\u0c3e\u0c30\u0c3f\u0c15\u0c4d" },
            { "Arab", metaValue_ar },
            { "an", "\u0c05\u0c30\u0c17\u0c4b\u0c28\u0c3f\u0c38\u0c4d" },
            { "Jpan", "\u0c1c\u0c3e\u0c2a\u0c28\u0c40\u0c38\u0c4d" },
            { "ar", metaValue_ar },
            { "Hrkt", "\u0c1c\u0c2a\u0c28\u0c40\u0c38\u0c4d \u0c38\u0c3f\u0c32\u0c2c\u0c46\u0c30\u0c40\u0c38\u0c4d" },
            { "as", "\u0c05\u0c38\u0c4d\u0c38\u0c3e\u0c2e\u0c40\u0c38\u0c4d" },
            { "Lina", "\u0c32\u0c3f\u0c28\u0c3f\u0c2f\u0c30\u0c4d \u0c0e" },
            { "av", "\u0c05\u0c35\u0c3e\u0c30\u0c3f\u0c15\u0c4d" },
            { "Linb", "\u0c32\u0c3f\u0c28\u0c3f\u0c2f\u0c30\u0c4d \u0c2c\u0c3f" },
            { "sdh", "\u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c15\u0c41\u0c30\u0c4d\u0c21\u0c3f\u0c37\u0c4d" },
            { "ay", "\u0c10\u0c2e\u0c3e\u0c30\u0c3e" },
            { "az", "\u0c05\u0c1c\u0c30\u0c4d\u0c2c\u0c48\u0c1c\u0c3e\u0c28\u0c3f" },
            { "ba", "\u0c2c\u0c3e\u0c37\u0c4d\u0c15\u0c3f\u0c30\u0c4d" },
            { "type.co.unihan", "\u0c30\u0c3e\u0c21\u0c3f\u0c15\u0c32\u0c4d-\u0c38\u0c4d\u0c1f\u0c4d\u0c30\u0c4b\u0c15\u0c4d \u0c15\u0c4d\u0c30\u0c2e\u0c2c\u0c26\u0c4d\u0c27\u0c40\u0c15\u0c30\u0c23 \u0c15\u0c4d\u0c30\u0c2e\u0c02" },
            { "be", "\u0c2c\u0c46\u0c32\u0c3e\u0c30\u0c41\u0c37\u0c3f\u0c2f\u0c28\u0c4d" },
            { "bg", "\u0c2c\u0c32\u0c4d\u0c17\u0c47\u0c30\u0c3f\u0c2f\u0c28\u0c4d" },
            { "bi", "\u0c2c\u0c3f\u0c38\u0c4d\u0c32\u0c3e\u0c2e\u0c3e" },
            { "bm", "\u0c2c\u0c02\u0c2c\u0c3e\u0c30\u0c3e" },
            { "bn", "\u0c2c\u0c02\u0c17\u0c4d\u0c32\u0c3e" },
            { "bo", metaValue_bo },
            { "dgr", "\u0c21\u0c4b\u0c17\u0c4d\u0c30\u0c3f\u0c2c\u0c4d" },
            { "br", "\u0c2c\u0c4d\u0c30\u0c46\u0c1f\u0c28\u0c4d" },
            { "bs", "\u0c2c\u0c4b\u0c38\u0c4d\u0c28\u0c3f\u0c2f\u0c28\u0c4d" },
            { "Mymr", "\u0c2e\u0c2f\u0c3e\u0c28\u0c4d\u0c2e\u0c3e\u0c30\u0c4d" },
            { "type.nu.laoo", "\u0c32\u0c3e\u0c35\u0c4b \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "seh", "\u0c38\u0c46\u0c28\u0c3e" },
            { "Nkoo", metaValue_nqo },
            { "sel", "\u0c38\u0c47\u0c32\u0c4d\u0c15\u0c2a\u0c4d" },
            { "ca", "\u0c15\u0c3e\u0c1f\u0c32\u0c3e\u0c28\u0c4d" },
            { "ses", "\u0c15\u0c4b\u0c2f\u0c4b\u0c30\u0c3e\u0c2c\u0c4b\u0c30\u0c4b \u0c38\u0c46\u0c28\u0c4d\u0c28\u0c40" },
            { "ce", "\u0c1a\u0c46\u0c1a\u0c46\u0c28\u0c4d" },
            { "ch", "\u0c1a\u0c2e\u0c30\u0c4d\u0c30\u0c4b" },
            { "%%REVISED", "\u0c38\u0c35\u0c30\u0c3f\u0c02\u0c1a\u0c2c\u0c21\u0c3f\u0c28 \u0c35\u0c30\u0c4d\u0c23\u0c15\u0c4d\u0c30\u0c2e\u0c02" },
            { "co", "\u0c15\u0c4b\u0c30\u0c4d\u0c38\u0c3f\u0c15\u0c28\u0c4d" },
            { "Orya", metaValue_or },
            { "cr", "\u0c15\u0c4d\u0c30\u0c3f" },
            { "cs", "\u0c1a\u0c46\u0c15\u0c4d" },
            { "cu", "\u0c1a\u0c30\u0c4d\u0c1a\u0c4d \u0c38\u0c4d\u0c32\u0c3e\u0c35\u0c3f\u0c15\u0c4d" },
            { "cv", "\u0c1a\u0c41\u0c35\u0c3e\u0c37\u0c4d" },
            { "cy", "\u0c35\u0c46\u0c32\u0c4d\u0c37\u0c4d" },
            { "type.nu.ethi", "\u0c0e\u0c25\u0c3f\u0c2f\u0c4b\u0c2a\u0c3f\u0c15\u0c4d \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "Yiii", "\u0c2f\u0c3f" },
            { "da", "\u0c21\u0c3e\u0c28\u0c3f\u0c37\u0c4d" },
            { "pt_PT", "\u0c2f\u0c42\u0c30\u0c4b\u0c2a\u0c3f\u0c2f\u0c28\u0c4d \u0c2a\u0c4b\u0c30\u0c4d\u0c1a\u0c41\u0c17\u0c40\u0c38\u0c4d" },
            { "de", "\u0c1c\u0c30\u0c4d\u0c2e\u0c28\u0c4d" },
            { "type.cf.standard", "\u0c2a\u0c4d\u0c30\u0c3e\u0c2e\u0c3e\u0c23\u0c3f\u0c15 \u0c15\u0c30\u0c46\u0c28\u0c4d\u0c38\u0c40 \u0c2b\u0c3e\u0c30\u0c4d\u0c2e\u0c3e\u0c1f\u0c4d" },
            { "bej", "\u0c2c\u0c47\u0c1c\u0c3e" },
            { "din", "\u0c21\u0c3f\u0c02\u0c15\u0c3e" },
            { "Bugi", "\u0c2c\u0c4d\u0c2f\u0c41\u0c17\u0c3f\u0c28\u0c40\u0c38\u0c4d" },
            { "bem", "\u0c2c\u0c46\u0c02\u0c2c\u0c3e" },
            { "sga", "\u0c2a\u0c4d\u0c30\u0c3e\u0c1a\u0c40\u0c28 \u0c10\u0c30\u0c3f\u0c37\u0c4d" },
            { "type.nu.mong", "\u0c2e\u0c02\u0c17\u0c4b\u0c32\u0c3f\u0c2f\u0c28\u0c4d \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "dv", "\u0c26\u0c3f\u0c35\u0c47\u0c39\u0c3f" },
            { "es_419", "\u0c32\u0c3e\u0c1f\u0c3f\u0c28\u0c4d \u0c05\u0c2e\u0c46\u0c30\u0c3f\u0c15\u0c28\u0c4d \u0c38\u0c4d\u0c2a\u0c3e\u0c28\u0c3f\u0c37\u0c4d" },
            { "dz", "\u0c1c\u0c4b\u0c02\u0c16\u0c3e" },
            { "bez", "\u0c2c\u0c46\u0c28\u0c3e" },
            { "type.ca.chinese", "\u0c1a\u0c48\u0c28\u0c40\u0c38\u0c4d \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "dje", "\u0c1c\u0c3e\u0c30\u0c4d\u0c2e\u0c3e" },
            { "type.nu.grek", "\u0c17\u0c4d\u0c30\u0c40\u0c15\u0c4d \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "ee", "\u0c2f\u0c42" },
            { "type.lb.normal", "\u0c38\u0c3e\u0c27\u0c3e\u0c30\u0c23 \u0c32\u0c48\u0c28\u0c4d \u0c2c\u0c4d\u0c30\u0c47\u0c15\u0c4d \u0c36\u0c48\u0c32\u0c3f" },
            { "ro_MD", "\u0c2e\u0c4a\u0c32\u0c4d\u0c21\u0c3e\u0c35\u0c3f\u0c2f\u0c28\u0c4d" },
            { "el", metaValue_el },
            { "en", "\u0c07\u0c02\u0c17\u0c4d\u0c32\u0c40\u0c37\u0c4d" },
            { "eo", "\u0c0e\u0c38\u0c4d\u0c2a\u0c46\u0c30\u0c3e\u0c02\u0c1f\u0c4b" },
            { "type.co.big5han", "\u0c38\u0c3e\u0c02\u0c2a\u0c4d\u0c30\u0c26\u0c3e\u0c2f \u0c1a\u0c48\u0c28\u0c40\u0c38\u0c4d \u0c15\u0c4d\u0c30\u0c2e\u0c2c\u0c26\u0c4d\u0c27\u0c40\u0c15\u0c30\u0c23 \u0c15\u0c4d\u0c30\u0c2e\u0c02 - Big5" },
            { "es", "\u0c38\u0c4d\u0c2a\u0c3e\u0c28\u0c3f\u0c37\u0c4d" },
            { "et", "\u0c0e\u0c38\u0c4d\u0c1f\u0c4b\u0c28\u0c3f\u0c2f\u0c28\u0c4d" },
            { "Hanb", "\u0c39\u0c3e\u0c28\u0c4d\u0c2c\u0c4d" },
            { "eu", "\u0c2c\u0c3e\u0c38\u0c4d\u0c15\u0c4d\u0c2f\u0c42" },
            { "Buhd", "\u0c2c\u0c41\u0c39\u0c3f\u0c21\u0c4d" },
            { "Hang", "\u0c39\u0c02\u0c17\u0c41\u0c32\u0c4d" },
            { "Samr", "\u0c38\u0c2e\u0c3e\u0c30\u0c3f\u0c1f\u0c28\u0c4d" },
            { "shi", "\u0c1f\u0c3e\u0c1a\u0c46\u0c32\u0c4d\u200c\u0c39\u0c3f\u0c1f\u0c4d" },
            { "hsb", "\u0c05\u0c2a\u0c4d\u0c2a\u0c30\u0c4d \u0c38\u0c4b\u0c30\u0c4d\u0c2c\u0c3f\u0c2f\u0c28\u0c4d" },
            { "Hani", "\u0c39\u0c3e\u0c28\u0c4d" },
            { "shn", "\u0c37\u0c3e\u0c28\u0c4d" },
            { "Hano", "\u0c39\u0c28\u0c41\u0c28\u0c42" },
            { "fa", "\u0c2a\u0c30\u0c4d\u0c37\u0c3f\u0c2f\u0c28\u0c4d" },
            { "Hans", "\u0c38\u0c30\u0c33\u0c40\u0c15\u0c43\u0c24\u0c02" },
            { "type.nu.latn", "\u0c2a\u0c36\u0c4d\u0c1a\u0c3f\u0c2e \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "Hant", "\u0c38\u0c3e\u0c02\u0c2a\u0c4d\u0c30\u0c26\u0c3e\u0c2f\u0c15" },
            { "ff", "\u0c2b\u0c4d\u0c2f\u0c41\u0c32" },
            { "hsn", "\u0c1c\u0c3f\u0c2f\u0c3e\u0c02\u0c17\u0c4d \u0c1a\u0c48\u0c28\u0c40\u0c38\u0c4d" },
            { "fi", "\u0c2b\u0c3f\u0c28\u0c4d\u0c28\u0c3f\u0c37\u0c4d" },
            { "fj", "\u0c2b\u0c3f\u0c1c\u0c3f\u0c2f\u0c28\u0c4d" },
            { "fon", "\u0c2b\u0c3e\u0c28\u0c4d" },
            { "bgn", "\u0c2a\u0c36\u0c4d\u0c1a\u0c3f\u0c2e \u0c2c\u0c32\u0c42\u0c1a\u0c40" },
            { "yue", "\u0c15\u0c3e\u0c02\u0c1f\u0c28\u0c40\u0c38\u0c4d" },
            { "fo", "\u0c2b\u0c3e\u0c30\u0c4b\u0c38\u0c4d" },
            { "type.m0.bgn", "US BGN \u0c1f\u0c4d\u0c30\u0c3e\u0c28\u0c4d\u0c38\u0c4d\u200c\u0c32\u0c3f\u0c1f\u0c4d\u0c30\u0c47\u0c37\u0c28\u0c4d" },
            { "umb", "\u0c09\u0c2e\u0c4d\u0c2c\u0c41\u0c02\u0c21\u0c41" },
            { "fr", "\u0c2b\u0c4d\u0c30\u0c46\u0c02\u0c1a\u0c4d" },
            { "sid", "\u0c38\u0c3f\u0c21\u0c3e\u0c2e\u0c4b" },
            { "fy", "\u0c2a\u0c36\u0c4d\u0c1a\u0c3f\u0c2e \u0c2b\u0c4d\u0c30\u0c3f\u0c38\u0c3f\u0c2f\u0c28\u0c4d" },
            { "ga", "\u0c10\u0c30\u0c3f\u0c37\u0c4d" },
            { "gd", "\u0c38\u0c4d\u0c15\u0c3e\u0c1f\u0c3f\u0c37\u0c4d \u0c17\u0c47\u0c32\u0c3f\u0c15\u0c4d" },
            { "gl", "\u0c17\u0c3e\u0c32\u0c3f\u0c37\u0c3f\u0c2f\u0c28\u0c4d" },
            { "gn", "\u0c17\u0c4d\u0c35\u0c3e\u0c30\u0c28\u0c40" },
            { "bho", "\u0c2d\u0c4b\u0c1c\u0c4d\u200c\u0c2a\u0c41\u0c30\u0c3f" },
            { "und", "\u0c24\u0c46\u0c32\u0c3f\u0c2f\u0c28\u0c3f \u0c2d\u0c3e\u0c37" },
            { "type.ca.ethiopic-amete-alem", "\u0c0e\u0c25\u0c4b\u0c2a\u0c3f\u0c15\u0c4d \u0c05\u0c2e\u0c47\u0c1f\u0c47 \u0c05\u0c32\u0c46\u0c2e\u0c4d \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "type.ca.islamic-tbla", metaValue_type_ca_islamic },
            { "gu", "\u0c17\u0c41\u0c1c\u0c30\u0c3e\u0c24\u0c3f" },
            { "gv", "\u0c2e\u0c3e\u0c02\u0c15\u0c4d\u0c38\u0c4d" },
            { "ha", "\u0c39\u0c4c\u0c38\u0c3e" },
            { "he", "\u0c39\u0c3f\u0c2c\u0c4d\u0c30\u0c42" },
            { "hi", "\u0c39\u0c3f\u0c02\u0c26\u0c40" },
            { "hup", "\u0c39\u0c41\u0c2a\u0c3e" },
            { "bik", "\u0c2c\u0c3f\u0c15\u0c4b\u0c32\u0c4d" },
            { "bin", "\u0c2c\u0c3f\u0c28\u0c3f" },
            { "ho", "\u0c39\u0c3f\u0c30\u0c3f \u0c2e\u0c4b\u0c1f\u0c41" },
            { "hr", "\u0c15\u0c4d\u0c30\u0c4a\u0c2f\u0c47\u0c37\u0c3f\u0c2f\u0c28\u0c4d" },
            { "ht", "\u0c39\u0c48\u0c1f\u0c3f\u0c2f\u0c28\u0c4d \u0c15\u0c4d\u0c30\u0c3f\u0c2f\u0c4b\u0c32\u0c4d" },
            { "hu", "\u0c39\u0c02\u0c17\u0c47\u0c30\u0c3f\u0c2f\u0c28\u0c4d" },
            { "hy", "\u0c06\u0c30\u0c4d\u0c2e\u0c47\u0c28\u0c3f\u0c2f\u0c28\u0c4d" },
            { "hz", "\u0c39\u0c46\u0c30\u0c46\u0c30\u0c4b" },
            { "frc", "\u0c15\u0c3e\u0c1c\u0c41\u0c28\u0c4d \u0c2b\u0c4d\u0c30\u0c46\u0c02\u0c1a\u0c4d" },
            { "ia", "\u0c07\u0c02\u0c1f\u0c30\u0c4d\u0c32\u0c3f\u0c02\u0c17\u0c4d\u0c35\u0c3e" },
            { "Jamo", "\u0c1c\u0c2e\u0c4b" },
            { "id", "\u0c07\u0c02\u0c21\u0c4b\u0c28\u0c47\u0c37\u0c3f\u0c2f\u0c28\u0c4d" },
            { "type.nu.tibt", "\u0c1f\u0c3f\u0c2c\u0c3f\u0c1f\u0c28\u0c4d \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "ie", "\u0c07\u0c02\u0c1f\u0c30\u0c4d\u0c32\u0c3f\u0c02\u0c17\u0c4d" },
            { "ig", "\u0c07\u0c17\u0c4d\u0c2c\u0c4b" },
            { "ii", "\u0c36\u0c3f\u0c37\u0c41\u0c35\u0c28\u0c4d \u0c08" },
            { "frm", "\u0c2e\u0c27\u0c4d\u0c2f\u0c2e \u0c2a\u0c4d\u0c30\u0c46\u0c02\u0c1a\u0c4d" },
            { "ik", "\u0c07\u0c28\u0c41\u0c2a\u0c48\u0c2f\u0c3e\u0c15\u0c4d" },
            { "fro", "\u0c2a\u0c4d\u0c30\u0c3e\u0c1a\u0c40\u0c28 \u0c2b\u0c4d\u0c30\u0c46\u0c02\u0c1a\u0c4d" },
            { "io", "\u0c08\u0c21\u0c4b" },
            { "frs", "\u0c24\u0c42\u0c30\u0c4d\u0c2a\u0c41 \u0c2b\u0c4d\u0c30\u0c3f\u0c38\u0c3f\u0c2f\u0c28\u0c4d" },
            { "frr", "\u0c09\u0c24\u0c4d\u0c24\u0c30 \u0c2b\u0c4d\u0c30\u0c3f\u0c38\u0c3f\u0c2f\u0c28\u0c4d" },
            { "is", "\u0c10\u0c38\u0c4d\u0c32\u0c3e\u0c02\u0c21\u0c3f\u0c15\u0c4d" },
            { "it", "\u0c07\u0c1f\u0c3e\u0c32\u0c3f\u0c2f\u0c28\u0c4d" },
            { "iu", "\u0c07\u0c28\u0c41\u0c15\u0c4d\u0c1f\u0c3f\u0c1f\u0c41\u0c1f\u0c4d" },
            { "Mlym", metaValue_ml },
            { "ja", "\u0c1c\u0c2a\u0c28\u0c40\u0c38\u0c4d" },
            { "Sara", "\u0c38\u0c30\u0c3e\u0c1f\u0c3f" },
            { "doi", "\u0c21\u0c4b\u0c17\u0c4d\u0c30\u0c3f" },
            { "sma", "\u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c38\u0c3e\u0c2e\u0c3f" },
            { "jv", metaValue_jv },
            { "Shaw", "\u0c37\u0c35\u0c3f\u0c2f\u0c3e\u0c28\u0c4d" },
            { "mad", "\u0c2e\u0c3e\u0c26\u0c41\u0c30\u0c40\u0c38\u0c4d" },
            { "smj", "\u0c32\u0c41\u0c32\u0c47 \u0c38\u0c3e\u0c2e\u0c3f" },
            { "mag", "\u0c2e\u0c17\u0c3e\u0c39\u0c3f" },
            { "mai", "\u0c2e\u0c48\u0c25\u0c3f\u0c32\u0c3f" },
            { "smn", "\u0c07\u0c28\u0c3e\u0c30\u0c3f \u0c38\u0c3e\u0c2e\u0c3f" },
            { "ka", metaValue_ka },
            { "bla", "\u0c38\u0c3f\u0c15\u0c4d\u0c38\u0c3f\u0c15\u0c3e" },
            { "mak", "\u0c2e\u0c15\u0c3e\u0c38\u0c3e\u0c30\u0c4d" },
            { "wuu", "\u0c35\u0c41 \u0c1a\u0c48\u0c28\u0c40\u0c38\u0c4d" },
            { "sms", "\u0c38\u0c4d\u0c15\u0c4b\u0c32\u0c4d\u0c1f\u0c4d \u0c38\u0c3e\u0c2e\u0c3f" },
            { "man", "\u0c2e\u0c02\u0c21\u0c3f\u0c02\u0c17\u0c4b" },
            { "kg", "\u0c15\u0c4b\u0c02\u0c17\u0c4b" },
            { "Goth", "\u0c17\u0c4b\u0c24\u0c3f\u0c15\u0c4d" },
            { "ki", "\u0c15\u0c3f\u0c15\u0c41\u0c2f\u0c41" },
            { "mas", "\u0c2e\u0c3e\u0c38\u0c48" },
            { "kj", "\u0c15\u0c4d\u0c35\u0c3e\u0c28\u0c4d\u0c2f\u0c3e\u0c2e" },
            { "kk", "\u0c15\u0c1c\u0c16\u0c4d" },
            { "kl", "\u0c15\u0c32\u0c3e\u0c32\u0c4d\u0c32\u0c3f\u0c38\u0c42\u0c1f\u0c4d" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u0c15\u0c3e\u0c28\u0c41\u0c30\u0c3f" },
            { "ks", "\u0c15\u0c3e\u0c36\u0c4d\u0c2e\u0c40\u0c30\u0c3f" },
            { "Cirt", "\u0c38\u0c3f\u0c30\u0c4d\u0c25\u0c4d" },
            { "Lepc", "\u0c32\u0c47\u0c2a\u0c4d\u0c1a\u0c3e" },
            { "Avst", metaValue_ae },
            { "ku", "\u0c15\u0c41\u0c30\u0c4d\u0c26\u0c3f\u0c37\u0c4d" },
            { "kv", "\u0c15\u0c4b\u0c2e\u0c3f" },
            { "kw", "\u0c15\u0c4b\u0c30\u0c4d\u0c28\u0c3f\u0c37\u0c4d" },
            { "ky", "\u0c15\u0c3f\u0c30\u0c4d\u0c17\u0c3f\u0c1c\u0c4d" },
            { "snk", "\u0c38\u0c4b\u0c28\u0c3f\u0c02\u0c15\u0c3f" },
            { "la", metaValue_la },
            { "lb", "\u0c32\u0c15\u0c4d\u0c38\u0c46\u0c02\u0c2c\u0c30\u0c4d\u0c17\u0c3f\u0c37\u0c4d" },
            { "type.nu.mlym", "\u0c2e\u0c32\u0c2f\u0c3e\u0c33\u0c02 \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "lg", "\u0c17\u0c3e\u0c02\u0c21\u0c3e" },
            { "Roro", "\u0c30\u0c4b\u0c02\u0c17\u0c4b \u0c30\u0c4b\u0c02\u0c17\u0c4b" },
            { "li", "\u0c32\u0c3f\u0c2e\u0c4d\u0c2c\u0c30\u0c4d\u0c17\u0c3f\u0c37\u0c4d" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0c32\u0c3f\u0c02\u0c17\u0c3e\u0c32" },
            { "fur", "\u0c2b\u0c4d\u0c30\u0c3f\u0c2f\u0c41\u0c32\u0c3f\u0c2f\u0c28\u0c4d" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u0c07\u0c02\u0c2a\u0c40\u0c30\u0c3f\u0c2f\u0c32\u0c4d \u0c15\u0c4a\u0c32\u0c2e\u0c3e\u0c28 \u0c2a\u0c26\u0c4d\u0c27\u0c24\u0c3f" },
            { "lt", "\u0c32\u0c3f\u0c25\u0c41\u0c35\u0c47\u0c28\u0c3f\u0c2f\u0c28\u0c4d" },
            { "lu", "\u0c32\u0c42\u0c2c-\u0c15\u0c1f\u0c3e\u0c02\u0c17" },
            { "lv", "\u0c32\u0c3e\u0c1f\u0c4d\u0c35\u0c3f\u0c2f\u0c28\u0c4d" },
            { "sog", "\u0c38\u0c4b\u0c17\u0c4d\u0c21\u0c3f\u0c2f\u0c28\u0c4d" },
            { "mg", "\u0c2e\u0c32\u0c17\u0c3e\u0c38\u0c3f" },
            { "mh", "\u0c2e\u0c3e\u0c30\u0c4d\u0c37\u0c32\u0c40\u0c38\u0c4d" },
            { "type.co.ducet", "\u0c21\u0c3f\u0c2b\u0c3e\u0c32\u0c4d\u0c1f\u0c4d \u0c2f\u0c42\u0c28\u0c40\u0c15\u0c4b\u0c21\u0c4d \u0c15\u0c4d\u0c30\u0c2e\u0c2c\u0c26\u0c4d\u0c27\u0c40\u0c15\u0c30\u0c23 \u0c15\u0c4d\u0c30\u0c2e\u0c02" },
            { "mi", "\u0c2e\u0c3e\u0c35\u0c4a\u0c30\u0c40" },
            { "mk", "\u0c2e\u0c3e\u0c38\u0c3f\u0c21\u0c4b\u0c28\u0c3f\u0c2f\u0c28\u0c4d" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "\u0c2e\u0c30\u0c3e\u0c20\u0c40" },
            { "ms", "\u0c2e\u0c32\u0c2f\u0c4d" },
            { "mt", "\u0c2e\u0c3e\u0c32\u0c4d\u0c1f\u0c40\u0c38\u0c4d" },
            { "my", "\u0c2c\u0c30\u0c4d\u0c2e\u0c40\u0c38\u0c4d" },
            { "Saur", "\u0c38\u0c4c\u0c30\u0c3e\u0c37\u0c4d\u0c1f\u0c4d\u0c30" },
            { "Armn", "\u0c05\u0c30\u0c4d\u0c2e\u0c47\u0c28\u0c3f\u0c2f\u0c28\u0c4d" },
            { "mdf", "\u0c2e\u0c4b\u0c15\u0c4d\u0c37" },
            { "dsb", "\u0c32\u0c4b\u0c2f\u0c30\u0c4d \u0c38\u0c4b\u0c30\u0c4d\u0c2c\u0c3f\u0c2f\u0c28\u0c4d" },
            { "Armi", "\u0c07\u0c02\u0c2a\u0c40\u0c30\u0c3f\u0c2f\u0c32\u0c4d \u0c05\u0c30\u0c3e\u0c2e\u0c3e\u0c15\u0c4d" },
            { "na", metaValue_NR },
            { "type.co.search", "\u0c38\u0c3e\u0c27\u0c3e\u0c30\u0c23-\u0c2a\u0c4d\u0c30\u0c2f\u0c4b\u0c1c\u0c28 \u0c36\u0c4b\u0c27\u0c28" },
            { "nb", "\u0c28\u0c3e\u0c30\u0c4d\u0c35\u0c47\u0c1c\u0c3f\u0c2f\u0c28\u0c4d \u0c2c\u0c4a\u0c15\u0c4d\u0c2e\u0c3e\u0c32\u0c4d" },
            { "nd", "\u0c09\u0c24\u0c4d\u0c24\u0c30 \u0c26\u0c46\u0c2c\u0c46\u0c32\u0c46" },
            { "ne", "\u0c28\u0c47\u0c2a\u0c3e\u0c32\u0c3f" },
            { "ng", "\u0c21\u0c4b\u0c02\u0c17\u0c3e" },
            { "mdr", "\u0c2e\u0c02\u0c21\u0c3e\u0c30\u0c4d" },
            { "nl", "\u0c21\u0c1a\u0c4d" },
            { "nn", "\u0c28\u0c3e\u0c30\u0c4d\u0c35\u0c47\u0c1c\u0c3f\u0c2f\u0c3e\u0c28\u0c4d \u0c28\u0c4d\u0c2f\u0c4b\u0c30\u0c4d\u0c38\u0c4d\u0c15\u0c4d" },
            { "no", "\u0c28\u0c3e\u0c30\u0c4d\u0c35\u0c47\u0c1c\u0c3f\u0c2f\u0c28\u0c4d" },
            { "nr", "\u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c26\u0c46\u0c2c\u0c46\u0c32\u0c46" },
            { "nv", "\u0c28\u0c35\u0c3e\u0c1c\u0c4a" },
            { "kaa", "\u0c15\u0c3e\u0c30\u0c3e-\u0c15\u0c32\u0c4d\u0c2a\u0c3e\u0c15\u0c4d" },
            { "ny", "\u0c28\u0c4d\u0c2f\u0c3e\u0c28\u0c4d\u0c1c\u0c3e" },
            { "kac", "\u0c15\u0c3e\u0c1a\u0c3f\u0c28\u0c4d" },
            { "kab", "\u0c15\u0c3e\u0c2c\u0c3f\u0c32\u0c4d" },
            { "oc", "\u0c06\u0c15\u0c4d\u0c38\u0c3f\u0c1f\u0c28\u0c4d" },
            { "kaj", "\u0c1c\u0c4d\u0c2f\u0c42" },
            { "kam", "\u0c15\u0c02\u0c2c\u0c3e" },
            { "men", "\u0c2e\u0c46\u0c02\u0c21\u0c47" },
            { "oj", "\u0c1a\u0c47\u0c35\u0c3e" },
            { "mer", "\u0c2e\u0c46\u0c30\u0c41" },
            { "type.nu.armn", "\u0c06\u0c30\u0c4d\u0c2e\u0c47\u0c28\u0c3f\u0c2f\u0c28\u0c4d \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "om", "\u0c12\u0c30\u0c4b\u0c2e\u0c4b" },
            { "kaw", "\u0c15\u0c3e\u0c35\u0c3f" },
            { "or", metaValue_or },
            { "os", "\u0c12\u0c38\u0c47\u0c1f\u0c3f\u0c15\u0c4d" },
            { "bpy", "\u0c2c\u0c3f\u0c37\u0c4d\u0c23\u0c41\u0c2a\u0c4d\u0c30\u0c3f\u0c2f" },
            { "kbd", "\u0c15\u0c2c\u0c3e\u0c30\u0c4d\u0c21\u0c3f\u0c2f\u0c28\u0c4d" },
            { "mfe", "\u0c2e\u0c4a\u0c30\u0c3f\u0c38\u0c4d\u0c2f\u0c47\u0c28\u0c4d" },
            { "srn", "\u0c38\u0c4d\u0c30\u0c3e\u0c28\u0c28\u0c4d \u0c1f\u0c4b\u0c02\u0c17\u0c4b" },
            { "pa", "\u0c2a\u0c02\u0c1c\u0c3e\u0c2c\u0c40" },
            { "dua", "\u0c21\u0c4d\u0c2f\u0c42\u0c32\u0c3e" },
            { "srr", "\u0c38\u0c46\u0c30\u0c47\u0c30\u0c4d" },
            { "pi", "\u0c2a\u0c3e\u0c32\u0c40" },
            { "pl", "\u0c2a\u0c4b\u0c32\u0c3f\u0c37\u0c4d" },
            { "dum", "\u0c2e\u0c27\u0c4d\u0c2f\u0c2e \u0c21\u0c1a\u0c4d" },
            { "type.ca.dangi", "\u0c26\u0c3e\u0c02\u0c17\u0c40 \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "ps", "\u0c2a\u0c3e\u0c37\u0c4d\u0c1f\u0c4b" },
            { "pt", "\u0c2a\u0c4b\u0c30\u0c4d\u0c1a\u0c41\u0c17\u0c40\u0c38\u0c4d" },
            { "mga", "\u0c2e\u0c27\u0c4d\u0c2f\u0c2e \u0c10\u0c30\u0c3f\u0c37\u0c4d" },
            { "key.co", "\u0c15\u0c4d\u0c30\u0c2e\u0c2c\u0c26\u0c4d\u0c27\u0c40\u0c15\u0c30\u0c23 \u0c15\u0c4d\u0c30\u0c2e\u0c02" },
            { "pt_BR", "\u0c2c\u0c4d\u0c30\u0c46\u0c1c\u0c40\u0c32\u0c3f\u0c2f\u0c28\u0c4d \u0c2a\u0c4b\u0c30\u0c4d\u0c1a\u0c41\u0c17\u0c40\u0c38\u0c4d" },
            { "kcg", "\u0c1f\u0c4d\u0c2f\u0c3e\u0c2a\u0c4d" },
            { "mgh", "\u0c2e\u0c15\u0c4d\u0c35\u0c3e-\u0c2e\u0c3f\u0c1f\u0c4d\u0c1f\u0c4b" },
            { "key.cf", "\u0c15\u0c30\u0c46\u0c28\u0c4d\u0c38\u0c40 \u0c2b\u0c3e\u0c30\u0c4d\u0c2e\u0c3e\u0c1f\u0c4d" },
            { "bra", "\u0c2c\u0c4d\u0c30\u0c3e\u0c1c\u0c4d" },
            { "key.ca", "\u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u0c2e\u0c46\u0c1f\u0c3e" },
            { "type.hc.h23", "24 \u0c17\u0c02\u0c1f\u0c32 \u0c2a\u0c26\u0c4d\u0c27\u0c24\u0c3f (0\u201323)" },
            { "type.hc.h24", "24 \u0c17\u0c02\u0c1f\u0c32 \u0c2a\u0c26\u0c4d\u0c27\u0c24\u0c3f (1\u201324)" },
            { "ssy", "\u0c38\u0c3e\u0c39\u0c4b" },
            { "type.nu.mymr", "\u0c2e\u0c2f\u0c28\u0c4d\u0c2e\u0c3e\u0c30\u0c4d \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "qu", "\u0c15\u0c46\u0c1a\u0c41\u0c35\u0c3e" },
            { "zap", "\u0c1c\u0c2a\u0c4b\u0c1f\u0c46\u0c15\u0c4d" },
            { "brx", "\u0c2c\u0c4b\u0c21\u0c4b" },
            { "Lana", "\u0c32\u0c28\u0c4d\u0c28\u0c3e" },
            { "kde", "\u0c2e\u0c15\u0c4a\u0c02\u0c21\u0c47" },
            { "Ethi", "\u0c07\u0c25\u0c3f\u0c2f\u0c4b\u0c2a\u0c3f\u0c15\u0c4d" },
            { "type.hc.h12", "12 \u0c17\u0c02\u0c1f\u0c32 \u0c2a\u0c26\u0c4d\u0c27\u0c24\u0c3f (1\u201312)" },
            { "type.hc.h11", "12 \u0c17\u0c02\u0c1f\u0c32 \u0c2a\u0c26\u0c4d\u0c27\u0c24\u0c3f (0\u201311)" },
            { "rm", "\u0c30\u0c4b\u0c2e\u0c28\u0c4d\u0c37\u0c4d" },
            { "rn", "\u0c30\u0c41\u0c02\u0c21\u0c3f" },
            { "key.cu", "\u0c15\u0c30\u0c46\u0c28\u0c4d\u0c38\u0c40" },
            { "ro", "\u0c30\u0c4b\u0c2e\u0c47\u0c28\u0c3f\u0c2f\u0c28\u0c4d" },
            { "type.nu.orya", "\u0c12\u0c30\u0c3f\u0c2f\u0c3e \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "type.nu.hanidec", "\u0c1a\u0c48\u0c28\u0c40\u0c2f\u0c41\u0c32 \u0c26\u0c36\u0c3e\u0c02\u0c36 \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "ru", "\u0c30\u0c37\u0c4d\u0c2f\u0c28\u0c4d" },
            { "rw", "\u0c15\u0c3f\u0c28\u0c4d\u0c2f\u0c30\u0c4d\u0c35\u0c3e\u0c02\u0c21\u0c3e" },
            { "zbl", "\u0c2c\u0c4d\u0c32\u0c3f\u0c38\u0c3f\u0c02\u0c2c\u0c32\u0c4d\u0c38\u0c4d" },
            { "kea", "\u0c15\u0c3e\u0c2c\u0c41\u0c35\u0c47\u0c30\u0c4d\u0c26\u0c3f\u0c2f\u0c28\u0c41" },
            { "mic", "\u0c2e\u0c3f\u0c15\u0c2e\u0c3e\u0c15\u0c4d" },
            { "suk", "\u0c38\u0c41\u0c15\u0c41\u0c2e\u0c3e" },
            { "en_AU", "\u0c06\u0c38\u0c4d\u0c1f\u0c4d\u0c30\u0c47\u0c32\u0c3f\u0c2f\u0c28\u0c4d \u0c07\u0c02\u0c17\u0c4d\u0c32\u0c40\u0c37\u0c4d" },
            { "sa", "\u0c38\u0c02\u0c38\u0c4d\u0c15\u0c43\u0c24\u0c02" },
            { "sc", "\u0c38\u0c3e\u0c30\u0c4d\u0c21\u0c40\u0c28\u0c3f\u0c2f\u0c28\u0c4d" },
            { "sus", "\u0c38\u0c41\u0c38\u0c41" },
            { "sd", "\u0c38\u0c3f\u0c02\u0c27\u0c40" },
            { "se", "\u0c09\u0c24\u0c4d\u0c24\u0c30 \u0c38\u0c3e\u0c2e\u0c3f" },
            { "min", "\u0c2e\u0c3f\u0c28\u0c3e\u0c02\u0c17\u0c4d\u200c\u0c15\u0c3e\u0c2c\u0c4b" },
            { "sg", "\u0c38\u0c3e\u0c02\u0c17\u0c4b" },
            { "sh", "\u0c38\u0c47\u0c30\u0c4d\u0c2c\u0c4b-\u0c15\u0c4d\u0c30\u0c4a\u0c2f\u0c47\u0c37\u0c3f\u0c2f\u0c28\u0c4d" },
            { "si", metaValue_si },
            { "sux", "\u0c38\u0c41\u0c2e\u0c47\u0c30\u0c3f\u0c2f\u0c3e\u0c28\u0c4d" },
            { "sk", "\u0c38\u0c4d\u0c32\u0c4b\u0c35\u0c15\u0c4d" },
            { "sl", "\u0c38\u0c4d\u0c32\u0c4b\u0c35\u0c47\u0c28\u0c3f\u0c2f\u0c28\u0c4d" },
            { "sm", "\u0c38\u0c2e\u0c4b\u0c35\u0c28\u0c4d" },
            { "sn", "\u0c37\u0c4b\u0c28" },
            { "so", "\u0c38\u0c4b\u0c2e\u0c3e\u0c32\u0c3f" },
            { "type.nu.arab", "\u0c05\u0c30\u0c2c\u0c3f\u0c15\u0c4d-\u0c07\u0c02\u0c21\u0c3f\u0c15\u0c4d \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "sq", "\u0c05\u0c32\u0c4d\u0c2c\u0c47\u0c28\u0c3f\u0c2f\u0c28\u0c4d" },
            { "sr", "\u0c38\u0c46\u0c30\u0c4d\u0c2c\u0c3f\u0c2f\u0c28\u0c4d" },
            { "ss", "\u0c38\u0c4d\u0c35\u0c3e\u0c24\u0c3f" },
            { "type.cf.account", "\u0c05\u0c15\u0c4c\u0c02\u0c1f\u0c3f\u0c02\u0c17\u0c4d \u0c15\u0c30\u0c46\u0c28\u0c4d\u0c38\u0c40 \u0c2b\u0c3e\u0c30\u0c4d\u0c2e\u0c3e\u0c1f\u0c4d" },
            { "Java", metaValue_jv },
            { "st", "\u0c26\u0c15\u0c4d\u0c37\u0c3f\u0c23 \u0c38\u0c4b\u0c24\u0c4b" },
            { "su", "\u0c38\u0c02\u0c21\u0c3e\u0c28\u0c40\u0c38\u0c4d" },
            { "sv", "\u0c38\u0c4d\u0c35\u0c40\u0c21\u0c3f\u0c37\u0c4d" },
            { "sw", "\u0c38\u0c4d\u0c35\u0c3e\u0c39\u0c3f\u0c32\u0c3f" },
            { "type.nu.hantfin", "\u0c38\u0c3e\u0c02\u0c2a\u0c4d\u0c30\u0c26\u0c3e\u0c2f \u0c1a\u0c48\u0c28\u0c40\u0c2f\u0c41\u0c32 \u0c06\u0c30\u0c4d\u0c25\u0c3f\u0c15 \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "ibb", "\u0c07\u0c2c\u0c3f\u0c2c\u0c3f\u0c2f\u0c4b" },
            { "iba", "\u0c10\u0c2c\u0c3e\u0c28\u0c4d" },
            { "ta", metaValue_ta },
            { "142", "\u0c06\u0c38\u0c3f\u0c2f\u0c3e" },
            { "bua", "\u0c2c\u0c41\u0c30\u0c3f\u0c2f\u0c1f\u0c4d" },
            { "143", "\u0c2e\u0c27\u0c4d\u0c2f \u0c06\u0c38\u0c3f\u0c2f\u0c3e" },
            { "te", metaValue_te },
            { "145", "\u0c2a\u0c36\u0c4d\u0c1a\u0c3f\u0c2e \u0c06\u0c38\u0c3f\u0c2f\u0c3e" },
            { "tg", "\u0c24\u0c1c\u0c3f\u0c15\u0c4d" },
            { "th", metaValue_th },
            { "ti", "\u0c1f\u0c3f\u0c17\u0c4d\u0c30\u0c3f\u0c28\u0c4d\u0c2f\u0c3e" },
            { "bug", "\u0c2c\u0c41\u0c17\u0c3f\u0c28\u0c40\u0c38\u0c4d" },
            { "kfo", "\u0c15\u0c4b\u0c30\u0c4b" },
            { "en_CA", "\u0c15\u0c46\u0c28\u0c21\u0c3f\u0c2f\u0c28\u0c4d \u0c07\u0c02\u0c17\u0c4d\u0c32\u0c40\u0c37\u0c4d" },
            { "tk", "\u0c24\u0c41\u0c30\u0c4d\u0c15\u0c4d\u200c\u0c2e\u0c46\u0c28\u0c4d" },
            { "tl", metaValue_tl },
            { "tn", "\u0c38\u0c4d\u0c35\u0c3e\u0c28\u0c3e" },
            { "to", "\u0c1f\u0c3e\u0c02\u0c17\u0c3e\u0c28\u0c4d" },
            { "dyo", "\u0c1c\u0c4b\u0c32\u0c3e-\u0c2b\u0c4b\u0c28\u0c2f\u0c3f" },
            { "type.nu.jpan", "\u0c1c\u0c2a\u0c3e\u0c28\u0c40\u0c2f\u0c41\u0c32 \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "tr", "\u0c1f\u0c30\u0c4d\u0c15\u0c3f\u0c37\u0c4d" },
            { "Cakm", metaValue_ccp },
            { "ts", "\u0c38\u0c4b\u0c02\u0c17\u0c3e" },
            { "swb", "\u0c15\u0c4a\u0c2e\u0c4a\u0c30\u0c3f\u0c2f\u0c28\u0c4d" },
            { "tt", "\u0c1f\u0c3e\u0c1f\u0c30\u0c4d" },
            { "dyu", "\u0c21\u0c4d\u0c2f\u0c41\u0c32\u0c3e" },
            { "tw", "\u0c1f\u0c4d\u0c35\u0c3f" },
            { "ty", "\u0c24\u0c39\u0c3f\u0c24\u0c3f\u0c2f\u0c28\u0c4d" },
            { "150", "\u0c2f\u0c42\u0c30\u0c4b\u0c2a\u0c4d" },
            { "151", "\u0c24\u0c42\u0c30\u0c4d\u0c2a\u0c41 \u0c2f\u0c42\u0c30\u0c4b\u0c2a\u0c4d" },
            { "154", "\u0c09\u0c24\u0c4d\u0c24\u0c30 \u0c2f\u0c42\u0c30\u0c4b\u0c2a\u0c4d" },
            { "dzg", "\u0c21\u0c3e\u0c1c\u0c3e\u0c17\u0c3e" },
            { "155", "\u0c2a\u0c36\u0c4d\u0c1a\u0c3f\u0c2e \u0c2f\u0c42\u0c30\u0c4b\u0c2a\u0c4d" },
            { "ug", "\u0c09\u0c2f\u0c4d\u200c\u0c18\u0c30\u0c4d" },
            { "Kore", metaValue_ko },
            { "Ital", "\u0c2a\u0c4d\u0c30\u0c3e\u0c1a\u0c3f\u0c28 \u0c10\u0c1f\u0c3e\u0c32\u0c3f\u0c15\u0c4d" },
            { "Zyyy", "\u0c38\u0c3e\u0c2e\u0c3e\u0c28\u0c4d\u0c2f" },
            { "uk", "\u0c09\u0c15\u0c4d\u0c30\u0c46\u0c2f\u0c3f\u0c28\u0c3f\u0c2f\u0c28\u0c4d" },
            { "type.ca.coptic", "\u0c15\u0c3e\u0c2a\u0c4d\u0c1f\u0c3f\u0c15\u0c4d \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "ur", "\u0c09\u0c30\u0c4d\u0c26\u0c42" },
            { "xal", "\u0c15\u0c32\u0c4d\u0c2e\u0c3f\u0c15\u0c4d" },
            { "zen", "\u0c1c\u0c46\u0c28\u0c3e\u0c17\u0c3e" },
            { "uz", "\u0c09\u0c1c\u0c4d\u0c2c\u0c46\u0c15\u0c4d" },
            { "kha", "\u0c16\u0c3e\u0c38\u0c3f" },
            { "%%1996", "1996 \u0c19\u0c30\u0c4d\u0c2e\u0c28 \u0c35\u0c30\u0c4d\u0c23\u0c15\u0c4d\u0c30\u0c2e\u0c02" },
            { "nds_NL", "\u0c32\u0c4b \u0c38\u0c3e\u0c15\u0c4d\u0c38\u0c28\u0c4d" },
            { "Sylo", "\u0c38\u0c4d\u0c32\u0c4b\u0c1f\u0c3f \u0c28\u0c3e\u0c17\u0c4d\u0c30\u0c3f" },
            { "ve", "\u0c35\u0c46\u0c02\u0c21\u0c3e" },
            { "type.ca.roc", "\u0c2e\u0c3f\u0c02\u0c17\u0c4d\u0c2f\u0c42 \u0c15\u0c4d\u0c2f\u0c3e\u0c32\u0c46\u0c02\u0c21\u0c30\u0c4d" },
            { "vi", "\u0c35\u0c3f\u0c2f\u0c24\u0c4d\u0c28\u0c3e\u0c2e\u0c40\u0c38\u0c4d" },
            { "kho", "\u0c16\u0c4b\u0c1f\u0c28\u0c40\u0c38\u0c4d" },
            { "khq", "\u0c15\u0c4a\u0c2f\u0c30\u0c3e \u0c1a\u0c40\u0c28\u0c4d\u0c28\u0c40" },
            { "key.hc", "\u0c17\u0c02\u0c1f\u0c32 \u0c2a\u0c26\u0c4d\u0c27\u0c24\u0c3f (12 \u0c35\u0c30\u0c4d\u0c38\u0c46\u0c38\u0c4d 24)" },
            { "vo", "\u0c35\u0c4b\u0c32\u0c3e\u0c2a\u0c41\u0c15\u0c4d" },
            { "syc", "\u0c38\u0c3e\u0c02\u0c2a\u0c4d\u0c30\u0c26\u0c3e\u0c2f \u0c38\u0c3f\u0c30\u0c3f\u0c2f\u0c3e\u0c15\u0c4d" },
            { "Osma", "\u0c13\u0c38\u0c2e\u0c3e\u0c28\u0c4d\u0c2f" },
            { "quc", "\u0c15\u0c3f\u0c1a\u0c47" },
            { "gaa", "\u0c17\u0c3e" },
            { "wa", "\u0c35\u0c3e\u0c32\u0c42\u0c28\u0c4d" },
            { "gag", "\u0c17\u0c3e\u0c17\u0c4c\u0c1c\u0c4d" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "\u0c17\u0c3e\u0c28\u0c4d \u0c1a\u0c48\u0c28\u0c40\u0c38\u0c4d" },
            { "Lydi", "\u0c32\u0c3f\u0c21\u0c3f\u0c2f\u0c28\u0c4d" },
            { "Xsux", "\u0c38\u0c41\u0c2e\u0c47\u0c30\u0c4b- \u0c05\u0c15\u0c4d\u0c15\u0c21\u0c3f\u0c2f\u0c28\u0c4d \u0c15\u0c4d\u0c2f\u0c41\u0c28\u0c3f\u0c2b\u0c3e\u0c30\u0c4d\u0c2e\u0c4d" },
            { "wo", "\u0c09\u0c32\u0c42\u0c2b\u0c4d" },
            { "zgh", "\u0c2a\u0c4d\u0c30\u0c3e\u0c2e\u0c3e\u0c23\u0c3f\u0c15 \u0c2e\u0c4a\u0c30\u0c4a\u0c15\u0c28\u0c4d \u0c1f\u0c3e\u0c2e\u0c1c\u0c48\u0c1f\u0c4d" },
            { "ar_001", "\u0c06\u0c27\u0c41\u0c28\u0c3f\u0c15 \u0c2a\u0c4d\u0c30\u0c3e\u0c2e\u0c3e\u0c23\u0c3f\u0c15 \u0c05\u0c30\u0c2c\u0c3f\u0c15\u0c4d" },
            { "Cans", "\u0c2f\u0c41\u0c28\u0c3f\u0c2b\u0c48\u0c21\u0c4d \u0c15\u0c46\u0c28\u0c46\u0c21\u0c3f\u0c2f\u0c28\u0c4d \u0c05\u0c2c\u0c4a\u0c30\u0c3f\u0c1c\u0c3f\u0c28\u0c32\u0c4d \u0c38\u0c3f\u0c32\u0c2c\u0c3f\u0c15\u0c4d\u0c38\u0c4d" },
            { "gay", "\u0c17\u0c3e\u0c2f\u0c4b" },
            { "Mong", metaValue_mn },
            { "mnc", "\u0c2e\u0c02\u0c1a\u0c41" },
            { "Latf", "\u0c2b\u0c4d\u0c30\u0c3e\u0c15\u0c4d\u0c1f\u0c42\u0c30\u0c4d \u0c32\u0c3e\u0c1f\u0c3f\u0c28\u0c4d" },
            { "gba", "\u0c17\u0c4d\u0c2c\u0c3e\u0c2f\u0c3e" },
            { "mni", "\u0c2e\u0c23\u0c3f\u0c2a\u0c41\u0c30\u0c3f" },
            { "Latn", metaValue_la },
            { "Latg", "\u0c17\u0c47\u0c32\u0c3f\u0c15\u0c4d \u0c32\u0c3e\u0c1f\u0c3f\u0c28\u0c4d" },
            { "type.nu.hans", "\u0c38\u0c30\u0c33\u0c40\u0c15\u0c43\u0c24 \u0c1a\u0c48\u0c28\u0c40\u0c2f\u0c41\u0c32 \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "type.nu.hant", "\u0c38\u0c3e\u0c02\u0c2a\u0c4d\u0c30\u0c26\u0c3e\u0c2f \u0c1a\u0c48\u0c28\u0c40\u0c2f\u0c41\u0c32 \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "xh", "\u0c37\u0c4b\u0c38\u0c3e" },
            { "type.nu.romanlow", "\u0c30\u0c4b\u0c2e\u0c28\u0c4d \u0c1a\u0c3f\u0c28\u0c4d\u0c28\u0c2c\u0c21\u0c3f \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "byn", "\u0c2c\u0c4d\u0c32\u0c3f\u0c28\u0c4d" },
            { "Lyci", "\u0c32\u0c3f\u0c38\u0c3f\u0c2f\u0c28\u0c4d" },
            { "osa", "\u0c12\u0c38\u0c3e\u0c1c\u0c4d" },
            { "Moon", "\u0c2e\u0c42\u0c28\u0c4d" },
            { "moh", "\u0c2e\u0c4b\u0c39\u0c3e\u0c15\u0c4d" },
            { "kkj", "\u0c15\u0c3e\u0c15\u0c4b" },
            { "Syrc", metaValue_syr },
            { "yi", "\u0c07\u0c21\u0c4d\u0c21\u0c3f\u0c37\u0c4d" },
            { "mos", "\u0c2e\u0c4b\u0c38\u0c4d\u0c38\u0c3f" },
            { "Dsrt", "\u0c21\u0c47\u0c38\u0c46\u0c30\u0c46\u0c1f\u0c4d" },
            { "yo", "\u0c2f\u0c4b\u0c30\u0c41\u0c2c\u0c3e" },
            { "type.nu.traditional", "\u0c38\u0c3e\u0c02\u0c2a\u0c4d\u0c30\u0c26\u0c3e\u0c2f \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "es_MX", "\u0c2e\u0c46\u0c15\u0c4d\u0c38\u0c3f\u0c15\u0c28\u0c4d \u0c38\u0c4d\u0c2a\u0c3e\u0c28\u0c3f\u0c37\u0c4d" },
            { "Syrj", "\u0c2a\u0c36\u0c4d\u0c1a\u0c3f\u0c2e \u0c38\u0c3f\u0c30\u0c3f\u0c2f\u0c3e\u0c15\u0c4d" },
            { "ota", "\u0c12\u0c1f\u0c4d\u0c1f\u0c4b\u0c2e\u0c28\u0c4d \u0c1f\u0c30\u0c4d\u0c15\u0c3f\u0c37\u0c4d" },
            { "Syre", "\u0c0e\u0c38\u0c4d\u0c1f\u0c4d\u0c30\u0c3e\u0c28\u0c1c\u0c40\u0c32\u0c4b \u0c38\u0c3f\u0c30\u0c3f\u0c2f\u0c3e\u0c15\u0c4d" },
            { "vai", metaValue_vai },
            { "za", "\u0c1c\u0c41\u0c35\u0c3e\u0c28\u0c4d" },
            { "Cari", "\u0c15\u0c3e\u0c30\u0c3f\u0c2f\u0c28\u0c4d" },
            { "kln", "\u0c15\u0c32\u0c46\u0c02\u0c1c\u0c3f\u0c28\u0c4d" },
            { "zh", "\u0c1a\u0c48\u0c28\u0c40\u0c38\u0c4d" },
            { "Bopo", "\u0c2c\u0c4b\u0c2a\u0c4b\u0c2e\u0c4b\u0c2b\u0c4b" },
            { "Perm", "\u0c2a\u0c4d\u0c30\u0c3e\u0c1a\u0c40\u0c28 \u0c2a\u0c46\u0c30\u0c4d\u0c2e\u0c3f\u0c15\u0c4d" },
            { "key.lb", "\u0c32\u0c48\u0c28\u0c4d \u0c2c\u0c4d\u0c30\u0c47\u0c15\u0c4d \u0c36\u0c48\u0c32\u0c3f" },
            { "zu", "\u0c1c\u0c42\u0c32\u0c42" },
            { "type.co.phonebook", "\u0c2b\u0c4b\u0c28\u0c4d\u200c\u0c2c\u0c41\u0c15\u0c4d \u0c15\u0c4d\u0c30\u0c2e\u0c2c\u0c26\u0c4d\u0c27\u0c40\u0c15\u0c30\u0c23 \u0c15\u0c4d\u0c30\u0c2e\u0c02" },
            { "Geor", metaValue_ka },
            { "kmb", "\u0c15\u0c3f\u0c2e\u0c4d\u0c2c\u0c41\u0c02\u0c21\u0c41" },
            { "type.nu.jpanfin", "\u0c1c\u0c2a\u0c3e\u0c28\u0c40\u0c2f\u0c32\u0c41 \u0c06\u0c30\u0c4d\u0c25\u0c3f\u0c15 \u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "Cham", "\u0c1a\u0c3e\u0c2e\u0c4d" },
            { "gez", "\u0c1c\u0c40\u0c1c\u0c4d" },
            { "Syrn", "\u0c24\u0c42\u0c30\u0c4d\u0c2a\u0c41 \u0c38\u0c3f\u0c30\u0c3f\u0c2f\u0c3e\u0c15\u0c4d" },
            { "type.co.reformed", "\u0c2e\u0c33\u0c4d\u0c33\u0c40 \u0c06\u0c15\u0c43\u0c24\u0c40\u0c15\u0c30\u0c3f\u0c02\u0c1a\u0c2c\u0c21\u0c3f\u0c28 \u0c15\u0c4d\u0c30\u0c2e\u0c2c\u0c26\u0c4d\u0c27\u0c40\u0c15\u0c30\u0c23 \u0c15\u0c4d\u0c30\u0c2e\u0c02" },
            { "Tglg", metaValue_tl },
            { "Egyd", "\u0c07\u0c1c\u0c3f\u0c2a\u0c4d\u0c37\u0c3f\u0c2f\u0c28\u0c4d \u0c21\u0c46\u0c2e\u0c4b\u0c1f\u0c3f\u0c15\u0c4d" },
            { "Egyh", "\u0c07\u0c1c\u0c3f\u0c2a\u0c4d\u0c37\u0c3f\u0c2f\u0c28\u0c4d \u0c39\u0c48\u0c30\u0c3e\u0c1f\u0c3f\u0c15\u0c4d" },
            { "ebu", "\u0c07\u0c02\u0c2c\u0c41" },
            { "Egyp", "\u0c07\u0c1c\u0c3f\u0c2a\u0c4d\u0c37\u0c3f\u0c2f\u0c28\u0c4d \u0c39\u0c48\u0c30\u0c4b\u0c17\u0c4d\u0c32\u0c48\u0c2b\u0c4d\u0c38\u0c4d" },
            { "Geok", "\u0c1c\u0c3e\u0c30\u0c4d\u0c1c\u0c3f\u0c2f\u0c28\u0c4d \u0c16\u0c1f\u0c4d\u0c38\u0c42\u0c30\u0c3f" },
            { "zh_Hans", "\u0c38\u0c30\u0c33\u0c40\u0c15\u0c43\u0c24 \u0c1a\u0c48\u0c28\u0c40\u0c38\u0c4d" },
            { "koi", "\u0c15\u0c4b\u0c2e\u0c3f-\u0c2a\u0c30\u0c4d\u0c2e\u0c3e\u0c15\u0c4d" },
            { "Hung", "\u0c2a\u0c4d\u0c30\u0c3e\u0c1a\u0c40\u0c28 \u0c39\u0c02\u0c17\u0c47\u0c30\u0c3f\u0c2f\u0c28\u0c4d" },
            { "kok", "\u0c15\u0c4a\u0c02\u0c15\u0c23\u0c3f" },
            { "%%1901", "\u0c2a\u0c4d\u0c30\u0c3e\u0c1a\u0c40\u0c28 \u0c19\u0c30\u0c4d\u0c2e\u0c28 \u0c35\u0c30\u0c4d\u0c23\u0c15\u0c4d\u0c30\u0c2e\u0c02" },
            { "kos", "\u0c15\u0c4b\u0c38\u0c4d\u0c30\u0c47\u0c2f\u0c28\u0c4d" },
            { "zh_Hant", "\u0c38\u0c3e\u0c02\u0c2a\u0c4d\u0c30\u0c26\u0c3e\u0c2f\u0c15 \u0c1a\u0c48\u0c28\u0c40\u0c38\u0c4d" },
            { "Sund", "\u0c38\u0c41\u0c21\u0c3e\u0c28\u0c40\u0c38\u0c4d" },
            { "kpe", "\u0c2a\u0c46\u0c32\u0c4d\u0c32\u0c47" },
            { "type.nu.khmr", "\u0c16\u0c4d\u0c2e\u0c47\u0c30\u0c4d \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "ilo", "\u0c10\u0c32\u0c4b\u0c15\u0c4b" },
            { "Cprt", "\u0c38\u0c48\u0c2a\u0c4d\u0c30\u0c4b\u0c1f\u0c4d" },
            { "mua", "\u0c2e\u0c02\u0c21\u0c3e\u0c02\u0c17\u0c4d" },
            { "type.nu.guru", "\u0c17\u0c41\u0c30\u0c4d\u0c2e\u0c41\u0c16\u0c40 \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "mul", "\u0c2c\u0c39\u0c41\u0c33 \u0c2d\u0c3e\u0c37\u0c32\u0c41" },
            { "cad", "\u0c15\u0c47\u0c21\u0c4d\u0c21\u0c4b" },
            { "key.ms", "\u0c15\u0c4a\u0c32\u0c2e\u0c3e\u0c28 \u0c2a\u0c26\u0c4d\u0c27\u0c24\u0c3f" },
            { "mus", "\u0c15\u0c4d\u0c30\u0c40\u0c15\u0c4d" },
            { "Glag", "\u0c17\u0c4d\u0c32\u0c3e\u0c17\u0c4b \u0c32\u0c3f\u0c1f\u0c3f\u0c15\u0c4d" },
            { "gil", "\u0c17\u0c3f\u0c32\u0c4d\u0c2c\u0c30\u0c4d\u0c1f\u0c40\u0c38\u0c4d" },
            { "Cher", "\u0c1a\u0c3f\u0c30\u0c4b\u0c15\u0c3f" },
            { "car", "\u0c15\u0c47\u0c30\u0c3f\u0c2c\u0c4d" },
            { "type.nu.tamldec", "\u0c24\u0c2e\u0c3f\u0c33 \u0c05\u0c02\u0c15\u0c46\u0c32\u0c41" },
            { "krc", "\u0c15\u0c30\u0c1a\u0c47-\u0c2c\u0c32\u0c4d\u0c15\u0c3e\u0c30\u0c4d" },
            { "inh", "\u0c07\u0c02\u0c17\u0c41\u0c37\u0c4d" },
            { "fa_AF", "\u0c21\u0c3e\u0c30\u0c3f" },
            { "krl", "\u0c15\u0c30\u0c47\u0c32\u0c3f\u0c2f\u0c28\u0c4d" },
            { "efi", "\u0c0e\u0c2b\u0c3f\u0c15\u0c4d" },
            { "tcy", "\u0c24\u0c41\u0c33\u0c41" },
            { "key.nu", "\u0c38\u0c02\u0c16\u0c4d\u0c2f\u0c32\u0c41" },
            { "kru", "\u0c15\u0c42\u0c30\u0c41\u0c16\u0c4d" },
            { "ksb", "\u0c36\u0c02\u0c2c\u0c3e\u0c32\u0c3e" },
            { "Telu", metaValue_te },
            { "ksf", "\u0c2c\u0c3e\u0c2b\u0c3f\u0c2f" },
        };
        return data;
    }
}
