/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives.actions;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.CleanupzipAction;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.engine.spi.Value;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class UnzipAction
extends ProvisioningAction {
    public static final String ACTION_UNZIP = "unzip";
    private Value<String[]> result;

    public IStatus execute(Map<String, Object> parameters) {
        return this.unzip(parameters, true);
    }

    public IStatus undo(Map<String, Object> parameters) {
        return CleanupzipAction.cleanupzip(parameters, false);
    }

    public IStatus unzip(Map<String, Object> parameters, boolean restoreable) {
        String source = (String)parameters.get("source");
        if (source == null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ACTION_UNZIP));
        }
        String originalSource = source;
        String target = (String)parameters.get("target");
        if (target == null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"target", (Object)ACTION_UNZIP));
        }
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        Profile profile = (Profile)parameters.get("profile");
        if (source.equals("@artifact")) {
            String artifactLocation = (String)parameters.get("artifact.location");
            if (artifactLocation == null) {
                IArtifactKey artifactKey = (IArtifactKey)parameters.get("artifact");
                return Util.createError(NLS.bind((String)Messages.artifact_not_available, (Object)artifactKey));
            }
            source = artifactLocation;
        }
        IBackupStore store = restoreable ? (IBackupStore)parameters.get("backup") : null;
        String path = (String)parameters.get("path");
        String includePattern = (String)parameters.get("include");
        String excludePattern = (String)parameters.get("exclude");
        File[] unzippedFiles = UnzipAction.unzip(source, target, path, includePattern, excludePattern, store);
        String[] filesAsString = new String[unzippedFiles.length];
        int i = 0;
        while (i < unzippedFiles.length) {
            filesAsString[i] = unzippedFiles[i].getAbsolutePath();
            ++i;
        }
        this.result = new Value((Object)filesAsString);
        StringBuffer unzippedFileNameBuffer = new StringBuffer();
        File[] fileArray = unzippedFiles;
        int n = unzippedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File unzippedFile = fileArray[n2];
            unzippedFileNameBuffer.append(unzippedFile.getAbsolutePath()).append("|");
            ++n2;
        }
        profile.setInstallableUnitProperty(iu, "unzipped|" + originalSource + "|" + target, unzippedFileNameBuffer.toString());
        return Status.OK_STATUS;
    }

    private static File[] unzip(String source, String destination, String path, String includePattern, String excludePattern, IBackupStore store) {
        File zipFile = new File(source);
        if (zipFile == null || !zipFile.exists()) {
            Util.logError(UnzipAction.class.getName() + " the files to be unzipped is not here", null);
        }
        try {
            String taskName = NLS.bind((String)Messages.unzipping, (Object)source);
            String[] includes = includePattern == null ? null : includePattern.split("\\s+");
            String[] excludes = excludePattern == null ? null : excludePattern.split("\\s+");
            return Util.unzipFile(zipFile, new File(destination), path, includes, excludes, store, taskName, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            Util.logError(UnzipAction.class.getName() + " error unzipping zipfile: " + zipFile.getAbsolutePath() + "destination: " + destination, null);
            return new File[0];
        }
    }

    public Value<String[]> getResult() {
        return this.result;
    }
}

