/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.charts;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.resource.ColorRegistry;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.charts.BaseChartConstants;

public class BaseChartDrawingSupplier
extends DefaultDrawingSupplier {
    public static final String COLOR_PREF_ID_PREFIX = "org.jkiss.dbeaver.ui.data.chart.color.";
    private static final Log log = Log.getLog(BaseChartDrawingSupplier.class);

    public BaseChartDrawingSupplier() {
        super(BaseChartDrawingSupplier.getChartColorsDefinitions(), DEFAULT_FILL_PAINT_SEQUENCE, DEFAULT_OUTLINE_PAINT_SEQUENCE, DEFAULT_STROKE_SEQUENCE, DEFAULT_OUTLINE_STROKE_SEQUENCE, DEFAULT_SHAPE_SEQUENCE);
    }

    private static Paint[] getChartColorsDefinitions() {
        org.eclipse.swt.graphics.Color swtColor;
        ColorRegistry colorRegistry = UIUtils.getActiveWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        ArrayList<Color> result = new ArrayList<Color>();
        int i = 1;
        while ((swtColor = colorRegistry.get(COLOR_PREF_ID_PREFIX + i)) != null) {
            result.add(new Color(swtColor.getRed(), swtColor.getGreen(), swtColor.getBlue()));
            ++i;
        }
        if (result.isEmpty()) {
            log.warn((Object)"Chart colors configuration not found");
            Collections.addAll(result, BaseChartConstants.DBEAVER_DEFAULT_COLOR_SERIES);
        }
        return result.toArray(new Paint[0]);
    }
}

