/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public final class SeparatorBorder
extends MarginBorder {
    private final int position;
    private Color color;

    public SeparatorBorder(Insets insets, int sides) {
        super(insets);
        this.position = sides;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void paint(IFigure f, Graphics g, Insets i) {
        Rectangle r = SeparatorBorder.getPaintRectangle(f, i);
        if (this.color != null) {
            g.setForegroundColor(this.color);
        }
        g.setLineWidth(1);
        g.setLineStyle(1);
        if ((this.position & 1) > 0) {
            g.drawLine(r.getTopLeft(), r.getBottomLeft());
        }
        if ((this.position & 4) > 0) {
            --r.width;
            g.drawLine(r.getTopRight(), r.getBottomRight());
            ++r.width;
        }
        if ((this.position & 8) > 0) {
            g.drawLine(r.getTopLeft(), r.getTopRight());
        }
        if ((this.position & 0x20) > 0) {
            --r.height;
            g.drawLine(r.getBottomLeft(), r.getBottomRight());
            ++r.height;
        }
    }
}

