/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericScriptObject;
import org.jkiss.dbeaver.ext.vertica.VerticaUtils;
import org.jkiss.dbeaver.ext.vertica.model.VerticaDataSource;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;

public class VerticaProjection
extends JDBCTable<VerticaDataSource, VerticaSchema>
implements GenericScriptObject {
    private static final Log log = Log.getLog(VerticaProjection.class);
    private final long objectId;
    private final String baseName;
    private final String ownerName;
    private final String anchorTableName;
    private final String nodeName;
    private final boolean isPreJoin;
    private final String createType;
    private final String segmentExpression;
    private final String segmentRange;
    private final boolean isSuperProjection;
    private final boolean isKeyConstraintProjection;
    private final boolean hasExpressions;
    private final boolean isAggregateProjection;
    private final String aggregateType;
    private final String description;

    public VerticaProjection(VerticaSchema schema, JDBCResultSet dbResult) {
        super((DBSObject)schema, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"projection_name"), true);
        this.objectId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"projection_id");
        this.baseName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"projection_basename");
        this.ownerName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"owner_name");
        this.anchorTableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"anchor_table_name");
        this.nodeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"node_name");
        this.isPreJoin = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_prejoin");
        this.createType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"create_type");
        this.segmentExpression = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"segment_expression");
        this.segmentRange = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"segment_range");
        this.isSuperProjection = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_super_projection");
        this.isKeyConstraintProjection = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_key_constraint_projection");
        this.hasExpressions = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"has_expressions");
        this.isAggregateProjection = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_aggregate_projection");
        this.aggregateType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"aggregate_type");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
    }

    public long getObjectId() {
        return this.objectId;
    }

    @Property(viewable=true, order=10)
    public String getBaseName() {
        return this.baseName;
    }

    @Property(viewable=true, order=11)
    public String getOwnerName() {
        return this.ownerName;
    }

    @Property(viewable=true, order=12)
    public String getAnchorTableName() {
        return this.anchorTableName;
    }

    @Property(viewable=true, order=13)
    public String getNodeName() {
        return this.nodeName;
    }

    @Property(order=50)
    public boolean isPreJoin() {
        return this.isPreJoin;
    }

    @Property(order=51)
    public String getCreateType() {
        return this.createType;
    }

    @Property(order=52)
    public String getSegmentExpression() {
        return this.segmentExpression;
    }

    @Property(order=53)
    public String getSegmentRange() {
        return this.segmentRange;
    }

    @Property(order=54)
    public boolean isSuperProjection() {
        return this.isSuperProjection;
    }

    @Property(order=55)
    public boolean isKeyConstraintProjection() {
        return this.isKeyConstraintProjection;
    }

    @Property(order=56)
    public boolean isHasExpressions() {
        return this.hasExpressions;
    }

    @Property(order=57)
    public boolean isIsAggregateProjection() {
        return this.isAggregateProjection;
    }

    @Property(order=58)
    public String getAggregateType() {
        return this.aggregateType;
    }

    public JDBCStructCache<VerticaSchema, ? extends DBSEntity, ? extends DBSEntityAttribute> getCache() {
        return ((VerticaSchema)this.getContainer()).projectionCache;
    }

    public boolean isView() {
        return false;
    }

    public Collection<? extends DBSTableIndex> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public List<? extends DBSEntityAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((VerticaSchema)this.getContainer()).projectionCache.getChildren(monitor, (DBSObject)((VerticaSchema)this.getContainer()), (DBSObject)this);
    }

    public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (DBSEntityAttribute)((VerticaSchema)this.getContainer()).projectionCache.getChild(monitor, (DBSObject)((VerticaSchema)this.getContainer()), (DBSObject)this, attributeName);
    }

    public Collection<? extends DBSTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    @Property(viewable=true, order=100)
    public String getDescription() {
        return this.description;
    }

    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (this.isPersisted()) {
            return VerticaUtils.getObjectDDL(monitor, (GenericDataSource)this.getDataSource(), (DBSObject)this);
        }
        return null;
    }
}

