/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { ApplicationRef, NgZone, ɵgetDebugNodeR2 } from '@angular/core';
import { exportNgVar } from '../util';
const CORE_TOKENS = (() => ({
    'ApplicationRef': ApplicationRef,
    'NgZone': NgZone,
}))();
const INSPECT_GLOBAL_NAME = 'probe';
const CORE_TOKENS_GLOBAL_NAME = 'coreTokens';
/**
 * Returns a {@link DebugElement} for the given native DOM element, or
 * null if the given native element does not have an Angular view associated
 * with it.
 */
export function inspectNativeElementR2(element) {
    return ɵgetDebugNodeR2(element);
}
export function _createNgProbeR2(coreTokens) {
    exportNgVar(INSPECT_GLOBAL_NAME, inspectNativeElementR2);
    exportNgVar(CORE_TOKENS_GLOBAL_NAME, { ...CORE_TOKENS, ..._ngProbeTokensToMap(coreTokens || []) });
    return () => inspectNativeElementR2;
}
function _ngProbeTokensToMap(tokens) {
    return tokens.reduce((prev, t) => (prev[t.name] = t.token, prev), {});
}
//# sourceMappingURL=data:application/json;base64,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