/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp.responses.highlevel;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hampelratte.svdrp.Connection;
import org.hampelratte.svdrp.Version;

public class Timer
implements Serializable,
Comparable<Timer>,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final int INACTIVE = 0;
    public static final int ACTIVE = 1;
    public static final int INSTANT_TIMER = 2;
    public static final int VPS = 4;
    public static final int RECORDING = 8;
    private int state = 1;
    private Calendar startTime = GregorianCalendar.getInstance();
    private Calendar endTime = GregorianCalendar.getInstance();
    private Calendar firstTime = GregorianCalendar.getInstance();
    private boolean hasFirstTime;
    private boolean[] repeatingDays = new boolean[7];
    private int channelNumber;
    private int ID;
    private int priority;
    private int lifetime;
    private String title = "";
    private String path = "";
    private String description = "";

    public boolean isActive() {
        return this.hasState(1);
    }

    public boolean hasState(int STATE) {
        if (STATE == 0) {
            return !this.isActive();
        }
        return (this.state & STATE) == STATE;
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    public void setChannelNumber(int channel) {
        this.channelNumber = channel;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int durability) {
        this.lifetime = durability;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Calendar endTime) {
        this.endTime = endTime;
        if (endTime.before(this.startTime)) {
            endTime.add(5, 1);
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Calendar startTime) {
        this.startTime = startTime;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title.replace('|', ':');
    }

    public String getUniqueKey() {
        SimpleDateFormat sdf = this.isRepeating() ? new SimpleDateFormat("HH:mm") : new SimpleDateFormat("dd.MM.yyyy HH:mm");
        String startTime = sdf.format(this.getStartTime().getTime());
        String endTime = sdf.format(this.getEndTime().getTime());
        StringBuffer sb = new StringBuffer();
        sb.append(this.getChannelNumber());
        sb.append(':');
        sb.append(this.getDayString());
        sb.append(':');
        sb.append(startTime);
        sb.append(':');
        sb.append(endTime);
        return sb.toString();
    }

    public String toNEWT() {
        String start = this.createTimeString(this.getStartTime());
        String end = this.createTimeString(this.getEndTime());
        StringBuffer sb = new StringBuffer();
        sb.append(this.getState());
        sb.append(':');
        sb.append(this.channelNumber);
        sb.append(':');
        sb.append(this.getDayString());
        sb.append(':');
        sb.append(start);
        sb.append(':');
        sb.append(end);
        sb.append(':');
        sb.append(this.priority);
        sb.append(':');
        sb.append(this.lifetime);
        sb.append(':');
        sb.append(this.getFile());
        sb.append(':');
        sb.append(this.description.replaceAll("\n", "\\|"));
        return sb.toString();
    }

    public String toString() {
        String start = this.createTimeString(this.getStartTime());
        String end = this.createTimeString(this.getEndTime());
        StringBuffer sb = new StringBuffer();
        sb.append(this.getState());
        sb.append(':');
        sb.append(this.channelNumber);
        sb.append(':');
        sb.append(this.getDayString());
        if (this.isRepeating()) {
            sb.append(" [instance:" + this.createDateString(this.startTime, false) + "]");
        }
        sb.append(':');
        sb.append(start);
        sb.append(':');
        sb.append(end);
        sb.append(':');
        sb.append(this.priority);
        sb.append(':');
        sb.append(this.lifetime);
        sb.append(':');
        sb.append(this.getFile());
        sb.append(':');
        String desc = this.description.replaceAll("\n", "\\|");
        if (desc.length() > 15) {
            desc = desc.substring(0, 15) + "...";
        }
        sb.append(desc);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof Timer) {
            Timer timer = (Timer)o;
            return timer.toNEWT().equals(this.toNEWT());
        }
        return false;
    }

    @Override
    public int compareTo(Timer that) {
        return that.toNEWT().compareTo(this.toNEWT());
    }

    public boolean[] getRepeatingDays() {
        return this.repeatingDays;
    }

    public void setRepeatingDays(boolean[] repeating_days) {
        this.repeatingDays = repeating_days;
    }

    public boolean isRepeating() {
        for (int i = 0; i < this.repeatingDays.length; ++i) {
            if (!this.repeatingDays[i]) continue;
            return true;
        }
        return false;
    }

    public Calendar getFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(Calendar firstTime) {
        this.firstTime = firstTime;
        this.hasFirstTime = true;
    }

    public boolean hasFirstTime() {
        return this.hasFirstTime;
    }

    public void setHasFirstTime(boolean hasFirstTime) {
        this.hasFirstTime = hasFirstTime;
    }

    public String getDayString() {
        StringBuffer sb = new StringBuffer();
        if (this.isRepeating()) {
            sb.append(this.createRepeatingString());
            if (this.hasFirstTime()) {
                sb.append('@');
                sb.append(this.createDateString(this.firstTime, true));
            }
        } else {
            sb.append(this.createDateString(this.startTime, false));
        }
        return sb.toString();
    }

    private String createDateString(Calendar cal, boolean repeating) {
        Version v = Connection.getVersion();
        if (v == null) {
            v = new Version("1.0.0");
        }
        int major = v.getMajor();
        int minor = v.getMinor();
        int rev = v.getRevision();
        boolean newFormat = (major == 1 && (minor > 3 || minor == 3 && rev >= 23)) | this.isRepeating();
        String date = "";
        if (newFormat) {
            int day = cal.get(5);
            String dayString = day < 10 ? "0" + day : Integer.toString(day);
            int month = cal.get(2) + 1;
            String monthString = month < 10 ? "0" + month : Integer.toString(month);
            date = cal.get(1) + "-" + monthString + "-" + dayString;
        } else {
            date = Integer.toString(cal.get(5));
        }
        return date;
    }

    private String createTimeString(Calendar time) {
        SimpleDateFormat df = new SimpleDateFormat("HHmm");
        Date date = new Date(time.getTimeInMillis());
        return df.format(date);
    }

    private String createRepeatingString() {
        StringBuffer day = new StringBuffer();
        day.append(this.repeatingDays[0] ? (char)'M' : '-');
        day.append(this.repeatingDays[1] ? (char)'T' : '-');
        day.append(this.repeatingDays[2] ? (char)'W' : '-');
        day.append(this.repeatingDays[3] ? (char)'T' : '-');
        day.append(this.repeatingDays[4] ? (char)'F' : '-');
        day.append(this.repeatingDays[5] ? (char)'S' : '-');
        day.append(this.repeatingDays[6] ? (char)'S' : '-');
        return day.toString();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path.replace('|', ':');
    }

    public String getFile() {
        String _path = this.path;
        if (!_path.endsWith("~") && !_path.equals("")) {
            _path = _path + "~";
        }
        return (_path + this.title).replace(':', '|');
    }

    public void setFile(String file) {
        if (file.indexOf("~") >= 0) {
            int pos = file.lastIndexOf("~");
            this.setPath(file.substring(0, pos));
            this.setTitle(file.substring(pos + 1));
        } else {
            this.setPath("");
            this.setTitle(file);
        }
    }

    public boolean isDaySet(Calendar cal) {
        boolean[] days = this.getRepeatingDays();
        return days[(cal.get(7) + 5) % 7];
    }

    public Object clone() {
        Timer timer = new Timer();
        timer.setID(this.getID());
        timer.setState(this.getState());
        timer.setChannelNumber(this.getChannelNumber());
        timer.setDescription(this.getDescription());
        timer.setEndTime((Calendar)this.getEndTime().clone());
        timer.setFile(this.getFile());
        timer.setFirstTime((Calendar)this.getFirstTime().clone());
        timer.setHasFirstTime(this.hasFirstTime());
        timer.setChannelNumber(this.getChannelNumber());
        timer.setLifetime(this.getLifetime());
        timer.setPath(this.getPath());
        timer.setPriority(this.getPriority());
        timer.setRepeatingDays((boolean[])this.getRepeatingDays().clone());
        timer.setStartTime((Calendar)this.getStartTime().clone());
        timer.setTitle(this.getTitle());
        return timer;
    }

    public int getID() {
        return this.ID;
    }

    public void setID(int id) {
        this.ID = id;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void changeStateTo(int STATE, boolean enabled) {
        if (enabled && this.hasState(STATE) || !enabled && !this.hasState(STATE)) {
            return;
        }
        int sign = enabled ? 1 : -1;
        this.state += sign * STATE;
    }

    public boolean isRecording() {
        if (this.hasState(1) && this.hasState(8)) {
            return true;
        }
        Calendar now = Calendar.getInstance();
        if (now.after(this.getStartTime()) && now.before(this.getEndTime())) {
            return this.hasState(1);
        }
        return false;
    }
}

