// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudGlobalNetworkManager20220215PeeringConnection hashicorp cloud global network manager 20220215 peering connection
//
// swagger:model hashicorp.cloud.global_network_manager_20220215.PeeringConnection
type HashicorpCloudGlobalNetworkManager20220215PeeringConnection struct {

	// `created_at` is the timestamp of when the peering_connection was created.
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// display_error is an error to give to the front end to determine on-going issues for customers
	DisplayError *cloud.GoogleRPCStatus `json:"display_error,omitempty"`

	// location is the location of the peering connection (composite of the org/project)
	Location *cloud.HashicorpCloudLocationLocation `json:"location,omitempty"`

	// network_connectivity is used to determine how the underlying network
	// infrastructure is connected
	NetworkConnectivity *HashicorpCloudGlobalNetworkManager20220215NetworkConnectivity `json:"network_connectivity,omitempty"`

	// peering_connection_id is slug ID of the peering connection
	PeeringConnectionID string `json:"peering_connection_id,omitempty"`

	// `updated_at` is the timestamp of when the peering_connection was last updated.
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`
}

// Validate validates this hashicorp cloud global network manager 20220215 peering connection
func (m *HashicorpCloudGlobalNetworkManager20220215PeeringConnection) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDisplayError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetworkConnectivity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215PeeringConnection) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215PeeringConnection) validateDisplayError(formats strfmt.Registry) error {
	if swag.IsZero(m.DisplayError) { // not required
		return nil
	}

	if m.DisplayError != nil {
		if err := m.DisplayError.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("display_error")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("display_error")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215PeeringConnection) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215PeeringConnection) validateNetworkConnectivity(formats strfmt.Registry) error {
	if swag.IsZero(m.NetworkConnectivity) { // not required
		return nil
	}

	if m.NetworkConnectivity != nil {
		if err := m.NetworkConnectivity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("network_connectivity")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("network_connectivity")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215PeeringConnection) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this hashicorp cloud global network manager 20220215 peering connection based on the context it is used
func (m *HashicorpCloudGlobalNetworkManager20220215PeeringConnection) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDisplayError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetworkConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215PeeringConnection) contextValidateDisplayError(ctx context.Context, formats strfmt.Registry) error {

	if m.DisplayError != nil {

		if swag.IsZero(m.DisplayError) { // not required
			return nil
		}

		if err := m.DisplayError.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("display_error")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("display_error")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215PeeringConnection) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {

		if swag.IsZero(m.Location) { // not required
			return nil
		}

		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215PeeringConnection) contextValidateNetworkConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if m.NetworkConnectivity != nil {

		if swag.IsZero(m.NetworkConnectivity) { // not required
			return nil
		}

		if err := m.NetworkConnectivity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("network_connectivity")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("network_connectivity")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudGlobalNetworkManager20220215PeeringConnection) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudGlobalNetworkManager20220215PeeringConnection) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudGlobalNetworkManager20220215PeeringConnection
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
