# Copyright 2025 The Bazel Authors. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
{#python-apis-executables-bzl}
Loading-phase APIs specific to executables (binaries/tests).

:::{versionadded} 1.3.0
:::
"""

load("//python/private:py_binary_rule.bzl", "create_py_binary_rule_builder")
load("//python/private:py_executable.bzl", "create_executable_rule_builder")
load("//python/private:py_test_rule.bzl", "create_py_test_rule_builder")

executables = struct(
    py_binary_rule_builder = create_py_binary_rule_builder,
    py_test_rule_builder = create_py_test_rule_builder,
    executable_rule_builder = create_executable_rule_builder,
)
