# Distro sox

## Links

* [`sox.sf.net`](https://sox.sf.net)
  * [Patches](https://sourceforge.net/p/sox/bugs/?limit=100)

## Tickets

Here is the correspondence between the `sox.sf.net` tickets and sox_ng's issues.

```
Legend
-  Not required in `sox_ng`
```

### Patches

| Patch | Issue |
| :---- | :---: |
| [129](https://sourceforge.net/p/sox/patches/129) a sane build system | #271 |
| [128](https://sourceforge.net/p/sox/patches/128) Division by zero at `wav.c:967` | Only affects 42b355 |
| [127](https://sourceforge.net/p/sox/patches/127) Division by zero at `voc.c:334` | #247 |
| [126](https://sourceforge.net/p/sox/patches/126) Global-buffer-overflow at `adpcms.c:58` | #262 |
| [125](https://sourceforge.net/p/sox/patches/125) Fix `property_size = sizeof(name)` | #167 |
| [124](https://sourceforge.net/p/sox/patches/124) low-latency pulseaudio pipeline using --input-buffer | #185 |
| [123](https://sourceforge.net/p/sox/patches/123) configure.ac: fix static linking with id3tag | Only affects 42b355 |
| [122](https://sourceforge.net/p/sox/patches/122) configure.ac: put back --disable-protector | #254 |
| [121](https://sourceforge.net/p/sox/patches/121) Full RF64 support | #253 |
| [120](https://sourceforge.net/p/sox/patches/120) Initialize channel map for pulseaudio | #252 |
| [116](https://sourceforge.net/p/sox/patches/116) [PATCH] Adding FFTW support speeds up spectrogram by factor of ten | #109 |
| [108](https://sourceforge.net/p/sox/patches/108) Fix multi-channel LADSPA effects + draining for all LADSPA effects | #245 |
| [107](https://sourceforge.net/p/sox/patches/107) Win32 Progress Flush Fix | #244 |
| [106](https://sourceforge.net/p/sox/patches/106) Support for "DynAudNorm" Effect | #164 |
| [105](https://sourceforge.net/p/sox/patches/105) Win32 Unicode (UTF-8) support | #203 |
| [104](https://sourceforge.net/p/sox/patches/104) missing version number in sox --version output | #159 |
| [103](https://sourceforge.net/p/sox/patches/103) ignore SIGPIPE so stop callbacks may fire | #243 |
| [102](https://sourceforge.net/p/sox/patches/102) [PATCH] modified spectrogram hh:mm:ss in X-axis | #242 |
| [94](https://sourceforge.net/p/sox/patches/94) libmpg123 support for mp3 decoding | #150 |
| [93](https://sourceforge.net/p/sox/patches/93) flac (decoder): simplify EOF state and fix MD5 check | - |
| [89](https://sourceforge.net/p/sox/patches/89) Docs: libsox.3 update | - |
| [65](https://sourceforge.net/p/sox/patches/65) Enable SoX to be built as a Windows DLL | #251 |
| [41](https://sourceforge.net/p/sox/patches/41) MIDI Sample Dump Module | #157 |
| [35](https://sourceforge.net/p/sox/patches/35) Amiga Module support | #158 |

## Notes for maintainers of sox.sf.net

`sox_ng` stems from `sox-14.4.2`, not from a more recent `sox.sf.net` commit,
because the first `sox_ng` release (micro) concentrates on bug fixes and
* patches in the distros, mostly based on 14.4.2, are more likely to apply cleanly
* sox.sf.net since 14.4.2 has 184 commits: a mixture of bug fixes, new features, build system fixes, code reformatting and refactoring and who knows what else
* the regression test suite shows that 42b355 fails on some CVEs that 14.4.2 doesn't, so it has more bugs as well as less. See [Testing](Testing).

Some of its commits have been applied: those which became Debian patches
and others necessary for other patches to apply including:
* [9ce4a4a](https://sourceforge.net/p/sox/code/ci/9ce4a4a):: `Segmentation fault in rate.c:504:30` See [bug 334](https://sourceforge.net/p/sox/bugs/334) and issue #56.
* [ccedd08](https://sourceforge.net/p/sox/code/ci/ccedd08): `Clean up lsx_malloc and friends` See issue #57.

and it would be worth scanning the 169 commits since 14.4.2 for bug fixes.

## Issues

[Bugs reported on `sox.sf.net`](https://sourceforge.net/p/sox/bugs) since 14.4.2 need importing into the `sox_ng` issue tracker.

## TODO

### Fix bug 321

[Bug 321](https://sourceforge.net/p/sox/bugs/321): Stack-Buffer-Overflow in fft4g.c
is addressed by [patch b7883ae](https://sourceforge.net/p/sox/code/ci/b7883ae),
imported by Debian, but on the test case it makes sox loop for 6 seconds
consuming gigabytes of memory and creates a 127MB audio file of random noise
just over an hour long. See issue #18: CVE-2017-8356.

This is because the check against `FFT4G_MAX_SIZE` makes the functions
in `fft4g.c` `return` instead of failing. The solution is to turn each
```
    if (n > FFT4G_MAX_SIZE)
        return;
```
into
```
    if (n > FFT4G_MAX_SIZE) {
        lsx_fail("FFT size is too large");
        exit(2);
    }
```

### Add `README` to the repository

SoX's `README` file is generated by `README.sh` and is not included
in the repository. As a consequence, code browsed at `sox.sf.net`
shows at the bottom of the page `README.osx` or `README.win32`
which are irrelevant.

It would be better to run `README.sh` and add the generated `README`
to the repository. People editing `README.sh` or `FEATURES.in`
will have to remember to update `README` too and commit it,
unless this can be automated.

### Import patches

If `sox.sf.net` maintainers wish to import patches from `sox_ng`
and make a `sox-14.4.3` release, that is of course fine.
After all, it's where everyone goes to get the latest `sox`
and where semiautomatic distros update from.
