/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContextManagerImpl;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwnerEx;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsPackageStatementImpl;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.ModuleStubBuildingVisitor;
import com.intellij.psi.impl.compiled.OutOfOrderInnerClassException;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.cls.ClsFormatException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class ClsFileImpl
extends PsiBinaryFileImpl
implements PsiJavaFile,
PsiFileWithStubSupport,
PsiFileEx,
Queryable,
PsiClassOwnerEx,
PsiCompiledFile {
    private static final Logger LOG = Logger.getInstance(ClsFileImpl.class);
    private static final String BANNER = "\n  // IntelliJ API Decompiler stub source generated from a class file\n  // Implementation of methods is not available\n\n";
    private static final String CORRUPTED_CLASS_PACKAGE = "corrupted_class_file";
    private static final Key<Document> CLS_DOCUMENT_LINK_KEY = Key.create((String)"cls.document.link");
    private final Object myMirrorLock;
    private final Object myStubLock;
    private final boolean myIsForDecompiling;
    private volatile SoftReference<StubTree> myStub;
    private volatile Reference<TreeElement> myMirrorFileElement;
    private volatile ClsPackageStatementImpl myPackageStatement;
    private static final InnerClassSourceStrategy<FileContentPair> STRATEGY = new InnerClassSourceStrategy<FileContentPair>(){

        @Override
        @Nullable
        public FileContentPair findInnerClass(String innerName, FileContentPair outerClass) {
            String baseName = ((VirtualFile)outerClass.first).getNameWithoutExtension();
            VirtualFile dir = ((VirtualFile)outerClass.first).getParent();
            assert (dir != null) : outerClass;
            VirtualFile innerClass = dir.findChild(baseName + '$' + innerName + ".class");
            if (innerClass != null) {
                try {
                    byte[] bytes = innerClass.contentsToByteArray(false);
                    return new FileContentPair(innerClass, new ClassReader(bytes));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public void accept(FileContentPair innerClass, StubBuildingVisitor<FileContentPair> visitor) {
            try {
                ((ClassReader)innerClass.second).accept(visitor, EMPTY_ATTRIBUTES, 261);
            }
            catch (Exception e) {
                VirtualFile file = (VirtualFile)innerClass.first;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.valueOf(file), (Throwable)e);
                }
                LOG.info(file + ": " + e.getMessage());
            }
        }
    };
    public static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];

    public ClsFileImpl(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            ClsFileImpl.$$$reportNull$$$0(0);
        }
        this(viewProvider, false);
    }

    private ClsFileImpl(@NotNull FileViewProvider viewProvider, boolean forDecompiling) {
        if (viewProvider == null) {
            ClsFileImpl.$$$reportNull$$$0(1);
        }
        super((PsiManagerEx)viewProvider.getManager(), viewProvider);
        this.myMirrorLock = new Object();
        this.myStubLock = new Object();
        this.myIsForDecompiling = forDecompiling;
        JavaElementType.CLASS.getIndex();
    }

    public PsiFile getContainingFile() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return this;
    }

    public boolean isValid() {
        return super.isValid() && (this.myIsForDecompiling || this.getVirtualFile().isValid());
    }

    boolean isForDecompiling() {
        return this.myIsForDecompiling;
    }

    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            ClsFileImpl.$$$reportNull$$$0(2);
        }
        return javaLanguage;
    }

    public PsiElement @NotNull [] getChildren() {
        PsiElement[] psiElementArray;
        PsiJavaModule module = this.getModuleDeclaration();
        if (module != null) {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = module;
        } else {
            psiElementArray = this.getClasses();
        }
        if (psiElementArray == null) {
            ClsFileImpl.$$$reportNull$$$0(3);
        }
        return psiElementArray;
    }

    @Override
    public PsiClass @NotNull [] getClasses() {
        PsiClass[] psiClassArray = this.getStub().getClasses();
        if (psiClassArray == null) {
            ClsFileImpl.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    @Override
    public PsiPackageStatement getPackageStatement() {
        ClsPackageStatementImpl statement = this.myPackageStatement;
        if (statement == null) {
            String packageName;
            statement = ClsPackageStatementImpl.NULL_PACKAGE;
            PsiClassHolderFileStub<?> stub = this.getStub();
            if (!(stub instanceof PsiJavaFileStub && stub.findChildStubByElementType(JavaStubElementTypes.MODULE) != null || (packageName = ClsFileImpl.findPackageName(stub)) == null)) {
                statement = new ClsPackageStatementImpl(this, packageName);
            }
            this.myPackageStatement = statement;
        }
        return statement != ClsPackageStatementImpl.NULL_PACKAGE ? statement : null;
    }

    private static String findPackageName(PsiClassHolderFileStub<?> stub) {
        String packageName = null;
        if (stub instanceof PsiJavaFileStub) {
            packageName = ((PsiJavaFileStub)stub).getPackageName();
        } else {
            int index;
            String className;
            PsiClass[] psiClasses = stub.getClasses();
            if (psiClasses.length > 0 && (className = psiClasses[0].getQualifiedName()) != null && (index = className.lastIndexOf(46)) >= 0) {
                packageName = className.substring(0, index);
            }
        }
        return !StringUtil.isEmpty((String)packageName) ? packageName : null;
    }

    @Override
    @NotNull
    public String getPackageName() {
        PsiPackageStatement statement = this.getPackageStatement();
        String string = statement == null ? "" : statement.getPackageName();
        if (string == null) {
            ClsFileImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public void setPackageName(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName == null) {
            ClsFileImpl.$$$reportNull$$$0(6);
        }
        throw new IncorrectOperationException("Cannot set package name for compiled files");
    }

    @Override
    public PsiImportList getImportList() {
        return null;
    }

    @Override
    public boolean importClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ClsFileImpl.$$$reportNull$$$0(7);
        }
        throw new UnsupportedOperationException("Cannot add imports to compiled classes");
    }

    @Override
    public PsiElement @NotNull [] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            ClsFileImpl.$$$reportNull$$$0(8);
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @Override
    public PsiClass @NotNull [] getSingleClassImports(boolean checkIncludes) {
        if (PsiClass.EMPTY_ARRAY == null) {
            ClsFileImpl.$$$reportNull$$$0(9);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Override
    public String @NotNull [] getImplicitlyImportedPackages() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            ClsFileImpl.$$$reportNull$$$0(10);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> getClassNames() {
        return Collections.singleton(this.getVirtualFile().getNameWithoutExtension());
    }

    @Override
    public PsiJavaCodeReferenceElement @NotNull [] getImplicitlyImportedPackageReferences() {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            ClsFileImpl.$$$reportNull$$$0(11);
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @Override
    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        return null;
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel level;
        PsiClassHolderFileStub<?> stub = this.getStub();
        if (stub instanceof PsiJavaFileStub && (level = ((PsiJavaFileStub)stub).getLanguageLevel()) != null) {
            LanguageLevel languageLevel = level;
            if (languageLevel == null) {
                ClsFileImpl.$$$reportNull$$$0(12);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            ClsFileImpl.$$$reportNull$$$0(13);
        }
        return languageLevel;
    }

    @Override
    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        PsiClassHolderFileStub<?> stub = this.getStub();
        return stub instanceof PsiJavaFileStub ? ((PsiJavaFileStub)stub).getModule() : null;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            ClsFileImpl.$$$reportNull$$$0(14);
        }
        throw ClsElementImpl.cannotModifyException((PsiCompiledElement)this);
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        throw ClsElementImpl.cannotModifyException((PsiCompiledElement)this);
    }

    private void appendMirrorText(StringBuilder buffer) {
        buffer.append(BANNER);
        PsiJavaModule module = this.getModuleDeclaration();
        if (module != null) {
            ClsElementImpl.appendText(module, 0, buffer);
        } else {
            PsiClass[] classes = this.getClasses();
            if (classes.length > 0) {
                PsiClass topClass = classes[0];
                if ("package-info".equals(topClass.getName())) {
                    PsiAnnotation[] annotations;
                    for (PsiAnnotation annotation : annotations = topClass.getAnnotations()) {
                        ClsElementImpl.appendText(annotation, 0, buffer, "go_to_next_line_and_indent");
                    }
                    ClsElementImpl.appendText(this.getPackageStatement(), 0, buffer, "\n");
                } else {
                    ClsElementImpl.appendText(this.getPackageStatement(), 0, buffer, "\n\n");
                    ClsElementImpl.appendText(topClass, 0, buffer);
                }
            }
        }
    }

    private void setFileMirror(TreeElement element) {
        PsiElement mirrorElement = SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)element);
        if (!(mirrorElement instanceof PsiJavaFile)) {
            throw new ClsElementImpl.InvalidMirrorException("Unexpected mirror file: " + mirrorElement);
        }
        PsiJavaFile mirrorFile = (PsiJavaFile)mirrorElement;
        PsiJavaModule module = this.getModuleDeclaration();
        if (module != null) {
            ClsElementImpl.setMirror(module, mirrorFile.getModuleDeclaration());
        } else {
            PsiElement[] classes = this.getClasses();
            PsiElement[] mirrors = mirrorFile.getClasses();
            PsiPackageStatement pkg = this.getPackageStatement();
            PsiPackageStatement mirrorPkg = mirrorFile.getPackageStatement();
            if (classes.length == 1 && mirrors.length == 0 && "package-info".equals(classes[0].getName())) {
                ClsElementImpl.setMirror(pkg, mirrorPkg);
                ClsElementImpl.setMirrorIfPresent(classes[0].getModifierList(), mirrorPkg.getAnnotationList());
            } else if (pkg == null || !CORRUPTED_CLASS_PACKAGE.equals(pkg.getPackageName())) {
                ClsElementImpl.setMirrorIfPresent(pkg, mirrorPkg);
                ClsElementImpl.setMirrors((PsiElement[])classes, (PsiElement[])mirrors);
            }
        }
    }

    @NotNull
    public PsiElement getNavigationElement() {
        for (ClsCustomNavigationPolicy navigationPolicy : ClsCustomNavigationPolicy.EP_NAME.getExtensionList()) {
            PsiElement psiElement;
            try {
                PsiElement navigationElement = navigationPolicy.getNavigationElement(this);
                if (navigationElement == null) continue;
                psiElement = navigationElement;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                continue;
            }
            if (psiElement == null) {
                ClsFileImpl.$$$reportNull$$$0(15);
            }
            return psiElement;
        }
        PsiElement psiElement = (PsiElement)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            PsiElement target = JavaPsiImplementationHelper.getInstance(this.getProject()).getClsFileNavigationElement(this);
            ModificationTracker tracker = FileIndexFacade.getInstance((Project)this.getProject()).getRootModificationTracker();
            return CachedValueProvider.Result.create((Object)target, (Object[])new Object[]{this, target.getContainingFile(), tracker});
        });
        if (psiElement == null) {
            ClsFileImpl.$$$reportNull$$$0(16);
        }
        return psiElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PsiElement getMirror() {
        TreeElement mirrorTreeElement = (TreeElement)com.intellij.reference.SoftReference.dereference(this.myMirrorFileElement);
        if (mirrorTreeElement == null) {
            Object object = this.myMirrorLock;
            synchronized (object) {
                mirrorTreeElement = (TreeElement)com.intellij.reference.SoftReference.dereference(this.myMirrorFileElement);
                if (mirrorTreeElement == null) {
                    VirtualFile file = this.getVirtualFile();
                    AstLoadingFilter.assertTreeLoadingAllowed((VirtualFile)file);
                    PsiClass[] classes = this.getClasses();
                    String fileName = (classes.length > 0 ? classes[0].getName() : file.getNameWithoutExtension()) + ".java";
                    Document document = FileDocumentManager.getInstance().getDocument(file);
                    assert (document != null) : file.getUrl();
                    CharSequence mirrorText = document.getImmutableCharSequence();
                    boolean internalDecompiler = StringUtil.startsWith((CharSequence)mirrorText, (CharSequence)BANNER);
                    PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.getManager().getProject());
                    PsiFile mirror = factory.createFileFromText(fileName, (Language)JavaLanguage.INSTANCE, mirrorText, false, false, true);
                    mirror.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, (Object)this.getLanguageLevel());
                    CodeInsightContextManagerImpl contextManager = CodeInsightContextManagerImpl.getInstanceImpl((Project)this.getProject());
                    if (contextManager.isSharedSourceSupportEnabled()) {
                        CodeInsightContext context = contextManager.getCodeInsightContext(this.getViewProvider());
                        contextManager.setCodeInsightContext(mirror.getViewProvider(), context);
                    }
                    mirrorTreeElement = SourceTreeToPsiMap.psiToTreeNotNull((PsiElement)mirror);
                    try {
                        TreeElement _mirrorTreeElement = mirrorTreeElement;
                        ProgressManager.getInstance().executeNonCancelableSection(() -> {
                            this.setFileMirror(_mirrorTreeElement);
                            this.putUserData(CLS_DOCUMENT_LINK_KEY, document);
                        });
                    }
                    catch (ClsElementImpl.InvalidMirrorException e) {
                        LOG.error(file.getUrl(), (Throwable)(internalDecompiler ? e : ClsFileImpl.wrapException(e, file)));
                    }
                    ((PsiFileImpl)mirror).setOriginalFile((PsiFile)this);
                    this.myMirrorFileElement = new SoftReference<TreeElement>(mirrorTreeElement);
                }
            }
        }
        PsiElement psiElement = mirrorTreeElement.getPsi();
        if (psiElement == null) {
            ClsFileImpl.$$$reportNull$$$0(17);
        }
        return psiElement;
    }

    public String getText() {
        VirtualFile file = this.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(file);
        assert (document != null) : file.getUrl();
        return document.getText();
    }

    public int getTextLength() {
        VirtualFile file = this.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(file);
        assert (document != null) : file.getUrl();
        return document.getTextLength();
    }

    private static Exception wrapException(ClsElementImpl.InvalidMirrorException e, VirtualFile file) {
        PluginDescriptor plugin;
        ClassFileDecompilers.Light decompiler = ClassFileDecompilers.getInstance().find(file, ClassFileDecompilers.Light.class);
        if (decompiler != null && (plugin = PluginManager.getPluginByClass(decompiler.getClass())) != null) {
            return new PluginException((Throwable)e, plugin.getPluginId());
        }
        return e;
    }

    @NotNull
    public PsiFile getDecompiledPsiFile() {
        PsiFile psiFile = (PsiFile)this.getMirror();
        if (psiFile == null) {
            ClsFileImpl.$$$reportNull$$$0(18);
        }
        return psiFile;
    }

    @Nullable
    public PsiFile getCachedMirror() {
        TreeElement mirrorTreeElement = (TreeElement)com.intellij.reference.SoftReference.dereference(this.myMirrorFileElement);
        return mirrorTreeElement == null ? null : (PsiFile)mirrorTreeElement.getPsi();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            ClsFileImpl.$$$reportNull$$$0(19);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitJavaFile(this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    public String toString() {
        return "PsiFile:" + this.getName();
    }

    public final TextRange getTextRange() {
        return TextRange.create((int)0, (int)this.getTextLength());
    }

    public final int getStartOffsetInParent() {
        return 0;
    }

    public final PsiElement findElementAt(int offset) {
        return this.getMirror().findElementAt(offset);
    }

    public PsiReference findReferenceAt(int offset) {
        return this.getMirror().findReferenceAt(offset);
    }

    public final int getTextOffset() {
        return 0;
    }

    public char @NotNull [] textToCharArray() {
        char[] cArray = this.getMirror().textToCharArray();
        if (cArray == null) {
            ClsFileImpl.$$$reportNull$$$0(20);
        }
        return cArray;
    }

    @NotNull
    public PsiClassHolderFileStub<?> getStub() {
        PsiClassHolderFileStub psiClassHolderFileStub = (PsiClassHolderFileStub)this.getStubTree().getRoot();
        if (psiClassHolderFileStub == null) {
            ClsFileImpl.$$$reportNull$$$0(21);
        }
        return psiClassHolderFileStub;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            ClsFileImpl.$$$reportNull$$$0(22);
        }
        if (state == null) {
            ClsFileImpl.$$$reportNull$$$0(23);
        }
        if (place == null) {
            ClsFileImpl.$$$reportNull$$$0(24);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            for (PsiClass aClass : this.getClasses()) {
                if (processor.execute((PsiElement)aClass, state)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public StubTree getStubTree() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        StubTree stubTree = (StubTree)com.intellij.reference.SoftReference.dereference(this.myStub);
        if (stubTree != null) {
            StubTree stubTree2 = stubTree;
            if (stubTree2 == null) {
                ClsFileImpl.$$$reportNull$$$0(25);
            }
            return stubTree2;
        }
        StubTreeLoader stubTreeLoader = StubTreeLoader.getInstance();
        Project project = this.getProject();
        VirtualFile virtualFile = this.getVirtualFile();
        boolean isDefault = project.isDefault();
        StubTree newStubTree = (StubTree)(isDefault ? stubTreeLoader.build(null, virtualFile, (PsiFile)this) : stubTreeLoader.readOrBuild(project, virtualFile, (PsiFile)this));
        if (newStubTree == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No stub for class file " + virtualFile.getPresentableUrl());
            }
            newStubTree = new StubTree((PsiFileStub)new PsiJavaFileStubImpl(CORRUPTED_CLASS_PACKAGE, true));
        } else if (!(newStubTree.getRoot() instanceof PsiClassHolderFileStub)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invalid stub for class file " + virtualFile.getPresentableUrl() + ": " + newStubTree.getRoot());
            }
            newStubTree = new StubTree((PsiFileStub)new PsiJavaFileStubImpl(CORRUPTED_CLASS_PACKAGE, true));
        }
        Object object = this.myStubLock;
        synchronized (object) {
            stubTree = (StubTree)com.intellij.reference.SoftReference.dereference(this.myStub);
            if (stubTree != null) {
                StubTree stubTree3 = stubTree;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl27 : MonitorExitStatement: MONITOREXIT : var7_7
                if (stubTree3 == null) {
                    ClsFileImpl.$$$reportNull$$$0(26);
                }
                return stubTree3;
            }
            stubTree = newStubTree;
            PsiFileStubImpl fileStub = (PsiFileStubImpl)stubTree.getRoot();
            fileStub.setPsi((PsiFile)this);
            this.myStub = new SoftReference<StubTree>(stubTree);
        }
        StubTree stubTree4 = stubTree;
        if (stubTree4 == null) {
            ClsFileImpl.$$$reportNull$$$0(27);
        }
        return stubTree4;
    }

    @NotNull
    public StubbedSpine getStubbedSpine() {
        StubbedSpine stubbedSpine = this.getStubTree().getSpine();
        if (stubbedSpine == null) {
            ClsFileImpl.$$$reportNull$$$0(28);
        }
        return stubbedSpine;
    }

    public boolean isContentsLoaded() {
        return this.getCachedMirror() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onContentReload() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Object object = this.myStubLock;
        synchronized (object) {
            StubTree stubTree = (StubTree)com.intellij.reference.SoftReference.dereference(this.myStub);
            this.myStub = null;
            if (stubTree != null) {
                ((PsiFileStubImpl)stubTree.getRoot()).clearPsi("cls onContentReload");
            }
        }
        object = this.myMirrorLock;
        synchronized (object) {
            this.putUserData(CLS_DOCUMENT_LINK_KEY, null);
            this.myMirrorFileElement = null;
            this.myPackageStatement = null;
        }
    }

    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        if (info == null) {
            ClsFileImpl.$$$reportNull$$$0(29);
        }
        PsiFileImpl.putInfo((PsiFile)this, info);
    }

    @NotNull
    public static CharSequence decompile(@NotNull VirtualFile file) {
        if (file == null) {
            ClsFileImpl.$$$reportNull$$$0(30);
        }
        PsiManager manager = PsiManager.getInstance((Project)DefaultProjectFactory.getInstance().getDefaultProject());
        ClsFileImpl clsFile = new ClsFileImpl((FileViewProvider)new ClassFileViewProvider(manager, file), true);
        StringBuilder buffer = new StringBuilder();
        ApplicationManager.getApplication().runReadAction(() -> clsFile.appendMirrorText(buffer));
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            ClsFileImpl.$$$reportNull$$$0(31);
        }
        return stringBuilder;
    }

    @Nullable
    public static PsiJavaFileStub buildFileStub(@NotNull VirtualFile file, byte @NotNull [] bytes) throws ClsFormatException {
        if (file == null) {
            ClsFileImpl.$$$reportNull$$$0(32);
        }
        if (bytes == null) {
            ClsFileImpl.$$$reportNull$$$0(33);
        }
        try {
            block13: {
                LanguageLevel level;
                ClassReader reader = new ClassReader(bytes);
                if (ClassFileViewProvider.isInnerClass(file, reader)) {
                    return null;
                }
                String className = file.getNameWithoutExtension();
                String internalName = reader.getClassName();
                boolean module = internalName.equals("module-info") && BitUtil.isSet((int)reader.getAccess(), (int)32768);
                JavaSdkVersion jdkVersion = ClsParsingUtil.getJdkVersionByBytecode(reader.readUnsignedShort(6));
                LanguageLevel languageLevel = level = jdkVersion != null ? jdkVersion.getMaxLanguageLevel() : null;
                if (level != null && level.isAtLeast(LanguageLevel.JDK_11) && ClsParsingUtil.isPreviewLevel(reader.readUnsignedShort(4))) {
                    level = (LanguageLevel)((Object)ObjectUtils.notNull((Object)((Object)level.getPreviewLevel()), (Object)((Object)LanguageLevel.HIGHEST)));
                }
                if (module) {
                    PsiJavaFileStubImpl stub = new PsiJavaFileStubImpl(null, "", level, true);
                    ModuleStubBuildingVisitor visitor = new ModuleStubBuildingVisitor(stub);
                    reader.accept((ClassVisitor)visitor, visitor.attributes(), 4);
                    if (visitor.getResult() != null) {
                        return stub;
                    }
                } else {
                    PsiJavaFileStubImpl stub = new PsiJavaFileStubImpl(null, ClsFileImpl.getPackageName(internalName), level, true);
                    try {
                        FileContentPair source = new FileContentPair(file, reader);
                        StubBuildingVisitor<FileContentPair> visitor = new StubBuildingVisitor<FileContentPair>(source, STRATEGY, (StubElement<?>)stub, 0, className);
                        reader.accept(visitor, EMPTY_ATTRIBUTES, 261);
                        if (visitor.getResult() != null) {
                            return stub;
                        }
                    }
                    catch (OutOfOrderInnerClassException e) {
                        if (!LOG.isTraceEnabled()) break block13;
                        LOG.trace(file.getPath());
                    }
                }
            }
            return null;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ClsFormatException(file.getPath() + ": " + e.getMessage(), e);
        }
    }

    private static String getPackageName(String internalName) {
        int p = internalName.lastIndexOf(47);
        return p > 0 ? internalName.substring(0, p).replace('/', '.') : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClsFileImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClsFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnDemandImports";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleClassImports";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackages";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackageReferences";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMirror";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecompiledPsiFile";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getStub";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubTree";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedSpine";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "decompile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setPackageName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "importClass";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "decompile";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "buildFileStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class FileContentPair
    extends Pair<VirtualFile, ClassReader> {
        FileContentPair(@NotNull VirtualFile file, @NotNull ClassReader content) {
            if (file == null) {
                FileContentPair.$$$reportNull$$$0(0);
            }
            if (content == null) {
                FileContentPair.$$$reportNull$$$0(1);
            }
            super((Object)file, (Object)content);
        }

        @NotNull
        public ClassReader getContent() {
            ClassReader classReader = (ClassReader)this.second;
            if (classReader == null) {
                FileContentPair.$$$reportNull$$$0(2);
            }
            return classReader;
        }

        public String toString() {
            return ((VirtualFile)this.first).toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/compiled/ClsFileImpl$FileContentPair";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/compiled/ClsFileImpl$FileContentPair";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

