/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl.logging;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;

public abstract class ProjectBuilderLoggerBase
implements ProjectBuilderLogger {
    @Override
    public void logDeletedFiles(Collection<String> paths) {
        if (paths.isEmpty()) {
            return;
        }
        Object[] buffer = new String[paths.size()];
        int i = 0;
        for (String o : paths) {
            buffer[i++] = o;
        }
        Arrays.sort(buffer);
        this.logLine("Cleaning output files:");
        for (Object o : buffer) {
            this.logLine((String)o);
        }
        this.logLine("End of files");
    }

    @Override
    public void logCompiledFiles(Collection<File> files, String builderId, String description) throws IOException {
        this.logCompiled(files, description, (T file) -> {
            try {
                return FileUtilRt.toSystemIndependentName((String)file.getCanonicalPath());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private <T> void logCompiled(@NotNull Collection<T> files, String description, @NotNull Function<T, String> toString) {
        if (files == null) {
            ProjectBuilderLoggerBase.$$$reportNull$$$0(0);
        }
        if (toString == null) {
            ProjectBuilderLoggerBase.$$$reportNull$$$0(1);
        }
        this.logLine(description);
        Object[] buffer = new String[files.size()];
        int i = 0;
        for (T file : files) {
            buffer[i++] = toString.apply(file);
        }
        Arrays.sort(buffer);
        for (Object s : buffer) {
            this.logLine((String)s);
        }
        this.logLine("End of files");
    }

    @Override
    public void logCompiled(@NotNull Collection<Path> files, String builderId, String description) {
        if (files == null) {
            ProjectBuilderLoggerBase.$$$reportNull$$$0(2);
        }
        this.logCompiled(files, description, (T file) -> FileUtilRt.toSystemIndependentName((String)file.toAbsolutePath().normalize().toString()));
    }

    @Override
    public void logCompiledPaths(@NotNull Collection<String> paths, String builderId, String description) {
        if (paths == null) {
            ProjectBuilderLoggerBase.$$$reportNull$$$0(3);
        }
        this.logCompiled(paths, description, (T file) -> FileUtilRt.toSystemIndependentName((String)Path.of(file, new String[0]).toAbsolutePath().normalize().toString()));
    }

    protected abstract void logLine(@NonNls String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toString";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/builders/impl/logging/ProjectBuilderLoggerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "logCompiled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "logCompiledPaths";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

