/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.filters;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rdclient.filters.FrontendFilterNavigationContext;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/filters/FrontendHeavyFilterFrame;", "", "fragment", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "highlightRange", "<init>", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/openapi/util/TextRange;)V", "getHighlightRange", "()Lcom/intellij/openapi/util/TextRange;", "getText", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getNavigationContext", "Lcom/jetbrains/rdclient/filters/FrontendFilterNavigationContext;", "rangeStart", "", "rangeEnd", "intellij.rd.client"})
public class FrontendHeavyFilterFrame {
    @NotNull
    private final Document fragment;
    @NotNull
    private final TextRange textRange;
    @NotNull
    private final TextRange highlightRange;

    public FrontendHeavyFilterFrame(@NotNull Document fragment, @NotNull TextRange textRange, @NotNull TextRange highlightRange) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)highlightRange, (String)"highlightRange");
        this.fragment = fragment;
        this.textRange = textRange;
        this.highlightRange = highlightRange;
    }

    @NotNull
    public final TextRange getHighlightRange() {
        return this.highlightRange;
    }

    @NotNull
    public final String getText() {
        String string = this.fragment.getText(this.textRange);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public final FrontendFilterNavigationContext getNavigationContext(int rangeStart, int rangeEnd) {
        int frameOffset = this.highlightRange.getStartOffset();
        TextRange hyperlinkRange = new TextRange(frameOffset + rangeStart, frameOffset + rangeEnd);
        boolean bl = this.highlightRange.contains(hyperlinkRange.getStartOffset());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int overlap = 5;
        Document $this$getNavigationContext_u24lambda_u240 = this.fragment;
        boolean bl2 = false;
        int blockStartLine = Math.max($this$getNavigationContext_u24lambda_u240.getLineNumber(hyperlinkRange.getStartOffset()) - overlap, 0);
        int blockStartOffset = $this$getNavigationContext_u24lambda_u240.getLineStartOffset(blockStartLine);
        int blockEndLine = Math.min($this$getNavigationContext_u24lambda_u240.getLineNumber(hyperlinkRange.getEndOffset()) + overlap, $this$getNavigationContext_u24lambda_u240.getLineCount() - 1);
        int blockEndOffset = $this$getNavigationContext_u24lambda_u240.getLineEndOffset(blockEndLine);
        int delta = this.highlightRange.getStartOffset() - blockStartOffset;
        String string = $this$getNavigationContext_u24lambda_u240.getText(new TextRange(blockStartOffset, blockEndOffset));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String blockText = string;
        return new FrontendFilterNavigationContext(blockText, delta);
    }
}

