use struct_patch::Patch;

#[derive(Default, Patch)]
#[patch(attribute(derive(Debug, Default)))]
struct Item {
    field_complete: bool,
    field_int: usize,
    field_string: String,
}

// Generated by Patch derive macro
//
// #[derive(Debug, Default)] // pass by patch(attribute(...))
// struct ItemPatch {
//     field_complete: Option<bool>,
//     field_int: Option<usize>,
//     field_string: Option<String>,
// }

fn main() {
    let mut item = Item::default();

    let mut patch: ItemPatch = Item::new_empty_patch();

    patch.field_int = Some(7);

    assert_eq!(
        format!("{patch:?}"),
        "ItemPatch { field_complete: None, field_int: Some(7), field_string: None }"
    );

    item.apply(patch);

    assert!(!item.field_complete);
    assert_eq!(item.field_int, 7);
    assert_eq!(item.field_string, "");

    #[cfg(feature = "op")]
    {
        let another_patch = ItemPatch {
            field_complete: None,
            field_int: None,
            field_string: Some("from another patch".into()),
        };
        let new_item = item << another_patch;

        assert!(!new_item.field_complete);
        assert_eq!(new_item.field_int, 7);
        assert_eq!(new_item.field_string, "from another patch");

        let the_other_patch = ItemPatch {
            field_complete: Some(true),
            field_int: None,
            field_string: None,
        };
        let final_item = new_item << the_other_patch;
        assert!(final_item.field_complete);
        assert_eq!(final_item.field_int, 7);
        assert_eq!(final_item.field_string, "from another patch");
    }
}
