//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// A badge to be rendered on a bar button item.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uibarbuttonitembadge?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIBarButtonItemBadge;
);

extern_conformance!(
    unsafe impl NSCoding for UIBarButtonItemBadge {}
);

extern_conformance!(
    unsafe impl NSCopying for UIBarButtonItemBadge {}
);

unsafe impl CopyingHelper for UIBarButtonItemBadge {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIBarButtonItemBadge {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UIBarButtonItemBadge {}
);

impl UIBarButtonItemBadge {
    extern_methods!(
        /// Creates a badge with the specified `count`.
        ///
        /// The count is localized when shown, and will update
        /// when the app’s locale changes.
        #[unsafe(method(badgeWithCount:))]
        #[unsafe(method_family = none)]
        pub fn badgeWithCount(count: NSUInteger, mtm: MainThreadMarker) -> Retained<Self>;

        /// Creates a badge with the specified `string`.
        #[unsafe(method(badgeWithString:))]
        #[unsafe(method_family = none)]
        pub fn badgeWithString(string_value: &NSString, mtm: MainThreadMarker) -> Retained<Self>;

        /// Creates a badge that's empty, and just renders the badge background
        /// with no content.
        #[unsafe(method(indicatorBadge))]
        #[unsafe(method_family = none)]
        pub fn indicatorBadge(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(stringValue))]
        #[unsafe(method_family = none)]
        pub fn stringValue(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "UIColor")]
        /// The badge's background color. A `nil` value will be treated as an indication to use the system default.
        #[unsafe(method(backgroundColor))]
        #[unsafe(method_family = none)]
        pub fn backgroundColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`backgroundColor`][Self::backgroundColor].
        #[unsafe(method(setBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundColor(&self, background_color: Option<&UIColor>);

        #[cfg(feature = "UIColor")]
        /// The badge's foreground color. A `nil` value will be treated as an indication to use the system default.
        #[unsafe(method(foregroundColor))]
        #[unsafe(method_family = none)]
        pub fn foregroundColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`foregroundColor`][Self::foregroundColor].
        #[unsafe(method(setForegroundColor:))]
        #[unsafe(method_family = none)]
        pub fn setForegroundColor(&self, foreground_color: Option<&UIColor>);

        #[cfg(feature = "UIFont")]
        /// The font to use for the badge. A `nil` value will be treated as an indication to use the system default.
        #[unsafe(method(font))]
        #[unsafe(method_family = none)]
        pub fn font(&self) -> Option<Retained<UIFont>>;

        #[cfg(feature = "UIFont")]
        /// Setter for [`font`][Self::font].
        #[unsafe(method(setFont:))]
        #[unsafe(method_family = none)]
        pub fn setFont(&self, font: Option<&UIFont>);
    );
}

/// Methods declared on superclass `NSObject`.
impl UIBarButtonItemBadge {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// Badging.
#[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
impl UIBarButtonItem {
    extern_methods!(
        /// Sets a badge on the bar button item. Currently only supported in navigation bars.
        #[unsafe(method(badge))]
        #[unsafe(method_family = none)]
        pub fn badge(&self) -> Option<Retained<UIBarButtonItemBadge>>;

        /// Setter for [`badge`][Self::badge].
        #[unsafe(method(setBadge:))]
        #[unsafe(method_family = none)]
        pub fn setBadge(&self, badge: Option<&UIBarButtonItemBadge>);
    );
}
