import React from "react";
import PropTypes from "prop-types";

function HiddenWidget(_ref) {
  var id = _ref.id,
      value = _ref.value;
  return React.createElement("input", {
    type: "hidden",
    id: id,
    value: typeof value === "undefined" ? "" : value
  });
}

if (process.env.NODE_ENV !== "production") {
  HiddenWidget.propTypes = {
    id: PropTypes.string.isRequired,
    value: PropTypes.oneOfType([PropTypes.string, PropTypes.number, PropTypes.bool])
  };
}

export default HiddenWidget;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jb21wb25lbnRzL3dpZGdldHMvSGlkZGVuV2lkZ2V0LmpzIl0sIm5hbWVzIjpbIlJlYWN0IiwiUHJvcFR5cGVzIiwiSGlkZGVuV2lkZ2V0IiwiaWQiLCJ2YWx1ZSIsInByb2Nlc3MiLCJlbnYiLCJOT0RFX0VOViIsInByb3BUeXBlcyIsInN0cmluZyIsImlzUmVxdWlyZWQiLCJvbmVPZlR5cGUiLCJudW1iZXIiLCJib29sIl0sIm1hcHBpbmdzIjoiQUFBQSxPQUFPQSxLQUFQLE1BQWtCLE9BQWxCO0FBQ0EsT0FBT0MsU0FBUCxNQUFzQixZQUF0Qjs7QUFFQSxTQUFTQyxZQUFULE9BQXFDO0FBQUEsTUFBYkMsRUFBYSxRQUFiQSxFQUFhO0FBQUEsTUFBVEMsS0FBUyxRQUFUQSxLQUFTO0FBQ25DLFNBQ0U7QUFDRSxJQUFBLElBQUksRUFBQyxRQURQO0FBRUUsSUFBQSxFQUFFLEVBQUVELEVBRk47QUFHRSxJQUFBLEtBQUssRUFBRSxPQUFPQyxLQUFQLEtBQWlCLFdBQWpCLEdBQStCLEVBQS9CLEdBQW9DQTtBQUg3QyxJQURGO0FBT0Q7O0FBRUQsSUFBSUMsT0FBTyxDQUFDQyxHQUFSLENBQVlDLFFBQVosS0FBeUIsWUFBN0IsRUFBMkM7QUFDekNMLEVBQUFBLFlBQVksQ0FBQ00sU0FBYixHQUF5QjtBQUN2QkwsSUFBQUEsRUFBRSxFQUFFRixTQUFTLENBQUNRLE1BQVYsQ0FBaUJDLFVBREU7QUFFdkJOLElBQUFBLEtBQUssRUFBRUgsU0FBUyxDQUFDVSxTQUFWLENBQW9CLENBQ3pCVixTQUFTLENBQUNRLE1BRGUsRUFFekJSLFNBQVMsQ0FBQ1csTUFGZSxFQUd6QlgsU0FBUyxDQUFDWSxJQUhlLENBQXBCO0FBRmdCLEdBQXpCO0FBUUQ7O0FBRUQsZUFBZVgsWUFBZiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tIFwicmVhY3RcIjtcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSBcInByb3AtdHlwZXNcIjtcblxuZnVuY3Rpb24gSGlkZGVuV2lkZ2V0KHsgaWQsIHZhbHVlIH0pIHtcbiAgcmV0dXJuIChcbiAgICA8aW5wdXRcbiAgICAgIHR5cGU9XCJoaWRkZW5cIlxuICAgICAgaWQ9e2lkfVxuICAgICAgdmFsdWU9e3R5cGVvZiB2YWx1ZSA9PT0gXCJ1bmRlZmluZWRcIiA/IFwiXCIgOiB2YWx1ZX1cbiAgICAvPlxuICApO1xufVxuXG5pZiAocHJvY2Vzcy5lbnYuTk9ERV9FTlYgIT09IFwicHJvZHVjdGlvblwiKSB7XG4gIEhpZGRlbldpZGdldC5wcm9wVHlwZXMgPSB7XG4gICAgaWQ6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICB2YWx1ZTogUHJvcFR5cGVzLm9uZU9mVHlwZShbXG4gICAgICBQcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgUHJvcFR5cGVzLm51bWJlcixcbiAgICAgIFByb3BUeXBlcy5ib29sLFxuICAgIF0pLFxuICB9O1xufVxuXG5leHBvcnQgZGVmYXVsdCBIaWRkZW5XaWRnZXQ7XG4iXX0=