v3 Migration
==========

Mockery releases version 3 of the project that provides a number of high-profile benefits over v2:

1. Generation of [`matryer`](template/matryer.md)-style templates. The https://github.com/matryer/moq project is being subsumed into mockery to combine the speed and configuration flexibility of mockery with the simplicity of moq-style mocks.
2. The ability to specify [your own templates](template/index.md) for rendering.
3. One output file for all generated mocks (for a particular package) instead of one output file per mock.
4. Simplification and streamlining of the way mocks are generated using new configuration defaults.

v3 has been architected in a way that will eventually make all other interface-based code generation frameworks obsolete.[^2]

Read the maintainer's blog post on the history and background of v3:

[![](https://topofmind.dev/assets/images/social/blog/2025/04/08/announcing-mockery-v3.png){ style="width: 600px; max-width: 100%" }](https://topofmind.dev/blog/2025/04/08/announcing-mockery-v3/)

## `mockery migrate`

A tool is provided that will migrate your v2 config to v3 on a best-effort basis. Take for example a v2 schema config:

```yaml title=""
quiet: False
disable-version-string: True
with-expecter: True
structname: "{{.InterfaceNameCamel}}"
filename: "{{.StructName}}_mock.go"
outpkg: mocks
tags: "custom2"
issue-845-fix: True
resolve-type-alias: False
packages:
  github.com/vektra/mockery/v2/pkg/fixtures:
    config:
      all: True
    interfaces:
      RequesterVariadic:
        config:
          with-expecter: False
        configs:
          - structname: RequesterVariadicOneArgument
            unroll-variadic: False
          - structname: RequesterVariadic
            unroll-variadic: True
      ReplaceGeneric:
        config:
          replace-type:
            - github.com/vektra/mockery/v2/pkg/fixtures.ReplaceGeneric[-TImport]=github.com/vektra/mockery/v2/pkg/fixtures/redefined_type_b.B
            - github.com/vektra/mockery/v2/pkg/fixtures.ReplaceGeneric[TConstraint]=github.com/vektra/mockery/v2/pkg/fixtures/constraints.String
```



We can run the command to migrate this to the v3 schema:

```title=""
$ mockery migrate --config ./.mockery_v2.yml
2025-03-28T00:26:44.762164000-05:00 INF using config config=./.mockery_v2.yml version=v0.0.0-dev
2025-03-28T00:26:44.762804000-05:00 INF writing v3 config config=./.mockery_v2.yml v3-config=.mockery_v3.yml version=v0.0.0-dev
2025-03-28T00:26:44.762914000-05:00 WRN breaking changes detected that possibly require manual intervention. See table below. config=./.mockery_v2.yml version=v0.0.0-dev
```

This command will return two results:

!!! info ""

    === "`.mockery_v3.yml`"

        The translated v3 config file.

        ```yaml
        structname: '{{.InterfaceNameCamel}}'
        pkgname: mocks
        template: testify
        template-data:
          with-expecter: true
        packages:
          github.com/vektra/mockery/v2/pkg/fixtures:
            config:
              all: true
            interfaces:
              ReplaceGeneric:
                config: {}
              RequesterVariadic:
                config:
                  template-data:
                    with-expecter: false
                configs:
                  - structname: RequesterVariadicOneArgument
                    template-data:
                      unroll-variadic: false
                  - structname: RequesterVariadic
                    template-data:
                      unroll-variadic: true
        ```

    === "Deprecation Table"

        A deprecation table that highlights situations that could not be resolved automatically. Each of these entries must be manually handled.

        Take for example the last entry mentioning `replace-type`. In v3, the [schema for `replace-type`](replace-type.md#schema){ data-preview } was changed from a parsed string to a more explicit key-value mapping.

        ```title=""
        ╭────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮
        │                                                              Deprecations                                                              │
        ├────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
        │ IDX  DEPRECATION TYPE      MESSAGE                                                                                                     │
        ├────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
        │ 0    template-variable     InterfaceNameCamel template variable has been deleted. Use "{{ .InterfaceName | camelcase }}" instead       │
        ├────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
        │ 1    deprecated-parameter  `tags` is no longer supported, parameter not migrated. Use `mock-build-tags` instead.                       │
        ├────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
        │ 2    deprecated-parameter  `disable-func-mocks` permanently enabled in v3.                                                             │
        ├────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
        │ 3    deprecated-parameter  `fail-on-missing` is permanently set to True in v3.                                                         │
        ├────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
        │ 4    deprecated-parameter  `disable-version-string` is permanently set to True in v3.                                                  │
        ├────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
        │ 5    deprecated-parameter  `issue-845-fix` is permanently set to true in v3.                                                           │
        ├────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
        │ 6    deprecated-parameter  `replace-type` has moved to a new schema. Cannot automatically migrate. Please visit                        │
        │                            https://vektra.github.io/mockery/latest-v3/replace-type/ for more information.                              │
        ╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯
        ```

!!! warning

    `mockery migrate` is not comprehensive and likely has missing edge cases. We encourage you to submit issues and PRs for any problems you encounter.

## Config Templates

Template functions used in configuration files have changed. The order of arugments for functions that take input strings is swapped. For example, in v2 the [`trimSuffix` function](https://github.com/vektra/mockery/blob/v2.53.3/pkg/outputter.go#L49) was set to the `strings.TrimSuffix` function from the stdlib. In v3, the argument orders are swapped, for example:

```go
"trimSuffix":  func(suffix string, s string) string { return strings.TrimSuffix(s, suffix) },
```

This is done to support [template pipelines](https://pkg.go.dev/text/template#hdr-Pipelines). You can see all of the reordered functions at [pkg.go.dev](https://pkg.go.dev/github.com/vektra/mockery/v3@v3.2.4/template_funcs#pkg-variables).

## Layouts

In v2, mockery defaulted to placing mocks in a separate `mocks/` directory as [shown here](https://vektra.github.io/mockery/latest-v2/configuration/#layouts). In v3, mockery will by default place mocks adjacent to the mocked interface.

It is still possible to place mocks in a separate directory by making use of the [template variables and functions](configuration.md#templates) available to the configuration parameters.

## Function Mocks

Mockery v2 allowed generating mocks for function types. v3 no longer does this as it provided little benefit for users.

## Parameters

### `#!yaml inpackage: True`

Mockery v2 has an `inpackage` parameter that informed mockery when a mock was being generated in the same package as the original interface. In v3, this parameter has been removed as mockery is now able to detect when the mock is placed in the same package.

### `#!yaml keeptree: True`

Mockery v2 provided a `keeptree` parameter that was deprecated and used only in the pre-`packages` config schema. This parameter has no use in v3 and has been removed.

### `#!yaml replace-type:`

The `#!yaml replace-type:` parameter has an updated schema. In v2, [users provided a list of strings](https://vektra.github.io/mockery/latest-v2/features/#replace-types), where each string needed to confirm to a specific format that was parsed at runtime. In v3, the [schema is more explicit](replace-type.md) to make it simpler.


### `#!yaml structname:`

The `structname` parameter has been replaced with `structname`.

### `#!yaml resolve-type-alias:`

In v2, `resolve-type-alias` was set to `True` by default to retain backwards compatibility. In v3, this is permanently set to `False`.

### `#!yaml with-expecter:`

In v3, this parameter has been removed. `testify`-style mocks will always generate expecter methods.

### `#!yaml unroll-variadic:`

This parameter has been moved under the `#!yaml template-data:` parameter. Parameters that apply only to specific templates are not expressed in the top-level schema and are instead passed through the schemaless `#!yaml template-data:` map.

### `#!yaml exclude:`

This parameter in v2 was renamed to `#! exclude-subpkg-regex:`.

## v2 Support Lifecycle

In order to give the community ample time to adjust to v3, the mockery maintainers will support v2 until Dec 31, 2029 in the following ways:

1. Bug fixes
2. Security/vulnerability fixes
3. Dependency updates to support future Go language versions.[^1]

From the date at which v3 is released for full production, the Mockery project will support feature updates to v2 for a period of 6 months.

[^1]: More specifically, we agree to update our dependencies used in parsing Go types such that Mockery is capable of parsing new syntax introduced in the Go language. The mockery project will _not_ support changes to the generated code in a manner that makes use of any new language features. The only promise is that Mockery will be able to parse modules that use such new syntax or other language features without failing.
[^2]: A bold statement yes, but we hope to convince you of its truth with what's coming. The assumption of the https://github.com/matryer/moq project into mockery is a testament to this statement, and is only the first of many other projects we hope to integrate into mockery.
