## Launch Tayga within a container

# Enable Forwarding
echo "Enabling IPv4 and IPv6 forwarding"
echo 1 > /proc/sys/net/ipv4/conf/all/forwarding
echo 1 > /proc/sys/net/ipv6/conf/all/forwarding

# Default environment variables
TAYGA_PREF64="${TAYGA_PREF64:-64:ff9b::/96}"
TAYGA_POOL4="${TAYGA_POOL4:-192.168.240.0/20}"
TAYGA_ADDR4="${TAYGA_ADDR:-192.168.240.1}"
#Addr6 not set, Tayga will choose on its own
TAYGA_WKPF_STRICT="${TAYGA_WKPF_STRICT:-no}"
TAYGA_LOG="${TAYGA_LOG:-drop reject icmp self dyn}"

# Generate tayga.conf file
cat << EOF > /app/tayga.conf
# tayga.conf
# This file is generated by launch-nat64.sh

tun-device nat64
wkpf-strict ${TAYGA_WKPF_STRICT}
ipv4-addr ${TAYGA_ADDR4}
prefix ${TAYGA_PREF64}
dynamic-pool ${TAYGA_POOL4}
log ${TAYGA_LOG}
data-dir /app
EOF

# Make tunnel adapter
echo "Creating tunnel adapter"
/app/tayga -c /app/tayga.conf -d --mktun || exit 1

# Bring up the interface
echo "Bringing up the interface"
ip link set dev nat64 up
ip route add ${TAYGA_POOL4} dev nat64
ip route add ${TAYGA_PREF64} dev nat64

# Start tayga
echo "Starting tayga"
# Use debug mode instead of syslog since containers log to stdout
/app/tayga -c /app/tayga.conf -d

# Delete tunnel adapter on exit
echo "Deleting tunnel adapter on exit"
ip link del nat64