/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.feature.preprocessor;

import com.jetbrains.mlapi.feature.Feature;
import com.jetbrains.mlapi.feature.FeatureEntitySpecification;
import com.jetbrains.mlapi.feature.FeatureSet;
import com.jetbrains.mlapi.feature.FeatureSignature;
import com.jetbrains.mlapi.feature.FeatureSignatureKt;
import com.jetbrains.mlapi.feature.preprocessor.FeaturePreprocessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\u0006\u0010\u0010\u001a\u00020\u000fJ\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000fH$R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/mlapi/feature/preprocessor/FeatureTransformer;", "Lcom/jetbrains/mlapi/feature/preprocessor/FeaturePreprocessor;", "inputFeature", "Lcom/jetbrains/mlapi/feature/FeatureSignature;", "(Lcom/jetbrains/mlapi/feature/FeatureSignature;)V", "inputFeatures", "", "(Ljava/util/List;)V", "getInputFeatures", "()Ljava/util/List;", "output", "", "getOutput", "()Ljava/util/Collection;", "deduceRequiredInput", "Lcom/jetbrains/mlapi/feature/FeatureSet;", "requiredOutput", "preprocessFeatures", "Lcom/jetbrains/mlapi/feature/Feature;", "features", "transformFeature", "feature", "mlapi-core"})
@SourceDebugExtension(value={"SMAP\nFeatureTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureTransformer.kt\ncom/jetbrains/mlapi/feature/preprocessor/FeatureTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1603#2,9:75\n1855#2:84\n1856#2:86\n1612#2:87\n1360#2:88\n1446#2,5:89\n766#2:94\n857#2,2:95\n819#2:97\n847#2,2:98\n1#3:85\n*S KotlinDebug\n*F\n+ 1 FeatureTransformer.kt\ncom/jetbrains/mlapi/feature/preprocessor/FeatureTransformer\n*L\n60#1:75,9\n60#1:84\n60#1:86\n60#1:87\n61#1:88\n61#1:89,5\n62#1:94\n62#1:95,2\n67#1:97\n67#1:98,2\n60#1:85\n*E\n"})
public abstract class FeatureTransformer
implements FeaturePreprocessor {
    @NotNull
    private final List<FeatureSignature> inputFeatures;

    public FeatureTransformer(@NotNull List<? extends FeatureSignature> inputFeatures2) {
        Intrinsics.checkNotNullParameter(inputFeatures2, (String)"inputFeatures");
        this.inputFeatures = inputFeatures2;
    }

    @NotNull
    public final List<FeatureSignature> getInputFeatures() {
        return this.inputFeatures;
    }

    public FeatureTransformer(@NotNull FeatureSignature inputFeature) {
        Intrinsics.checkNotNullParameter((Object)inputFeature, (String)"inputFeature");
        this(CollectionsKt.listOf((Object)inputFeature));
    }

    @NotNull
    public abstract Collection<FeatureSignature> getOutput();

    @NotNull
    protected abstract Collection<Feature> transformFeature(@NotNull Feature var1, @NotNull FeatureSet var2);

    @Override
    @NotNull
    public FeatureSet deduceRequiredInput(@NotNull FeatureSet requiredOutput) {
        Intrinsics.checkNotNullParameter((Object)requiredOutput, (String)"requiredOutput");
        return new FeatureSet(this, requiredOutput){
            final /* synthetic */ FeatureTransformer this$0;
            final /* synthetic */ FeatureSet $requiredOutput;
            {
                this.this$0 = $receiver;
                this.$requiredOutput = $requiredOutput;
            }

            public boolean contains(@NotNull FeatureSignature signature) {
                Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                if (FeatureSignatureKt.isDeclaredBy(signature, (Iterable<? extends FeatureSignature>)this.this$0.getInputFeatures())) {
                    return true;
                }
                boolean isInOutput = FeatureSignatureKt.isDeclaredBy(signature, (Iterable<? extends FeatureSignature>)this.$requiredOutput.selectSignatures(this.this$0.getOutput()));
                return !isInOutput && this.$requiredOutput.contains(signature);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public Collection<FeatureSignature> selectMissingSignatures(@NotNull Collection<? extends FeatureSignature> provided) {
                void $this$filterNotTo$iv$iv;
                void $this$filterNot$iv;
                void $this$filterNotTo$iv$iv2;
                Intrinsics.checkNotNullParameter(provided, (String)"provided");
                Iterable $this$filterNot$iv2 = this.this$0.getInputFeatures();
                boolean $i$f$filterNot22 = false;
                Object object = $this$filterNot$iv2;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterNotTo22 = false;
                for (T element$iv$iv : $this$filterNotTo$iv$iv2) {
                    FeatureSignature it = (FeatureSignature)element$iv$iv;
                    boolean bl = false;
                    if (FeatureSignatureKt.isDeclaredBy(it, (Iterable<? extends FeatureSignature>)provided)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List nonProvidedInputFeatures = (List)destination$iv$iv;
                Iterable $i$f$filterNot22 = this.$requiredOutput.selectMissingSignatures(provided);
                object = this.this$0;
                boolean $i$f$filterNot = false;
                void $i$f$filterNotTo22 = $this$filterNot$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterNotTo = false;
                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                    boolean bl;
                    block5: {
                        FeatureSignature missing = (FeatureSignature)element$iv$iv;
                        boolean bl2 = false;
                        Iterable $this$any$iv = ((FeatureTransformer)object).getOutput();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                FeatureSignature it = (FeatureSignature)element$iv;
                                boolean bl3 = false;
                                if (!missing.isSupersetOf(it)) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                    }
                    if (bl) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List originalMissing = (List)destination$iv$iv2;
                return CollectionsKt.plus((Collection)nonProvidedInputFeatures, (Iterable)originalMissing);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final Collection<Feature> preprocessFeatures(@NotNull Collection<? extends Feature> features, @NotNull FeatureSet requiredOutput) {
        void $this$filterNotTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        FeatureEntitySpecification it;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(features, (String)"features");
        Intrinsics.checkNotNullParameter((Object)requiredOutput, (String)"requiredOutput");
        Iterable $this$mapNotNull$iv = this.inputFeatures;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<Feature> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Feature it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            it = (FeatureSignature)element$iv$iv;
            boolean bl2 = false;
            if (FeatureSignatureKt.findFeatureMatching((Iterable<? extends Feature>)features, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List inputFeatureValues = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = inputFeatureValues;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Feature it2 = (Feature)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.transformFeature(it2, requiredOutput);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List transformedFeatures = (List)destination$iv$iv2;
        Iterable $this$filter$iv = features;
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Feature it3 = (Feature)element$iv$iv;
            boolean bl = false;
            if (!(!inputFeatureValues.contains(it3))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List otherFeatures = (List)destination$iv$iv3;
        Collection<Feature> extraFeatures = FeatureSet.Companion.selectFeaturesOnlyNotFrom(transformedFeatures, requiredOutput);
        if (!extraFeatures.isEmpty()) {
            boolean $i$a$-check-FeatureTransformer$preprocessFeatures$32 = false;
            String $i$a$-check-FeatureTransformer$preprocessFeatures$32 = "Preprocessor " + this + " as produced features that are not required in the output: " + extraFeatures;
            throw new IllegalStateException($i$a$-check-FeatureTransformer$preprocessFeatures$32.toString());
        }
        Iterable $this$filterNot$iv = transformedFeatures;
        boolean $i$f$filterNot = false;
        Iterable $i$f$filterTo22 = $this$filterNot$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Feature)element$iv$iv;
            boolean bl = false;
            if (FeatureSignatureKt.isDeclaredBy((Feature)it, (Iterable<? extends FeatureSignature>)this.getOutput())) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        List nonDeclared = (List)destination$iv$iv4;
        if (!nonDeclared.isEmpty()) {
            boolean bl = false;
            String string = "Preprocessor " + this + " has produced features that were not declared in the output: " + nonDeclared;
            throw new IllegalStateException(string.toString());
        }
        return CollectionsKt.plus((Collection)transformedFeatures, (Iterable)FeatureSet.Companion.selectOnlyFrom(otherFeatures, requiredOutput));
    }
}

