/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.openjdk.jmc.common.collection.IteratorToolkit;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemConsumer;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.util.PredicateToolkit;
import org.openjdk.jmc.flightrecorder.IParserStats;
import org.openjdk.jmc.flightrecorder.internal.EventArray;
import org.openjdk.jmc.flightrecorder.internal.EventArrays;
import org.openjdk.jmc.flightrecorder.internal.parser.ParserStats;

class EventCollection
implements IItemCollection,
IParserStats {
    private final Set<IType<IItem>> types = new HashSet<IType<IItem>>();
    private final ArrayList<EventTypeEntry> items;
    private final Set<IRange<IQuantity>> chunkRanges;
    private final ParserStats parserStats;

    static IItemCollection build(EventArrays events) {
        ArrayList<EventTypeEntry> items = new ArrayList<EventTypeEntry>(events.getArrays().length);
        for (EventArray ea : events.getArrays()) {
            EventTypeEntry entry = new EventTypeEntry(ea);
            items.add(entry);
        }
        return new EventCollection(items, events.getChunkTimeranges(), events.getParserStats());
    }

    private EventCollection(ArrayList<EventTypeEntry> items, Set<IRange<IQuantity>> chunkRanges, ParserStats parserStats) {
        this.items = items;
        this.chunkRanges = chunkRanges;
        this.parserStats = parserStats;
        for (EventTypeEntry e : items) {
            this.types.add(e.events.getType());
        }
    }

    @Override
    public EventCollection apply(IItemFilter filter) {
        ArrayList<EventTypeEntry> newEntries = new ArrayList<EventTypeEntry>();
        for (EventTypeEntry e : this.items) {
            IItemIterable newEntry = e.apply((Predicate)filter.getPredicate(e.events.getType()));
            if (PredicateToolkit.isTrueGuaranteed(((EventTypeEntry)newEntry).predicate)) {
                newEntries.add(e);
                continue;
            }
            if (PredicateToolkit.isFalseGuaranteed(((EventTypeEntry)newEntry).predicate)) continue;
            newEntries.add((EventTypeEntry)newEntry);
        }
        return new EventCollection(newEntries, this.chunkRanges, this.parserStats);
    }

    private static Iterator<IItem> buildIterator(IItem[] array, Predicate<? super IItem> filter) {
        if (EventCollection.isFiltered(filter)) {
            return IteratorToolkit.filter(IteratorToolkit.of(array), filter);
        }
        return IteratorToolkit.of(array);
    }

    private static boolean isFiltered(Predicate<?> filter) {
        return filter != null && !PredicateToolkit.isTrueGuaranteed(filter);
    }

    @Override
    public Iterator<IItemIterable> iterator() {
        return Collections.unmodifiableList(this.items).iterator();
    }

    @Override
    public boolean hasItems() {
        Iterator<EventTypeEntry> ii = this.items.iterator();
        while (ii.hasNext()) {
            if (!((IItemIterable)ii.next()).iterator().hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <V, C extends IItemConsumer<C>> V getAggregate(IAggregator<V, C> aggregator) {
        return EventCollection.aggregate(aggregator, this.items.iterator());
    }

    private static <V, C extends IItemConsumer<C>> V aggregate(final IAggregator<V, C> aggregator, final Iterator<? extends IItemIterable> items) {
        return aggregator.getValue(new Iterator<C>(){
            IItemIterable next = this.findNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public C next() {
                Object calc = aggregator.newItemConsumer(this.next.getType());
                Iterator iterator2 = this.next.iterator();
                while (iterator2.hasNext()) {
                    calc.consume((IItem)iterator2.next());
                }
                this.next = this.findNext();
                return calc;
            }

            IItemIterable findNext() {
                while (items.hasNext()) {
                    IItemIterable ii = (IItemIterable)items.next();
                    if (!aggregator.acceptType(ii.getType())) continue;
                    return ii;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    @Override
    public Set<IRange<IQuantity>> getUnfilteredTimeRanges() {
        return this.chunkRanges;
    }

    @Override
    public void forEachEventType(Consumer<IParserStats.IEventStats> consumer) {
        this.parserStats.forEachEventType(consumer);
    }

    @Override
    public short getMajorVersion() {
        return this.parserStats.getMajorVersion();
    }

    @Override
    public short getMinorVersion() {
        return this.parserStats.getMinorVersion();
    }

    @Override
    public int getChunkCount() {
        return this.parserStats.getChunkCount();
    }

    @Override
    public long getSkippedEventCount() {
        return this.parserStats.getSkippedEventCount();
    }

    @Override
    public long getEventCountByType(String eventTypeName) {
        return this.parserStats.getCount(eventTypeName);
    }

    @Override
    public long getEventTotalSizeByType(String eventTypeName) {
        return this.parserStats.getTotalSize(eventTypeName);
    }

    @Override
    public IItemCollection getConstantPools() {
        return this.parserStats.getConstantPools();
    }

    @Override
    public IItemCollection getConstants() {
        return this.parserStats.getConstants();
    }

    private static class EventTypeEntry
    implements IItemIterable {
        final EventArray events;
        final Predicate<IItem> predicate;

        EventTypeEntry(EventArray events) {
            this.events = events;
            this.predicate = PredicateToolkit.truePredicate();
        }

        EventTypeEntry(EventArray events, Predicate<IItem> predicate) {
            this.events = events;
            this.predicate = predicate;
        }

        @Override
        public IType<IItem> getType() {
            return this.events.getType();
        }

        @Override
        public Iterator<IItem> iterator() {
            return EventCollection.buildIterator(this.events.getEvents(), this.predicate);
        }

        @Override
        public boolean hasItems() {
            return this.iterator().hasNext();
        }

        @Override
        public long getItemCount() {
            if (EventCollection.isFiltered(this.predicate)) {
                long c = 0L;
                Iterator<IItem> it = this.iterator();
                while (it.hasNext()) {
                    it.next();
                    ++c;
                }
                return c;
            }
            return this.events.getEvents().length;
        }

        @Override
        public EventTypeEntry apply(Predicate<IItem> filter) {
            Predicate<IItem> newPredicate = PredicateToolkit.and(Arrays.asList(filter, this.predicate));
            return new EventTypeEntry(this.events, newPredicate);
        }
    }
}

