/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge.svg12;

import org.jetbrains.relocated.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.jetbrains.relocated.apache.batik.bridge.Bridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.GVTBuilder;
import org.jetbrains.relocated.apache.batik.bridge.SVGUtilities;
import org.jetbrains.relocated.apache.batik.gvt.CompositeGraphicsNode;
import org.jetbrains.relocated.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class XBLShadowTreeElementBridge
extends AbstractGraphicsNodeBridge {
    @Override
    public String getLocalName() {
        return "shadowTree";
    }

    @Override
    public String getNamespaceURI() {
        return "http://www.w3.org/2004/xbl";
    }

    @Override
    public Bridge getInstance() {
        return new XBLShadowTreeElementBridge();
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext ctx2, Element e) {
        if (!SVGUtilities.matchUserAgent(e, ctx2.getUserAgent())) {
            return null;
        }
        CompositeGraphicsNode cgn = new CompositeGraphicsNode();
        this.associateSVGContext(ctx2, e, cgn);
        return cgn;
    }

    @Override
    protected GraphicsNode instantiateGraphicsNode() {
        return null;
    }

    @Override
    public void buildGraphicsNode(BridgeContext ctx2, Element e, GraphicsNode node) {
        this.initializeDynamicSupport(ctx2, e, node);
    }

    @Override
    public boolean getDisplay(Element e) {
        return true;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public void handleDOMNodeInsertedEvent(MutationEvent evt) {
        if (evt.getTarget() instanceof Element) {
            this.handleElementAdded((CompositeGraphicsNode)this.node, this.e, (Element)((Object)evt.getTarget()));
        }
    }

    public void handleElementAdded(CompositeGraphicsNode gn, Node parent, Element childElt) {
        GVTBuilder builder = this.ctx.getGVTBuilder();
        GraphicsNode childNode = builder.build(this.ctx, childElt);
        if (childNode == null) {
            return;
        }
        int idx = -1;
        for (Node ps = childElt.getPreviousSibling(); ps != null; ps = ps.getPreviousSibling()) {
            GraphicsNode psgn;
            if (ps.getNodeType() != 1) continue;
            Element pse = (Element)ps;
            for (psgn = this.ctx.getGraphicsNode(pse); psgn != null && psgn.getParent() != gn; psgn = psgn.getParent()) {
            }
            if (psgn != null && (idx = gn.indexOf(psgn)) != -1) break;
        }
        gn.add(++idx, childNode);
    }
}

