/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.instrumentation;

import com.intellij.rt.coverage.data.TestDiscoveryProjectData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.ClassWriter;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenCloseFileTransformer
implements ClassFileTransformer {
    private static final List<ClassTransformation> CLASS_TRANSFORMATIONS = new LinkedList<ClassTransformation>(){
        {
            this.add(OpenCloseFileTransformer.access$000(FileOutputStream.class, "(Ljava/io/File;Z)V"));
            this.add(OpenCloseFileTransformer.access$000(FileInputStream.class, "(Ljava/io/File;)V"));
            this.add(OpenCloseFileTransformer.access$000(RandomAccessFile.class, "(Ljava/io/File;Ljava/lang/String;)V"));
            this.add(OpenCloseFileTransformer.access$000(ZipFile.class, "(Ljava/io/File;I)V"));
            this.addNotNull(OpenCloseFileTransformer.nioInputStreamTransformation());
        }

        /*
         * WARNING - void declaration
         */
        private void addNotNull(ClassTransformation transformation) {
            if (transformation != null) {
                void var1_1;
                this.add(var1_1);
            }
        }
    };
    private final HashMap<String, ClassTransformation> myClassTransformations = new HashMap();

    /*
     * WARNING - void declaration
     */
    public OpenCloseFileTransformer() {
        for (ClassTransformation ct : CLASS_TRANSFORMATIONS) {
            void var2_2;
            this.myClassTransformations.put(ct.myClass.getName().replace('.', '/'), (ClassTransformation)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        void var2_2;
        void var1_1;
        void var3_3;
        ClassTransformation ct = this.myClassTransformations.get(className);
        if (ct == null) {
            return classfileBuffer;
        }
        ClassReader cr = new ClassReader(classfileBuffer);
        ClassWriter cw = new ClassWriter(1);
        var3_3.accept(new ClassVisitor(this, 589824, cw, (ClassTransformation)var1_1){
            final /* synthetic */ ClassTransformation val$ct;
            final /* synthetic */ OpenCloseFileTransformer this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.val$ct = classTransformation;
                super((int)var2_2, (ClassVisitor)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                void var1_2;
                void var2_3;
                void var3_4;
                MethodVisitor base = super.visitMethod(access, name, desc, signature, exceptions);
                MethodTransformer methodTransformer = (MethodTransformer)this.val$ct.methodTransformers.get(name + (String)var3_4);
                if (methodTransformer == null) {
                    return base;
                }
                return var2_3.createVisitor((MethodVisitor)var1_2);
            }
        }, 4);
        System.out.println("Injected open/close file listeners into " + (String)var2_2);
        return cw.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public Class<?>[] classesToTransform() {
        void var1_1;
        LinkedList<Class> classes = new LinkedList<Class>();
        for (ClassTransformation t : this.myClassTransformations.values()) {
            void var3_3;
            classes.add(((ClassTransformation)var3_3).myClass);
        }
        return var1_1.toArray(new Class[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static ClassTransformation classTransformation(Class<?> c, String ctor) {
        void var1_1;
        Class<?> clazz;
        return new ClassTransformation((Class)clazz, new MethodTransformer[]{new MethodTransformer.CtorTransformer((String)var1_1), new MethodTransformer.CloseTransformer("close", "()V")});
    }

    /*
     * WARNING - void declaration
     */
    private static ClassTransformation nioInputStreamTransformation() {
        try {
            void var0;
            Class<?> filesClass = Class.forName("java.nio.file.Files");
            return new ClassTransformation((Class)var0, new MethodTransformer[]{new MethodTransformer("newInputStream(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/InputStream;"){
                {
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                final MethodVisitor createVisitor(MethodVisitor mv) {
                    void var1_1;
                    new MethodTransformer.Generator(mv).call(TestDiscoveryProjectData.class.getName(), "openPath", new Class[]{Object.class});
                    return super.createVisitor((MethodVisitor)var1_1);
                }
            }});
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ClassTransformation access$000(Class x0, String x1) {
        void var1_1;
        return OpenCloseFileTransformer.classTransformation(x0, (String)var1_1);
    }

    private static abstract class MethodTransformer {
        private final String signature;

        /*
         * WARNING - void declaration
         */
        MethodTransformer(String signature) {
            void var1_1;
            this.signature = var1_1;
        }

        void generate(Generator g) {
        }

        /*
         * WARNING - void declaration
         */
        MethodVisitor createVisitor(MethodVisitor base) {
            void var2_2;
            void var1_1;
            Generator cg = new Generator(base);
            return new MethodVisitor(this, 589824, (MethodVisitor)var1_1, (Generator)var2_2){
                final /* synthetic */ Generator val$cg;
                final /* synthetic */ MethodTransformer this$0;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$cg = generator;
                    super((int)var2_2, (MethodVisitor)var3_3);
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitInsn(int opcode) {
                    void var1_1;
                    switch (opcode) {
                        case 172: 
                        case 173: 
                        case 174: 
                        case 175: 
                        case 176: 
                        case 177: {
                            this.this$0.generate(this.val$cg);
                        }
                    }
                    super.visitInsn((int)var1_1);
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Generator
        extends MethodVisitor {
            /*
             * WARNING - void declaration
             */
            Generator(MethodVisitor mv) {
                super(589824, (MethodVisitor)var1_1);
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            private void createArray(String type, int size) {
                void var1_1;
                void var2_2;
                this.putConst((int)var2_2);
                this.visitTypeInsn(189, (String)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            private void putConst(int i) {
                void var1_1;
                if (i <= 5) {
                    this.visitInsn(i + 3);
                    return;
                }
                this.visitLdcInsn((int)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            private void pushConst(Object o) {
                void var1_1;
                if (o.getClass() == Class.class) {
                    o = Type.getType((Class)o);
                }
                this.visitLdcInsn(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            void call(String userClassName, String userMethodName, Class<?>[] argTypes) {
                int i;
                void var2_3;
                this.visitMethodInsn(184, "java/lang/ClassLoader", "getSystemClassLoader", "()Ljava/lang/ClassLoader;", false);
                this.pushConst(userClassName);
                this.visitMethodInsn(182, "java/lang/ClassLoader", "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", false);
                this.pushConst(var2_3);
                this.createArray("java/lang/Class", argTypes.length);
                for (i = 0; i < argTypes.length; ++i) {
                    this.visitInsn(89);
                    this.putConst(i);
                    this.pushConst(argTypes[i]);
                    this.visitInsn(83);
                }
                this.visitMethodInsn(182, "java/lang/Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", false);
                this.visitInsn(1);
                this.createArray("java/lang/Object", argTypes.length);
                for (i = 0; i < argTypes.length; ++i) {
                    this.visitInsn(89);
                    this.putConst(i);
                    this.visitIntInsn(25, i);
                    this.visitInsn(83);
                }
                this.visitMethodInsn(182, "java/lang/reflect/Method", "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", false);
            }
        }

        private static class CloseTransformer
        extends MethodTransformer {
            /*
             * WARNING - void declaration
             */
            CloseTransformer(String methodName, String desc) {
                super((String)var1_1 + (String)var2_2);
                void var2_2;
                void var1_1;
            }

            protected void generate(Generator g) {
                g.call(TestDiscoveryProjectData.class.getName(), "closeFile", new Class[]{Object.class});
            }
        }

        private static class CtorTransformer
        extends MethodTransformer {
            /*
             * WARNING - void declaration
             */
            CtorTransformer(String constructorDesc) {
                super("<init>" + (String)var1_1);
                void var1_1;
            }

            protected void generate(Generator g) {
                g.call(TestDiscoveryProjectData.class.getName(), "openFile", new Class[]{Object.class, File.class});
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ClassTransformation {
        private final Map<String, MethodTransformer> methodTransformers = new HashMap<String, MethodTransformer>();
        private final Class<?> myClass;

        /*
         * WARNING - void declaration
         */
        private ClassTransformation(Class<?> c, MethodTransformer ... methodTransformers) {
            void var2_2;
            void var1_1;
            this.myClass = var1_1;
            for (void s : var2_2) {
                this.methodTransformers.put(((MethodTransformer)s).signature, (MethodTransformer)s);
            }
        }
    }
}

