/*
 * Decompiled with CFR 0.152.
 */
package org.dita.index.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dita.dost.util.XMLUtils;
import org.dita.index.configuration.CharRange;
import org.dita.index.configuration.ConfigEntry;
import org.dita.index.configuration.ConfigEntryImpl;
import org.dita.index.configuration.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IndexConfiguration {
    private static final String ELEM_INDEX_CONFIGURATION_SET = "index.configuration.set";
    private static final String ELEM_INDEX_CONFIGURATION = "index.configuration";
    private static final String ELEM_INDEX_GROUPS = "index.groups";
    private static final String ELEM_INDEX_GROUP = "index.group";
    private static final String ELEM_GROUP_KEY = "group.key";
    private static final String ELEM_GROUP_LABEL = "group.label";
    private static final String ELEM_GROUP_MEMBERS = "group.members";
    private static final String ELEM_CHAR_SET = "char.set";
    private static final String ATTR_START_RANGE = "start-range";
    private static final String ATTR_END_RANGE = "end-range";
    private final List<ConfigEntry> entries = new ArrayList<ConfigEntry>();

    private IndexConfiguration() {
    }

    public List<ConfigEntry> getEntries() {
        return this.entries;
    }

    private void addEntry(ConfigEntry entry) {
        this.entries.add(entry);
    }

    public static IndexConfiguration parse(Document document) throws ParseException {
        String message = "Invalid configuration format";
        IndexConfiguration indexConfiguration = new IndexConfiguration();
        NodeList indexConfigurationSet = document.getElementsByTagName(ELEM_INDEX_CONFIGURATION_SET);
        if (indexConfigurationSet.getLength() != 1) {
            throw new ParseException(message);
        }
        Node indexConfigurationSetNode = indexConfigurationSet.item(0);
        if (indexConfigurationSetNode == null) {
            throw new ParseException(message);
        }
        Node indexConf = IndexConfiguration.getFirstNodeByName(ELEM_INDEX_CONFIGURATION, indexConfigurationSetNode.getChildNodes());
        if (indexConf == null) {
            throw new ParseException(message);
        }
        Node indexGroups = IndexConfiguration.getFirstNodeByName(ELEM_INDEX_GROUPS, indexConf.getChildNodes());
        if (indexGroups == null) {
            throw new ParseException(message);
        }
        List indexGroupChilds = XMLUtils.toList((NodeList)indexGroups.getChildNodes());
        for (Node node : indexGroupChilds) {
            if (!node.getNodeName().equals(ELEM_INDEX_GROUP)) continue;
            Node key = IndexConfiguration.getFirstNodeByName(ELEM_GROUP_KEY, node.getChildNodes());
            Node label = IndexConfiguration.getFirstNodeByName(ELEM_GROUP_LABEL, node.getChildNodes());
            Node members = IndexConfiguration.getFirstNodeByName(ELEM_GROUP_MEMBERS, node.getChildNodes());
            String keyValue = IndexConfiguration.getNodeValue(key);
            String labelValue = IndexConfiguration.getNodeValue(label);
            List<String> groupMembers = Collections.emptyList();
            ArrayList<CharRange> rangeList = new ArrayList<CharRange>();
            if (null != members && members.getChildNodes().getLength() > 0) {
                ArrayList<String> nodeValues = new ArrayList<String>();
                NodeList membersChilds = members.getChildNodes();
                for (int j = 0; j < membersChilds.getLength(); ++j) {
                    String nodeValue;
                    Node membersChild = membersChilds.item(j);
                    if (!membersChild.getNodeName().equals(ELEM_CHAR_SET)) continue;
                    if (membersChild.hasAttributes() && membersChild.getAttributes() != null) {
                        Node startRange = membersChild.getAttributes().getNamedItem(ATTR_START_RANGE);
                        Node endRange = membersChild.getAttributes().getNamedItem(ATTR_END_RANGE);
                        String startRangeText = IndexConfiguration.getNodeValue(startRange);
                        String endRangeText = IndexConfiguration.getNodeValue(endRange);
                        if (startRange != null && startRangeText.length() > 0 && endRange != null && endRangeText.length() > 0) {
                            CharRange range = new CharRange(startRangeText, endRangeText);
                            rangeList.add(range);
                            nodeValues.add(startRangeText);
                        }
                    }
                    if ((nodeValue = IndexConfiguration.getNodeValue(membersChild)).isEmpty()) continue;
                    nodeValues.add(nodeValue);
                }
                groupMembers = nodeValues;
            }
            ConfigEntryImpl configEntry = new ConfigEntryImpl(labelValue, keyValue, groupMembers);
            for (CharRange charRange : rangeList) {
                configEntry.addRange(charRange);
            }
            indexConfiguration.addEntry(configEntry);
        }
        return indexConfiguration;
    }

    private static String getNodeValue(Node node) {
        if (node.getNodeType() == 3) {
            return node.getNodeValue().trim();
        }
        StringBuilder res = new StringBuilder();
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String nodeValue = IndexConfiguration.getNodeValue(childNodes.item(i));
            res.append(nodeValue);
        }
        return res.toString().trim();
    }

    private static Node getFirstNodeByName(String nodeName, NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!nodeName.equals(node.getNodeName())) continue;
            return node;
        }
        return null;
    }
}

