/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.z.IntIterator;

public class OpCapture
extends Operation {
    int groupNr;
    Operation childOp;

    OpCapture(Operation childOp, int group) {
        this.childOp = childOp;
        this.groupNr = group;
    }

    @Override
    public int getMatchLength() {
        return this.childOp.getMatchLength();
    }

    @Override
    public int getMinimumMatchLength() {
        return this.childOp.getMinimumMatchLength();
    }

    @Override
    public int matchesEmptyString() {
        return this.childOp.matchesEmptyString();
    }

    @Override
    public Operation optimize(REProgram program, REFlags flags) {
        this.childOp = this.childOp.optimize(program, flags);
        return this;
    }

    @Override
    public int getMaxLoopingDepth() {
        return this.childOp.getMaxLoopingDepth();
    }

    @Override
    public IntIterator iterateMatches(final REMatcher matcher, final int position) {
        if ((matcher.program.optimizationFlags & 1) != 0) {
            matcher.startBackref[this.groupNr] = position;
        }
        final IntIterator basis = this.childOp.iterateMatches(matcher, position);
        return new IntIterator(){

            @Override
            public boolean hasNext() {
                return basis.hasNext();
            }

            @Override
            public int next() {
                int next = basis.next();
                if (OpCapture.this.groupNr >= matcher._captureState.parenCount) {
                    matcher._captureState.parenCount = OpCapture.this.groupNr + 1;
                }
                matcher.setParenStart(OpCapture.this.groupNr, position);
                matcher.setParenEnd(OpCapture.this.groupNr, next);
                if ((matcher.program.optimizationFlags & 1) != 0) {
                    matcher.startBackref[OpCapture.this.groupNr] = position;
                    matcher.endBackref[OpCapture.this.groupNr] = next;
                }
                return next;
            }
        };
    }

    @Override
    public String display() {
        return "(" + this.childOp.display() + ")";
    }
}

