/*
 * Decompiled with CFR 0.152.
 */
package com.idiominc.ws.opentopic.fo.index2;

import com.idiominc.ws.opentopic.fo.index2.IndexComparator;
import com.idiominc.ws.opentopic.fo.index2.IndexEntry;
import com.idiominc.ws.opentopic.fo.index2.IndexEntryFoundListener;
import com.idiominc.ws.opentopic.fo.index2.IndexGroup;
import com.idiominc.ws.opentopic.fo.index2.IndexGroupProcessor;
import com.idiominc.ws.opentopic.fo.index2.IndexPreprocessResult;
import com.idiominc.ws.opentopic.fo.index2.ProcessException;
import com.idiominc.ws.opentopic.fo.index2.configuration.IndexConfiguration;
import com.idiominc.ws.opentopic.fo.index2.util.IndexDitaProcessor;
import com.idiominc.ws.opentopic.fo.index2.util.IndexStringProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.util.Constants;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Deprecated
public final class IndexPreprocessor {
    public static final String VALUE_SEPARATOR = ":";
    private final String prefix;
    private final String namespace_url;
    private final Stack<Boolean> excludedDraftSection = new Stack();
    private final IndexDitaProcessor indexDitaProcessor;
    private final IndexGroupProcessor indexGroupProcessor;
    private boolean includeDraft = false;
    private DITAOTLogger logger;
    private XMLUtils xmlUtils;
    private static final String elIndexRangeStartName = "start";
    private static final String elIndexRangeEndName = "end";
    private static final String hashPrefix = "indexid";

    public IndexPreprocessor(String prefix, String theNamespace_url, String draftParameter) {
        this.prefix = prefix;
        this.namespace_url = theNamespace_url;
        this.excludedDraftSection.clear();
        this.excludedDraftSection.add(false);
        this.includeDraft = draftParameter.equals("yes");
        this.indexDitaProcessor = new IndexDitaProcessor();
        this.indexGroupProcessor = new IndexGroupProcessor();
    }

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
        this.indexDitaProcessor.setLogger(logger);
        this.indexGroupProcessor.setLogger(logger);
    }

    public void setXmlUtils(XMLUtils xmlUtils) {
        this.xmlUtils = xmlUtils;
    }

    public IndexPreprocessResult process(Document theInput) throws ProcessException {
        Document doc = this.xmlUtils.newDocument();
        Element rootElement = theInput.getDocumentElement();
        ArrayList indexes = new ArrayList();
        IndexEntryFoundListener listener = indexes::add;
        Node node = this.processCurrNode(rootElement, doc, listener)[0];
        doc.appendChild(node);
        doc.getDocumentElement().setAttribute("xmlns:" + this.prefix, this.namespace_url);
        return new IndexPreprocessResult(doc, indexes.toArray(new IndexEntry[0]));
    }

    public void createAndAddIndexGroups(IndexEntry[] theIndexEntries, IndexConfiguration theConfiguration, Document theDocument, Locale theLocale) {
        IndexComparator indexEntryComparator = new IndexComparator(theLocale);
        IndexGroup[] indexGroups = this.indexGroupProcessor.process(theIndexEntries, theConfiguration, theLocale);
        Element rootElement = theDocument.getDocumentElement();
        Element indexGroupsElement = theDocument.createElementNS(this.namespace_url, "index.groups");
        indexGroupsElement.setPrefix(this.prefix);
        for (IndexGroup group : indexGroups) {
            Node[] entryNodes;
            Element groupElement = theDocument.createElementNS(this.namespace_url, "index.group");
            groupElement.setPrefix(this.prefix);
            Element groupLabelElement = theDocument.createElementNS(this.namespace_url, "label");
            groupLabelElement.setPrefix(this.prefix);
            groupLabelElement.appendChild(theDocument.createTextNode(group.getLabel()));
            groupElement.appendChild(groupLabelElement);
            for (Node entryNode : entryNodes = this.transformToNodes(group.getEntries(), theDocument, indexEntryComparator)) {
                groupElement.appendChild(entryNode);
            }
            indexGroupsElement.appendChild(groupElement);
        }
        rootElement.appendChild(indexGroupsElement);
    }

    private Node[] processCurrNode(Node theNode, Document theTargetDocument, IndexEntryFoundListener theIndexEntryFoundListener) {
        NodeList childNodes = theNode.getChildNodes();
        if (this.checkElementName(theNode) && !this.excludedDraftSection.peek().booleanValue()) {
            return this.processIndexNode(theNode, theTargetDocument, theIndexEntryFoundListener);
        }
        Node result = theTargetDocument.importNode(theNode, false);
        if (!this.includeDraft && this.checkDraftNode(theNode)) {
            this.excludedDraftSection.add(true);
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node[] processedNodes;
            for (Node node : processedNodes = this.processCurrNode(childNodes.item(i), theTargetDocument, theIndexEntryFoundListener)) {
                result.appendChild(node);
            }
        }
        if (!this.includeDraft && this.checkDraftNode(theNode)) {
            this.excludedDraftSection.pop();
        }
        return new Node[]{result};
    }

    private Node[] processIndexNode(Node theNode, Document theTargetDocument, IndexEntryFoundListener theIndexEntryFoundListener) {
        theNode.normalize();
        boolean ditastyle = false;
        String textNode = null;
        NodeList childNodes = theNode.getChildNodes();
        StringBuilder textBuf = new StringBuilder();
        ArrayList<Node> contents = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (this.checkElementName(child)) {
                ditastyle = true;
                break;
            }
            if (child.getNodeType() == 1) {
                textBuf.append(XMLUtils.getStringValue((Element)((Element)child)));
                contents.add(child);
                continue;
            }
            if (child.getNodeType() != 3) continue;
            textBuf.append(child.getNodeValue());
            contents.add(child);
        }
        if ((textNode = IndexStringProcessor.normalizeTextValue(textBuf.toString())).length() == 0) {
            textNode = null;
        }
        if (theNode.getAttributes().getNamedItem(elIndexRangeStartName) != null || theNode.getAttributes().getNamedItem(elIndexRangeEndName) != null) {
            ditastyle = true;
        }
        ArrayList<Node> res = new ArrayList<Node>();
        if (ditastyle) {
            IndexEntry[] indexEntries;
            for (IndexEntry indexEntrie : indexEntries = this.indexDitaProcessor.processIndexDitaNode(theNode, "")) {
                theIndexEntryFoundListener.foundEntry(indexEntrie);
            }
            Node[] nodes = this.transformToNodes(indexEntries, theTargetDocument, null);
            res.addAll(Arrays.asList(nodes));
        } else if (textNode != null) {
            Node[] nodes = this.processIndexString(textNode, contents, theTargetDocument, theIndexEntryFoundListener);
            res.addAll(Arrays.asList(nodes));
        } else {
            return new Node[0];
        }
        return res.toArray(new Node[0]);
    }

    private boolean checkElementName(Node node) {
        return Constants.TOPIC_INDEXTERM.matches(node) || Constants.INDEXING_D_INDEX_SORT_AS.matches(node) || Constants.INDEXING_D_INDEX_SEE.matches(node) || Constants.INDEXING_D_INDEX_SEE_ALSO.matches(node);
    }

    private boolean checkDraftNode(Node node) {
        return Constants.TOPIC_DRAFT_COMMENT.matches(node) || Constants.TOPIC_REQUIRED_CLEANUP.matches(node);
    }

    private Node[] processIndexString(String theIndexString, List<Node> contents, Document theTargetDocument, IndexEntryFoundListener theIndexEntryFoundListener) {
        IndexEntry[] indexEntries;
        for (IndexEntry indexEntrie : indexEntries = IndexStringProcessor.processIndexString(theIndexString, contents)) {
            theIndexEntryFoundListener.foundEntry(indexEntrie);
        }
        return this.transformToNodes(indexEntries, theTargetDocument, null);
    }

    private Node[] transformToNodes(IndexEntry[] theIndexEntries, Document theTargetDocument, Comparator<IndexEntry> theIndexEntryComparator) {
        if (null != theIndexEntryComparator) {
            Arrays.sort(theIndexEntries, theIndexEntryComparator);
        }
        ArrayList<Element> result = new ArrayList<Element>();
        for (IndexEntry indexEntry : theIndexEntries) {
            IndexEntry[] seeAlsoChildIndexEntries;
            Node[] nodes;
            String sort;
            String[] refIDs;
            Element indexEntryNode = this.createElement(theTargetDocument, "index.entry");
            Element formattedStringElement = this.createElement(theTargetDocument, "formatted-value");
            if (indexEntry.getContents() != null) {
                Iterator<Node> i = indexEntry.getContents().iterator();
                while (i.hasNext()) {
                    String[] child = i.next();
                    Node clone = theTargetDocument.importNode((Node)child, true);
                    if (!i.hasNext() && clone.getNodeType() == 3) {
                        Text t = (Text)clone;
                        t.setData(t.getData().replaceAll("[\\s\\n]+$", ""));
                    }
                    formattedStringElement.appendChild(clone);
                }
            } else {
                Text textNode = theTargetDocument.createTextNode(indexEntry.getFormattedString());
                textNode.normalize();
                formattedStringElement.appendChild(textNode);
            }
            indexEntryNode.appendChild(formattedStringElement);
            for (String refID : refIDs = indexEntry.getRefIDs()) {
                Node[] referenceIDElement = this.createElement(theTargetDocument, "refID");
                referenceIDElement.setAttribute(hashPrefix, hashPrefix + refID.hashCode());
                referenceIDElement.setAttribute("value", refID);
                indexEntryNode.appendChild((Node)referenceIDElement);
            }
            String val = indexEntry.getValue();
            if (null != val) {
                indexEntryNode.setAttribute("value", val);
            }
            if (null != (sort = indexEntry.getSortString())) {
                indexEntryNode.setAttribute("sort-string", sort);
            }
            if (indexEntry.isStartingRange()) {
                indexEntryNode.setAttribute("start-range", "true");
            } else if (indexEntry.isEndingRange()) {
                indexEntryNode.setAttribute("end-range", "true");
            }
            if (indexEntry.isSuppressesThePageNumber()) {
                indexEntryNode.setAttribute("no-page", "true");
            } else if (indexEntry.isRestoresPageNumber()) {
                indexEntryNode.setAttribute("single-page", "true");
            }
            IndexEntry[] childIndexEntries = indexEntry.getChildIndexEntries();
            for (Node node : nodes = this.transformToNodes(childIndexEntries, theTargetDocument, theIndexEntryComparator)) {
                indexEntryNode.appendChild(node);
            }
            IndexEntry[] seeChildIndexEntries = indexEntry.getSeeChildIndexEntries();
            if (seeChildIndexEntries != null) {
                Node[] seeNodes;
                Element seeElement = this.createElement(theTargetDocument, "see-childs");
                for (Node node2 : seeNodes = this.transformToNodes(seeChildIndexEntries, theTargetDocument, theIndexEntryComparator)) {
                    seeElement.appendChild(node2);
                }
                indexEntryNode.appendChild(seeElement);
            }
            if ((seeAlsoChildIndexEntries = indexEntry.getSeeAlsoChildIndexEntries()) != null) {
                Node[] nodeArray;
                Element seeAlsoElement = this.createElement(theTargetDocument, "see-also-childs");
                for (Node node : nodeArray = this.transformToNodes(seeAlsoChildIndexEntries, theTargetDocument, theIndexEntryComparator)) {
                    seeAlsoElement.appendChild(node);
                }
                indexEntryNode.appendChild(seeAlsoElement);
            }
            result.add(indexEntryNode);
        }
        return result.toArray(new Node[0]);
    }

    private Element createElement(Document theTargetDocument, String theName) {
        Element indexEntryNode = theTargetDocument.createElementNS(this.namespace_url, theName);
        indexEntryNode.setPrefix(this.prefix);
        return indexEntryNode;
    }
}

