/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.serial.rxtx.rfc2217.internal;

import gnu.io.rfc2217.TelnetSerialPort;
import java.net.URI;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.serial.ProtocolType;
import org.openhab.core.io.transport.serial.SerialPortIdentifier;
import org.openhab.core.io.transport.serial.SerialPortProvider;
import org.openhab.core.io.transport.serial.rxtx.rfc2217.internal.SerialPortIdentifierImpl;
import org.osgi.service.component.annotations.Component;

@NonNullByDefault
@Component(service={SerialPortProvider.class})
public class RFC2217PortProvider
implements SerialPortProvider {
    private static final String PROTOCOL = "rfc2217";

    public @Nullable SerialPortIdentifier getPortIdentifier(URI portName) {
        TelnetSerialPort telnetSerialPort = new TelnetSerialPort();
        telnetSerialPort.setName(portName.toString());
        return new SerialPortIdentifierImpl(telnetSerialPort, portName);
    }

    public Stream<ProtocolType> getAcceptedProtocols() {
        return Stream.of(new ProtocolType(ProtocolType.PathType.NET, PROTOCOL));
    }

    public Stream<SerialPortIdentifier> getSerialPortIdentifiers() {
        return Stream.empty();
    }
}

