/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.utils;

import com.igormaznitsa.jbbp.JBBPCustomFieldTypeProcessor;
import com.igormaznitsa.jbbp.JBBPParser;
import com.igormaznitsa.jbbp.compiler.JBBPCompiledBlock;
import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.compiler.conversion.CompiledBlockVisitor;
import com.igormaznitsa.jbbp.compiler.conversion.IntConstValueEvaluator;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPFieldTypeParameterContainer;
import com.igormaznitsa.jbbp.compiler.varlen.JBBPIntegerValueEvaluator;
import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.utils.JBBPIntCounter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;

public final class JBBPUtils {
    public static final String[] ARRAY_STRING_EMPTY = new String[0];
    public static final JBBPAbstractField[] ARRAY_FIELD_EMPTY = new JBBPAbstractField[0];
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");

    private JBBPUtils() {
    }

    public static byte[] strToUtf8(String str) {
        ByteBuffer buffer = CHARSET_UTF8.encode(str);
        byte[] bytesArray = new byte[buffer.remaining()];
        buffer.get(bytesArray, 0, bytesArray.length);
        return bytesArray;
    }

    public static String utf8ToStr(byte[] array) {
        return CHARSET_UTF8.decode(ByteBuffer.wrap(array)).toString();
    }

    public static boolean isNumber(String num) {
        if (num == null || num.isEmpty()) {
            return false;
        }
        boolean firstIsDigit = Character.isDigit(num.charAt(0));
        if (!firstIsDigit && num.charAt(0) != '-') {
            return false;
        }
        boolean dig = firstIsDigit;
        for (int i = 1; i < num.length(); ++i) {
            if (!Character.isDigit(num.charAt(i))) {
                return false;
            }
            dig = true;
        }
        return dig;
    }

    public static byte[] packInt(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return new byte[]{(byte)value};
        }
        if ((value & 0xFFFF0000) == 0) {
            return new byte[]{-128, (byte)(value >>> 8), (byte)value};
        }
        return new byte[]{-127, (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static int packInt(byte[] array, JBBPIntCounter position, int value) {
        if ((value & 0xFFFFFF80) == 0) {
            array[position.getAndIncrement()] = (byte)value;
            return 1;
        }
        if ((value & 0xFFFF0000) == 0) {
            array[position.getAndIncrement()] = -128;
            array[position.getAndIncrement()] = (byte)(value >>> 8);
            array[position.getAndIncrement()] = (byte)value;
            return 3;
        }
        array[position.getAndIncrement()] = -127;
        array[position.getAndIncrement()] = (byte)(value >>> 24);
        array[position.getAndIncrement()] = (byte)(value >>> 16);
        array[position.getAndIncrement()] = (byte)(value >>> 8);
        array[position.getAndIncrement()] = (byte)value;
        return 5;
    }

    public static int unpackInt(byte[] array, JBBPIntCounter position) {
        int result;
        int code = array[position.getAndIncrement()] & 0xFF;
        if (code < 128) {
            return code;
        }
        switch (code) {
            case 128: {
                result = (array[position.getAndIncrement()] & 0xFF) << 8 | array[position.getAndIncrement()] & 0xFF;
                break;
            }
            case 129: {
                result = (array[position.getAndIncrement()] & 0xFF) << 24 | (array[position.getAndIncrement()] & 0xFF) << 16 | (array[position.getAndIncrement()] & 0xFF) << 8 | array[position.getAndIncrement()] & 0xFF;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported packed integer prefix [0x" + Integer.toHexString(code).toUpperCase(Locale.ENGLISH) + "]");
            }
        }
        return result;
    }

    public static String array2hex(byte[] array) {
        return JBBPUtils.byteArray2String(array, "0x", ", ", true, 16);
    }

    public static String array2bin(byte[] array) {
        return JBBPUtils.byteArray2String(array, "0b", ", ", true, 2);
    }

    public static String array2oct(byte[] array) {
        return JBBPUtils.byteArray2String(array, "0o", ", ", true, 8);
    }

    public static String byteArray2String(byte[] array, String prefix, String delimiter, boolean brackets, int radix) {
        if (array == null) {
            return null;
        }
        int maxLength = Integer.toString(255, radix).length();
        String zero = "00000000";
        String normDelimiter = delimiter == null ? " " : delimiter;
        String normPrefix = prefix == null ? "" : prefix;
        StringBuilder result = new StringBuilder(array.length * 4);
        if (brackets) {
            result.append('[');
        }
        boolean notFirst = false;
        for (byte b : array) {
            if (notFirst) {
                result.append(normDelimiter);
            } else {
                notFirst = true;
            }
            result.append(normPrefix);
            String v = Integer.toString(b & 0xFF, radix);
            if (v.length() < maxLength) {
                result.append("00000000", 0, maxLength - v.length());
            }
            result.append(v.toUpperCase(Locale.ENGLISH));
        }
        if (brackets) {
            result.append(']');
        }
        return result.toString();
    }

    public static byte reverseBitsInByte(byte value) {
        int v = value & 0xFF;
        return (byte)((v * 2050 & 0x22110 | v * 32800 & 0x88440) * 65793 >> 16);
    }

    public static byte reverseBitsInByte(JBBPBitNumber bitNumber, byte value) {
        byte reversed = JBBPUtils.reverseBitsInByte(value);
        return (byte)(reversed >>> 8 - bitNumber.getBitNumber() & bitNumber.getMask());
    }

    public static String bin2str(byte[] values) {
        return JBBPUtils.bin2str(values, JBBPBitOrder.LSB0, false);
    }

    public static String bin2str(byte[] values, boolean separateBytes) {
        return JBBPUtils.bin2str(values, JBBPBitOrder.LSB0, separateBytes);
    }

    public static String bin2str(byte[] values, JBBPBitOrder bitOrder, boolean separateBytes) {
        if (values == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(values.length * (separateBytes ? 9 : 8));
        boolean notFirst = false;
        for (int n : values) {
            int i;
            if (separateBytes) {
                if (notFirst) {
                    result.append(' ');
                } else {
                    notFirst = true;
                }
            }
            int a = n;
            if (bitOrder == JBBPBitOrder.MSB0) {
                for (i = 0; i < 8; ++i) {
                    result.append((a & 1) == 0 ? (char)'0' : '1');
                    a >>= 1;
                }
                continue;
            }
            for (i = 0; i < 8; ++i) {
                result.append((a & 0x80) == 0 ? (char)'0' : '1');
                a <<= 1;
            }
        }
        return result.toString();
    }

    public static List<JBBPAbstractField> fieldsAsList(JBBPAbstractField ... fields) {
        ArrayList<JBBPAbstractField> result = new ArrayList<JBBPAbstractField>();
        Collections.addAll(result, fields);
        return result;
    }

    public static byte[] str2bin(String values) {
        return JBBPUtils.str2bin(values, JBBPBitOrder.LSB0);
    }

    public static byte[] str2bin(String values, JBBPBitOrder bitOrder) {
        if (values == null) {
            return new byte[0];
        }
        int buff = 0;
        int cnt = 0;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(values.length() + 7 >> 3);
        boolean msb0 = bitOrder == JBBPBitOrder.MSB0;
        block5: for (char v : values.toCharArray()) {
            switch (v) {
                case ' ': 
                case '_': {
                    continue block5;
                }
                case '0': 
                case 'X': 
                case 'Z': 
                case 'x': 
                case 'z': {
                    if (msb0) {
                        buff >>= 1;
                        break;
                    }
                    buff <<= 1;
                    break;
                }
                case '1': {
                    if (msb0) {
                        buff = buff >> 1 | 0x80;
                        break;
                    }
                    buff = buff << 1 | 1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Detected unsupported char '" + v + "]");
                }
            }
            if (++cnt != 8) continue;
            buffer.write(buff);
            cnt = 0;
            buff = 0;
        }
        if (cnt > 0) {
            buffer.write(msb0 ? buff >>> 8 - cnt : buff);
        }
        return buffer.toByteArray();
    }

    public static String[] splitString(String str, char splitChar) {
        int length = str.length();
        StringBuilder builder = new StringBuilder(Math.max(8, length));
        int counter = 1;
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) != splitChar) continue;
            ++counter;
        }
        String[] result = new String[counter];
        int position = 0;
        for (int i = 0; i < length; ++i) {
            char chr = str.charAt(i);
            if (chr == splitChar) {
                result[position++] = builder.toString();
                builder.setLength(0);
                continue;
            }
            builder.append(chr);
        }
        if (position < result.length) {
            result[position] = builder.toString();
        }
        return result;
    }

    public static void assertNotNull(Object object, String message) {
        if (object == null) {
            throw new NullPointerException(message == null ? "Object is null" : message);
        }
    }

    public static String int2msg(int number) {
        return number + " (0x" + Long.toHexString((long)number & 0xFFFFFFFFL).toUpperCase(Locale.ENGLISH) + ")";
    }

    public static String normalizeFieldNameOrPath(String nameOrPath) {
        JBBPUtils.assertNotNull(nameOrPath, "Name of path must not be null");
        return nameOrPath.trim().toLowerCase(Locale.ENGLISH);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] str2UnicodeByteArray(JBBPByteOrder byteOrder, String str) {
        byte[] result = new byte[str.length() << 1];
        int index = 0;
        block4: for (int i = 0; i < str.length(); ++i) {
            char val = str.charAt(i);
            switch (byteOrder) {
                case BIG_ENDIAN: {
                    result[index++] = (byte)(val >> 8);
                    result[index++] = (byte)val;
                    continue block4;
                }
                case LITTLE_ENDIAN: {
                    result[index++] = (byte)val;
                    result[index++] = (byte)(val >> 8);
                    continue block4;
                }
                default: {
                    throw new Error("Unexpected byte order [" + String.valueOf((Object)byteOrder) + "]");
                }
            }
        }
        return result;
    }

    public static byte[] reverseArray(byte[] nullableArrayToBeInverted) {
        if (nullableArrayToBeInverted != null && nullableArrayToBeInverted.length > 0) {
            int indexStart = 0;
            for (int indexEnd = nullableArrayToBeInverted.length - 1; indexStart < indexEnd; ++indexStart, --indexEnd) {
                byte a = nullableArrayToBeInverted[indexStart];
                nullableArrayToBeInverted[indexStart] = nullableArrayToBeInverted[indexEnd];
                nullableArrayToBeInverted[indexEnd] = a;
            }
        }
        return nullableArrayToBeInverted;
    }

    public static byte[] splitInteger(int value, boolean valueInLittleEndian, byte[] buffer) {
        byte[] result = buffer == null || buffer.length < 4 ? new byte[4] : buffer;
        int tempValue = value;
        if (valueInLittleEndian) {
            for (int i = 0; i < 4; ++i) {
                result[i] = (byte)tempValue;
                tempValue >>>= 8;
            }
        } else {
            for (int i = 3; i >= 0; --i) {
                result[i] = (byte)tempValue;
                tempValue >>>= 8;
            }
        }
        return result;
    }

    public static byte[] splitLong(long value, boolean valueInLittleEndian, byte[] buffer) {
        byte[] result = buffer == null || buffer.length < 8 ? new byte[8] : buffer;
        long tempValue = value;
        if (valueInLittleEndian) {
            for (int i = 0; i < 8; ++i) {
                result[i] = (byte)tempValue;
                tempValue >>>= 8;
            }
        } else {
            for (int i = 7; i >= 0; --i) {
                result[i] = (byte)tempValue;
                tempValue >>>= 8;
            }
        }
        return result;
    }

    public static byte[] concat(byte[] ... arrays) {
        int len = 0;
        for (byte[] arr : arrays) {
            len += arr.length;
        }
        byte[] result = new byte[len];
        int pos = 0;
        for (byte[] arr : arrays) {
            System.arraycopy(arr, 0, result, pos, arr.length);
            pos += arr.length;
        }
        return result;
    }

    public static long reverseByteOrder(long value, int numOfLowerBytesToInvert) {
        if (numOfLowerBytesToInvert < 1 || numOfLowerBytesToInvert > 8) {
            throw new IllegalArgumentException("Wrong number of bytes [" + numOfLowerBytesToInvert + "]");
        }
        long result = 0L;
        int offsetInResult = (numOfLowerBytesToInvert - 1) * 8;
        while (numOfLowerBytesToInvert-- > 0) {
            long b = value & 0xFFL;
            value >>>= 8;
            result |= b << offsetInResult;
            offsetInResult -= 8;
        }
        return result;
    }

    public static String double2str(double doubleValue, int radix) {
        String result;
        if (radix != 10 && radix != 16) {
            throw new IllegalArgumentException("Illegal radix [" + radix + "]");
        }
        if (radix == 16) {
            String converted = Double.toHexString(doubleValue);
            boolean minus = converted.startsWith("-");
            if (minus) {
                converted = converted.substring(1);
            }
            if (converted.startsWith("0x")) {
                converted = converted.substring(2);
            }
            result = ((String)(minus ? "-" + converted : converted)).toUpperCase(Locale.ENGLISH);
        } else {
            result = Double.toString(doubleValue);
        }
        return result;
    }

    public static String float2str(float floatValue, int radix) {
        String result;
        if (radix != 10 && radix != 16) {
            throw new IllegalArgumentException("Illegal radix [" + radix + "]");
        }
        if (radix == 16) {
            String converted = Double.toHexString(floatValue);
            boolean minus = converted.startsWith("-");
            if (minus) {
                converted = converted.substring(1);
            }
            if (converted.startsWith("0x")) {
                converted = converted.substring(2);
            }
            result = ((String)(minus ? "-" + converted : converted)).toUpperCase(Locale.ENGLISH);
        } else {
            result = Double.toString(floatValue);
        }
        return result;
    }

    public static String ulong2str(long ulongValue, int radix, char[] charBuffer) {
        String result;
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("Illegal radix [" + radix + "]");
        }
        if (ulongValue == 0L) {
            return "0";
        }
        if (ulongValue > 0L) {
            result = Long.toString(ulongValue, radix).toUpperCase(Locale.ENGLISH);
        } else {
            char[] buffer = charBuffer == null || charBuffer.length < 64 ? new char[64] : charBuffer;
            int pos = buffer.length;
            long topPart = ulongValue >>> 32;
            long bottomPart = (ulongValue & 0xFFFFFFFFL) + (topPart % (long)radix << 32);
            topPart /= (long)radix;
            while ((bottomPart | topPart) > 0L) {
                int val = (int)(bottomPart % (long)radix);
                buffer[--pos] = (char)(val < 10 ? 48 + val : 65 + val - 10);
                bottomPart = bottomPart / (long)radix + (topPart % (long)radix << 32);
                topPart /= (long)radix;
            }
            result = new String(buffer, pos, buffer.length - pos);
        }
        return result;
    }

    public static String ensureMinTextLength(String text, int neededLen, char ch, int mode) {
        int number = neededLen - text.length();
        if (number <= 0) {
            return text;
        }
        StringBuilder result = new StringBuilder(neededLen);
        switch (mode) {
            case 0: {
                for (int i = 0; i < number; ++i) {
                    result.append(ch);
                }
                result.append(text);
                break;
            }
            case 1: {
                result.append(text);
                for (int i = 0; i < number; ++i) {
                    result.append(ch);
                }
                break;
            }
            default: {
                int leftField = number / 2;
                int rightField = number - leftField;
                while (leftField-- > 0) {
                    result.append(ch);
                }
                result.append(text);
                while (rightField-- > 0) {
                    result.append(ch);
                }
                break block0;
            }
        }
        return result.toString();
    }

    public static String removeLeadingZeros(String str) {
        String result = str;
        if (str != null && !str.isEmpty()) {
            char ch;
            int startIndex;
            for (startIndex = 0; startIndex < str.length() - 1 && (ch = str.charAt(startIndex)) == '0'; ++startIndex) {
            }
            if (startIndex > 0) {
                result = str.substring(startIndex);
            }
        }
        return result;
    }

    public static String removeTrailingZeros(String str) {
        String result = str;
        if (str != null && !str.isEmpty()) {
            char ch;
            int endIndex;
            for (endIndex = str.length(); endIndex > 1 && (ch = str.charAt(endIndex - 1)) == '0'; --endIndex) {
            }
            if (endIndex < str.length()) {
                result = str.substring(0, endIndex);
            }
        }
        return result;
    }

    public static boolean arrayStartsWith(byte[] array, byte[] str) {
        boolean result = false;
        if (array.length >= str.length) {
            result = true;
            int index = str.length;
            while (--index >= 0) {
                if (array[index] == str[index]) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean arrayEndsWith(byte[] array, byte[] str) {
        boolean result = false;
        if (array.length >= str.length) {
            result = true;
            int index = str.length;
            int arrayIndex = array.length;
            while (--index >= 0) {
                if (array[--arrayIndex] == str[index]) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static int makeMask(int value) {
        if (value == 0) {
            return 0;
        }
        if ((value & Integer.MIN_VALUE) != 0) {
            return -1;
        }
        int msk = 1;
        while ((msk <<= 1) <= value) {
        }
        return msk - 1;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static String toHexString(long value, int charsNum) {
        String result = Long.toHexString(value).toUpperCase(Locale.ENGLISH);
        if (charsNum >= result.length()) {
            StringBuilder buffer = new StringBuilder(charsNum);
            for (int i = 0; i < charsNum - result.length(); ++i) {
                buffer.append('0');
            }
            buffer.append(result);
            result = buffer.toString();
        }
        return result;
    }

    public static void traceData(InputStream inStream, PrintStream out) throws IOException {
        JBBPUtils.traceData(inStream, 4, 8, " ", " ", " | ", " ", '.', true, out);
    }

    public static void traceData(InputStream inStream, int valuesPerColumn, int columnsNumber, String afterAddressDelimiter, String interValueDelimiter, String interColumnDelimiter, String delimiterBeforeChars, char nonPrintableChar, boolean printAsChars, PrintStream out) throws IOException {
        long address = 0L;
        valuesPerColumn = valuesPerColumn <= 0 ? 1 : valuesPerColumn;
        int bytesPerLine = columnsNumber <= 0 ? 8 : columnsNumber * valuesPerColumn;
        StringBuilder charBuffer = printAsChars ? new StringBuilder(bytesPerLine) : null;
        int lineByteCounter = 0;
        boolean ending = false;
        while (!Thread.currentThread().isInterrupted()) {
            int nextData;
            if (ending) {
                nextData = -1;
            } else {
                nextData = inStream.read();
                boolean bl = ending = nextData < 0;
            }
            if (lineByteCounter == 0) {
                out.print(JBBPUtils.toHexString(address, 8));
                out.print(afterAddressDelimiter);
            }
            if (charBuffer != null) {
                charBuffer.append(nextData > 31 && nextData < 255 ? (char)nextData : nonPrintableChar);
            }
            out.print(nextData < 0 ? "--" : JBBPUtils.toHexString(nextData, 2));
            if (++lineByteCounter == bytesPerLine) {
                if (charBuffer != null) {
                    out.print(delimiterBeforeChars);
                    out.print(charBuffer);
                    charBuffer.setLength(0);
                }
                lineByteCounter = 0;
                address += (long)bytesPerLine;
                out.println();
                if (!ending) continue;
                break;
            }
            if (lineByteCounter % valuesPerColumn == 0) {
                out.print(interColumnDelimiter);
                continue;
            }
            out.print(interValueDelimiter);
        }
    }

    public static long findMaxStaticArraySize(String script, JBBPCustomFieldTypeProcessor customFieldTypeProcessor) {
        return JBBPUtils.findMaxStaticArraySize(script, customFieldTypeProcessor, (fieldName, wholeStream) -> 1);
    }

    public static long findMaxStaticArraySize(String script, JBBPCustomFieldTypeProcessor customFieldTypeProcessor, final BiFunction<JBBPNamedFieldInfo, Boolean, Integer> expectedStructArraySizeSupplier) {
        final AtomicLong maxFound = new AtomicLong();
        JBBPCompiledBlock compiledBlock = JBBPParser.prepare(script, customFieldTypeProcessor).getCompiledBlock();
        final ArrayList structSizeStack = new ArrayList();
        new CompiledBlockVisitor(0, compiledBlock){

            private Integer extractStaticArraySize(int compiledBlockOffset, JBBPIntegerValueEvaluator evaluator) {
                if (evaluator instanceof IntConstValueEvaluator) {
                    return evaluator.eval(null, compiledBlockOffset, this.compiledBlock, null);
                }
                return null;
            }

            private void processSize(int size) {
                long accum = size;
                for (Integer i : structSizeStack) {
                    accum = Math.multiplyExact(accum, (int)i);
                }
                maxFound.set(Math.max(accum, maxFound.get()));
            }

            @Override
            public void visitPrimitiveField(int offsetInCompiledBlock, int primitiveType, JBBPNamedFieldInfo nullableNameFieldInfo, JBBPByteOrder byteOrder, boolean readWholeStreamAsArray, boolean altFieldType, JBBPIntegerValueEvaluator nullableArraySize) {
                Integer staticSize;
                if (!readWholeStreamAsArray && (staticSize = this.extractStaticArraySize(offsetInCompiledBlock, nullableArraySize)) != null) {
                    this.processSize(staticSize);
                }
            }

            @Override
            public void visitBitField(int offsetInCompiledBlock, JBBPByteOrder byteOrder, JBBPNamedFieldInfo nullableNameFieldInfo, boolean readWholeStream, JBBPIntegerValueEvaluator notNullFieldSize, JBBPIntegerValueEvaluator nullableArraySize) {
                Integer staticSize;
                if (!readWholeStream && (staticSize = this.extractStaticArraySize(offsetInCompiledBlock, nullableArraySize)) != null) {
                    this.processSize(staticSize);
                }
            }

            @Override
            public void visitCustomField(int offsetInCompiledBlock, JBBPFieldTypeParameterContainer notNullFieldType, JBBPNamedFieldInfo nullableNameFieldInfo, JBBPByteOrder byteOrder, boolean readWholeStream, JBBPIntegerValueEvaluator nullableArraySizeEvaluator, JBBPIntegerValueEvaluator extraDataValueEvaluator) {
                Integer staticSize;
                if (!readWholeStream && (staticSize = this.extractStaticArraySize(offsetInCompiledBlock, nullableArraySizeEvaluator)) != null) {
                    this.processSize(staticSize);
                }
            }

            @Override
            public void visitVarField(int offsetInCompiledBlock, JBBPNamedFieldInfo nullableNameFieldInfo, JBBPByteOrder byteOrder, boolean readWholeStream, JBBPIntegerValueEvaluator nullableArraySize, JBBPIntegerValueEvaluator extraDataValue) {
                Integer staticSize;
                if (!readWholeStream && (staticSize = this.extractStaticArraySize(offsetInCompiledBlock, nullableArraySize)) != null) {
                    this.processSize(staticSize);
                }
            }

            @Override
            public void visitStructureStart(int offsetInCompiledBlock, JBBPByteOrder byteOrder, boolean readWholeStream, JBBPNamedFieldInfo nullableNameFieldInfo, JBBPIntegerValueEvaluator nullableArraySize) {
                if (readWholeStream) {
                    structSizeStack.add((Integer)expectedStructArraySizeSupplier.apply(nullableNameFieldInfo, readWholeStream));
                } else {
                    Integer staticSize = this.extractStaticArraySize(offsetInCompiledBlock, nullableArraySize);
                    if (staticSize == null) {
                        structSizeStack.add((Integer)expectedStructArraySizeSupplier.apply(nullableNameFieldInfo, readWholeStream));
                    } else {
                        this.processSize(staticSize);
                        structSizeStack.add(staticSize);
                    }
                }
            }

            @Override
            public void visitStructureEnd(int offsetInCompiledBlock, JBBPNamedFieldInfo nullableNameFieldInfo) {
                structSizeStack.remove(structSizeStack.size() - 1);
            }
        }.visit();
        if (!structSizeStack.isEmpty()) {
            throw new Error("Unexpectedly structure stack is not empty, contact developer!");
        }
        return maxFound.get();
    }
}

