/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.persistence.registry;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.persistence.PersistenceItemConfiguration;
import org.openhab.core.persistence.filter.PersistenceFilter;
import org.openhab.core.persistence.strategy.PersistenceStrategy;

@NonNullByDefault
public class PersistenceServiceConfiguration
implements Identifiable<String> {
    private final String serviceId;
    private final List<PersistenceItemConfiguration> configs;
    private final Map<String, String> aliases;
    private final List<PersistenceStrategy> strategies;
    private final List<PersistenceFilter> filters;

    public PersistenceServiceConfiguration(String serviceId, Collection<PersistenceItemConfiguration> configs, Map<String, String> aliases, Collection<PersistenceStrategy> strategies, Collection<PersistenceFilter> filters) {
        this.serviceId = serviceId;
        this.configs = List.copyOf(configs);
        this.aliases = Map.copyOf(aliases);
        this.strategies = List.copyOf(strategies);
        this.filters = List.copyOf(filters);
    }

    public String getUID() {
        return this.serviceId;
    }

    public List<PersistenceItemConfiguration> getConfigs() {
        return this.configs;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public List<PersistenceStrategy> getStrategies() {
        return this.strategies;
    }

    public List<PersistenceFilter> getFilters() {
        return this.filters;
    }
}

