/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arabe";
        final String metaValue_hy = "arménien";
        final String metaValue_ae = "avestique";
        final String metaValue_ban = "balinais";
        final String metaValue_bn = "bengali";
        final String metaValue_zbl = "symboles Bliss";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "copte";
        final String metaValue_ka = "géorgien";
        final String metaValue_got = "gotique";
        final String metaValue_el = "grec";
        final String metaValue_he = "hébreu";
        final String metaValue_jv = "javanais";
        final String metaValue_ja = "japonais";
        final String metaValue_km = "khmer";
        final String metaValue_ko = "coréen";
        final String metaValue_lo = "lao";
        final String metaValue_la = "latin";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birman";
        final String metaValue_nqo = "n’ko";
        final String metaValue_or = "odia";
        final String metaValue_phn = "phénicien";
        final String metaValue_saz = "saurashtra";
        final String metaValue_si = "cingalais";
        final String metaValue_syr = "syriaque";
        final String metaValue_ta = "tamoul";
        final String metaValue_te = "télougou";
        final String metaValue_th = "thaï";
        final String metaValue_bo = "tibétain";
        final String metaValue_uga = "ougaritique";
        final String metaValue_vai = "vaï";
        final Object[][] data = new Object[][] {
            { "001", "Monde" },
            { "002", "Afrique" },
            { "003", "Amérique du Nord" },
            { "005", "Amérique du Sud" },
            { "009", "Océanie" },
            { "011", "Afrique occidentale" },
            { "013", "Amérique centrale" },
            { "014", "Afrique orientale" },
            { "015", "Afrique septentrionale" },
            { "017", "Afrique centrale" },
            { "018", "Afrique australe" },
            { "019", "Amériques" },
            { "021", "Amérique septentrionale" },
            { "029", "Caraïbes" },
            { "030", "Asie de l’Est" },
            { "034", "Asie du Sud" },
            { "035", "Asie du Sud-Est" },
            { "039", "Europe du Sud" },
            { "053", "Australasie" },
            { "054", "Mélanésie" },
            { "057", "région micronésienne" },
            { "061", "Polynésie" },
            { "142", "Asie" },
            { "143", "Asie centrale" },
            { "145", "Asie de l’Ouest" },
            { "150", "Europe" },
            { "151", "Europe de l’Est" },
            { "154", "Europe du Nord" },
            { "155", "Europe de l’Ouest" },
            { "202", "Afrique subsaharienne" },
            { "419", "Amérique latine" },
            { "AC", "Île de l’Ascension" },
            { "AD", "Andorre" },
            { "AE", "Émirats arabes unis" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua-et-Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanie" },
            { "AM", "Arménie" },
            { "AO", "Angola" },
            { "AQ", "Antarctique" },
            { "AR", "Argentine" },
            { "AS", "Samoa américaines" },
            { "AT", "Autriche" },
            { "AU", "Australie" },
            { "AW", "Aruba" },
            { "AX", "Îles Åland" },
            { "AZ", "Azerbaïdjan" },
            { "BA", "Bosnie-Herzégovine" },
            { "BB", "Barbade" },
            { "BD", "Bangladesh" },
            { "BE", "Belgique" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarie" },
            { "BH", "Bahreïn" },
            { "BI", "Burundi" },
            { "BJ", "Bénin" },
            { "BL", "Saint-Barthélemy" },
            { "BM", "Bermudes" },
            { "BN", "Brunei" },
            { "BO", "Bolivie" },
            { "BQ", "Pays-Bas caribéens" },
            { "BR", "Brésil" },
            { "BS", "Bahamas" },
            { "BT", "Bhoutan" },
            { "BV", "Île Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Biélorussie" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Îles Cocos" },
            { "CD", "Congo-Kinshasa" },
            { "CF", "République centrafricaine" },
            { "CG", "Congo-Brazzaville" },
            { "CH", "Suisse" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Îles Cook" },
            { "CL", "Chili" },
            { "CM", "Cameroun" },
            { "CN", "Chine" },
            { "CO", "Colombie" },
            { "CP", "Île Clipperton" },
            { "CQ", "Sercq" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cap-Vert" },
            { "CW", "Curaçao" },
            { "CX", "Île Christmas" },
            { "CY", "Chypre" },
            { "CZ", "Tchéquie" },
            { "DE", "Allemagne" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Danemark" },
            { "DM", "Dominique" },
            { "DO", "République dominicaine" },
            { "DZ", "Algérie" },
            { "EA", "Ceuta et Melilla" },
            { "EC", "Équateur" },
            { "EE", "Estonie" },
            { "EG", "Égypte" },
            { "EH", "Sahara occidental" },
            { "ER", "Érythrée" },
            { "ES", "Espagne" },
            { "ET", "Éthiopie" },
            { "EU", "Union européenne" },
            { "EZ", "zone euro" },
            { "FI", "Finlande" },
            { "FJ", "Fidji" },
            { "FK", "Îles Malouines" },
            { "FM", "Micronésie" },
            { "FO", "Îles Féroé" },
            { "FR", "France" },
            { "GA", "Gabon" },
            { "GB", "Royaume-Uni" },
            { "GD", "Grenade" },
            { "GE", "Géorgie" },
            { "GF", "Guyane française" },
            { "GG", "Guernesey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenland" },
            { "GM", "Gambie" },
            { "GN", "Guinée" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guinée équatoriale" },
            { "GR", "Grèce" },
            { "GS", "Géorgie du Sud-et-les Îles Sandwich du Sud" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinée-Bissau" },
            { "GY", "Guyana" },
            { "HK", "R.A.S. chinoise de Hong Kong" },
            { "HM", "Îles Heard-et-MacDonald" },
            { "HN", "Honduras" },
            { "HR", "Croatie" },
            { "HT", "Haïti" },
            { "HU", "Hongrie" },
            { "IC", "Îles Canaries" },
            { "ID", "Indonésie" },
            { "IE", "Irlande" },
            { "IL", "Israël" },
            { "IM", "Île de Man" },
            { "IN", "Inde" },
            { "IO", "Territoire britannique de l’océan Indien" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islande" },
            { "IT", "Italie" },
            { "JE", "Jersey" },
            { "JM", "Jamaïque" },
            { "JO", "Jordanie" },
            { "JP", "Japon" },
            { "KE", "Kenya" },
            { "KG", "Kirghizstan" },
            { "KH", "Cambodge" },
            { "KI", "Kiribati" },
            { "KM", "Comores" },
            { "KN", "Saint-Christophe-et-Niévès" },
            { "KP", "Corée du Nord" },
            { "KR", "Corée du Sud" },
            { "KW", "Koweït" },
            { "KY", "Îles Caïmans" },
            { "KZ", "Kazakhstan" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Sainte-Lucie" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituanie" },
            { "LU", "Luxembourg" },
            { "LV", "Lettonie" },
            { "LY", "Libye" },
            { "MA", "Maroc" },
            { "MC", "Monaco" },
            { "MD", "Moldavie" },
            { "ME", "Monténégro" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagascar" },
            { "MH", "Îles Marshall" },
            { "MK", "Macédoine du Nord" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmanie)" },
            { "MN", "Mongolie" },
            { "MO", "R.A.S. chinoise de Macao" },
            { "MP", "Îles Mariannes du Nord" },
            { "MQ", "Martinique" },
            { "MR", "Mauritanie" },
            { "MS", "Montserrat" },
            { "MT", "Malte" },
            { "MU", "Maurice" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexique" },
            { "MY", "Malaisie" },
            { "MZ", "Mozambique" },
            { "NA", "Namibie" },
            { "NC", "Nouvelle-Calédonie" },
            { "NE", "Niger" },
            { "NF", "Île Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Pays-Bas" },
            { "NO", "Norvège" },
            { "NP", "Népal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nouvelle-Zélande" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Pérou" },
            { "PF", "Polynésie française" },
            { "PG", "Papouasie-Nouvelle-Guinée" },
            { "PH", "Philippines" },
            { "PK", "Pakistan" },
            { "PL", "Pologne" },
            { "PM", "Saint-Pierre-et-Miquelon" },
            { "PN", "Îles Pitcairn" },
            { "PR", "Porto Rico" },
            { "PS", "Territoires palestiniens" },
            { "PT", "Portugal" },
            { "PW", "Palaos" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "régions éloignées de l’Océanie" },
            { "RE", "La Réunion" },
            { "RO", "Roumanie" },
            { "RS", "Serbie" },
            { "RU", "Russie" },
            { "RW", "Rwanda" },
            { "SA", "Arabie saoudite" },
            { "SB", "Îles Salomon" },
            { "SC", "Seychelles" },
            { "SD", "Soudan" },
            { "SE", "Suède" },
            { "SG", "Singapour" },
            { "SH", "Sainte-Hélène" },
            { "SI", "Slovénie" },
            { "SJ", "Svalbard et Jan Mayen" },
            { "SK", "Slovaquie" },
            { "SL", "Sierra Leone" },
            { "SM", "Saint-Marin" },
            { "SN", "Sénégal" },
            { "SO", "Somalie" },
            { "SR", "Suriname" },
            { "SS", "Soudan du Sud" },
            { "ST", "Sao Tomé-et-Principe" },
            { "SV", "Salvador" },
            { "SX", "Saint-Martin (partie néerlandaise)" },
            { "SY", "Syrie" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Îles Turques-et-Caïques" },
            { "TD", "Tchad" },
            { "TF", "Terres australes françaises" },
            { "TG", "Togo" },
            { "TH", "Thaïlande" },
            { "TJ", "Tadjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor oriental" },
            { "TM", "Turkménistan" },
            { "TN", "Tunisie" },
            { "TO", "Tonga" },
            { "TR", "Turquie" },
            { "TT", "Trinité-et-Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taïwan" },
            { "TZ", "Tanzanie" },
            { "UA", "Ukraine" },
            { "UG", "Ouganda" },
            { "UM", "Îles mineures éloignées des États-Unis" },
            { "UN", "Nations Unies" },
            { "US", "États-Unis" },
            { "UY", "Uruguay" },
            { "UZ", "Ouzbékistan" },
            { "VA", "État de la Cité du Vatican" },
            { "VC", "Saint-Vincent-et-les Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Îles Vierges britanniques" },
            { "VI", "Îles Vierges des États-Unis" },
            { "VN", "Viêt Nam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis-et-Futuna" },
            { "WS", "Samoa" },
            { "XA", "pseudo-accents" },
            { "XB", "pseudo-bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yémen" },
            { "YT", "Mayotte" },
            { "ZA", "Afrique du Sud" },
            { "ZM", "Zambie" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "région inconnue" },
            { "aa", "afar" },
            { "ab", "abkhaze" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amharique" },
            { "an", "aragonais" },
            { "ar", metaValue_ar },
            { "as", "assamais" },
            { "av", "avar" },
            { "ay", "aymara" },
            { "az", "azerbaïdjanais" },
            { "ba", "bachkir" },
            { "be", "biélorusse" },
            { "bg", "bulgare" },
            { "bi", "bichelamar" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "breton" },
            { "bs", "bosniaque" },
            { "ca", "catalan" },
            { "ce", "tchétchène" },
            { "ch", "chamorro" },
            { "co", "corse" },
            { "cr", "cree" },
            { "cs", "tchèque" },
            { "cu", "slavon d’église" },
            { "cv", "tchouvache" },
            { "cy", "gallois" },
            { "da", "danois" },
            { "de", "allemand" },
            { "dv", "maldivien" },
            { "dz", "dzongkha" },
            { "ee", "éwé" },
            { "el", metaValue_el },
            { "en", "anglais" },
            { "eo", "espéranto" },
            { "es", "espagnol" },
            { "et", "estonien" },
            { "eu", "basque" },
            { "fa", "persan" },
            { "ff", "peul" },
            { "fi", "finnois" },
            { "fj", "fidjien" },
            { "fo", "féroïen" },
            { "fr", "français" },
            { "fy", "frison occidental" },
            { "ga", "irlandais" },
            { "gd", "gaélique écossais" },
            { "gl", "galicien" },
            { "gn", "guarani" },
            { "gu", "goudjarati" },
            { "gv", "mannois" },
            { "ha", "haoussa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "croate" },
            { "ht", "créole haïtien" },
            { "hu", "hongrois" },
            { "hy", metaValue_hy },
            { "hz", "héréro" },
            { "ia", "interlingua" },
            { "id", "indonésien" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yi du Sichuan" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "islandais" },
            { "it", "italien" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "kikongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazakh" },
            { "kl", "groenlandais" },
            { "km", metaValue_km },
            { "kn", "kannada" },
            { "ko", metaValue_ko },
            { "kr", "kanouri" },
            { "ks", "cachemiri" },
            { "ku", "kurmandji" },
            { "kv", "komi" },
            { "kw", "cornique" },
            { "ky", "kirghize" },
            { "la", metaValue_la },
            { "lb", "luxembourgeois" },
            { "lg", "ganda" },
            { "li", "limbourgeois" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituanien" },
            { "lu", "luba-katanga (kiluba)" },
            { "lv", "letton" },
            { "mg", "malgache" },
            { "mh", "marshallais" },
            { "mi", "maori" },
            { "mk", "macédonien" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malais" },
            { "mt", "maltais" },
            { "my", metaValue_my },
            { "na", "nauruan" },
            { "nb", "norvégien bokmål" },
            { "nd", "ndébélé du Nord" },
            { "ne", "népalais" },
            { "ng", "ndonga" },
            { "nl", "néerlandais" },
            { "nn", "norvégien nynorsk" },
            { "no", "norvégien" },
            { "nr", "ndébélé du Sud" },
            { "nv", "navajo" },
            { "ny", "chewa" },
            { "oc", "occitan" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "ossète" },
            { "pa", "pendjabi" },
            { "pi", "pali" },
            { "pl", "polonais" },
            { "ps", "pachto" },
            { "pt", "portugais" },
            { "qu", "quechua" },
            { "rm", "romanche" },
            { "rn", "roundi" },
            { "ro", "roumain" },
            { "ru", "russe" },
            { "rw", "kinyarwanda" },
            { "sa", "sanskrit" },
            { "sc", "sarde" },
            { "sd", "sindhi" },
            { "se", "same du Nord" },
            { "sg", "sango" },
            { "sh", "serbo-croate" },
            { "si", metaValue_si },
            { "sk", "slovaque" },
            { "sl", "slovène" },
            { "sm", "samoan" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "albanais" },
            { "sr", "serbe" },
            { "ss", "swati" },
            { "st", "sotho du Sud" },
            { "su", "soundanais" },
            { "sv", "suédois" },
            { "sw", "swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tadjik" },
            { "th", metaValue_th },
            { "ti", "tigrigna" },
            { "tk", "turkmène" },
            { "tl", "tagalog" },
            { "tn", "tswana" },
            { "to", "tongien" },
            { "tr", "turc" },
            { "ts", "tsonga" },
            { "tt", "tatar" },
            { "tw", "twi" },
            { "ty", "tahitien" },
            { "ug", "ouïghour" },
            { "uk", "ukrainien" },
            { "ur", "ourdou" },
            { "uz", "ouzbek" },
            { "ve", "venda" },
            { "vi", "vietnamien" },
            { "vo", "volapük" },
            { "wa", "wallon" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "yiddish" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "chinois" },
            { "zu", "zoulou" },
            { "ace", "aceh" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adyguéen" },
            { "aeb", "arabe tunisien" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "aïnou" },
            { "akk", "akkadien" },
            { "akz", "alabama" },
            { "ale", "aléoute" },
            { "aln", "guègue" },
            { "alt", "altaï du Sud" },
            { "ang", "ancien anglais" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "araméen" },
            { "arn", "mapuche" },
            { "aro", "araona" },
            { "arp", "arapaho" },
            { "arq", "arabe algérien" },
            { "ars", "arabe najdi" },
            { "arw", "arawak" },
            { "ary", "arabe marocain" },
            { "arz", "arabe égyptien" },
            { "asa", "asu" },
            { "ase", "langue des signes américaine" },
            { "ast", "asturien" },
            { "atj", "atikamekw" },
            { "avk", "kotava" },
            { "awa", "awadhi" },
            { "bal", "baloutchi" },
            { "ban", metaValue_ban },
            { "bar", "bavarois" },
            { "bas", "bassa" },
            { "bax", "bamoun" },
            { "bbc", "batak toba" },
            { "bbj", "ghomalaʼ" },
            { "bej", "bedja" },
            { "bem", "bemba" },
            { "bew", "betawi" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bfq", "badaga" },
            { "bgc", "haryanvi" },
            { "bgn", "baloutchi occidental" },
            { "bho", "bhodjpouri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bjn", "banjar" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "bpy", "bishnupriya" },
            { "bqi", "bakhtiari" },
            { "bra", "braj" },
            { "brh", "brahoui" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "bouriate" },
            { "bug", "bugi" },
            { "bum", "boulou" },
            { "byn", "blin" },
            { "byv", "médumba" },
            { "cad", "caddo" },
            { "car", "caribe" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", "changma kodha" },
            { "ceb", "cebuano" },
            { "cgg", "kiga" },
            { "chb", "chibcha" },
            { "chg", "tchaghataï" },
            { "chk", "chuuk" },
            { "chm", "mari" },
            { "chn", "jargon chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "cheyenne" },
            { "ckb", "sorani" },
            { "clc", "chilcotin" },
            { "cop", metaValue_cop },
            { "cps", "capiznon" },
            { "crg", "mitchif" },
            { "crh", "tatar de Crimée" },
            { "crj", "cri de l’Est (dialecte du Sud)" },
            { "crk", "cri des plaines" },
            { "crl", "cri de l’Est (dialecte du Nord)" },
            { "crm", "cri de Moose" },
            { "crr", "algonquin de Caroline" },
            { "crs", "créole seychellois" },
            { "csb", "kachoube" },
            { "csw", "cri des marais" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "esclave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "bas-sorabe" },
            { "dtp", "dusun central" },
            { "dua", "douala" },
            { "dum", "moyen néerlandais" },
            { "dyo", "diola-fogny" },
            { "dyu", "dioula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "éfik" },
            { "egl", "émilien" },
            { "egy", "égyptien ancien" },
            { "eka", "ékadjouk" },
            { "elx", "élamite" },
            { "enm", "moyen anglais" },
            { "esu", "youpik central" },
            { "ewo", "éwondo" },
            { "ext", "estrémègne" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipino" },
            { "fit", "finnois tornédalien" },
            { "fon", "fon" },
            { "frc", "français cadien" },
            { "frm", "moyen français" },
            { "fro", "ancien français" },
            { "frp", "francoprovençal" },
            { "frr", "frison septentrional" },
            { "frs", "frison oriental" },
            { "fur", "frioulan" },
            { "gaa", "ga" },
            { "gag", "gagaouze" },
            { "gan", "gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gbz", "dari zoroastrien" },
            { "gez", "guèze" },
            { "gil", "gilbertin" },
            { "glk", "gilaki" },
            { "gmh", "moyen haut-allemand" },
            { "goh", "ancien haut allemand" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "grec ancien" },
            { "gsw", "suisse allemand" },
            { "guc", "wayuu" },
            { "gur", "gurenne" },
            { "guz", "gusii" },
            { "gwi", "gwichʼin" },
            { "hai", "haïda" },
            { "hak", "hakka" },
            { "haw", "hawaïen" },
            { "hax", "haïda du Sud" },
            { "hif", "hindi fidjien" },
            { "hil", "hiligaynon" },
            { "hit", "hittite" },
            { "hmn", "hmong" },
            { "hsb", "haut-sorabe" },
            { "hsn", "xiang" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut de l’Ouest canadien" },
            { "ilo", "ilocano" },
            { "inh", "ingouche" },
            { "izh", "ingrien" },
            { "jam", "créole jamaïcain" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "matchamé" },
            { "jpr", "judéo-persan" },
            { "jrb", "judéo-arabe" },
            { "jut", "jute" },
            { "kaa", "karakalpak" },
            { "kab", "kabyle" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabarde" },
            { "kbl", "kanembou" },
            { "kcg", "tyap" },
            { "kde", "makondé" },
            { "kea", "capverdien" },
            { "ken", "kényang" },
            { "kfo", "koro" },
            { "kgp", "caingangue" },
            { "kha", "khasi" },
            { "kho", "khotanais" },
            { "khq", "koyra chiini" },
            { "khw", "khowar" },
            { "kiu", "kirmanjki" },
            { "kkj", "kako" },
            { "kln", "kalendjin" },
            { "kmb", "kimboundou" },
            { "koi", "komi-permiak" },
            { "kok", "konkani" },
            { "kos", "kosraéen" },
            { "kpe", "kpellé" },
            { "krc", "karatchaï balkar" },
            { "kri", "krio" },
            { "krj", "kinaray-a" },
            { "krl", "carélien" },
            { "kru", "kouroukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "kölsch" },
            { "kum", "koumyk" },
            { "kut", "kutenai" },
            { "kwk", "kwak’wala" },
            { "kxv", "kuvi" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezghien" },
            { "lfn", "lingua franca nova" },
            { "lij", "ligure" },
            { "lil", "lillooet" },
            { "liv", "livonien" },
            { "lkt", "lakota" },
            { "lmo", "lombard" },
            { "lol", "mongo" },
            { "lou", "créole louisianais" },
            { "loz", "lozi" },
            { "lrc", "lori du Nord" },
            { "lsm", "samia" },
            { "ltg", "latgalien" },
            { "lua", "luba-kasaï (ciluba)" },
            { "lui", "luiseño" },
            { "lun", "lunda" },
            { "lus", "lushaï" },
            { "luy", "luyia" },
            { "lzh", "chinois littéraire" },
            { "lzz", "laze" },
            { "mad", "madurais" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maïthili" },
            { "mak", "makassar" },
            { "man", "mandingue" },
            { "mas", "maasaï" },
            { "mde", "maba" },
            { "mdf", "mokcha" },
            { "mdr", "mandar" },
            { "men", "mendé" },
            { "mer", "meru" },
            { "mfe", "créole mauricien" },
            { "mga", "moyen irlandais" },
            { "mgh", "makua" },
            { "mgo", "metaʼ" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "mandchou" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "moré" },
            { "mrj", "mari occidental" },
            { "mua", "moundang" },
            { "mul", "multilingue" },
            { "mus", "creek" },
            { "mwl", "mirandais" },
            { "mwr", "marwarî" },
            { "mwv", "mentawaï" },
            { "mye", "myènè" },
            { "myv", "erzya" },
            { "mzn", "mazandérani" },
            { "nan", "minnan" },
            { "nap", "napolitain" },
            { "naq", "nama" },
            { "nds", "bas-allemand" },
            { "new", "newari" },
            { "nia", "niha" },
            { "niu", "niuéen" },
            { "njo", "ao" },
            { "nmg", "ngoumba" },
            { "nnh", "ngiemboon" },
            { "nog", "nogaï" },
            { "non", "vieux norrois" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "sotho du Nord" },
            { "nus", "nuer" },
            { "nwc", "newarî classique" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankolé" },
            { "nyo", "nyoro" },
            { "nzi", "nzema" },
            { "ojb", "ojibwé du Nord-Ouest" },
            { "ojc", "ojibwé central" },
            { "ojs", "oji-cri" },
            { "ojw", "ojibwé occidental" },
            { "oka", "colville-okanagan" },
            { "osa", "osage" },
            { "ota", "turc ottoman" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampangan" },
            { "pap", "papiamento" },
            { "pau", "palau" },
            { "pcd", "picard" },
            { "pcm", "pidgin nigérian" },
            { "pdc", "pennsilfaanisch" },
            { "pdt", "bas-prussien" },
            { "peo", "persan ancien" },
            { "pfl", "allemand palatin" },
            { "phn", metaValue_phn },
            { "pis", "pijin" },
            { "pms", "piémontais" },
            { "pnt", "pontique" },
            { "pon", "pohnpei" },
            { "pqm", "malécite-passamaquoddy" },
            { "prg", "prussien" },
            { "pro", "provençal ancien" },
            { "quc", "quiché" },
            { "qug", "quichua du Haut-Chimborazo" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotongien" },
            { "rgn", "romagnol" },
            { "rhg", "rohingya" },
            { "rif", "rifain" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rtm", "rotuman" },
            { "rue", "ruthène" },
            { "rug", "roviana" },
            { "rup", "aroumain" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "iakoute" },
            { "sam", "araméen samaritain" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "saz", metaValue_saz },
            { "sba", "ngambay" },
            { "sbp", "isangu" },
            { "scn", "sicilien" },
            { "sco", "écossais" },
            { "sdc", "sarde sassarais" },
            { "sdh", "kurde du Sud" },
            { "see", "seneca" },
            { "seh", "cisena" },
            { "sei", "séri" },
            { "sel", "selkoupe" },
            { "ses", "koyraboro senni" },
            { "sga", "ancien irlandais" },
            { "sgs", "samogitien" },
            { "shi", "chleuh" },
            { "shn", "shan" },
            { "shu", "arabe tchadien" },
            { "sid", "sidamo" },
            { "slh", "lushootseed du Sud" },
            { "sli", "bas-silésien" },
            { "sly", "sélayar" },
            { "sma", "same du Sud" },
            { "smj", "same de Lule" },
            { "smn", "same d’Inari" },
            { "sms", "same skolt" },
            { "snk", "soninké" },
            { "sog", "sogdien" },
            { "srn", "sranan tongo" },
            { "srr", "sérère" },
            { "ssy", "saho" },
            { "stq", "saterlandais" },
            { "str", "salish des détroits" },
            { "suk", "soukouma" },
            { "sus", "soussou" },
            { "sux", "sumérien" },
            { "swb", "comorien" },
            { "syc", "syriaque classique" },
            { "syr", metaValue_syr },
            { "szl", "silésien" },
            { "tce", "tutchone du Sud" },
            { "tcy", "toulou" },
            { "tem", "timné" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tétoum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigré" },
            { "tiv", "tiv" },
            { "tkl", "tokelau" },
            { "tkr", "tsakhour" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tly", "talysh" },
            { "tmh", "tamacheq" },
            { "tog", "tonga nyasa" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "tru", "touroyo" },
            { "trv", "taroko" },
            { "tsd", "tsakonien" },
            { "tsi", "tsimshian" },
            { "ttm", "tutchone du Nord" },
            { "ttt", "tati caucasien" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawaq" },
            { "tyv", "touvain" },
            { "tzm", "amazighe de l’Atlas central" },
            { "udm", "oudmourte" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "langue indéterminée" },
            { "vai", metaValue_vai },
            { "vec", "vénitien" },
            { "vep", "vepse" },
            { "vls", "flamand occidental" },
            { "vmf", "franconien du Main" },
            { "vmw", "macua" },
            { "vot", "vote" },
            { "vro", "võro" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "walamo" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "wu" },
            { "xal", "kalmouk" },
            { "xmf", "mingrélien" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "yapois" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatou" },
            { "yue", "cantonais" },
            { "zap", "zapotèque" },
            { "zbl", metaValue_zbl },
            { "zea", "zélandais" },
            { "zen", "zenaga" },
            { "zgh", "amazighe standard marocain" },
            { "zun", "zuñi" },
            { "zxx", "sans contenu linguistique" },
            { "zza", "zazaki" },
            { "Adlm", "adlam" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armi", "araméen impérial" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Blis", metaValue_zbl },
            { "Bopo", "bopomofo" },
            { "Brah", "brâhmî" },
            { "Brai", "braille" },
            { "Bugi", "bouguis" },
            { "Buhd", "bouhide" },
            { "Cakm", "chakma" },
            { "Cans", "syllabaire autochtone canadien unifié" },
            { "Cari", "carien" },
            { "Cham", "cham" },
            { "Cher", metaValue_chr },
            { "Cirt", "cirth" },
            { "Copt", metaValue_cop },
            { "Cprt", "syllabaire chypriote" },
            { "Cyrl", "cyrillique" },
            { "Cyrs", "cyrillique (variante slavonne)" },
            { "Deva", "dévanagari" },
            { "Dsrt", "déséret" },
            { "Egyd", "démotique égyptien" },
            { "Egyh", "hiératique égyptien" },
            { "Egyp", "hiéroglyphes égyptiens" },
            { "Elym", "élymaïque" },
            { "Ethi", "éthiopique" },
            { "Geok", "géorgien khoutsouri" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolitique" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", "goudjarâtî" },
            { "Guru", "gourmoukhî" },
            { "Hanb", "han avec bopomofo" },
            { "Hang", "hangûl" },
            { "Hani", "sinogrammes" },
            { "Hano", "hanounóo" },
            { "Hans", "simplifié" },
            { "Hant", "traditionnel" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hmng", "pahawh hmong" },
            { "Hmnp", "nyiakeng puachue hmong" },
            { "Hrkt", "katakana ou hiragana" },
            { "Hung", "ancien hongrois" },
            { "Inds", "indus" },
            { "Ital", "ancien italique" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharochthî" },
            { "Khmr", metaValue_km },
            { "Knda", "kannara" },
            { "Kore", metaValue_ko },
            { "Kthi", "kaithî" },
            { "Lana", "lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "latin (variante brisée)" },
            { "Latg", "latin (variante gaélique)" },
            { "Latn", metaValue_la },
            { "Lepc", "lepcha" },
            { "Limb", "limbou" },
            { "Lina", "linéaire A" },
            { "Linb", "linéaire B" },
            { "Lyci", "lycien" },
            { "Lydi", "lydien" },
            { "Mand", "mandéen" },
            { "Mani", "manichéen" },
            { "Maya", "hiéroglyphes mayas" },
            { "Mero", "méroïtique" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "moon" },
            { "Mtei", "meitei mayek" },
            { "Mymr", metaValue_my },
            { "Nand", "nandinagari" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ogam" },
            { "Olck", "ol-chiki" },
            { "Orkh", "orkhon" },
            { "Orya", metaValue_or },
            { "Osma", "osmanais" },
            { "Perm", "ancien permien" },
            { "Phag", "phags pa" },
            { "Phli", "pehlevi des inscriptions" },
            { "Phlp", "pehlevi des psautiers" },
            { "Phlv", "pehlevi des livres" },
            { "Phnx", metaValue_phn },
            { "Plrd", "phonétique de Pollard" },
            { "Prti", "parthe des inscriptions" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "runique" },
            { "Samr", "samaritain" },
            { "Sara", "sarati" },
            { "Saur", metaValue_saz },
            { "Sgnw", "écriture des signes" },
            { "Shaw", "shavien" },
            { "Sinh", metaValue_si },
            { "Sund", "sundanais" },
            { "Sylo", "sylotî nâgrî" },
            { "Syrc", metaValue_syr },
            { "Syre", "syriaque estranghélo" },
            { "Syrj", "syriaque occidental" },
            { "Syrn", "syriaque oriental" },
            { "Tagb", "tagbanoua" },
            { "Tale", "taï-le" },
            { "Talu", "nouveau taï-lue" },
            { "Taml", metaValue_ta },
            { "Tavt", "taï viêt" },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", "tagal" },
            { "Thaa", "thâna" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "parole visible" },
            { "Wcho", "wantcho" },
            { "Xpeo", "cunéiforme persépolitain" },
            { "Xsux", "cunéiforme suméro-akkadien" },
            { "Yiii", "yi" },
            { "Zinh", "hérité" },
            { "Zmth", "notation mathématique" },
            { "Zsye", "emoji" },
            { "Zsym", "symboles" },
            { "Zxxx", "non écrit" },
            { "Zyyy", "commun" },
            { "Zzzz", "écriture inconnue" },
            { "de_AT", "allemand autrichien" },
            { "de_CH", "allemand suisse" },
            { "en_AU", "anglais australien" },
            { "en_CA", "anglais canadien" },
            { "en_GB", "anglais britannique" },
            { "en_US", "anglais américain" },
            { "es_ES", "espagnol d’Espagne" },
            { "es_MX", "espagnol du Mexique" },
            { "fa_AF", "dari" },
            { "fr_CA", "français canadien" },
            { "fr_CH", "français suisse" },
            { "nl_BE", "flamand" },
            { "pt_BR", "portugais brésilien" },
            { "pt_PT", "portugais européen" },
            { "ro_MD", "moldave" },
            { "sw_CD", "swahili du Congo" },
            { "%%1901", "orthographe allemande traditionnelle" },
            { "%%1994", "orthographe normalisée de Resia" },
            { "%%1996", "orthographe allemande de 1996" },
            { "ar_001", "arabe standard moderne" },
            { "es_419", "espagnol d’Amérique latine" },
            { "key.ca", "calendrier" },
            { "key.cf", "format de devise" },
            { "key.co", "ordre de tri" },
            { "key.cu", "devise" },
            { "key.em", "Présentation des Emoji" },
            { "key.hc", "système horaire (12 ou 24 heures)" },
            { "key.lb", "style de saut de ligne" },
            { "key.lw", "Sauts de ligne dans les mots" },
            { "key.ms", "système de mesure" },
            { "key.nu", "nombres" },
            { "key.ss", "Saut de phrase après une abréviation" },
            { "key.tz", "fuseau horaire" },
            { "key.va", "variante locale" },
            { "nds_NL", "bas-saxon néerlandais" },
            { "%%BISKE", "dialecte de San Giorgio / Bila" },
            { "%%BOONT", "dialecte boontling" },
            { "%%LIPAW", "dialecte lipovaz de Resia" },
            { "%%NEDIS", "dialecte de Natisone" },
            { "%%NJIVA", "dialecte de Gniva / Njiva" },
            { "%%OSOJS", "dialecte d’Oseacco / Osojane" },
            { "%%POSIX", "informatique" },
            { "%%ROZAJ", "dialecte de Resia" },
            { "%%SAAHO", "dialecte saho" },
            { "%%SOLBA", "dialecte de Stolvizza / Solbica" },
            { "zh_Hans", "chinois simplifié" },
            { "zh_Hant", "chinois traditionnel" },
            { "%%FONIPA", "alphabet phonétique international" },
            { "%%FONUPA", "alphabet phonétique ouralique" },
            { "%%PINYIN", "pinyin" },
            { "%%SCOUSE", "dialecte scouse" },
            { "%%TARASK", "orthographe taraskievica" },
            { "%%AREVELA", "arménien oriental" },
            { "%%AREVMDA", "arménien occidental" },
            { "%%MONOTON", "monotonique" },
            { "%%POLYTON", "polytonique" },
            { "%%REVISED", "orthographe révisée" },
            { "%%1606NICT", "françoys de 1606" },
            { "%%1694ACAD", "françois académique de 1694" },
            { "%%BAKU1926", "alphabet latin altaïque unifié" },
            { "%%SCOTLAND", "anglais standard écossais" },
            { "%%VALENCIA", "valencien" },
            { "%%WADEGILE", "Wade-Giles" },
            { "type.ca.roc", "calendrier républicain chinois" },
            { "type.co.eor", "règles de classement européen" },
            { "type.hc.h11", "système horaire de 12 heures (0–11)" },
            { "type.hc.h12", "système horaire de 12 heures (1–12)" },
            { "type.hc.h23", "système horaire de 24 heures (0–23)" },
            { "type.hc.h24", "système horaire de 24 heures (1–24)" },
            { "type.m0.bgn", "BGN" },
            { "type.nu.arab", "chiffres arabes" },
            { "type.nu.armn", "chiffres arméniens" },
            { "type.nu.beng", "chiffres bengalis" },
            { "type.nu.cakm", "chiffres chakmas" },
            { "type.nu.deva", "chiffres dévanagaris" },
            { "type.nu.ethi", "chiffres éthiopiens" },
            { "type.nu.geor", "chiffres géorgiens" },
            { "type.nu.grek", "chiffres grecs" },
            { "type.nu.gujr", "chiffres goudjarâtîs" },
            { "type.nu.guru", "chiffres gourmoukhîs" },
            { "type.nu.hans", "chiffres en chinois simplifié" },
            { "type.nu.hant", "chiffres en chinois traditionnel" },
            { "type.nu.hebr", "chiffres hébreux" },
            { "type.nu.hmnp", "chiffres nyiakeng puachue hmong" },
            { "type.nu.java", "chiffres javanais" },
            { "type.nu.jpan", "chiffres japonais" },
            { "type.nu.khmr", "chiffres khmers" },
            { "type.nu.knda", "chiffres kannadas" },
            { "type.nu.laoo", "chiffres laotiens" },
            { "type.nu.latn", "chiffres occidentaux" },
            { "type.nu.mlym", "chiffres malayâlams" },
            { "type.nu.mong", "chiffres mongols" },
            { "type.nu.mtei", "chiffres meitei-mayeks" },
            { "type.nu.mymr", "chiffres birmans" },
            { "type.nu.olck", "chiffres ol-chikis" },
            { "type.nu.orya", "chiffres oriyas" },
            { "type.nu.taml", "chiffres tamouls traditionnels" },
            { "type.nu.telu", "chiffres télougous" },
            { "type.nu.thai", "chiffres thaïs" },
            { "type.nu.tibt", "chiffres tibétains" },
            { "type.nu.vaii", "chiffres en vaï" },
            { "type.nu.wcho", "chiffres wantcho" },
            { "type.ca.dangi", "calendrier dangi" },
            { "type.co.ducet", "ordre de tri Unicode par défaut" },
            { "type.lb.loose", "style de saut de ligne permissif" },
            { "type.nu.roman", "chiffres romains" },
            { "type.ca.coptic", "calendrier copte" },
            { "type.ca.hebrew", "calendrier hébraïque" },
            { "type.ca.indian", "calendrier indien" },
            { "type.co.compat", "ancien ordre de tri pour compatibilité" },
            { "type.co.pinyin", "ordre pinyin" },
            { "type.co.search", "recherche générique" },
            { "type.co.stroke", "ordre des traits" },
            { "type.co.unihan", "ordre de tri radical-traits" },
            { "type.co.zhuyin", "ordre zhuyin" },
            { "type.d0.fwidth", "en pleine chasse" },
            { "type.d0.hwidth", "en demi-chasse" },
            { "type.lb.normal", "style de saut de ligne normal" },
            { "type.lb.strict", "style de saut de ligne strict" },
            { "type.m0.ungegn", "UNGEGN" },
            { "type.ms.metric", "système métrique" },
            { "type.nu.native", "chiffres locaux" },
            { "type.ca.chinese", "calendrier chinois" },
            { "type.ca.islamic", "calendrier hégirien" },
            { "type.ca.iso8601", "calendrier ISO 8601" },
            { "type.ca.persian", "calendrier persan" },
            { "type.cf.account", "format de devise comptable" },
            { "type.d0.npinyin", "Numérique" },
            { "type.nu.arabext", "chiffres arabes étendus" },
            { "type.nu.armnlow", "chiffres arméniens minuscules" },
            { "type.nu.finance", "Chiffres financiers" },
            { "type.nu.greklow", "chiffres grecs minuscules" },
            { "type.nu.hanidec", "nombres décimaux chinois" },
            { "type.nu.hansfin", "chiffres financiers en chinois simplifié" },
            { "type.nu.hantfin", "chiffres financiers en chinois traditionnel" },
            { "type.nu.jpanfin", "chiffres financiers japonais" },
            { "type.nu.tamldec", "chiffres tamouls" },
            { "type.ca.buddhist", "calendrier bouddhiste" },
            { "type.ca.ethiopic", "calendrier éthiopien" },
            { "type.ca.japanese", "calendrier japonais" },
            { "type.cf.standard", "format de devise standard" },
            { "type.co.phonetic", "ordre de tri phonétique" },
            { "type.co.searchjl", "rechercher par consonne initiale en hangeul" },
            { "type.co.standard", "ordre de tri standard" },
            { "type.ms.uksystem", "système impérial" },
            { "type.ms.ussystem", "système américain" },
            { "type.nu.fullwide", "chiffres pleine chasse" },
            { "type.nu.romanlow", "chiffres romains minuscules" },
            { "type.ca.gregorian", "calendrier grégorien" },
            { "type.co.phonebook", "ordre de l’annuaire" },
            { "ListKeyTypePattern", "{0} : {1}" },
            { "type.co.dictionary", "ordre du dictionnaire" },
            { "type.co.traditional", "ordre traditionnel" },
            { "type.nu.traditional", "Chiffres traditionnels" },
            { "type.ca.islamic-tbla", "calendrier hégirien (tabulaire, époque astronomique)" },
            { "type.ca.islamic-civil", "calendrier hégirien (tabulaire, époque civile)" },
            { "type.ca.islamic-umalqura", "calendrier hégirien (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "calendrier éthiopien Amete Alem" },
        };
        return data;
    }
}
