// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn de_put_object_acl_http_error(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::put_object_acl::PutObjectAclOutput, crate::operation::put_object_acl::PutObjectAclError> {
    #[allow(unused_mut)]
    let mut generic_builder = crate::protocol_serde::parse_http_error_metadata(_response_status, _response_headers, _response_body)
        .map_err(crate::operation::put_object_acl::PutObjectAclError::unhandled)?;
    generic_builder = crate::s3_request_id::apply_extended_request_id(generic_builder, _response_headers);
    generic_builder = ::aws_types::request_id::apply_request_id(generic_builder, _response_headers);
    let generic = generic_builder.build();
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::operation::put_object_acl::PutObjectAclError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchKey" => crate::operation::put_object_acl::PutObjectAclError::NoSuchKey({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::NoSuchKeyBuilder::default();
                output = crate::protocol_serde::shape_no_such_key::de_no_such_key_xml_err(_response_body, output)
                    .map_err(crate::operation::put_object_acl::PutObjectAclError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        _ => crate::operation::put_object_acl::PutObjectAclError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn de_put_object_acl_http_response(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::put_object_acl::PutObjectAclOutput, crate::operation::put_object_acl::PutObjectAclError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::operation::put_object_acl::builders::PutObjectAclOutputBuilder::default();
        output = output.set_request_charged(
            crate::protocol_serde::shape_put_object_acl_output::de_request_charged_header(_response_headers).map_err(|_| {
                crate::operation::put_object_acl::PutObjectAclError::unhandled("Failed to parse RequestCharged from header `x-amz-request-charged")
            })?,
        );
        output._set_extended_request_id(crate::s3_request_id::RequestIdExt::extended_request_id(_response_headers).map(str::to_string));
        output._set_request_id(::aws_types::request_id::RequestId::request_id(_response_headers).map(str::to_string));
        output.build()
    })
}

pub fn ser_put_object_acl_headers(
    input: &crate::operation::put_object_acl::PutObjectAclInput,
    mut builder: ::http::request::Builder,
) -> std::result::Result<::http::request::Builder, ::aws_smithy_types::error::operation::BuildError> {
    if let ::std::option::Option::Some(inner_1) = &input.acl {
        let formatted_2 = inner_1.as_str();
        let header_value = formatted_2;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "acl",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-acl", header_value);
    }
    if let ::std::option::Option::Some(inner_3) = &input.content_md5 {
        let formatted_4 = inner_3.as_str();
        let header_value = formatted_4;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "content_md5",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("Content-MD5", header_value);
    }
    if let ::std::option::Option::Some(inner_5) = &input.checksum_algorithm {
        let formatted_6 = inner_5.as_str();
        let header_value = formatted_6;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "checksum_algorithm",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-sdk-checksum-algorithm", header_value);
    }
    if let ::std::option::Option::Some(inner_7) = &input.grant_full_control {
        let formatted_8 = inner_7.as_str();
        let header_value = formatted_8;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "grant_full_control",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-grant-full-control", header_value);
    }
    if let ::std::option::Option::Some(inner_9) = &input.grant_read {
        let formatted_10 = inner_9.as_str();
        let header_value = formatted_10;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "grant_read",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-grant-read", header_value);
    }
    if let ::std::option::Option::Some(inner_11) = &input.grant_read_acp {
        let formatted_12 = inner_11.as_str();
        let header_value = formatted_12;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "grant_read_acp",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-grant-read-acp", header_value);
    }
    if let ::std::option::Option::Some(inner_13) = &input.grant_write {
        let formatted_14 = inner_13.as_str();
        let header_value = formatted_14;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "grant_write",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-grant-write", header_value);
    }
    if let ::std::option::Option::Some(inner_15) = &input.grant_write_acp {
        let formatted_16 = inner_15.as_str();
        let header_value = formatted_16;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "grant_write_acp",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-grant-write-acp", header_value);
    }
    if let ::std::option::Option::Some(inner_17) = &input.request_payer {
        let formatted_18 = inner_17.as_str();
        let header_value = formatted_18;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "request_payer",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-request-payer", header_value);
    }
    if let ::std::option::Option::Some(inner_19) = &input.expected_bucket_owner {
        let formatted_20 = inner_19.as_str();
        let header_value = formatted_20;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "expected_bucket_owner",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-expected-bucket-owner", header_value);
    }
    Ok(builder)
}
