/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.schmizz.sshj.common.ByteArrayUtils;
import net.schmizz.sshj.userauth.keyprovider.PuTTYSecretKeyDerivationFunction;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;

class V3PuTTYSecretKeyDerivationFunction
implements PuTTYSecretKeyDerivationFunction {
    private static final String SECRET_KEY_ALGORITHM = "AES";
    private static final int KEY_LENGTH = 80;
    private final Map<String, String> headers;

    V3PuTTYSecretKeyDerivationFunction(Map<String, String> headers) {
        this.headers = Objects.requireNonNull(headers, "Headers required");
    }

    @Override
    public SecretKey deriveSecretKey(char[] passphrase) {
        Objects.requireNonNull(passphrase, "Passphrase required");
        Argon2Parameters parameters = this.getParameters();
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        generator.init(parameters);
        byte[] secretKeyEncoded = new byte[80];
        int bytesGenerated = generator.generateBytes(passphrase, secretKeyEncoded);
        if (80 == bytesGenerated) {
            return new SecretKeySpec(secretKeyEncoded, SECRET_KEY_ALGORITHM);
        }
        String message = String.format("Argon2 bytes generated [%d] not expected", bytesGenerated);
        throw new IllegalStateException(message);
    }

    private Argon2Parameters getParameters() {
        int algorithmType = this.getAlgorithmType();
        byte[] salt = ByteArrayUtils.parseHex(this.headers.get("Argon2-Salt"));
        int iterations = Integer.parseInt(this.headers.get("Argon2-Passes"));
        int memory = Integer.parseInt(this.headers.get("Argon2-Memory"));
        int parallelism = Integer.parseInt(this.headers.get("Argon2-Parallelism"));
        return new Argon2Parameters.Builder(algorithmType).withVersion(19).withIterations(iterations).withMemoryAsKB(memory).withParallelism(parallelism).withSalt(salt).build();
    }

    private int getAlgorithmType() {
        int algorithmType;
        String algorithm = this.headers.get("Key-Derivation");
        if ("argon2i".equalsIgnoreCase(algorithm)) {
            algorithmType = 1;
        } else if ("argon2d".equalsIgnoreCase(algorithm)) {
            algorithmType = 0;
        } else if ("argon2id".equalsIgnoreCase(algorithm)) {
            algorithmType = 2;
        } else {
            String message = String.format("Key-Derivation [%s] not supported", algorithm);
            throw new IllegalArgumentException(message);
        }
        return algorithmType;
    }
}

