// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpcollectorlogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type Logs struct {
	orig  *otlpcollectorlogs.ExportLogsServiceRequest
	state *State
}

func GetOrigLogs(ms Logs) *otlpcollectorlogs.ExportLogsServiceRequest {
	return ms.orig
}

func GetLogsState(ms Logs) *State {
	return ms.state
}

func NewLogs(orig *otlpcollectorlogs.ExportLogsServiceRequest, state *State) Logs {
	return Logs{orig: orig, state: state}
}

var (
	protoPoolExportLogsServiceRequest = sync.Pool{
		New: func() any {
			return &otlpcollectorlogs.ExportLogsServiceRequest{}
		},
	}
)

func NewOrigExportLogsServiceRequest() *otlpcollectorlogs.ExportLogsServiceRequest {
	if !UseProtoPooling.IsEnabled() {
		return &otlpcollectorlogs.ExportLogsServiceRequest{}
	}
	return protoPoolExportLogsServiceRequest.Get().(*otlpcollectorlogs.ExportLogsServiceRequest)
}

func DeleteOrigExportLogsServiceRequest(orig *otlpcollectorlogs.ExportLogsServiceRequest, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.ResourceLogs {
		DeleteOrigResourceLogs(orig.ResourceLogs[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolExportLogsServiceRequest.Put(orig)
	}
}

func CopyOrigExportLogsServiceRequest(dest, src *otlpcollectorlogs.ExportLogsServiceRequest) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.ResourceLogs = CopyOrigResourceLogsSlice(dest.ResourceLogs, src.ResourceLogs)
}

func GenTestOrigExportLogsServiceRequest() *otlpcollectorlogs.ExportLogsServiceRequest {
	orig := NewOrigExportLogsServiceRequest()
	orig.ResourceLogs = GenerateOrigTestResourceLogsSlice()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExportLogsServiceRequest(orig *otlpcollectorlogs.ExportLogsServiceRequest, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.ResourceLogs) > 0 {
		dest.WriteObjectField("resourceLogs")
		dest.WriteArrayStart()
		MarshalJSONOrigResourceLogs(orig.ResourceLogs[0], dest)
		for i := 1; i < len(orig.ResourceLogs); i++ {
			dest.WriteMore()
			MarshalJSONOrigResourceLogs(orig.ResourceLogs[i], dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigLogs unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExportLogsServiceRequest(orig *otlpcollectorlogs.ExportLogsServiceRequest, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "resourceLogs", "resource_logs":
			for iter.ReadArray() {
				orig.ResourceLogs = append(orig.ResourceLogs, NewOrigResourceLogs())
				UnmarshalJSONOrigResourceLogs(orig.ResourceLogs[len(orig.ResourceLogs)-1], iter)
			}

		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigExportLogsServiceRequest(orig *otlpcollectorlogs.ExportLogsServiceRequest) int {
	var n int
	var l int
	_ = l
	for i := range orig.ResourceLogs {
		l = SizeProtoOrigResourceLogs(orig.ResourceLogs[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigExportLogsServiceRequest(orig *otlpcollectorlogs.ExportLogsServiceRequest, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.ResourceLogs) - 1; i >= 0; i-- {
		l = MarshalProtoOrigResourceLogs(orig.ResourceLogs[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigExportLogsServiceRequest(orig *otlpcollectorlogs.ExportLogsServiceRequest, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceLogs", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ResourceLogs = append(orig.ResourceLogs, NewOrigResourceLogs())
			err = UnmarshalProtoOrigResourceLogs(orig.ResourceLogs[len(orig.ResourceLogs)-1], buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
