// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolStatus = sync.Pool{
		New: func() any {
			return &otlptrace.Status{}
		},
	}
)

func NewOrigStatus() *otlptrace.Status {
	if !UseProtoPooling.IsEnabled() {
		return &otlptrace.Status{}
	}
	return protoPoolStatus.Get().(*otlptrace.Status)
}

func DeleteOrigStatus(orig *otlptrace.Status, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolStatus.Put(orig)
	}
}

func CopyOrigStatus(dest, src *otlptrace.Status) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.Message = src.Message
	dest.Code = src.Code
}

func GenTestOrigStatus() *otlptrace.Status {
	orig := NewOrigStatus()
	orig.Message = "test_message"
	orig.Code = otlptrace.Status_StatusCode(1)
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigStatus(orig *otlptrace.Status, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.Message != "" {
		dest.WriteObjectField("message")
		dest.WriteString(orig.Message)
	}

	if int32(orig.Code) != 0 {
		dest.WriteObjectField("code")
		dest.WriteInt32(int32(orig.Code))
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigStatus unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigStatus(orig *otlptrace.Status, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "message":
			orig.Message = iter.ReadString()
		case "code":
			orig.Code = otlptrace.Status_StatusCode(iter.ReadEnumValue(otlptrace.Status_StatusCode_value))
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigStatus(orig *otlptrace.Status) int {
	var n int
	var l int
	_ = l
	l = len(orig.Message)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.Code != 0 {
		n += 1 + proto.Sov(uint64(orig.Code))
	}
	return n
}

func MarshalProtoOrigStatus(orig *otlptrace.Status, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = len(orig.Message)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Message)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	if orig.Code != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Code))
		pos--
		buf[pos] = 0x18
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigStatus(orig *otlptrace.Status, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Message = string(buf[startPos:pos])

		case 3:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Code = otlptrace.Status_StatusCode(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
