/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html.h"
        #include <wx/html/htmprint.h>
        #include <wx/html/htmlcell.h>
        #include <wx/dc.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
    void _wxHtmlDCRenderer_SetFonts(wxHtmlDCRenderer* self, const wxString * normal_face, const wxString * fixed_face, const wxArrayInt* sizes)
    {
        if (sizes->GetCount() != 7) {
            wxPyErr_SetString(PyExc_ValueError, "Sequence of 7 integers expected.");
            return;
        }
        self->SetFonts(*normal_face, *fixed_face, &sizes->Item(0));
    }


PyDoc_STRVAR(doc_wxHtmlDCRenderer_GetTotalWidth, "GetTotalWidth() -> int\n"
"\n"
"Returns the width of the HTML text in pixels.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_GetTotalWidth(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_GetTotalWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxHtmlDCRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetTotalWidth();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_GetTotalWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlDCRenderer_GetTotalHeight, "GetTotalHeight() -> int\n"
"\n"
"Returns the height of the HTML text in pixels.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_GetTotalHeight(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_GetTotalHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxHtmlDCRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetTotalHeight();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_GetTotalHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlDCRenderer_FindNextPageBreak, "FindNextPageBreak(pos) -> int\n"
"\n"
"Finds the next page break after the specified (vertical) position.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_FindNextPageBreak(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_FindNextPageBreak(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int pos;
        const ::wxHtmlDCRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp, &pos))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindNextPageBreak(pos);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_FindNextPageBreak, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlDCRenderer_Render, "Render(x, y, from_=0, to_=INT_MAX) -> None\n"
"\n"
"Renders HTML text to the DC.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_Render(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_Render(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int x;
        int y;
        int from_ = 0;
        int to_ = INT_MAX;
        ::wxHtmlDCRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_from_,
            sipName_to_,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii|ii", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp, &x, &y, &from_, &to_))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Render(x, y, from_, to_);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_Render, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlDCRenderer_SetDC, "SetDC(dc, pixel_scale=1.0) -> None\n"
"\n"
"Assign DC instance to the renderer.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_SetDC(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_SetDC(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDC* dc;
        double pixel_scale = 1;
        ::wxHtmlDCRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
            sipName_pixel_scale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8|d", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp, sipType_wxDC, &dc, &pixel_scale))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDC(dc, pixel_scale);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_SetDC, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlDCRenderer_SetFonts, "SetFonts(normal_face, fixed_face, sizes) -> None\n"
"\n"
"This function sets font sizes and faces.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_SetFonts(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_SetFonts(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* normal_face;
        int normal_faceState = 0;
        const ::wxString* fixed_face;
        int fixed_faceState = 0;
        const ::wxArrayInt* sizes;
        int sizesState = 0;
        ::wxHtmlDCRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_normal_face,
            sipName_fixed_face,
            sipName_sizes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1J1", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp, sipType_wxString, &normal_face, &normal_faceState, sipType_wxString, &fixed_face, &fixed_faceState, sipType_wxArrayInt, &sizes, &sizesState))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxHtmlDCRenderer_SetFonts(sipCpp, normal_face, fixed_face, sizes);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(normal_face), sipType_wxString, normal_faceState);
            sipReleaseType(const_cast< ::wxString *>(fixed_face), sipType_wxString, fixed_faceState);
            sipReleaseType(const_cast< ::wxArrayInt *>(sizes), sipType_wxArrayInt, sizesState);

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_SetFonts, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlDCRenderer_SetStandardFonts, "SetStandardFonts(size=-1, normal_face='', fixed_face='') -> None\n"
"\n"
"Sets font sizes to be relative to the given size or the system default\n"
"size; use either specified or default font.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_SetStandardFonts(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_SetStandardFonts(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int size = -1;
        const ::wxString& normal_facedef = wxEmptyString;
        const ::wxString* normal_face = &normal_facedef;
        int normal_faceState = 0;
        const ::wxString& fixed_facedef = wxEmptyString;
        const ::wxString* fixed_face = &fixed_facedef;
        int fixed_faceState = 0;
        ::wxHtmlDCRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
            sipName_normal_face,
            sipName_fixed_face,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|iJ1J1", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp, &size, sipType_wxString, &normal_face, &normal_faceState, sipType_wxString, &fixed_face, &fixed_faceState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetStandardFonts(size, *normal_face, *fixed_face);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(normal_face), sipType_wxString, normal_faceState);
            sipReleaseType(const_cast< ::wxString *>(fixed_face), sipType_wxString, fixed_faceState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_SetStandardFonts, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlDCRenderer_SetHtmlText, "SetHtmlText(html, basepath='', isdir=True) -> None\n"
"\n"
"Assign text to the renderer.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_SetHtmlText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_SetHtmlText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* html;
        int htmlState = 0;
        const ::wxString& basepathdef = wxEmptyString;
        const ::wxString* basepath = &basepathdef;
        int basepathState = 0;
        bool isdir = 1;
        ::wxHtmlDCRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_html,
            sipName_basepath,
            sipName_isdir,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|J1b", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp, sipType_wxString, &html, &htmlState, sipType_wxString, &basepath, &basepathState, &isdir))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHtmlText(*html, *basepath, isdir);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(html), sipType_wxString, htmlState);
            sipReleaseType(const_cast< ::wxString *>(basepath), sipType_wxString, basepathState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_SetHtmlText, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlDCRenderer_SetHtmlCell, "SetHtmlCell(cell) -> None\n"
"\n"
"Associate the given HTML contents to the renderer.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_SetHtmlCell(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_SetHtmlCell(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxHtmlContainerCell* cell;
        ::wxHtmlDCRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_cell,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp, sipType_wxHtmlContainerCell, &cell))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHtmlCell(*cell);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_SetHtmlCell, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlDCRenderer_SetSize, "SetSize(width, height) -> None\n"
"\n"
"Set size of output rectangle, in pixels.");

extern "C" {static PyObject *meth_wxHtmlDCRenderer_SetSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlDCRenderer_SetSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int width;
        int height;
        ::wxHtmlDCRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxHtmlDCRenderer, &sipCpp, &width, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetSize(width, height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_HtmlDCRenderer, sipName_SetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxHtmlDCRenderer(void *, const sipTypeDef *);}
static void *cast_wxHtmlDCRenderer(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxHtmlDCRenderer *sipCpp = reinterpret_cast< ::wxHtmlDCRenderer *>(sipCppV);

    if (targetType == sipType_wxHtmlDCRenderer)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxHtmlDCRenderer(void *, int);}
static void release_wxHtmlDCRenderer(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxHtmlDCRenderer *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxHtmlDCRenderer(Py_ssize_t);}
static void *array_wxHtmlDCRenderer(Py_ssize_t sipNrElem)
{
    return new ::wxHtmlDCRenderer[sipNrElem];
}


extern "C" {static void array_delete_wxHtmlDCRenderer(void *);}
static void array_delete_wxHtmlDCRenderer(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxHtmlDCRenderer *>(sipCpp);
}


extern "C" {static void dealloc_wxHtmlDCRenderer(sipSimpleWrapper *);}
static void dealloc_wxHtmlDCRenderer(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxHtmlDCRenderer(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxHtmlDCRenderer(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxHtmlDCRenderer(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxHtmlDCRenderer *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxHtmlDCRenderer();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxHtmlDCRenderer[] = {{25, 0, 1}};


static PyMethodDef methods_wxHtmlDCRenderer[] = {
    {sipName_FindNextPageBreak, SIP_MLMETH_CAST(meth_wxHtmlDCRenderer_FindNextPageBreak), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlDCRenderer_FindNextPageBreak},
    {sipName_GetTotalHeight, meth_wxHtmlDCRenderer_GetTotalHeight, METH_VARARGS, doc_wxHtmlDCRenderer_GetTotalHeight},
    {sipName_GetTotalWidth, meth_wxHtmlDCRenderer_GetTotalWidth, METH_VARARGS, doc_wxHtmlDCRenderer_GetTotalWidth},
    {sipName_Render, SIP_MLMETH_CAST(meth_wxHtmlDCRenderer_Render), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlDCRenderer_Render},
    {sipName_SetDC, SIP_MLMETH_CAST(meth_wxHtmlDCRenderer_SetDC), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlDCRenderer_SetDC},
    {sipName_SetFonts, SIP_MLMETH_CAST(meth_wxHtmlDCRenderer_SetFonts), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlDCRenderer_SetFonts},
    {sipName_SetHtmlCell, SIP_MLMETH_CAST(meth_wxHtmlDCRenderer_SetHtmlCell), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlDCRenderer_SetHtmlCell},
    {sipName_SetHtmlText, SIP_MLMETH_CAST(meth_wxHtmlDCRenderer_SetHtmlText), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlDCRenderer_SetHtmlText},
    {sipName_SetSize, SIP_MLMETH_CAST(meth_wxHtmlDCRenderer_SetSize), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlDCRenderer_SetSize},
    {sipName_SetStandardFonts, SIP_MLMETH_CAST(meth_wxHtmlDCRenderer_SetStandardFonts), METH_VARARGS|METH_KEYWORDS, doc_wxHtmlDCRenderer_SetStandardFonts}
};

sipVariableDef variables_wxHtmlDCRenderer[] = {
    {PropertyVariable, sipName_TotalWidth, &methods_wxHtmlDCRenderer[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_TotalHeight, &methods_wxHtmlDCRenderer[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxHtmlDCRenderer, "HtmlDCRenderer() -> None\n"
"\n"
"This class can render HTML document into a specified area of a DC.");


sipClassTypeDef sipTypeDef__html_wxHtmlDCRenderer = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxHtmlDCRenderer,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_HtmlDCRenderer,
        {0, 0, 1},
        10, methods_wxHtmlDCRenderer,
        0, SIP_NULLPTR,
        2, variables_wxHtmlDCRenderer,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxHtmlDCRenderer,
    -1,
    -1,
    supers_wxHtmlDCRenderer,
    SIP_NULLPTR,
    init_type_wxHtmlDCRenderer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxHtmlDCRenderer,
    SIP_NULLPTR,
    array_wxHtmlDCRenderer,
    SIP_NULLPTR,
    release_wxHtmlDCRenderer,
    cast_wxHtmlDCRenderer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxHtmlDCRenderer,
    sizeof (::wxHtmlDCRenderer),
};
