/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.intellij.util.Processor;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.Flags;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8PostOrderBuilder;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapGraphEdgeType;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReader;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class DominatorTreeBuilder {
    private IntList myDominators;
    private IntList myDominatorsTree;
    private IntList myAffected;
    private final int myNodesCnt;
    private final V8CachingReader myReader;
    private final V8PostOrderBuilder myPostOrderBuilder;
    @NotNull
    private final Flags myFlags;
    private int myRootPostOrderIndex;
    private V8HeapEntry myRoot;
    private final LinksReader<V8HeapEdge> myReverseIndexReader;
    private final boolean myShowHiddenData;

    public DominatorTreeBuilder(int nodesCnt, V8CachingReader reader, V8PostOrderBuilder postOrderBuilder, @NotNull Flags flags, @NotNull LinksReader<V8HeapEdge> linksReader, boolean showHiddenData) {
        if (flags == null) {
            DominatorTreeBuilder.$$$reportNull$$$0(0);
        }
        if (linksReader == null) {
            DominatorTreeBuilder.$$$reportNull$$$0(1);
        }
        this.myNodesCnt = nodesCnt;
        this.myReader = reader;
        this.myPostOrderBuilder = postOrderBuilder;
        this.myFlags = flags;
        this.myReverseIndexReader = linksReader;
        this.myShowHiddenData = showHiddenData;
        this.myDominators = new IntArrayList(nodesCnt);
        this.myAffected = new IntArrayList(nodesCnt);
    }

    private void initDominators(int nodesCnt) {
        this.myRootPostOrderIndex = nodesCnt - 1;
        for (int i = 0; i < this.myRootPostOrderIndex; ++i) {
            this.myDominators.add(nodesCnt);
            this.myAffected.add(0);
        }
        this.myAffected.add(0);
        this.myDominators.add(this.myRootPostOrderIndex);
    }

    public void execute() throws IOException {
        this.initDominators(this.myNodesCnt);
        this.myRoot = this.myReader.getNode(0L);
        for (V8HeapEdge edge : this.myReader.getChildren(this.myRoot)) {
            if (DominatorTreeBuilder.weakOrShortcut(edge)) continue;
            this.myAffected.set(this.myPostOrderBuilder.getNodeToPostOrder().getInt((int)edge.getToIndex()), 1);
        }
        while (this.iteration()) {
        }
        this.myDominatorsTree = new IntArrayList(this.myNodesCnt);
        for (int i = 0; i < this.myNodesCnt; ++i) {
            this.myDominatorsTree.add(-1);
        }
        for (int postOrderIndex = 0; postOrderIndex < this.myNodesCnt; ++postOrderIndex) {
            int nodeIdx = this.myPostOrderBuilder.getPostOrderToNode().getInt(postOrderIndex);
            int dominatorByPostOrder = this.myDominators.getInt(postOrderIndex);
            if (dominatorByPostOrder < this.myNodesCnt) {
                this.myDominatorsTree.set(nodeIdx, this.myPostOrderBuilder.getPostOrderToNode().getInt(dominatorByPostOrder));
                continue;
            }
            this.myDominatorsTree.set(nodeIdx, 0);
        }
        this.myDominators = null;
        this.myAffected = null;
    }

    public IntList getDominatorsTree() {
        return this.myDominatorsTree;
    }

    private static boolean weakOrShortcut(V8HeapEdge edge) {
        return V8HeapGraphEdgeType.kWeak.equals((Object)edge.getType()) || V8HeapGraphEdgeType.kShortcut.equals((Object)edge.getType());
    }

    private boolean iteration() throws IOException {
        boolean changed = false;
        for (int postOrderIndex = this.myRootPostOrderIndex - 1; postOrderIndex >= 0; --postOrderIndex) {
            if (this.myAffected.getInt(postOrderIndex) == 0) continue;
            this.myAffected.set(postOrderIndex, 0);
            if (this.myDominators.getInt(postOrderIndex) == this.myRootPostOrderIndex) continue;
            int nodeIdx = this.myPostOrderBuilder.getPostOrderToNode().getInt(postOrderIndex);
            final boolean isNodePageObject = this.myFlags.isPage(nodeIdx);
            final int[] newDominatorIndex = new int[]{this.myNodesCnt};
            final boolean[] orphanNode = new boolean[]{true};
            this.myReverseIndexReader.read(nodeIdx, new Processor<V8HeapEdge>(){
                private boolean breakFlag = false;

                public boolean process(V8HeapEdge edge) {
                    if (this.breakFlag) {
                        return false;
                    }
                    if (DominatorTreeBuilder.weakOrShortcut(edge)) {
                        return true;
                    }
                    orphanNode[0] = false;
                    boolean retainerFlag = DominatorTreeBuilder.this.myFlags.isPage((int)edge.getFromIndex());
                    if (!DominatorTreeBuilder.this.myShowHiddenData && edge.getFromIndex() != 0L && isNodePageObject && !retainerFlag) {
                        return true;
                    }
                    int retainerPostIndex = DominatorTreeBuilder.this.myPostOrderBuilder.getNodeToPostOrder().getInt((int)edge.getFromIndex());
                    if (DominatorTreeBuilder.this.myDominators.getInt(retainerPostIndex) != DominatorTreeBuilder.this.myNodesCnt) {
                        if (newDominatorIndex[0] == DominatorTreeBuilder.this.myNodesCnt) {
                            newDominatorIndex[0] = retainerPostIndex;
                        } else {
                            while (retainerPostIndex != newDominatorIndex[0]) {
                                while (retainerPostIndex < newDominatorIndex[0]) {
                                    retainerPostIndex = DominatorTreeBuilder.this.myDominators.getInt(retainerPostIndex);
                                }
                                while (newDominatorIndex[0] < retainerPostIndex) {
                                    newDominatorIndex[0] = DominatorTreeBuilder.this.myDominators.getInt(newDominatorIndex[0]);
                                }
                            }
                            if (newDominatorIndex[0] == DominatorTreeBuilder.this.myRootPostOrderIndex) {
                                this.breakFlag = true;
                                return false;
                            }
                        }
                    }
                    return true;
                }
            });
            if (orphanNode[0]) {
                newDominatorIndex[0] = this.myRootPostOrderIndex;
            }
            if (newDominatorIndex[0] == this.myNodesCnt || this.myDominators.getInt(postOrderIndex) == newDominatorIndex[0]) continue;
            this.myDominators.set(postOrderIndex, newDominatorIndex[0]);
            for (V8HeapEdge edge : this.myReader.getChildrenByNodeId(Long.valueOf(nodeIdx))) {
                this.myAffected.set(this.myPostOrderBuilder.getNodeToPostOrder().getInt((int)edge.getToIndex()), 1);
            }
            changed = true;
        }
        return changed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "flags";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "linksReader";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/DominatorTreeBuilder";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

