/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class JavaScriptQualifiedItemProcessor<T extends ResultSink>
extends TypeScriptResolveProcessor<T> {
    public JavaScriptQualifiedItemProcessor(T sink, PsiElement place) {
        super(sink, place.getContainingFile(), place);
    }

    @Override
    public void processImpl(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext) {
        if (type2 == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(0);
        }
        if (evaluateContext == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(1);
        }
        if (!this.processES6Class(type2)) {
            return;
        }
        super.processImpl(type2, evaluateContext);
    }

    private boolean processES6Class(@NotNull JSType type2) {
        PsiElement source;
        if (type2 == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(2);
        }
        if ((source = type2.getSourceElement()) instanceof ES6Class && type2 instanceof JSNamedType) {
            boolean isStatic = ((JSNamedType)type2).isStaticOrInstance() == JSContext.STATIC;
            AccessibilityProcessingHandler.processWithStatic(this, isStatic, () -> {
                boolean b = source.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), source, this.place);
                if (!b) {
                    this.forceResolvedState();
                }
                return b;
            });
            return false;
        }
        return true;
    }

    @Override
    protected @Unmodifiable @NotNull Collection<? extends PsiElement> resolveElementsByTypeWithContext(@NotNull JSType type2, @NotNull String qName, @NotNull PsiElement sourceToResolve) {
        JSTypeContext context2;
        if (type2 == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(3);
        }
        if (qName == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(4);
        }
        if (sourceToResolve == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(5);
        }
        if (type2 instanceof JSNamedType && ((context2 = ((JSNamedType)type2).getTypeContext()) == JSTypeContext.PROTOTYPE || context2 == JSTypeContext.UNKNOWN)) {
            List list = Collections.emptyList();
            if (list == null) {
                JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (JSCorePredefinedLibrariesProvider.isLibraryElement(sourceToResolve) || type2 instanceof JSSpecialNamedTypeImpl || type2 instanceof JSArrayType || type2 instanceof JSTupleType) {
            return JavaScriptQualifiedItemProcessor.resolveGlobalTypeElementsByName(qName, sourceToResolve);
        }
        Collection<PsiElement> results = super.resolveElementsByTypeWithContext(type2, qName, sourceToResolve);
        List list = ContainerUtil.filter(results, el -> el instanceof JSClass || el instanceof TypeScriptModule || el instanceof JSFile);
        if (list == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public static Collection<? extends PsiElement> resolveGlobalTypeElementsByName(@NotNull String resolvedName, @NotNull PsiElement jsContext) {
        if (resolvedName == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(8);
        }
        if (jsContext == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(9);
        }
        GlobalSearchScope jsScope = JSResolveUtil.getResolveScope(jsContext);
        GlobalSearchScope tsFiles = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)jsScope, (FileType[])TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY);
        Collection<JSQualifiedNamedElement> elements = TypeScriptClassResolver.getInstance().findGlobalElementsByQName(jsContext.getProject(), resolvedName, tsFiles);
        if (elements.size() <= 1) {
            Collection<JSQualifiedNamedElement> collection = elements;
            if (collection == null) {
                JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(10);
            }
            return collection;
        }
        List results = ContainerUtil.filter(elements, el -> TypeScriptPsiUtil.isNamedTypeContainerDefinition((PsiElement)el));
        Collection<Object> collection = !results.isEmpty() ? results : elements;
        if (collection == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @Override
    public ResolveResult @Nullable [] getResultsIfResolveCompleted() {
        return this.getResultsIfResolveCompletedJS();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceToResolve";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JavaScriptQualifiedItemProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JavaScriptQualifiedItemProcessor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElementsByTypeWithContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobalTypeElementsByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processImpl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processES6Class";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementsByTypeWithContext";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveGlobalTypeElementsByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 10, 11 -> new IllegalStateException(string);
        };
    }
}

